{ ------------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.                   }
{ (c) 1991-1999 Peter Mandrella                                       }
{ (c) 2000-2001 OpenXP-Team                                           }
{ (c) 2002-2025 FreeXP, http://www.freexp.de                          }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.         }
{                                                                     }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der     }
{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html }
{ ------------------------------------------------------------------- }

{ CrossPoint - First Unit        }

unit xpx;

{$I XPDEFINE.INC        }

interface

uses
  ems, xms, overxms, crt, dos,dosx,typeform,fileio,mouse,inout,xp0,crc,xpglobal, mcb,compdate,timemark;

implementation

  {$IFDEF DPMI       }
  const MinVersion = $330;
        MinVerStr  = '3.3';      
  {$ELSE       }
  uses  overlay, clip, xpovl, lfn;
  const MinVersion = $300;
        MinVerStr  = '3.0';        
  {$ENDIF       }

const starting : boolean = true;

var oldexit : pointer;
    i: integer;

procedure stop(const txt:string);
begin
  writeln;
  writeln(txt);
  runerror:=false;
  halt(1);
end;


procedure readname;
var t    : text;
    name : string[10];
    short: string[2];
    code : string[20];
begin
  assign(t,progpath+'pname.dat');
  if existf(t) then begin
    reset(t);
    readln(t,name);
    readln(t,short);
    readln(t,code);
    close(t);
    if (ioresult=0) and
       (ival(code)=sqr(CRC32Str(reverse(name)) and $ffff)) then begin
      XP_xp:=name;
      XP_origin := '--- '+name;
      end;
    end;
end;

procedure SetHandles;
var i    : integer;
    regs : registers;
begin
  {$IFNDEF DPMI        }
    for i:=1 to 255 do
      handles[i]:=$ff;
    for i:=1 to 5 do
      handles[i]:=mem[PrefixSeg:$18+pred(i)];
    MemW[PrefixSeg:$32] := 255;
    MemW[PrefixSeg:$34] := Ofs(handles);
    MemW[PrefixSeg:$36] := Seg(handles);
  {$ELSE       }
    with regs do begin
      ah:=$67;
      bx:=255;
      msdos(regs);
      if flags and fcarry<>0 then
        writeln('Warnung: Fehler beim Anfordern von File Handles!');
      end;
  {$ENDIF       }
end;

function complong:longint;
var dt:datetime;
    code:integer;
    ft:longint;

begin
  if comp_YY='0000' then complong:=filetime(Progname+'.exe')
  else begin
    Val(comp_YY,dt.year,code);
    Val(comp_MO,dt.Month,code);
    Val(comp_DD,dt.Day,code);
    Val(comp_HH,dt.Hour,code);
    Val(comp_MI,dt.Min,code);
    Val(comp_SS,dt.Sec,code);
    Packtime(dt,ft);
    complong:=ft;
  end;
end;

function ovrdate:longint;
var t:longint;

begin
  t:=getmark(Progname+'.ovr');
  if t=0 then t:=filetime(Progname+'.ovr');
  ovrdate:=t;
end;  

procedure TestOVR;
var c,cc : char;
begin
  if not exist(Progname+'.ovr') then
    stop('Die Datei '+Progname+'.OVR fehlt!');
  if (complong<>0) and (abs(complong-ovrdate)>=60) then begin
    writeln;
    writeln('WARNUNG: Das Dateidatum von '+Progname+'.OVR stimmt nicht mit dem von '+Progname+'.EXE');
    writeln('         berein. '+Progname+'.OVR stammt offenbar von einer anderen '+xp_display+'-');
    writeln('         Version. Bitte spielen Sie das Programm aus einem '+xp_display+'-');
    writeln('         Originalarchiv neu auf! Wenn Sie das Programm jetzt fortsetzen,');
    writeln('         wird es wahrscheinlich abstrzen.');
    writeln;
    writeln('         Falls Sie nach einem Neuaufspielen wieder die gleiche Fehler-');
    writeln('         meldung erhalten, ist Ihr Rechner mglicherweise mit einem');
    writeln('         Virus infiziert.');
    writeln;
    write(#7'Programm fortsetzen (J/N)? ');
    c:='N';
    repeat
      write(c,#8);
      cc:=readkey;
      case cc of
        #0 : if readkey='' then;
        'j','J' : c:='J';
        'n','N' : c:='N';
      end;
    until (cc=#13) or (cc=#27);
    writeln;
    if (cc=#27) or (c='N') then begin
      runerror:=false;
      halt(1);
      end;
    end;
end;

{$S-       }
procedure setpath; far;
begin
  if ioresult = 0 then ;
  GoDir(shellpath);
  if ioresult<>0 then GoDir(ownpath);
  if runerror and not starting then begin
    attrtxt(7);
    writeln;
    writeln('Fehler: ',ioerror(exitcode,'<interner Fehler>'));
    end;
  exitproc:=oldexit;
end;
{$IFDEF Debug        }
  {$S+       }
{$ENDIF        }

{.$define mcbdebug       }

procedure TestCD;
var f    : file;
    attr : rtlword;
begin
  assign(f,paramstr(0));
  getfattr(f,attr);
  if attr and ReadOnly<>0 then begin
    assign(f,OwnPath+'XP$T.$1');
    rewrite(f);
    if ioresult=0 then begin
      close(f);
      erase(f);
      end
    else begin
      writeln;
      writeln(xp_display+' kann nicht von einem schreibgeschtzten Laufwerk gestartet');
      writeln('werden. Kopieren Sie das Programm bitte auf Festplatte.');
      runerror:=false;
      halt(1);
      end;
    end;
end;

function xpshell:boolean; { true, wenn XP in seiner eigenen Shell gestartet wurde        }
var mcb:mcbp;
    envseg:word;
    s:string;
begin
  xpshell:=false;

{$ifdef mcbdebug       }
  writeln;
  writeln('PSP  Env. Typ    Gre  Prog.   Prog. (Environment)');
  writeln('Seg. Seg.               (MCB)');
  writeln('------------------------------------------------------------------------');
{$endif       }

  mcb:=firstmcb;
  repeat
    s:=getmcbprog(mcb);
{   if s='' then s:=getmcbenvprog(getmcbenvseg(mcb));        }
{ Fr DOS-Versionen kleiner 4.0 msste man obige Zeile eigentlich aktivieren,
  da ich es aber nicht mit DOS < 4.0 testen konnte, bin ich nicht sicher, ob
  es 100%ig funktioniert.
       }
    if (ustr(shortp(paramstr(0)))=ustr(s)) and (mcb^.psp_seg<>prefixseg)
       and (mcb^.size*16>20480)
      then xpshell:=true;

{$ifdef mcbdebug       }
    write(hex(mcb^.psp_seg,4),' ',
          hex(getmcbenvseg(mcb),4),' ');
    if ispsp(mcb) then write('PSP   ') else case mcb^.psp_seg of
      $0000: write('frei  ');
      $0008: write('DOS   ');
      $0006: write('DRDOS ');
      $0007: write('DRDOS ');
      $FFF7: write('386MAX');
      $FFFA: write('386MAX');
      $FFFD: write('386MAX');
      $FFFE: write('386MAX');
      $FFFF: write('386MAX');
      else write('?     ');
    end;
    write(mcb^.size*16:6,
          getmcbprog(mcb):9,' ',
          getmcbenvprog(getmcbenvseg(mcb)));
    writeln;
{$endif       }

    mcb:=nextmcb(mcb);
  until mcb^.id='Z';

{$ifdef mcbdebug       }
  write(#13#10'-> Enter');
  readln;
{$endif       }

end;

function _deutsch:boolean;
var t : text;
    s : string;
    i : integer;
begin
  filemode:=0;
  assign(t,'XP.RES');
  reset(t);
  readln(t,s);
  close(t);
  for i := 1 to length(s) do s[i] := UpCase(s[i]);
  _deutsch:=(ioresult<>0) or (s='XP-D.RES');
  filemode:=2;
end;

function xpswapspace:word;
var regs:registers;
begin
  intr($12,regs);
  xpswapspace:=(regs.ax - prefixseg div 64 - 42 - memavail div 1024)
end;

procedure logo;
var t : text;
begin
  assign(t,'');
  rewrite(t);
  writeln(t);
  write(t,xp_xp);
  if (xp_xp='CrossPoint') then write(t,'(R)');
  writeln(t,' ',verstr,betastr,iifs(rufstr<>'',' ("'+rufstr+'")',''),ovrstr);
  writeln(t,x_copyright,' by ',author_name,' (',author_mail,')');
  writeln(t);
  if _deutsch then
  begin
    writeln(t,'basierend auf CrossPoint(R) v3.2  (c) 1992-1999 Peter Mandrella');
  end else
  begin
    writeln(t,'based on CrossPoint(R) v3.2  (c) 1992-1999 Peter Mandrella');
  end;
  writeln(t);
  close(t);
end;

begin
  checkbreak:=false;
  if swap(dosversion)<MinVersion then
    stop('DOS Version '+MinVerStr+' oder hher erforderlich.');
  readname;
  if (left(getenv('PROMPT'),4)='[XP]') or xpshell then
    if _deutsch then stop('Zurck zu CrossPoint mit EXIT.')
    else stop('Type EXIT to return to CrossPoint.');
  SetHandles;
  ShellPath:=dospath(0);
  if (Shellpath+DirSepa<>progpath) then
    GoDir(progpath);
  oldexit:=exitproc;
  exitproc:=@setpath;
  mausunit_init;  
  {$IFNDEF NO386 }      { Die XT Version darf hier nicht testen }
  if Test8086 < 2 then
  begin
    Writeln(xp_display+' luft in dieser Version erst ab 386er CPUs');
    Writeln('sowohl mit als auch ohne Co-Prozessor.');
    Writeln('Eine XT-Version kann von der Homepage '+author_url);
    Writeln('bezogen werden (nur '+xp_display+' v3.21, nicht jedoch');
    Writeln('die vorliegende Version '+xp_display+' '+verstr+').');
    runerror := false;
    Halt(1);
  end;  
  {$ENDIF }
  {$IFNDEF DPMI       }     { mit DPMI auch nicht        }
    { Bei integriertem OVR mssen wir nicht testen !!       }
    {$IFDEF USEOVR       }
    TestOVR;
    OvrInit(Progname+'.ovr');
    {$ELSE       }
    OvrInit(Progname+'.exe'); 
    {$ENDIF       }
    { XPUnlock;        }     { hat nicht den gewnschten Effekt gebracht        }  
    {Lightweight-Readpar       }
    noovrbuf:=false; 
    for i:=1 to paramcount do begin     
      if ((paramstr(i)='/?') and (not noovrbuf)) then noovrbuf:=true;
      if ((ustr(left(paramstr(i),4))='/AV:') and (not noovrbuf)) then noovrbuf:=true;
      if (ustr(paramstr(i))='/NOOVRBUF') then noovrbuf:=true;                                              
    end;

    {Overlaycache anlegen in EMS oder XMS       }
    { Size_OVR enthaelt die Groesse des OVR-Files        }
    ovrmemsize:=0;
    { Erstmal Variable initialisieren        }
    if ((EmsTest) and (not noovrbuf) and ((EmsAvail*16)>(Size_OVR+xpswapspace+700))) then
    begin
      OvrInitEMS;
      xmsovrbuf:=false;
      emsovrbuf:=true;
      ovrstr:=' (EMS)';
    end
    else if ((XmsTest) and (not noovrbuf) and (XmsAvail>(Size_OVR+xpswapspace+700))) then
    begin
      OvrInitXMS;
      xmsovrbuf:=true;
      emsovrbuf:=false;
      ovrstr:=' (XMS)';
    end
    else begin
      xmsovrbuf:=false;
      emsovrbuf:=false;  
    end;
    OvrSetBuf(OvrGetBuf+50000);   { > CodeSize(MASKE.TPU)        }
  {$ENDIF       }
  logo;
  {$IFNDEF NO386}
  InitWinVersion;  
  if WinVersion=4 then begin 
      modus:=true;
      nttimer:=0; 
  end;
  If (WinVersion = 3) or { Win 9x/ME/...        }
     ((WinVersion = 4) and (lo(WinNTVersion)>=5)) then { Win 2k/XP/...        }
    EnableLFN;
  {$ENDIF       }
  OwnPath:=progpath;
  if ownpath='' then getdir(0,ownpath);
  if right(ownpath,1)<>'\' then
    ownpath:=ownpath+'\';
  if cpos(':',ownpath)=0 then begin
    if left(ownpath,1)<>'\' then ownpath:='\'+ownpath;
    ownpath:=getdrive+':'+ownpath;
    end;
  UpString(ownpath);
  TestCD;
  starting:=false;
end.
