{ ------------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.                   }
{ (c) 1991-1999 Peter Mandrella                                       }
{ (c) 2000-2001 OpenXP-Team                                           }
{ (c) 2002-2025 FreeXP, http://www.freexp.de                          }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.         }
{                                                                     }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der     }
{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html }
{ ------------------------------------------------------------------- }

(***********************************************************)
(*                                                         *)
(*                        UNIT xpovl                       *)
(*                                                         *)
(*        Overlay fr Strings und Typkonvertierungen       *)
(*                                                         *)
(***********************************************************)

{$I XPDEFINE.INC        }
{$O+,F+       }

unit xpovl;

{  ==================  Interface-Teil  ===================         }

interface

uses
  xpglobal,typeform,dos;


const Umlaut_List  = 'ဇ慊';
      Umlaut_Konv1 = 'aeiouAOUsCcoaaAaAEynN?!^^maeiouaeiuoaeiou';
      Umlaut_Konv2 = 'e--eeeees------ee------2ny---------------';  { '-' = ''        }

      iso15 : boolean = false;

procedure UkonvStr(var s:string;maxlen:byte;otherOK:boolean);  { ASCII-Konvertierung        }
Procedure Rot13(var data; size: word);          { Rot 13 Kodierung        }
Procedure RepStr(var s:string; s1,s2:string);   { s1 einmal durch s2 ersetzen        }

Function  diskfree_string(drive:byte):string;    { Anzeige freier Plattenplatz X/S/S und Filebox        }

{ JG: 04.02.00 Mailadresse aus String ausschneiden        }
{ MY: komplett berarbeitet                10/2004        }
function  mailstring(s:string; var s1:string; const remove:boolean):string;
                                                           
Function  rforms(const s:string; const n:byte):string;     { String links mit ' ' auff.          }
Function  SMatch(const s1,s2:string):byte;       { Anzahl der bereinst. Bytes          }
Function  GetToken(var s:string; delimiter:string):string;
Function  OctVal(s:string):longint;              { Oktalstring -> Logint                }
Function  Reverse(s:string):string;              { String umkehren                      }
Function  TimeDiff(t1,t2:DateTimeSt):longint;    { Abstand in Sekunden                  }
Function  isnum(const s:string):boolean;         { s besteht aus [0..9]                 }
Function  RightPos(c:char; s:string):byte;       { Pos von rechts                       }
Function  StrSn(const l:longint; const n:byte):string;     { "echtes" Str$, Integer             }
Function  StrSr(const r:real; const nk:byte):string;       { Str$ auf nk, Real                  }
Function  StrSrn(const r:real; const vk,nk:byte):string;   { "echtes" Str$, Real                }
Function  StrSrnp(const r:real; const vk,nk:byte):string;  { "echtes" Str$, Real, mit DP        }
Function  MinMaxR(const x,min,max:real):real;    { x -> [min,max]                       }
Function  MaxS(const a,b:string):string;         { Maximum String                       }
Function  MinR(const a,b:real):real;             { Minimum Real                         }
Function  MaxR(const a,b:real):real;             { Maximum Real                         }
Function  Round(const r:real; const nk:integer):real;      { Real --> Real auf nk runden        }
Function  Hoch(const r:real; const n:integer):real;        { Hoch <-- r^n                       }
Function  BlankposX(const s:string):byte;        { length(s)+1, falls bp=0              }
(* Function  BlankposHuge(var s:Hugestring):Integer;          { Position von ' ' oder #9           } *)
Procedure DellastHuge(var s:HugeString);
Function  Center(const s:string; n:byte):string; { String auf n Zchn. zentrieren        }
Function  TopStr(const s:string):string;         { erster Buchstabe gro                }
Function  TopAllStr(s:string):string;            { alle ersten Buchstaben gro          }
procedure SetLength(var s: String; size: Longint);         { Lnge von S setzen        }
procedure RfcQuoteString(var s:string; const maxlen:byte;  { RFC-Quoting        }
          const rfc:boolean);
function  RfcUnquoteToken(var s:string):string;            { RFC-Unquoting        }

{ ================= Implementation-Teil ==================         }

implementation

uses xp0,resource,clip;

{$IFDEF BP        }
procedure SetLength(var s: String; size: Longint); { Lnge von S setzen        }
begin
  s[0] := char(size);
end;
{$ENDIF        }


{$IFNDEF Windows       }

function topallstr(s:string):string;
var top : boolean;
    p   : byte;
begin
  p:=1; top:=true;
  while p<=length(s) do begin
    if (s[p]>='A') and (s[p]<='Z') or (s[p]='') or (s[p]='') or (s[p]='') then
      if top then top:=false
      else s[p]:=LoCase(s[p])
    else
      if ((s[p]<'a') or (s[p]>'z')) and (s[p]<>'') and (s[p]<>'') and (s[p]<>'')
      then
        top:=true;
    inc(p);
    end;
  topallstr:=s;
end;

{$ELSE       }

function topallstr(s:string):string;
var top : boolean;
    p   : byte;
begin
  p:=1; top:=true;
  while p<=length(s) do begin
    if (s[p]>='A') and (s[p]<='Z') or (s[p]>=#192) and (s[p]<=#221) then
      if top then top:=false
      else s[p]:=LoCase(s[p])
    else
      if ((s[p]<'a') or (s[p]>'z')) and ((s[p]<#224) or (s[p]>#253))
      then
        top:=true;
    inc(p);
    end;
  topallstr:=s;
end;

{$ENDIF       }


function TopStr(const s:string):string;
begin
  if s='' then TopStr:=''
  else TopStr:=UpCase(s[1])+LStr(copy(s,2,254));
end;


function center(const s:string; n:byte):string;
begin
  if length(s)>=n-1 then center:=left(s,n)
  else center:=sp((n-length(s))div 2)+s+sp((n-length(s)-1)div 2);
end;


procedure DellastHuge(var s:HugeString);
begin
  if s<>'' then SetLength(s, Length(s)-1);
end;


Function BlankposHuge(var s:Hugestring):Integer;  { Position von ' ' oder #9            }
var p1,p2 : Integer;
begin
  p1:=cpos(' ',s);
  p2:=cpos(#9, s);
  if p1=0 then blankposHuge:=p2
  else if p2=0 then blankposHuge:=p1
  else blankposHuge:=min(cpos(' ',s),cpos(#9,s));
end;


Function BlankposX(const s:string):byte;       { length(s)+1, falls bp=0        }
var p : byte;
begin
  p:=blankpos(s);
  if p>0 then BlankposX:=p
  else BlankposX:=min(255,length(s)+1);
end;


Function Hoch(const r:real; const n:integer):real;
var i : integer;
    x : real;
begin
  x:=1;
  for i:=1 to n do
    x:=x*r;
  hoch:=x;
end;


Function Round(const r:real; const nk:integer):real;
begin
  round:=int(r*hoch(10,nk)+0.5)/hoch(10,nk);
end;


Function MaxR(const a,b:real):real;
begin
  if a>b then maxr:=a else maxr:=b;
end;


Function MinR(const a,b:real):real;
begin
  if a<b then minr:=a else minr:=b;
end;


Function MaxS(const a,b:string):string;
begin
  if a>b then maxs:=a else maxs:=b;
end;


Function MinMaxR(const x,min,max:real):real;
begin
  if x<min then MinMaxR:=min
  else if x>max then MinMaxR:=max
  else MinMaxR:=x;
end;


Function StrSrnp(const r:real; const vk,nk:byte):string;
var s : string;
begin
  s:=strsrn(r,vk,nk);
  if r>=1000000 then
    s:=copy(s,3,vk-8)+'.'+copy(s,vk-5,3)+'.'+copy(s,vk-2,3)+','+right(s,nk)
  else if r>=1000 then
    s:=copy(s,2,vk-4)+'.'+copy(s,vk-2,3)+','+right(s,nk)
  else
    s:=copy(s,1,vk)+','+right(s,nk);
  if s[length(s)]=',' then
    s:=' '+copy(s,1,length(s)-1);
  strsrnp:=s;
end;


Function StrSrn(const r:real; const vk,nk:byte):string;
var s : string;
begin
  if nk=0 then
    str(r:vk:0,s)
  else
    str(r:vk+nk+1:nk,s);
  strsrn:=s;
end;


Function StrSr(const r:real; const nk:byte):string;
var s : string[40];
begin
  str(r:0:nk,s);
  strsr:=s;
end;


Function StrSn(const l:longint; const n:byte):string;
var s : string[20];
begin
  str(l:n,s);
  strsn:=s;
end;


Function RightPos(c:char; s:string):byte;    { Pos von rechts        }
var p : byte;
begin
  p:=length(s);
  while (p>0) and (s[p]<>c) do dec(p);
  RightPos:=p;
end;


Function isnum(const s:string):boolean;      { s besteht aus [0..9]        }
var i : integer;
begin
  if s='' then
    isnum:=false
  else begin
    i:=1;
    while (i<=length(s)) and (s[i]>='0') and (s[i]<='9') do
      inc(i);
    isnum:=(i>length(s));
    end;
end;


Function TimeDiff(t1,t2:DateTimeSt):longint;    { Abstand in Sekunden         }

  function TimeSecs(var t:DateTimeSt):longint;
  begin
    TimeSecs:=3600*ival(left(t,2))+60*ival(copy(t,4,2))+ival(right(t,2));
  end;

begin
  if t1<=t2 then
    TimeDiff:=0
  else
    TimeDiff:=TimeSecs(t1)-TimeSecs(t2);
end;


function reverse(s:string):string;
var i : byte;
begin
  reverse[0]:=s[0];
  for i:=1 to length(s) do reverse[i]:=s[length(s)+1-i];
end;


function OctVal(s:string):longint;     { Oktalstring -> Logint        }
var l   : longint;
    n   : integer;
    sgn : boolean;
begin
  s:=trim(s);
  sgn:=(firstchar(s)='-');
  if sgn then delfirst(s);
  l:=0;
  for n:=1 to length(s) do
    l:=(l shl 3) + ord(s[n]) - $30;
  if l>=0 then OctVal:=iif(sgn,-l,l)
  else OctVal:=0;
end;


{ erstes durch 'delimiter' abgegrenztes Wort aus s extrahieren        }

Function GetToken(var s:string; delimiter:string):string;
var p : byte;
begin
  if delimiter=' ' then begin
    s:=trim(s);
    p:=blankposx(s);
    GetToken:=left(s,p-1);
    delete(s,1,p);
    s:=ltrim(s);
    end
  else begin
    p:=posx(delimiter,s);
    GetToken:=trim(left(s,p-1));
    s:=trim(mid(s,p+length(delimiter)));
    end;
end;


Function SMatch(const s1,s2:string):byte;    { Anzahl der bereinst. Bytes         }
var p,ml : byte;
begin
  p:=0;
  ml := min(length(s1),length(s2));
  while (p<ml) and (s1[p]=s2[p]) do
    inc(p);
  SMatch:=p;
end;


Function rforms(const s:string; const n:byte):string;    { String links mit ' ' auff.          }
begin
  if length(s)>=n then
    rforms:=right(s,n)
  else
    rforms:=sp(n-length(s))+s;
end;


function diskfree_string(drive:byte):string;
var   dfree : longint;
const   rnr = 500;
      bighd = $7FF00000;
begin
{$IFNDEF NO386}
  if xp_ntvdm_ok then
  begin
    dfree:=NTDiskFree(drive);
    if dfree>=0 then
    begin
      if dfree<99999 then
        diskfree_string:=strsn(dfree,6)+' MB'
      else begin
        dfree:=dfree DIV $400;
        if dfree<99999 then
          diskfree_string:=strsn(dfree,6)+' GB'
        else begin
           dfree:=dfree DIV $400;
           diskfree_string:=strsn(dfree,6)+' TB';
        end;
      end;
    end
    else diskfree_string:=getres2(rnr,16);  { 'ber 2 PB'        }
  end
  else begin
  {$ENDIF}
    dfree:=fileio.diskfree(drive);
    if dfree<bighd then
      diskfree_string:=strsrn(dfree/$100000,4,1)+' MB'
    else
      diskfree_string:=getres2(rnr,11);     { 'ber 2 GB'        }
	  {$IFNDEF NO386}
  end;
    {$ENDIF}
end;


{ -------------------------------------------------------------------------        }
{ Mailadresse ('@' in der Mitte) in einem String erkennen und ausschneiden         }
{ Ist remove=true, dann wird aus 's' die Mailadresse ausgeschnitten.               }
{ Wird keine gltige Adresse erkannt, wird der komplette String an die             }
{ Funktion zurckgegeben.                                                          }
{                                                                                  }
{                                                                                  }
{ nderungen my 10/2004:                                                           }
{ ----------------------                                                           }
{                                                                                  }
{ 1. Zustzliche Variable 's1' eingefhrt. Wird keine gltige Adresse              }
{    erkannt, wird 's1' ein Leerstring zugewiesen, anderenfalls wird die           }
{    Adresse sowohl an die Funktion als auch an 's1' zurckgegeben.                }
{                                                                                  }
{ my: Kommentare, quoted-strings, quoted-pairs und Domain-Literale werden          }
{     jetzt beachtet, die Adresse wird aber ansonsten *nicht* auf syntak-          }
{     tische Korrektheit gem RFC2822 berprft! Leerzeichen drfen nur in        }
{     Kommentaren, quoted-strings und Domain-Literalen vorkommen.                  }
{                                                                                  }
{     Die Adresse mu durch WSPs vom restlichen Text getrennt oder in '<>'         }
{     eingeschlossen sein oder sich ganz am Anfang des Strings befinden.           }
{                                                                                  }
{     Sie sollte danach noch mittels RFC2822_Remove von Kommentaren sowie          }
{     berflssigen quoted-strings und quoted-pairs bereinigt werden (falls        }
{     sie berhaupt verwendet wird, d.h. remove=false ist).                        }
{                                                                                  }
{     Wenn remove=true und sich sowohl links als auch rechts von der               }
{     Adresse je ein Leerzeichen befindet, wird das rechte mitgelscht.            }
{     Spitze Klammern werden ebenfalls gelscht (aber nicht in der Adresse         }
{     bergeben).                                                                  }
{                                                                                  }
{     Wenn der Versuch, beim ersten Vorkommen von "@" eine gltige Adresse         }
{     zu erkennen, fehlschlgt, wird die Routine nicht wie bisher ohne             }
{     Ergebnis abgebrochen, sondern es wird solange weitergesucht, bis eine        }
{     Adresse gefunden wurde oder kein "@" mehr vorhanden ist.                     }
{                                                                                  }
{ -------------------------------------------------------------------------        }
function mailstring(s:string; var s1:string; const remove:boolean):string;
const sc = #9#32+'()<>[]:;@,"';
var q,p1,p2,incomment : byte;
    ok,char_seen,
    inquote,lastdot   : boolean;
label start;
begin
  p2:=cpos('@',s);                                         { '@' vorhanden?        }
start:
  ok:=false;
  while not ok do
  begin
    inquote:=false;
    char_seen:=false;
    lastdot:=false;
    incomment:=0;
    if (p2>1) and (p2<length(s)) then
    begin
      p1:=p2;
      while p1>1 do                                         { Anfang suchen        }
      begin
        dec(p1);
        while (p1>1) and (s[p1-1]='\') and
               ((inquote and (s[p1]<chr(127)) and (s[p1]<>'\')) or
                (incomment>0)) do       { Zeichen in Kommentaren irrelevant        }
        begin
          q:=p1-1;
          while (q>1) and (s[q-1]='\') do dec(q);
          if (odd(p1-q)) then
            if p1>2 then
              dec(p1,2)
            else
              dec(p1);
        end;
        case s[p1] of
          '\' : if inquote then break;          { "\" alleine nicht erlaubt        }
          '"' : if not (char_seen or inquote) then
                  inquote:=true else
                if (char_seen and inquote) then            { "user"@do.main        }
                begin
                  inquote:=false; break;
                end else
                if char_seen then  { inquote=false        }   {     "user@do.main"        }
                begin                                  { => '"' ignorieren!        }
                  inc(p1); break;
                end
                else break; { char_seen=false, inquote=true        }  { ""@do.main        }
          ')' : if not inquote then inc(incomment);
          '(' : if not inquote then
                  if incomment>0 then
                    dec(incomment) else
                  if char_seen then                    {     (user@do.main)        }
                  begin                                { => '(' ignorieren!        }
                    inc(p1); break;
                  end
                  else break; { char_seen=false, incomment=0        } { (@do.main)        }
          '<' : if char_seen then                      {     <user@do.main>        }
                begin                                  { => '<' ignorieren!        }
                  inc(p1); break;
                end
                else break;  { char_seen=false        }               { <@do.main>        }
          #9,
          ' ' : if char_seen and not (inquote or (incomment>0)) then
                begin
                  inc(p1); break;
                end;
          '.' : if lastdot then
                begin                           { Fehler bei '..' erzwingen        }
                  char_seen:=false; break;
                end
                else lastdot:=not (inquote or (incomment>0));
        else if inquote and (s[p1]>chr(127)) then
          break
        else if incomment=0 then
          char_seen:=true;
        end;  { case        }
      end;
      if inquote or (incomment>0) or       { ungltiger local-part, evtl.          }
         not char_seen then                { '@' in quoted-string gefunden?        }
      begin
        q:=p2;
        p2:=cpos('@',mid(s,q+1));               { => nchstes '@' probieren        }
        if p2>0 then inc(p2,q);
      end else
        ok:=true;
    end
    else begin                                    { '@' am Anfang oder Ende        }
      p1:=0;
      p2:=0;
      ok:=true;
    end;
  end;
  { -----------------------------------------------------------------------        }
  { ab hier steht 'inquote' fr "in domain-literal"        }
  inquote:=false;
  char_seen:=false;
  incomment:=0;
  if (p1<p2) and (s[p2]='@') then
  begin
    q:=p2;  { p2 sichern        }
    while p2<length(s) do                                     { Ende suchen        }
    begin
      inc(p2);
      case s[p2] of
        '\' : if inquote or (incomment>0) then inc(p2);
        '[' : if not inquote and (incomment=0) and not char_seen then
                inquote:=true else if inquote then break;
        ']' : if inquote then inquote:=false else if incomment=0 then break;
        '(' : if not inquote then inc(incomment);
        ')' : if not inquote then
                if incomment>0 then dec(incomment) else
                begin incomment:=1; break; end;
      else if not (inquote or (incomment>0)) and (cpos(s[p2],sc)>0) then
      begin
        dec(p2);
        break;
      end else
        if incomment=0 then char_seen:=true;
      end
    end;
    if inquote or (incomment>0) or                   { ungltige Domain :-(        }
       not char_seen then
    begin
      p2:=cpos('@',mid(s,q+1));                 { => nchstes '@' probieren        }
      if p2>0 then inc(p2,q);
      goto start;
    end;
  end
  else begin                             { keine Adresse im String gefunden        }
    s1:='';
    mailstring:=s;
    exit;
  end;
  { -----------------------------------------------------------------------        }
  s1:=copy(s,p1,(p2-p1)+1);                              { Adresse gefunden        }
  if remove then
  begin
    if (p1>1) and (s[p1-1]='<') then dec(p1);              { angle brackets        }
    if (p2<length(s)) and (s[p2+1]='>') then inc(p2);      { mit entfernen         }
    if ((p1=1) or ((p1>1) and (s[p1-1] in [' ',#9]))) and
       (p2<length(s)) and (s[p2+1] in [' ',#9]) then inc(p2);
    delete(s,p1,(p2-p1)+1);
    mailstring:=s;
  end
  else begin
    s1:=copy(s,p1,(p2-p1)+1);
    mailstring:=s1;
  end;
end;


Procedure RepStr(var s:string; s1,s2:string); { s1 einmal durch s2 ersetzen        }
var p : byte;
begin
  p:=pos(s1,s);
  if p>0 then begin
    delete(s,p,length(s1));
    insert(s2,s,p);
    end;
end;


{ ROT13 Kodierung        }
procedure Rot13(var data; size: word); {&uses edi       } assembler;
asm
         les   di,data
         mov   cx,size
         jcxz  @ende
         cld
  @rotlp:
         mov   al,es:[di]
         cmp   al,'A'
         jb    @rot
         cmp   al,'Z'
         ja    @noupcase
         add   al,13
         cmp   al,'Z'
         jbe   @rot
         sub   al,26
         jmp   @rot
  @noupcase:
         cmp   al,'a'
         jb    @rot
         cmp   al,'z'
         ja    @rot
         add   al,13
         cmp   al,'z'
         jbe   @rot
         sub   al,26
  @rot:
         stosb
         loop  @rotlp
  @ende:
end;


procedure UkonvStr(var s:string;maxlen:byte;otherOK:boolean);
var i,j,k : byte;
        l : integer;
       s2 : string[3];
     conv : boolean;

const Other_List  = '';
      Other_Konv1 = 'c--<>###|++++++|+++++++++-++++++++-+++++++++++++#####aGpSstPTOdpe/=><||/=*';
      Other_Konv2 = '---<>--------------------------------------------------i---hh--h-\-==-----';  { '-' = ''        }

begin
  i:=1; k:=length(s);
  While i <= k do begin
    conv:=false;
    if s[i] > #127 then
    begin
      conv:=true;
      if (s[i]=chr(euro)) and (OtherOK or (not OtherOK and euro_allowed)) then
        s2:='EUR' else                  { '' (Euro)        }
      if s[i]=#156 then s2:='GBP' else  { ''        }
      if s[i]=#157 then s2:='JPY' else  { ''        }
      if s[i]=#158 then s2:='ESP' else  { ''        }
      if s[i]=#159 then s2:='NLG' else  { ''        }
      if s[i]=#171 then s2:='1/2' else  { ''        }
      if s[i]=#172 then s2:='1/4' else  { ''        }
      if s[i]=#241 then s2:='+/-' else  { ''        }
      begin
        j:=cpos(s[i],Umlaut_List);      { "normale" Umlaute und Sonderzeichen        }
        if j=0 then
        begin
          conv:=false;
          if not otherOK then           { restliche Sonderzeichen z.B. bei Betreffkonvertierung        }
          begin                         { - nicht aber bei Suchfunktionen -        }
            conv:=true;
            j:=cpos(s[i],Other_List);
            if j=0 then s2:='.'
            else s2:=copy(Other_Konv1,j,1)+
              iifs(copy(Other_Konv2,j,1)='-','',copy(Other_Konv2,j,1));
          end;
        end
        else s2:=copy(Umlaut_Konv1,j,1)+
          iifs(copy(Umlaut_Konv2,j,1)='-','',copy(Umlaut_Konv2,j,1));
      end;
      if conv then
      begin
        l:=i + (length(s2)-1);
        if l > maxlen then  { Wenn's nicht mehr vollstndig in 'maxlen' pat...        }
        begin
          s:=left(s,i-1);   { ...String vor dem aktuellen Zeichen abschneiden        }
          exit;             { und fertig        }
        end
        else begin
          delete(s,i,1);
          insert(s2,s,i);
          l:=k + (length(s2)-1);  { 'inc(k,length(s2)-1)' geht nicht, weil        }
          k:=min(l,255);          { 'inc(254,2)' gleich 1 (ergbe Abbruch)        }
        end;
      end;
    end;
    if conv then
      inc(i,length(s2))     { Erstes Zeichen nach Ersetzungszeichen prfen        }
    else inc(i);            { Kein Zeichen ersetzt - nchstes Zeichen prfen        }
  end;
  s:=left(s,maxlen);        { String auf 'maxlen' krzen (wegen Headern)        }
end;


{ my: String in strukturiertem Header quoten        }
{                                                   }
{     Wenn 'rfc' true ist, wird der String          }
{     streng nach RFC2822 gequotet (z.B. bei        }
{     UUZ-Konvertierung), anderenfalls wird         }
{     er nur gequotet, wenn er ein Komma            }
{     enthlt (z.B. fr Stichwort-Header,           }
{     die Phrasen mit Kommata enthalten,            }
{     relevant z.B. bei der Eingabe von             }
{     Stichworten im Sendefenster).                 }

procedure RfcQuoteString(var s:string; const maxlen:byte; const rfc:boolean);
var p : byte;
    q : string[42];
const ql = '()<>@,;:\".[]';           { Beim Vorkommen von RFC2822-Specials        }
begin                                 { mu der String gequotet werden             }
  q:=iifs(rfc,ql,',');
  s:=left(s,maxlen);
  if (length(s)>=maxlen) and             { Prfen, ob nach evtl. Krzen des        }
     (multipos(q,s)) then                { Strings fr die beiden DQUOTEs          }
    for p:=1 to 2 do                     { immer noch gequotet werden mu          }
    begin                   
      dellast(s);
      if not multipos(q,s) then exit;
    end;
  if multipos(q,s) then
  begin
    p:=0;
    while p<length(s) do
    begin
      inc(p);
      if s[p] in ['"','\'] then
      begin
        insert(#255,s,p);
        inc(p);
      end;
    end;
    s:=left(s,maxlen-2);                       { Platz fr DQUOTEs schaffen        }
    if lastchar(s)=#255 then                 { ggf. letztes '\' abschneiden        }
      dellast(s);
    repeat
      p:=cpos(#255,s);                            { #255 durch '\' ersetzen        }
      if p>0 then s[p]:='\';
    until p=0;
    if (s<>'') and                    { Theoretisch knnte es sein, da das        }
       (multipos(q,s)) then           { einzige Zeichen, das zum Quoten            }
      s:='"'+s+'"';                   { gefhrt hat, abgeschnitten wurde...        }
  end;
end;


{ my: Nach RFC2822 gequoteten String in strukturiertem,        }
{     komma-separiertem Header unquoten und erstes             }
{     Token zurckgeben                                        }

function RfcUnquoteToken(var s:string):string;
var q,p : byte;

    function QuotedChar(const c:byte):boolean;
    var qc : byte;
    begin
      qc:=c;
      while (qc>1) and (s[qc-1]='\') do dec(qc);
      QuotedChar:=odd(c-qc);
    end;

begin
  q:=0;
  p:=0;
  while p<length(s) do
  begin
    inc(p);
    case s[p] of
      '"' : if q=0 then                            { nicht in quoted-string        }
            begin
              q:=p;
              repeat                           { schlieendes DQUOTE suchen        }
                q:=posn('"',s,q+1);
              until (q=0) or ((q>0) and not QuotedChar(q));
              if q>0 then                   { schlieendes DQUOTE gefunden,        }
                q:=p;                       { ffnendes    DQUOTE merken           }
            end
            else begin                                   { in quoted-string        }
              delete(s,p,1);                { schlieendes DQUOTE entfernen        }
              delete(s,q,1);                { ffnendes    DQUOTE entfernen        }
              q:=0;
              dec(p,2);
            end;
      '\' : if q>0 then                                  { in quoted-string        }
              delete(s,p,1);                        { quoted-pair entfernen        }
      ',' : if q=0 then
            begin
              RfcUnquoteToken:=trim(left(s,p-1));
              if p<length(s) then
                s:=trim(mid(s,p+1))
              else
                s:='';
              exit;
            end;
    end;
  end;
  RfcUnquoteToken:=trim(s);                         { kein Trenner gefunden        }
  s:='';
end;


end.
