{ ------------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.                   }
{ (c) 1991-1999 Peter Mandrella                                       }
{ (c) 2000-2001 OpenXP-Team                                           }
{ (c) 2002-2024 FreeXP, http://www.freexp.de                          }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.         }
{                                                                     }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der     }
{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html }
{ ------------------------------------------------------------------- }

{ beliebig groen Netcall- oder ZConnect-Header auswerten        }
{ wird in XP3, MAGGI, XPCHECK und UUZ included                   }


{ Achtung! hd.empfaenger enthlt u.U. eine /TO:-Kennung        }

var line : string;

procedure makeheader(const ZConnect:boolean; var f:file; empfnr,disknr:smallword;
                     var size:longint; var hd:header; var ok:boolean;
                     const PM2AMconv:boolean);
var i,res     : integer;
    o         : word;     { Offset im Lesepuffer        }
    s         : string[20];
    dummy     : string[realnlen];
    p         : word;
    id        : string[30];  { Headername in Groschreibung        }
    id0       : string[30];  { Headername in Originalschreibweise        }
    buf       : charrp;
    bufsize   : word;
    bufanz    : word;     { gelesene Bytes im Puffer        }
    tc        : char;     { 1. Trennzeichen hinter ':'        }
    gate_done : boolean;  { 'GATE:' gelesen => 'X-Gateway:' ignorieren        }

  procedure ReadBuf;
  begin
    blockread(f,buf^,bufsize,bufanz);
    o:=0;
  end;

  procedure IncO;
  begin
    inc(o);
    if o=bufanz then
      if eof(f) then
        ok:=false
      else begin
        inc(size,bufsize);
        ReadBuf;
      end;
  end;

  procedure getline(var s:string; const maxlen:byte);
  var l : byte;
  begin
    l:=0;
    while (o<bufanz) and (buf^[o]<>#13) do
    begin
      if l<maxlen then
      begin
        inc(l);
        s[l]:=buf^[o];
      end;
      incO;
    end;
    s[0]:=char(l);
    IncO;
    if ok and (buf^[o]=#10) then IncO;
  end;

  {$ifdef uuzmime       }

  { -----------------------------------------------------------------        }
  { my: Liest eine ZConnect-Headerzeile nach 'HdrLine' mit max. 65500        }
  {     Zeichen sowie nach 's' mit 'maxlen' Zeichen ein.      05/2004        }
  { -----------------------------------------------------------------        }

  function GetZcHdr(var s:string; const maxlen:byte):boolean;
  begin
    GetZcHdr:=false;
    truncated:=false;
    rest:='';
    tc:= ' ';
    HdrLen:=0;
    while (o<bufanz) and (buf^[o]<>#13) do
    begin
      if HdrLen<sizeof(HdrLine^) then
      begin
        inc(HdrLen);
        HdrLine^[HdrLen]:=buf^[o];
      end
      else begin
        truncated:=true;
        if length(rest)<sizeof(rest)-1 then rest:=rest+buf^[o];
      end;
      IncO;
    end;
    IncO;
    if ok and (buf^[o]=#10) then IncO;
    p:=HdrLen;
    while HdrLine^[HdrLen] in [' ',#9] do dec(HdrLen);             { rtrim        }
    if HdrLen>2 then
    begin
      GetZcHdr:=true;
      if HdrLine^[1]<' ' then  { gegen LFs o..        }
      begin
        dec(HdrLen);
        move(HdrLine^[2],HdrLine^[1],HdrLen);
      end;
      p:=1;
      while (p<HdrLen) and (HdrLine^[p]<>':') do inc(p);
      if (p<2) or ((p=HdrLen) and (HdrLine^[p]<>':')) then
        ok:=false
      else begin
        byte(id[0]):=min(p-1,sizeof(id)-1);
        fastmove(HdrLine^[1],id[1],byte(id[0]));
        if p<HdrLen then tc:=HdrLine^[p+1];
        inc(p);
        while (p<HdrLen) and (HdrLine^[p] in [' ',#9]) do inc(p);  { ltrim        }
        if (p=HdrLen) and (HdrLine^[p] in [' ',#9]) then
          HdrLen:=0
        else
          dec(HdrLen,p-1);
      end;
    end;
    byte(s[0]):=min(maxlen,HdrLen);
    if HdrLen>0 then
    begin
      move(HdrLine^[p],HdrLine^[1],HdrLen);
      fastmove(HdrLine^[1],s[1],byte(s[0]));
      s:=rtrim(s);
    end;
  end;

  {$else       }

  { -----------------------------------------------------------------        }
  { my: Liest einen ZConnect-Header nach 's' mit 'maxlen' Zeichen ein        }
  { -----------------------------------------------------------------        }

  function GetZcHdr(var s:string; const maxlen:byte):boolean;
  begin
    GetZcHdr:=false;
    tc:= ' ';
    getline(s,maxlen);
    s:=rtrim(s);
    if length(s)>2 then
    begin
      GetZcHdr:=true;
      if s[1]<' ' then delfirst(s);  { gegen LFs o..        }
      p:=cpos(':',line);
      if p<2 then
        ok:=false
      else begin
        id:=left(s,p-1);
        tc:=s[p+1];
        s:=ltrim(mid(s,p+1));
      end;
    end;
  end;

  {$endif       }

  procedure GetName(var name,realname:string);
  var p : byte;
  begin
    p:=pos(' (',line);
    if (p=0) or (p<cpos('@',line)) then p:=adrLen
    else
      realname:=trim(copy(line,p+2,min(length(line)-p-2,realnlen)));
    name:=left(line,min(adrLen-1,p-1));
  end;

  procedure LRead(var s:string; maxlen:byte);
  begin
    if maxlen<length(line) then
      line[0]:=chr(maxlen);
    s:=line;
  end;

  {$ifdef uuzmime       }
  procedure GetFrom(const is_abs:boolean);
  var a : string[adrlen];
      r : string[realnlen];
  begin
    a:=''; r:='';
    GetName(a,r);
    if is_abs then
    begin
      hd.absender:=a;
      hd.realname:=r;
    end;
    if (hd.absanz<maxabs) and (cpos('@',a)>0) then with hd do
    begin
      if xabs=nil then
      begin
        new(xabs);
        fillchar(xabs^,sizeof(xabs^),0);
        absanz:=0;
      end;
      if maxavail>=(length(a)+1)+(length(r)+1) then
      begin
        inc(absanz);
        getmem(xabs^[absanz].adr,length(a)+1);
        getmem(xabs^[absanz].name,length(r)+1);
        xabs^[absanz].adr^:=a;
        xabs^[absanz].name^:=r;
      end;
    end;

  end;
  {$endif       }

  procedure GetEmpf;
  var p : byte;
      s : string[adrlen];
  begin
    if readempflist then
    begin
      LRead(s,adrlen-1);
      if (cpos('@',s)>0) or (s[1]<>'/') then
      begin
        p:=pos(' (',s);
        if p>0 then byte(s[0]):=p-1;
      end;
      if hd.empfanz+1=empfnr then
        hd.empfaenger:=s
      else
        AddToEmpflist(s);
    end
    else if (empfnr=0) or (hd.empfanz<empfnr) then
    begin
      LRead(hd.empfaenger,adrlen-1);
      if (cpos('@',s)>0) or (s[1]<>'/') then
      begin
        p:=pos(' (',hd.empfaenger);
        if p>0 then byte(hd.empfaenger[0]):=p-1;
      end;
    end;
    if hd.empfanz<=maxemp then
      inc(hd.empfanz);
  end;

  procedure GetAbsender;
  begin
    {$ifdef uuzmime       }
    GetFrom(true);
    {$else       }
    GetName(absender,realname);
    {$endif       }
  end;

  procedure GetReplyTo;
  begin
    {$ifdef uuzmime       }
    if id0 = 'antwort-An' then
      GetFrom(false)
    else
      GetName(hd.PmReplyTo,dummy);
    {$else       }
    GetName(hd.PmReplyTo,dummy);
    {$endif       }
  end;

  procedure GetBetr;
  begin
    {$ifdef uuzmime       }
    SaveLongHdr(LSub,BetreffLen,line,hd.betreff,false,0);
    {$else       }
    LRead(hd.betreff,BetreffLen);
    {$endif       }
  end;

  procedure GetPfad;
  begin
    {$ifdef uuzmime       }
    SaveLongHdr(LPath,sizeof(hd.pfad)-1,line,hd.pfad,false,0);
    {$else       }
    hd.pfad:=line;
    {$endif       }
  end;

  {$ifdef allrefs       }

  procedure GetRef;             { Die letzte Referenz befindet sich *immer*        }
  begin                         { in hd.ref. Die vorletzte steht in                }
    with hd do                  { reflist^.ref, die davor in reflist^.next^        }
    begin                       { .ref etc.                                        }
      if ref<>'' then
        AddToReflist(ref);
      LRead(ref,midlen);
      inc(refanz);
    end;
  end;

  {$else       }
  {$ifdef uuzrefs       }

  procedure GetRef;
  begin
    with hd do
      if ref='' then
        LRead(ref,midlen)
      else begin

{ 24.09.1999 robo - Fix: Absturz bei zu vielen BEZ-Headern        }

{        inc(addrefs);        }

        if addrefs<maxrefs then inc(addrefs)
        else Move(addref[2],addref[1],(maxrefs-1)*sizeof(addref[1]));

{ /robo        }

        LRead(addref[addrefs],midlen);
      end;
  end;

  {$else       }

  procedure GetRef;
  begin
    LRead(hd.ref,midlen);
  end;

  {$endif       }
  {$endif       }


  procedure GetKop;
    procedure AddKop(var node:empfnodep);
    begin
      if node=nil then
      begin
        new(node);
        LRead(node^.empf,AdrLen);
        node^.next:=nil;
      end
      else
        AddKop(node^.next);
    end;
  begin
    if ReadKoplist then
      AddKop(hd.kopien);
  end;

  procedure GetTyp(var typ,charset:string);
  begin
    if line<>'' then
    begin
      if (UStr(line)<>'TRANSPARENT') and (UStr(line)<>'MIME') then typ:='B';
      if (typ<>'T') and (typ<>'') then charset:='';
    end;
  end;

  procedure GetStat;
  var p : byte;
  begin
    if line='' then exit;
    UpString(line);
    line:=trim(line)+' ';
    repeat
      p:=cpos(' ',line);
      if left(line,p-1)='EB' then hd.attrib:=hd.attrib or attrIsEB else
      if left(line,p-1)='PM-REPLY' then hd.pm_reply:=true else
      if left(line,p-1)='NOKOP' then hd.nokop:=true else
      if left(line,p-1)='CTL' then hd.attrib:=hd.attrib or attrControl;
      line:=ltrim(mid(line,p+1));
    until line='';
  end;

  {$ifndef uuzmime       }
  procedure CheckBetreff;
  var p : byte;
  begin
    repeat
      p:=cpos(#7,hd.betreff);
      if p>0 then hd.betreff[p]:='';
    until p=0;
    repeat
      p:=cpos(#8,hd.betreff);
      if p>0 then hd.betreff[p]:='';
    until p=0;
  end;
  {$endif       }

  procedure GetFollowup;
  begin
    if cpos('@',line)>0 then exit;
    if ((disknr>0) and (hd.amrepanz<disknr)) or (hd.amrepanz=0) then
      LRead(hd.AmReplyTo,79);
    if hd.amrepanz<127 then
      inc(hd.amrepanz);
  end;

  procedure GetStichwort;
  var s : string;
      p : byte;
  begin
  {$ifdef uuzmime       }                                     { UUZ: Stichworte in        }
    s:=line;                                           { verketteter Liste         }
    if maxavail>=sizeof(keystart^)+length(s)+1 then    { ablegen                   }
    begin                                              { (nicht quoten!)           }
      if keystart=nil then
      begin
        new(keystart);
        keystart^.next:=nil;
        getmem(keystart^.s,length(s)+1);
        keystart^.s^:=s;
        keylauf:=keystart;
      end
      else begin                    { hinten anfgen        }
        new(keylauf^.next);
        keylauf:=keylauf^.next;
        keylauf^.next:=nil;
        getmem(keylauf^.s,length(s)+1);
        keylauf^.s^:=s;
      end;
    end;
  {$else       }                                              { XP: Stichworte als        }
    if length(hd.keywords)>sizeof(hd.keywords)-3 then  { komma-separierte          }
      exit;                                            { Liste in                  }
    LRead(s,sizeof(hd.keywords)-1);                    { 'keywords' ablegen        }
    p:=sizeof(hd.keywords)-1-length(hd.keywords)-      { (quoten!)                 }
       iif(hd.keywords='',0,1);
    RfcQuoteString(s,p,false);
    if (hd.keywords<>'') and (s<>'') then hd.keywords:=hd.keywords+',';
    hd.keywords:=hd.keywords+s;
  {$endif       }
  end;

  procedure GetMailprog;
  begin
    {$ifdef uuzmime       }
    SaveLongHdr(LProg,sizeof(hd.programm)-1,line,hd.programm,false,0);
    {$else       }
    hd.programm:=line;
    {$endif       }
  end;

  procedure GetOrg;
  begin
    {$ifdef uuzmime       }
    SaveLongHdr(LOrg,sizeof(hd.organisation)-1,line,hd.organisation,false,0);
    {$else       }
    LRead(hd.organisation,sizeof(hd.organisation)-1);
    {$endif       }
  end;

  procedure GetSummary;
  begin
    {$ifdef uuzmime       }
    SaveLongHdr(LSum,sizeof(hd.summary)-1,line,hd.summary,false,0);
    {$else       }
    LRead(hd.Summary,sizeof(hd.summary)-1);
    {$endif       }
  end;

  procedure GetHomepage;
  begin
    {$ifdef uuzmime       }
    SaveLongHdr(LHome,sizeof(hd.homepage)-1,line,hd.homepage,false,0);
    {$else       }
    LRead(hd.homepage,sizeof(hd.homepage)-1);
    {$endif       }
  end;

  procedure GetPost;
  begin
    {$ifdef uuzmime       }
    SaveLongHdr(LPost,sizeof(hd.postanschrift)-1,line,hd.postanschrift,false,0);
    {$else       }
    LRead(hd.postanschrift,sizeof(hd.postanschrift)-1);
    {$endif       }
  end;

  procedure GetTelefon;
  begin
    {$ifdef uuzmime       }
    SaveLongHdr(LTele,sizeof(hd.telefon)-1,line,hd.telefon,false,0);
    {$else       }
    LRead(hd.telefon,sizeof(hd.telefon)-1);
    {$endif       }
  end;

  procedure GetCrypt;
  var s : string;
  begin
    lread(s,10);
    UpString(s);
    if s='QPC' then inc(hd.attrib,attrQPC)
    {$IFDEF PGP       }
      else if s='PGP' then inc(hd.pgpflags,fPGP_encoded)
    {$ENDIF       }
    ;
  end;

  {$IFDEF PGP       }
    procedure GetSigned;
    var s : string;
    begin
      lread(s,10);
      UpString(s);
      if s='PGP' then inc(hd.pgpflags,fPGP_signed) else
      if s='PGPCLEAR' then inc(hd.pgpflags,fPGP_clearsig);
    end;

    procedure GetPGP;
    var s : string;
    begin
      lread(s,10);
      UpString(s);
      if s='PLEASE' then inc(hd.attrib,fPGP_please) else
      if s='REQUEST' then inc(hd.pgpflags,fPGP_request);
    end;

    procedure GetPGPid;
    var s : string;
        p : byte;
    begin
      lread(s,120);
      p:=cpos('<',s);
      if (p>0) and (lastchar(s)='>') then begin
        delete(s,1,p);
        dellast(s);
        if cpos('@',s)>0 then hd.pgp_uid:=s;
        end;
    end;

    procedure GetXPpgp;
    var s : string[10];
    begin
      lread(s,10);
      LoString(s);
      if s='sigok'    then hd.pgpflags := hd.pgpflags or fPGP_sigok else
      if s='sigerror' then hd.pgpflags := hd.pgpflags or fPGP_sigerr;
    end;
  {$ENDIF       }

  procedure GetQStr;
  begin
    with hd do begin
      LRead(QuoteString,sizeof(QuoteString)-1);
      if quotestring[1]='"' then delfirst(quotestring);
      if quotestring[length(quotestring)]='"' then dellast(quotestring);
      end;
  end;

  procedure GetCharset(var charset:string);
  begin
    if charset='' then
    begin
      LRead(charset,sizeof(hd.charset)-1);
      {$ifndef uuzmime       }
      lostring(charset);
      {$endif       }
    end;
  end;

  procedure ParseContentType;
  var p       : byte;
      parname,
      parval  : string;
  begin
    hd.mimetyp:=compmimetyp(lstr(GetToken(line,';')));
    while line<>'' do
    begin
      parname:=lstr(GetToken(line,'='));
      p:=1;
      while (p<=length(line)) and (line[p]<>';') do
      begin
        if line[p]='\' then delete(line,p,1);
        inc(p);
      end;
      parval:=trim(left(line,p-1));
      if firstchar(parval)='"' then
      begin
        delfirst(parval);
        if lastchar(parval)='"' then dellast(parval);
      end;
      line:=trim(mid(line,p+1));
      if parname='boundary' then hd.boundary:=left(parval,sizeof(hd.boundary)-1) else
      if (parname='name') and (hd.datei='') then hd.datei:=left(parval,sizeof(hd.datei)-1) else

      { 03.02.2000 + 07/2004  robo + my        }
      {$ifdef uuzmime       }
      if parname='type' then
        hd.mimereltyp:=left(parval,sizeof(hd.mimereltyp)-1) else
      if parname='start' then
        hd.mimerelstart:=left(parval,sizeof(hd.mimerelstart)-1) else
      if parname='start-info' then
        hd.mimerelsinfo:=left(parval,sizeof(hd.mimerelsinfo)-1) {else       };
      {$endif       }
      { /robo + my        }

      { my: Charset-Parameter im CT-Header nicht mehr auswerten!          }
      {     Wird weder in XP noch im UUZ bentigt, da die Frage,          }
      {     ob und in welchen Zeichensatz konvertiert werden mu,         }
      {     ausschlielich ber die Header "CHARSET:" (in diesem          }
      {     Zeichensatz liegt die Nachricht bereits vor) bzw.             }
      {     "X-Charset:" (in diesen Zeichensatz soll die Nachricht        }
      {     vom IBM-Zeichensatz 437 konvertiert werden) gesteuert         }
      {     wird.                                                         }
      {     Im UUZ fhrte die Auswertung u.U. zu einer fehlerhaf-         }
      {     ten Zeichensatzdeklaration in zu-Richtung, da der UUZ         }
      {     nicht in den Quellzeichensatz (z.B. UTF-8, ISO-8859-2)        }
      {     konvertiert, sondern nur nach ISO1/15.)                       }
      {                                          10/2003 + 07/2004        }
      (*
      if (parname='charset') and (hd.x_charset='') then
        hd.x_charset:=left(parval,sizeof(hd.x_charset)-1);
      *)
    end;
  end;


  {$IFDEF ConvBrettempf       }

  procedure CheckEmpfs;          { /Brett@Box.domain -> /Brett        }
  var p : empfnodep;
    procedure check(var s:string);
    begin
      if (cpos('@',s)>0) and (s[1]='/') then
        truncstr(s,cpos('@',s)-1);
    end;
  begin
    with hd do
      if (netztyp=nt_ZConnect) and not archive and PM2AMconv then begin
        check(empfaenger);
        if empfanz>1 then begin
          p:=empflist;
          while p<>nil do begin
            check(p^.empf);
            p:=p^.next;
            end;
          end;
        end;
  end;

  {$ENDIF       }

  procedure getOEM;

    procedure Addoem (var node :empfnodep);
    begin
      if not assigned (node) then
      begin
        new(node);
        LRead (node^.empf, AdrLen);
        node^.next := nil;
      end else
        Addoem(node^.next);
    end;

  begin
    GetName (hd.oem,dummy);
    if readOEMList then
      addOEM (hd.oemlist);
  end;

begin  { of makeheader        }
  ok:=true;
{$ifdef allrefs       }
  DisposeReflist(reflist);
{$endif       }
{$ifdef uuzmime       }
  DisposeKeywordList;
{$endif       }
  fillchar(hd,sizeof(hd),0);
  bufsize:=2048;
  gate_done:=false;
  getmem(buf,bufsize);
  size:=0; Readbuf;
  with hd do
    if ZConnect then
    begin
      netztyp:=nt_ZConnect;
      archive:=false;
      typ:='T';
      {$ifdef uuzmime       }
      hd.xabs:=nil;
      hd.absanz:=0;
      new(HdrLine);
      {$endif       }
      repeat
        if GetZcHdr(line,255) then
        begin
          if ok then
          begin
            id0:=id;
            id:=ustr(id);

            { 01/2000 oh Auskommentiert, damit die CustomHeaders mit U-* tun        }
            if id[1]='U' then                      { RFC        }
            if id = 'U-KEYWORDS'     then LRead(Keywords,sizeof(keywords)-1) else
            if id = 'U-SUMMARY'      then GetSummary else
            if id = 'U-DISTRIBUTION' then LRead(Distribution,40) else
            if id = 'U-X-NEWSREADER' then GetMailprog else
            if id = 'U-X-MAILER'     then GetMailprog else
            if id = 'U-USER-AGENT'   then GetMailprog else

            if id = 'U-CONTENT-TYPE' then ParseContentType else
         {  if id = 'U-CONTENT-DISPOSITION' then ParseContentDisposition else         }
            if id = 'U-ENCRYPTED'    then GetCrypt else
            if id = 'U-X-HOMEPAGE'   then GetHomepage else

            { X-No-Archive Konvertierung        }
            if id = 'U-X-NO-ARCHIVE' then
            begin
              if LStr(line)='yes' then xnoarchive:=true;
            end else

            if id = 'U-X-PRIORITY' then
            begin
              i:=ival(line);
              if i<>0 then priority:=minmax(i,1,5)
            end else

            { Mime-Version wegschmeissen - wird neu erzeugt       }
            if id = 'U-MIME-VERSION' then else

            { CTE-Header wegschmeissen - wird neu erzeugt       }
            if id = 'U-CONTENT-TRANSFER-ENCODING' then else

            {$ifdef ulines       }
            begin
              if ulines<maxulines then
              begin
                inc(ulines);
                uline^[ulines]:=mid(id0,3)+': '+line;
              end;
            end
            {$endif       }

            else

            if id = 'EMP' then GetEmpf else             { ZConnect 3.0        }
            if id = 'ABS' then GetAbsender else
            if id = 'BET' then GetBetr else
            if id = 'ROT' then GetPfad else
            if id = 'O-ROT' then if pfad='' then pfad:=line
                                 else pfad:=pfad+'!'+line else
            if id = 'MID' then LRead(MsgID,midlen) else
            if id = 'EDA' then begin
                                 LRead(zdatum,22);
                                 ZCtoZdatum(zdatum,datum);
                               {  if tc=' ' then xpmail:=true;        }
                               end else
            if id = 'LEN'    then val(line,groesse,res) else
            if id = 'KOM'    then val(line,komlen,res) else
            if id = 'KOP'    then GetKop else
            if id = 'BEZ'    then GetRef else
            if id = 'MAILER' then GetMailprog else
            if id = 'ORG'    then GetOrg else
            if id = 'OEM'    then getOEM else
            if id = 'OAB'    then GetName(oab,oar) else
            if id = 'WAB'    then GetName(wab,war) else
            if id = 'FILE'   then LRead(datei,40) else
            if id = 'DDA'    then LRead(ddatum,14) else
            if id = 'TYP'    then GetTyp(hd.typ,hd.charset) else
            if id = 'PRIO'   then prio:=minmax(ival(line),0,20) else
            if id = 'EB'     then begin
                                    GetName(empfbestto,dummy);
                                    attrib:=attrib or attrReqEB;
                                  end else
            if id = 'STAT'   then GetStat else
            if id = 'CHARSET'then GetCharset(hd.charset) else
            if id = 'ERR'    then LRead(error,hdErrLen) else
            if id = 'ANTWORT-AN'      then GetReplyTo else
            if id = 'DISKUSSION-IN'   then GetFollowup else
            if id = 'STICHWORT'       then GetStichwort else
            if id = 'QUOTE-STRING'    then GetQStr else
            if id = 'POST'            then GetPost else
            if id = 'ZUSAMMENFASSUNG' then GetSummary else
            if id = 'TELEFON'         then GetTelefon else
            if id = 'HOMEPAGE'        then GetHomepage else
          { if id = 'X_C'    then xpmail:=true else        }
            if id = 'F-TO'            then LRead(fido_to,36) else
            if id = 'VER'             then GetName(vertreter,dummy) else
            if id = 'CONTROL'         then LRead(control,midlen+9) else
            if id = 'ERSETZT'         then LRead(ersetzt,midlen) else
            {$ifdef uuzmime       }
            if (id = 'GATE') and (add_gate<>'') then
            begin
              SaveLongHdr(LGate,sizeof(gateway)-1,line,gateway,false,0);
              gate_done:=true;
            end else
            {$endif       }
            if id[1]='X' then   { XP        }
            begin
              if id = 'X-CHARSET' then LRead(x_charset,30) else
              if id = 'X-XP-NTP' then netztyp:=minmax(ival(line),0,99) else {XP       }
              if id = 'X-XP-BOX' then LRead(real_box,20) else
              if id = 'X-XP-PNT' then LRead(hd_point,25) else
              if id = 'X-XP-BST' then LRead(pm_bstat,20) else
              if id = 'X-XP-ATT' then attrib:=hexval(left(line,4)) else
              if id = 'X-XP-FTO' then LRead(fido_to,36) else
              if id = 'X-XP-MRP' then LRead(ReplyPath,8) else
              if id = 'X-XP-RGR' then LRead(ReplyGroup,40) else
              if id = 'X-XP-ORGMID' then LRead(org_msgid,midlen) else
              if id = 'X-XP-ORGREF' then LRead(org_xref,midlen) else
              if id = 'X-XP-BOUNDARY' then LRead(boundary,sizeof(hd.boundary)-1) else
              if id = 'X-XP-CTL' then XpointCtl:=ival(line) else
              if id = 'X-XP-ARC' then archive:=true else
              {$ifdef uuzmime       }
              if (id = 'X-GATEWAY') and not gate_done and (add_gate<>'') then
                SaveLongHdr(LGate,sizeof(gateway)-1,line,gateway,false,0) else
              {$endif       }
              if tc=' ' then
                if id = 'X-XP_F'   then filterattr:=minmax(ival(line),0,65535);

            end else

            if pos('CRYPT',id)>0 then
            begin
              if id = 'CRYPT'    then GetCrypt else
              if id = 'CRYPT-CONTENT-TYP' then GetTyp(crypttyp,ccharset) else
              if id = 'CRYPT-CONTENT-CHARSET' then GetCharset(ccharset) else
              if id = 'CRYPT-CONTENT-KOM' then val(line,ckomlen,res);
            end else
            {$IFDEF PGP       }
              if id = 'SIGNED'         then GetSigned else
              if id = 'U-X-SIGNED'     then GetSigned else
              if pos('PGP',id)>0 then
              begin
                if id = 'PGP'            then GetPGP else
                if id = 'U-X-PGP'        then GetPGP else
                if id = 'PGP-ID'         then GetPGPid else
                if id = 'PGP-KEY-AVAIL'      then inc(pgpflags,fPGP_avail) else
                if id = 'U-X-PGP-KEY-AVAIL'  then inc(pgpflags,fPGP_avail) else
                if id = 'PGP-PUBLIC-KEY'     then inc(pgpflags,fPGP_haskey) else
                if id = 'U-X-PGP-PUBLIC-KEY' then inc(pgpflags,fPGP_haskey) else
                if id = 'PGP-KEY-COMPROMISE' then inc(pgpflags,fPGP_comprom) else
                if id = 'X-XP-PGP'           then GetXPpgp;
              end
              else
            {$ENDIF       }

            if id = 'ABR' then LRead(realname,realnlen) else { ZConnect 1.9        }
            if id = 'BIN' then typ:='B' else
            if id = 'MAL' then GetMailprog;

            { Customizable Headerlines        }
            if id = UStr(mheadercustom[1]) then
              LRead(Cust1,CustHeadLen)
            else
              if id = UStr(mheadercustom[2]) then
                LRead(Cust2,CustHeadLen);

            line:='*';
          end;
        end
        else if not ok and eof(f) then   { line=''        }
          ok:=(groesse=0);               { letzte Msg hat Lnge 0        }
      until (line='') or not ok;
      if ok and (attrib and attrQPC<>0) and (ustr(left(betreff,4))<>'QPC:') then
        betreff:='QPC:'+betreff;
      {$ifdef uuzmime       }
      dispose(HdrLine);
      {$endif       }
    end
    else begin   { ZConnect = false        }
      getline(empfaenger,sizeof(empfaenger)-1);
      empfaenger:=rtrim(empfaenger);
      empfanz:=1;
      getline(betreff,sizeof(betreff)-1);
      while (betreff<>'') and (betreff[1]<=' ') do
        delfirst(betreff);
      getline(absender,sizeof(absender)-1);
      getline(datum,sizeof(datum)-1);
      getline(pfad,sizeof(pfad)-1);
      getline(msgid,sizeof(msgid)-1);
      getline(typ,sizeof(typ)-1);
      getline(s,20);
      val(trim(s),groesse,res);
    end;
  freemem(buf,bufsize);
  {$ifndef uuzmime       }
  CheckBetreff;
  {$endif       }
  {$IFDEF ConvBrettempf       }             { /Brett@Box.domain -> /Brett        }
    CheckEmpfs;
  {$ENDIF       }
  inc(size,o);
  if res<>0 then ok:=false;
end;  { of makeheader        }
