{ ------------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.                   }
{ (c) 1991-1999 Peter Mandrella                                       }
{ (c) 2000-2001 OpenXP-Team                                           }
{ (c) 2002-2026 FreeXP, http://www.freexp.de                          }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.         }
{                                                                     }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der     }
{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html }
{ ------------------------------------------------------------------- }

{ Globale Konstanten/Variablen (FreeXP) und Tools        }

{$I XPDEFINE.INC        }
{$F+,O+       }

unit xpglobal;

interface

{ Beim Vergeben eines neuartigen Betastr darauf achten, das die            }
{ XP-Werbesignatur nur 78 Zeichen lang sein darf. XP6.PAS, XP6S.INC        }

const
  verstr      = 'v3.42g';       { Versionsnr. - steht nur an dieser Stelle }
  betastr     = '';             { '' bei Release-Versionen                 }
                                { ' alpha x' w hrend der Entwicklung       }
                                { ' beta x'  in der Stabilisierungsphase   }
                                { oder ' RCn' w hrend des Endtestes        }
  rufstr      = 'Projekt Retro'; { Enth lt einen Rufnamen, wenn einer       }
                                { fuer diese Version vergeben wurde        }

{ Die folgenden drei Konstanten m ssen Sie erg nzen, bevor Sie             }
{ CrossPoint compilieren k nnen. Falls Die das compilierte Programm        }
{ weitergeben m chten, m ssen der angegebene Name korrekt und die          }
{ E-Mail-Adresse erreichbar sein (siehe LIZENZ.TXT).                       }
{                                                                          }
{ Beispiel:                                                                }
{                                                                          }
{ const  author_name = 'Ralf M ller';                                      }
{        author_mail = 'ralf@t-offline.de';                                }
{        x_copyright = '(c) 2001';                                         }
{                                                                          }
{ Diese Informationen werden bei Programmstart und bei                     }
{ /XPoint/Registrierung angezeigt.                                         }

  author_name = 'FreeXP';
  author_fido = '2:2433/460';
  author_mail = '';
  author_url  = 'http://www.freexp.de/';
  compiler    = 'Borland Pascal 7.01';

  xp_xp       : string[17] = 'CrossPoint/FreeXP';
  xp_display  : string[6]  = 'FreeXP';
  xp_client   : string[10] = 'CrossPoint';
  xp_origin   : string[21] = '--- CrossPoint/FreeXP';
  xp_old      : string[32] = 'OpenXP/16 (compatibility string)';  { f r UKAW, XPNews u. .        }
  x_copyright = '(c) 2002-2026';

type
  { Regeln f r Datentypen unter 16/32 Bit

  Die gr  e einiger Datentypen unterscheidet sich je nach verwendetem
  Compiler und der Systemumgebung. Folgende Regeln sollten beachtet werden:

  Der im Regelfall zu verwendede Datentyp ist Integer. Dieser Datentyp
  ist unter 16 Bit nat rlich 16 Bit gro  und unter 32 Bit wiederum 32 Bit
  gro  und immer signed (vorzeichenbehaftet). Dieser Datentyp ist immer der
  _schnellste_ f r das System verf gbare Datentyp, sollte also in Schleifen
  usw. wenn m glich genommen und den spezielleren Datentypen vorgezogen
  werden.

  Der Datentyp rtlword ist je nach dem verwendeten Compiler und der damit
  verwendeten RTL 16 oder 32 Bit gro .

  Folgende Datentypen sind immer gleich gro  und z.B. f r Records geeignet:
  Byte       1 Byte  unsigned  0..255
  SmallWord  2 Byte  unsigned  0..65535
  DWord      4 Byte  unsigned  0..4294967295
  uint8      1 Byte  unsigned  0..255
  uint16     2 Byte  unsigned  0..65535
  uint32     4 Byte  unsigned  0..4294967295
  uint64     8 Byte  unsigned  0..18446744073709551615
  ( Vorsicht bei BP und VP, diese kennen kein echtes DWord/uint32 und )
  ( auch kein echtes uint64 )

  Integer8   1 Byte  signed   -128..127
  Integer16  2 Byte  signed   -32768..32767
  Integer32  4 Byte  signed   -2147493647..2147493647
  Integer64  8 Byte  signed   -9223372036854775808..9223372036854775807
         }

  { Borland Pascal bis Version 8, 16 Bit        }
  { Vorzeichenbehaftete Zahlen        }
  integer8  = shortint;
  integer16 = integer;
  integer32 = longint;  
  integer64 = comp;  

  { Vorzeichenlose Zahlen        }
  uint8     = byte;
  uint16    = word;
  uint32    = longint;           { Vorsicht: siehe oben!        }
  uint64    = comp;              { Vorsicht: siehe oben!        }    
  smallint  = integer;
  smallword = word;
  dword     = longint;           { Vorsicht: siehe oben!        }
  rtlword   = system.word;       { 16 Bit bei FPC        }

  { Zeichenketten        }
  { Der Typ HugeString enth lt in der 16 Bit Version einen normalen,
    auf 255 Zeichen begrenzten String, in den 32 Bit Versionen
    einen Hugestring mit bis zu 2 GB L nge        }
  HugeString = String;

const
  DirSepa  = '\';
  WildCard = '*.*';
  _MPMask  = ':\';
  Euro     = 238;

const
  MaxLenFilename = 13;
  MaxLenPathname = 79;

implementation


end.
