{ ------------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.                   }
{ (c) 1991-1999 Peter Mandrella                                       }
{ (c) 2000-2001 OpenXP-Team                                           }
{ (c) 2002-2025 FreeXP, http://www.freexp.de                          }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.         }
{                                                                     }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der     }
{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html }
{ ------------------------------------------------------------------- }

{ Interne Screenfonts        }

{$I XPDEFINE.INC       }

{$O+,F+       }

unit xpfonts;

interface

uses
  video,xp0,xpglobal,dos;

procedure InternalFont;
procedure Font8x16;
procedure Font8x14;
procedure Font8x8;
procedure LoadFont(height:byte; var data); { neue EGA/VGA-Font laden        }
procedure LoadFontFile(fn:pathstr);        { Font aus Datei laden        }
procedure setuserchar(height:byte);

implementation  { ------------------------------------------------------        }


uses typeform, fileio ,dosx;


type ba  = array[0..65000] of byte;
     bp  = ^ba;
var
    p1,p2   : bp;                    { Zeiger fr Font-Generator        }

var p : ^Pointer;

{$I XPFONTS.INC       }

{$IFNDEF NO386}
procedure MakeEuroChar(height:byte; var data); Assembler;
asm
   les di,data
   mov ax,euro   { ASCII #238 aendern, siehe xpglobal        }
   mov cl,height
   mul cl
   add di,ax
   mov bl,cl
   mov bh,0
   shl bx,4
   lea si,[offset @fonts-8*16+bx]
   segCS rep movsb
   jmp @end
@fonts: db $1f,$30,$fe,$60,$fc,$30,$1f,$00,$00,$00,$00,$00,$00,$00,$00,$00
        db $00,$1f,$30,$fe,$60,$fc,$30,$1f,$00,$00,$00,$00,$00,$00,$00,$00
        db $00,$1f,$30,$fe,$60,$fc,$30,$1f,$00,$00,$00,$00,$00,$00,$00,$00
        db $1e,$31,$60,$fe,$60,$fc,$60,$31,$1e,$00,$00,$00,$00,$00,$00,$00
        db $00,$1e,$31,$60,$fe,$60,$fc,$60,$31,$1e,$00,$00,$00,$00,$00,$00
        db $00,$1e,$31,$60,$fe,$60,$fc,$60,$31,$1e,$00,$00,$00,$00,$00,$00
        db $00,$00,$1e,$31,$60,$fe,$60,$fc,$60,$31,$1e,$00,$00,$00,$00,$00
        db $00,$1e,$31,$60,$60,$fe,$60,$fc,$60,$60,$31,$1e,$00,$00,$00,$00
        db $00,$1e,$31,$60,$60,$fe,$60,$fc,$60,$60,$31,$1e,$00,$00,$00,$00
@end:
end;
{$ENDIF}

procedure InternalFont;
var fnr : integer;
    h   : byte;
    p   : ^pointer;
begin
  fnr:=ival(mid(ParFontfile,2));
  case fnr of
     1 : begin h:=14; p:=@FontC2; end;
     2 : begin h:=16; p:=@FontScrawl16; end;
     3 : begin h:=14; p:=@FontBroadway14; end;
     4 : begin h:=16; p:=@Font_Mod1; end;
     5 : begin h:=14; p:=@Font_Mod2; end;
    else h:=0;
  end;
  if h>0 then
  begin
    inc(longint(p));
    p:=p^;
  { if EuroOK then MakeEuroChar(h,p^);        }  { spter aktivieren, sobald        }
    LoadFont(h,p^);                       { Euro-Symbol existiert            }
  end;
end;

procedure LoadFont(height:byte; var data);
var regs : registers;
begin
  with regs do begin
    ax:=$1110;
    bx:=height*256;
    cx:=256;
    dx:=0;
    es:=seg(data); bp:=ofs(data);
    Xintr($10,regs);
  end;
end;

procedure LoadFontFile(fn:pathstr);        { Font aus Datei laden        }
var p  : pointer;
    sr : searchrec;
    h  : byte;
    hmax:byte;
    ofs: byte;
    f  : file;
begin
  if vtype<2 then exit;
  findfirst(fn,ffAnyFile,sr);
  if (doserror=0) and (sr.size mod 256<=8) and (sr.size<65536) then begin
    h:=sr.size div 256;
    ofs:=sr.size mod 256;
    if vtype=2 then hmax:=14 else hmax:=16;
    if (h>=8) and (h<=hmax) then begin
      getmem(p,256*h);
      assign(f,fn);
      reset(f,1);
      seek(f,ofs);
      blockread(f,p^,256*h);
      close(f);
      LoadFont(h,p^);
      freemem(p,256*h);
      end;
    end;
end;

procedure setuserchar(height:byte);   { height = 12/11/10/9/7        }
var regs  : registers;
    sel   : word;

  procedure make15; assembler;
  asm
           push ds
           cld
           les   di,p2                   { Quelle: 8x16-Font                }
           lds   si,p1                   { 8x15-Font generieren             }
           mov   dx,256                  { 1. Zeile wird weggelassen        }
  @c15lp:  mov   cx,15
           rep   movsb
           inc   si
           dec   dx
           jnz   @c15lp
           pop ds
  end;

  procedure make13; assembler;
  asm
           push ds
           cld
           les   di,p2                   { Quelle: 8x14-Font                }
           lds   si,p1                   { 8x13-Font generieren             }
           mov   dx,256                  { 1. Zeile wird weggelassen        }
  @c13lp:   inc   si
           mov   cx,13
           rep   movsb
           dec   dx
           jnz   @c13lp
           pop ds
  end;

  procedure make12; assembler;
  asm
           push ds
           cld
           les   di,p2                   { Quelle: 8x14-Font                 }
           lds   si,p1                   { 8x12-Font generieren              }
           mov   dx,256                  { 1. und letzte Zeile werden        }
  @c12lp:  inc   si                      { weggelassen                       }
           mov   cx,12
           rep   movsb
           inc   si
           dec   dx
           jnz   @c12lp
           pop ds
  end;

  procedure make11; assembler;
  asm
           push ds
           cld
           les   di,p2                   { Quelle: 8x14-Font                     }
           lds   si,p1                   { 8x11-Font generieren                  }
           mov   dx,256                  { 1., 2. und letzte Zeile werden        }
  @c11lp:  inc   si                      { weggelassen                           }
           inc   si
           mov   cx,11
           rep   movsb
           inc   si
           dec   dx
           jnz   @c11lp
           pop ds
  end;

  procedure make10; assembler;
  asm
           push ds
           cld
           les   di,p2                   { Quelle: 8x8-Font                     }
           lds   si,p1                   { 8x10-Font generieren                 }
           mov   dx,256                  { 2. und vorletzte Zeile werden        }
           mov   bl,0                    { bei Blockzeichen verdoppelt          }
  @c10lp:  cmp   dl,80
           jnz   @m10j1
           inc   bl
  @m10j1:  cmp   dl,32
           jnz   @m10j2
           dec   bl
  @m10j2:  mov   al,0
           or    bl,bl
           jz    @zero1
           mov   al,[si+1]
  @zero1:  stosb
           mov   cx,8
           rep   movsb
           mov   al,0
           or    bl,bl
           jz    @zero2
           mov   al,[si-2]
  @zero2:  stosb
           dec   dx
           jnz   @c10lp
           pop ds
  end;

  procedure make9; assembler;
  asm
           push ds
           cld
           les   di,p2                   { Quelle: 8x8-Font                      }
           lds   si,p1                   { 8x9-Font generieren                   }
           mov   dx,256                  { 2. Zeile wird bei Blockzeichen        }
           mov   bl,0                    { verdoppelt                            }
  @c9lp:   cmp   dl,80
           jnz   @m9j1
           inc   bl
  @m9j1:   cmp   dl,32
           jnz   @m9j2
           dec   bl
  @m9j2:   mov   al,0
           or    bl,bl
           jz    @zero91
           mov   al,[si+1]
  @zero91: stosb
           mov   cx,8
           rep   movsb
           dec   dx
           jnz   @c9lp
           pop ds
  end;

  procedure make7;
  var i,j,sk : integer;
      skip   : array[0..255] of byte;   { zu bersprg. Zeile        }
      sp,dp  : word;    { SourcePointer, DestPointer        }
  begin
    for i:=0 to 255 do
      skip[i]:=2;

    skip[49]:=4;    { 1        }        skip[53]:=4;    { 5        }
    skip[67]:=4;    { C        }        skip[97]:=4;    { O        }
    skip[105]:=3;   { i        }        skip[106]:=3;   { j        }
    skip[129]:=4;   {         }        skip[132]:=2;   {         }
    skip[148]:=3;   {         }        skip[154]:=3;   {         }
    skip[161]:=3;   {         }        skip[168]:=3;   {         }
    skip[225]:=8;   {         }

    sp:=0; dp:=0;
    for i:=0 to 255 do
    begin
      sk:=skip[i];
      for j:=1 to 7 do
      begin
        if j=sk then inc(sp);
        p2^[dp]:=p1^[sp];
        inc(sp); inc(dp);
      end;
    end;
  end;

begin
  getmem(p2,16*256);
  with regs do
  begin
    if height<=10 then
      p:=@Font8x8
    else if height<=14 then
      p:=@Font8x14
    else
      p:=@Font8x16;
    inc(longint(p));
    p1:=p^;
    case height of
      15 : make15;
      13 : make13;
      12 : make12;
      11 : make11;
      10 : make10;
       9 : make9;
       7 : make7;
    else
      fastmove(p1^,p2^,4096);
    end;
	{$IFNDEF NO386}
    if EuroOK then MakeEuroChar(height,p2^);
	{$ENDIF}
    LoadFont(height,p2^);
  end;
  freemem(p2,16*256);
end;

end.
