{ ------------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.                   }
{ (c) 1991-1999 Peter Mandrella                                       }
{ (c) 2000-2001 OpenXP-Team                                           }
{ (c) 2002-2026 FreeXP, http://www.freexp.de                          }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.         }
{                                                                     }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der     }
{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html }
{ ------------------------------------------------------------------- }

{ CrossPoint - BoxPar verwalten }

{$I XPDEFINE.INC}
{$O+,F+}

unit xp9bp;

interface

uses dos,typeform,fileio,datadef,database,crt,
     xp0,xp1,xp2,xp2x,xpnt, xpglobal;


const bm_changesys = 1;
      bm_GUP       = 2;
      bm_Feeder    = 3;
      bm_AutoSys   = 4;
      bm_postmaster= 5;


procedure nt_bpar(nt:byte; var bpar:BoxRec);
procedure DefaultBoxPar(nt:byte; bp:BoxPtr);
procedure ReadBox(nt:byte; const dateiname:pathstr; bp:BoxPtr);
procedure WriteBox(const dateiname:pathstr; bp:BoxPtr);
procedure ReadBoxPar(nt:byte; box:string);
function  BoxBrettebene(const box:string):string;

procedure ReadQFG(const dateiname:pathstr; var qrec:QfgRec);
procedure WriteQFG(const dateiname:pathstr; qrec:QfgRec);


implementation  { ------------------------------------------------- }

uses
  xp2b,xpovl;

procedure nt_bpar(nt:byte; var bpar:BoxRec);
var i : integer;
begin
  with bpar do
    case nt of
      nt_Quick : begin
                   uparcer:='lharc a $UPFILE $PUFFER';
                   downarcer:='lharc e $DOWNFILE';
                   loginname:='NET410';
                 end;
      nt_Maus  : begin
                   pointname:=boxname;
                   exclude[1,1]:='04:00';
                   exclude[1,2]:='06:00';
                   for i:=2 to excludes do begin
                     exclude[i,1]:='  :  ';
                     exclude[i,2]:='  :  ';
                     end;
                   MagicBrett:='/';
                 end;
      nt_Magic : begin
                   zerbid:='2200';
                   lightlogin:=false;
                 end;
      nt_Fido  : MagicBrett:='/FIDO/';
      nt_UUCP  : begin
                   uparcer:='compress -v -b12 $PUFFER';
                   downarcer:='gzip -vdf $DOWNFILE'; {alt: compress}
                   unfreezer:='freeze -vdif $DOWNFILE';
                   ungzipper:='gzip -vdf $DOWNFILE';
                   chsysbetr:='your latest sys file entry';
                 end;
      nt_Pronet: begin
                   MagicNET:='ProNET';
                   MagicBrett:='/PRONET/';
                   pointname:='01';
                   downloader:='gsz.exe portx $ADDRESS,$IRQ rz';
                 end;
    end;
end;


procedure DefaultBoxPar(nt:byte; bp:BoxPtr);
var i : integer;
begin
  fillchar(bp^,sizeof(bp^),0);
  with bp^ do begin
    passwort  := iifs(deutsch,'GEHEIM','SECRET');
    areapw    := iifs(deutsch,'GEHEIM','SECRET');
    telefon   := '';
    zerbid    := '0000';
    uploader  := 'Zmodem';
    downloader:= 'Zmodem';
    prototyp  := 'Z';
    uparcer   := 'pkzip $UPFILE $PUFFER';
    downarcer := 'pkunzip $DOWNFILE';
    uparcext  := 'ZIP';
    downarcext:= 'ZIP';
    connwait  := 45;
    loginwait := 60;
    redialwait:= 240;
    redialmax := 100;
    connectmax:= 5;
    citycarrier:=false;
    packwait  := 1200;
    retrylogin:= 10;
    conn_time := 5;
    owaehlbef := '';
    mincps    := 150;
    bport     := 2;
    params    := '8n1';
    baud      := 19200;
    gebzone   := 'T-Com Ort';
    o_passwort:= iifs(deutsch,'GEHEIM','SECRET');
    o_logfile := '';
    MagicNet  := 'MagicNET';
    MagicBrett:= '/MAGIC/';
    for i:=1 to excludes do begin
      exclude[i,1]:='  :  ';
      exclude[i,2]:='  :  ';
      end;
    fPointNet:=20000;
    f4D:=true;
    fTosScan:=true;
    areaplus:=false;
    areabetreff:=true;
    EMSIenable:=true;
    AKAs:=''; SendAKAs:='';
    FileScanner:='FileScan'; FilescanPW:='GEHEIM';
    LocalIntl:=true;
    GetTime:=false;
    LightLogin:=false;
    SendTrx:=false;
    NotSEmpty:=false;
    brettmails:=true;
    MaxWinSize:=7;
    MaxPacketSize:=1024; {alt: 64}
    VarPacketSize:=true; ForcePacketSize:=false;
    SizeNego:=true;
    UUsmtp:=false;
    ClientSmtp:= false;
    PPPClientPath:= '';
    PPPClient:= '';
    PPPAddServers:= '';
    PPPDialUp:= '';
    PPPPhone:= '';
    PPPLogin:= '';
    PPPPass:= '';
    PPPAskIfConnect:= false;
    PPPAskIfDisconnect:= false;
    PPPKeepConnectStatus:= true;
    PPPSpool:= '';
    PPPMailInServer:= '';
    PPPMailInPort:= '110';
    PPPMailInProtocol:= 'POP3';
    PPPMailInEnv:= '';
    PPPMailInUser:= '';
    PPPMailInPass:= '';
    PPPMailInUseEnvTo:= false;
    PPPMailInKeep:= false;
    PPPMailInAPOP:= false;
    PPPMailOutServer:= '';
    PPPMailOutPort:= '25';
    PPPMailFallback:= '';
    PPPMailOutEnv:= '';
    PPPMailOutUser:= '';
    PPPMailOutPass:= '';
    PPPMailOutSMTPafterPOP:= false;
    PPPMailOutSMTPLogin:= false;
    PPPNewsServer:= '';
    PPPNewsPort:= '119';
    PPPNewsFallback:= '';
    PPPNewsUser:= '';
    PPPNewsPass:= '';
    PPPNewsList:= true;
    PPPNewsMaxLen:= 0;
    PPPNewsMax:= 99999;
    PPPExternCfg:= '';
    HdrOnly:='';
    UUprotos:='Ggz';
    efilter:='';
    afilter:='';
    SysopNetcall:=true;
    SysopPack:=false;
    ReplaceOwn := false;
    Replace_0:=false;
    Replace_2:=false;
    Replace_3:=false;
    Replace_4:=false;
    Replace_10:=false;
    Replace_11:=false;
    Replace_20:=false;
    Replace_30:=false;
    Replace_31:=false;
    Replace_40:=false;
    Replace_41:=true;
    EB_Daemon:=false;
    PacketPW:=false;
    ExtPFiles:=false;
    uucp7e1:=false;
    DelQWK:=true;
    BMtyp:=bm_changesys;
    BMdomain:=false;
    maxfsize:=0;
    end;
  nt_bpar(nt,bp^);
end;


{ Box- Parameter aus angegebener Datei lesen }
{ bp^ mu initialisiert sein.                }

procedure ReadBox(nt:byte; const dateiname:pathstr; bp:BoxPtr);
var t      : text;
    s,su   : string;
    p      : byte;
    dummyb : byte;
    dummys : string[10];
    dummyl : boolean;
    dummyw : smallword;
    dummyr : real;
    i      : integer;

  function get_exclude:boolean;
  var n : byte;
  begin
    get_exclude:=false;
    if (left(su,10)='AUSSCHLUSS') then begin
      n:=ival(copy(s,11,1));
      if (n>=1) and (n<=excludes) then begin
        BoxPar^.exclude[n,1]:=copy(s,p+1,5);
        BoxPar^.exclude[n,2]:=copy(s,p+7,5);
        get_exclude:=true;
        end;
      end;
  end;

begin
  assign(t,dateiname+BfgExt);
  DefaultBoxPar(nt,bp);
  if existf(t) then begin
    reset(t);
    with bp^ do
      while not eof(t) do begin
        readln(t,s);
        if (s<>'') and (left(s,1)<>'#') then begin
          su:=ustr(s);
          p:=cpos('=',s);
          if (p=0) or not (
            get_exclude or
            gets(s,su,'Boxname',boxname,BoxNameLen) or
            gets(s,su,'Pointname',pointname,25) or
            gets(s,su,'Username',username,30) or
            gets(s,su,'Domain',_domain,60) or
            gets(s,su,'FQDN',_fqdn,60) or    {17.03.2005 MW}
{           gets(s,su,'Domain',dummys,1) or
            gets(s,su,'FQDN',dummys,1) or } {16.01.00 HS}
            gets(s,su,'Passwort',passwort,25) or
            gets(s,su,'Telefon',telefon,60) or
            gets(s,su,'ZerbID',zerbid,4) or
            getb(su,  'Netztyp',dummyb) or
            gets(s,su,'Upload',uploader,100) or
            gets(s,su,'Download',downloader,100) or
            gets(s,su,'ProtokollTyp',prototyp,1) or
            gets(s,su,'ZMOptions',ZMOptions,60) or
            gets(s,su,'UpArc',uparcer,60) or
            gets(s,su,'DownArc',downarcer,60) or
            gets(s,su,'UnFreeze',unfreezer,40) or
            gets(s,su,'UnGZIP',ungzipper,40) or
            gets(s,su,'UpArcExt',uparcext,3) or
            gets(s,su,'DownArcExt',downarcext,3) or
            geti(su,  'ConnWait',connwait) or
            geti(su,  'LoginWait',loginwait) or
            geti(su,  'RedialWait',redialwait) or
            geti(su,  'RedialMax',redialmax) or
            geti(su,  'ConnectMax',connectmax) or
            getx(su,  'Citycarrier',citycarrier) or
            geti(su,  'PackWait',packwait) or
            geti(su,  'RetryLogin',retrylogin) or
            geti(su,  'ConnectTime',conn_time) or
            gets(s,su,'Waehlbef',owaehlbef,10) or
            gets(s,su,'ModemInit',modeminit,60) or
            geti(su,  'cpsmin',mincps) or
            getb(su,  'Port',bport) or
            gets(s,su,'Params',params,3) or
            getl(su,  'Baud',baud) or
            getr(su,  'GebuehrNormal',dummyr) or
            getr(su,  'GebuehrBillig',dummyr) or
            getw(su,  'GebuehrProEinheit',dummyw) or
            gets(s,su,'Waehrung',dummys,5) or
            gets(s,su,'Tarifzone',gebzone,20) or
            getx(su,  'SysopMode', sysopmode) or
            gets(s,su,'SysopInFile',sysopinp,60) or
            gets(s,su,'SysopOutfile',sysopout,60) or
            gets(s,su,'SysopStartprg',sysopstart,60) or
            gets(s,su,'SysopEndprg',sysopend,60) or
            gets(s,su,'OnlinePasswort',o_passwort,25) or
            gets(s,su,'LogFile',o_logfile,60) or
            gets(s,su,'MagicNET',magicnet,8) or
            gets(s,su,'MagicBrett',magicbrett,25) or
            getw(su,  'FidoFakenet',fPointNet) or
            getx(su,  'Fido4Dadr',f4D) or
            getx(su,  'TosScan',fTosScan) or
            getx(su,  'LocalINTL',localintl) or
            getx(su,  'FidoArea+',areaplus) or
            getx(su,  'AreaBetreff',areabetreff) or
            gets(s,su,'AreaPasswort',areaPW,12) or
            gets(s,su,'AreaListe',dummys,10) or
            gets(s,su,'FileScanner',filescanner,15) or
            gets(s,su,'FilescanPW',filescanpw,12) or
            getx(su,  'EMSI',EMSIenable) or
            gets(s,su,'AKAs',akas,AKAlen) or
            gets(s,su,'SendAKAs',sendakas,AKAlen) or
            getx(su,  'GetTime',gettime) or
            getx(su,  'SendTrx',sendtrx) or
            getx(su,  'PacketPW',packetpw) or
            getx(su,  'ExtFidoFNames',ExtPFiles) or
            getx(su,  'LightLogin',lightlogin) or
            getx(su,  'NotSEmpty',notsempty) or
            gets(s,su,'LoginName',loginname,60) or
            gets(s,su,'UUCPname',UUCPname,8) or
            getb(su,  'UU-MaxWinSize',maxwinsize) or
            getw(su,  'UU-MaxPacketSize',maxpacketsize) or
            getx(su,  'UU-VarPacketSize',varpacketsize) or
            getx(su,  'UU-ForcePacketSize',forcepacketsize) or
            getx(su,  'UU-SizeNegotiation',sizenego) or
            getx(su,  'UU-SMTP',UUsmtp) or
            getx(su,  'UU-SMTP-Client', ClientSmtp) or
            gets(s,su,'UU-SMTP-OneFilePerMsg',dummys,1) or
            gets(s,su,'Client-Path', PPPClientPath, MaxLenPathname) or
            gets(s,su,'Client-Exec', PPPClient, MaxLenPathname) or
            gets(s,su,'Client-AddServers', PPPAddServers, 160) or
            gets(s,su,'Client-DialUp',PPPDialup,60) or
            gets(s,su,'Client-Phone',PPPPhone,60) or
            gets(s,su,'Client-Login',PPPLogin,60) or
            gets(s,su,'Client-Password',PPPPass,20) or
            getx(su,  'Client-AskIfConnect', PPPAskIfConnect) or
            getx(su,  'Client-AskIfDisconnect', PPPAskIfDisconnect) or
            getx(su,  'Client-KeepConnectStatus', PPPKeepConnectStatus) or
            gets(s,su,'Client-Spool', PPPSpool, MaxLenPathname) or
            gets(s,su,'Client-MailInServer', PPPMailInServer, 160) or
            gets(s,su,'Client-MailInPort', PPPMailInPort, 50) or
            gets(s,su,'Client-MailInProtocol', PPPMailInProtocol, 5) or
            gets(s,su,'Client-MailInEnvelope', PPPMailInEnv, 160) or
            gets(s,su,'Client-MailInUser', PPPMailInUser, 160) or
            gets(s,su,'Client-MailInPassword', PPPMailInPass, 75) or
            getx(su,  'Client-MailInUseEnvTo',PPPMailInUseEnvTo) or
            getx(su,  'Client-MailInKeep',PPPMailInKeep) or
            getx(su,  'Client-MailInAPOP',PPPMailInAPOP) or
            gets(s,su,'Client-MailOutServer', PPPMailOutServer, 160) or
            gets(s,su,'Client-MailOutPort', PPPMailOutPort, 50) or
            gets(s,su,'Client-MailFallback', PPPMailFallback, 8) or
            gets(s,su,'Client-MailOutEnvelope', PPPMailOutEnv, 160) or
            gets(s,su,'Client-MailOutUser', PPPMailOutUser, 160) or
            gets(s,su,'Client-MailOutPassword', PPPMailOutPass, 75) or
            getx(su,  'Client-MailOutSMTPafterPOP',PPPMailOutSMTPafterPOP) or
            getx(su,  'Client-MailOutSMTPLogin',PPPMailOutSMTPLogin) or
            gets(s,su,'Client-NewsServer', PPPNewsServer, 160) or
            gets(s,su,'Client-NewsPort', PPPNewsPort, 50) or
            gets(s,su,'Client-NewsFallback', PPPNewsFallback, 8) or
            gets(s,su,'Client-NewsUser', PPPNewsUser, 160) or
            gets(s,su,'Client-NewsPassword', PPPNewsPass, 75) or
            getx(su,  'Client-NewsList', PPPNewsList) or
            getl(su,  'Client-NewsMaxLen', PPPNewsMaxLen) or
            getl(su,  'Client-NewsMax', PPPNewsMax) or
            gets(s,su,'Client-ExternalConfig', PPPExternCfg, MaxLenPathname) or
            gets(s,su,'HdrOnly', HdrOnly, 10) or
            gets(s,su,'UU-Protocols',uuprotos,10) or
            gets(s,su,'Eingangsfilter',eFilter,60) or
            gets(s,su,'Ausgangsfilter',aFilter,60) or
            getx(su,  'SysopNetcall',sysopnetcall) or
            getx(su,  'SysopPacken',sysoppack) or
            getx(su,  'ReplaceOwn', ReplaceOwn) or
            getx(su,  'Replace_0', Replace_0) or
            getx(su,  'Replace_2', Replace_2) or
            getx(su,  'Replace_3', Replace_3) or
            getx(su,  'Replace_4', Replace_4) or
            getx(su,  'Replace_10', Replace_10) or
            getx(su,  'Replace_11', Replace_11) or
            getx(su,  'Replace_20', Replace_20) or
            getx(su,  'Replace_30', Replace_30) or
            getx(su,  'Replace_31', Replace_31) or
            getx(su,  'Replace_40', Replace_40) or
            getx(su,  'Replace_41', Replace_41) or
            getx(su,  'Mailer-Daemon', EB_Daemon ) or
            gets(s,su,'NetcallScript',script,50) or
            gets(s,su,'OnlineScript',o_script,50) or
            getx(su,  'Brettmails',brettmails) or
            getx(su,  'SendSerial',dummyl) or
            gets(s,su,'Sysfile',chsysbetr,50) or
            getx(su,  '7e1Login',uucp7e1) or
            getx(su,  'janusplus',JanusPlus) or
            getx(su,  'delqwk',DelQWK) or
            getb(su,  'brettmanagertyp',BMtyp) or
            getx(su,  'brettmanagerdomain',BMdomain) or
            getw(su,  'maxfilesize',maxfsize)
          ) then
          begin
            window(1,1,80,25);
            trfehler1(901,left(s,35),30);   { 'Ungltige Box-Config-Angabe: %s' }
            end;
          end;
        end;
    close(t);
    if (ustr(bp^.boxname)=ustr(DefaultBox)) and (bp^.owaehlbef<>'') then begin
      for i:=1 to 4 do begin       { 2.93 beta: Waehlbefehl -> Config/Modem }
        freemem(comn[i].MDial,length(comn[i].MDial^)+1);
        getmem(comn[i].MDial,length(boxpar^.owaehlbef)+1);
        comn[i].MDial^:=boxpar^.owaehlbef;
        end;
      SaveConfig;
      bp^.owaehlbef:='';
      WriteBox(dateiname,bp);
      if bp=BoxPar then BoxPar^.owaehlbef:='';
      end;
    end;
end;


procedure WriteBox(const dateiname:pathstr; bp:BoxPtr);
var t : text;
    i : byte;

  function jnf(b:boolean):char;
  begin
    jnf:=iifc(b,'J','N');
  end;

var
 res: Integer;
begin
  assign(t,UStr(OwnPath+dateiname+BfgExt));
  rewrite(t);
  if ioresult<>0 then
  begin
    rfehler(902);     { 'ungltiger Boxname!' }
    exit;
  end;
  with bp^ do
  begin
    writeln(t,'Boxname=',boxname);
    writeln(t,'Pointname=',pointname);
    writeln(t,'Username=',username);
    writeln(t,'Domain=',_domain);
    writeln(t,'FQDN=',_fqdn);
    writeln(t,'Passwort=',passwort);
    writeln(t,'Telefon=',telefon);
    writeln(t,'ZerbID=',zerbid);
    writeln(t,'Upload=',uploader);
    writeln(t,'Download=',downloader);
    writeln(t,'Protokolltyp=',prototyp);
    writeln(t,'ZMOptions=',zmoptions);
    writeln(t,'UpArc=',uparcer);
    writeln(t,'DownArc=',downarcer);
    if UnFreezer<>'' then
      writeln(t,'UnFreeze=',unfreezer);
    if Ungzipper<>'' then
      writeln(t,'UnGZIP=',ungzipper);
    writeln(t,'UpArcExt=',uparcext);
    writeln(t,'DownArcExt=',downarcext);
    writeln(t,'ConnWait=',connwait);
    writeln(t,'Citycarrier=', jnf(citycarrier));
    writeln(t,'LoginWait=',loginwait);
    writeln(t,'RedialWait=',redialwait);
    writeln(t,'RedialMax=',redialmax);
    writeln(t,'ConnectMax=',connectmax);
    writeln(t,'PackWait=',packwait);
    writeln(t,'RetryLogin=',retrylogin);
    writeln(t,'ConnectTime=',conn_time);
    writeln(t,'ModemInit=',modeminit);
    writeln(t,'cpsMin=',mincps);
    writeln(t,'Port=',bport);
    writeln(t,'Params=',params);
    writeln(t,'Baud=',baud);
    writeln(t,'Tarifzone=',gebzone);
    writeln(t,'SysopMode=', jnf(sysopmode));
    writeln(t,'SysopInfile=',sysopinp);
    writeln(t,'SysopOutfile=',sysopout);
    writeln(t,'SysopStartprg=',sysopstart);
    writeln(t,'SysopEndprg=',sysopend);
    writeln(t,'MagicNET=',magicnet);
    writeln(t,'MagicBrett=',magicbrett);
    writeln(t,'LightLogin=',jnf(lightlogin));
    writeln(t,'OnlinePasswort=',o_passwort);
    writeln(t,'Logfile=',o_logfile);
    writeln(t,'NetcallScript=',script);
    writeln(t,'OnlineScript=',o_script);
    for i:=1 to excludes do
      if exclude[i,1]<>'  :  ' then
        writeln(t,'Ausschluss',i,'=',exclude[i,1],'-',exclude[i,2]);
    writeln(t,'Brettmails=',jnf(brettmails));
    writeln(t,'Eingangsfilter=',eFilter);
    writeln(t,'Ausgangsfilter=',aFilter);
    writeln(t,'SysopNetcall=',jnf(sysopnetcall));
    writeln(t,'SysopPacken=',jnf(sysoppack));
    writeln(t,'ReplaceOwn=', jnf(ReplaceOwn));
    writeln(t,'Replace_0=', jnf(Replace_0));
    writeln(t,'Replace_2=', jnf(Replace_2));
    writeln(t,'Replace_3=', jnf(Replace_3));
    writeln(t,'Replace_4=', jnf(Replace_4));
    writeln(t,'Replace_10=', jnf(Replace_10));
    writeln(t,'Replace_11=', jnf(Replace_11));
    writeln(t,'Replace_20=', jnf(Replace_20));
    writeln(t,'Replace_30=', jnf(Replace_30));
    writeln(t,'Replace_31=', jnf(Replace_31));
    writeln(t,'Replace_40=', jnf(Replace_40));
    writeln(t,'Replace_41=', jnf(Replace_41));
    writeln(t,'Mailer-Daemon=', jnf(EB_Daemon));
    writeln(t);
    writeln(t,'FidoFakenet=',fpointnet);
    writeln(t,'Fido4Dadr=',jnf(f4d));
    writeln(t,'TosScan=',jnf(ftosscan));
    writeln(t,'LocalINTL=',jnf(localintl));
    writeln(t,'FidoArea+=',jnf(areaplus));
    writeln(t,'AreaBetreff=',jnf(areabetreff));
    writeln(t,'AreaPasswort=',AreaPW);
    writeln(t,'FileScanner=',filescanner);
    writeln(t,'FilescanPW=',filescanpw);
    writeln(t,'EMSI=',jnf(EMSIenable));
    writeln(t,'GetTime=',jnf(gettime));
    if akas<>'' then writeln(t,'AKAs=',akas);
    if SendAKAs<>'' then writeln(t,'SendAKAs=',SendAKAs);
    if sendtrx  then writeln(t,'SendTrx=J');
    if notsempty then writeln(t,'NotSEmpty=J');
    if packetpw then writeln(t,'PacketPW=J');
    if ExtPFiles then writeln(t,'ExtFidoFNames=J');
    if loginname<>'' then writeln(t,'LoginName=',loginname);
    if uucpname<>''  then writeln(t,'UUCPname=',uucpname);
    if maxwinsize<>7 then writeln(t,'UU-MaxWinSize=',maxwinsize);
    if maxpacketsize<>64 then writeln(t,'UU-MaxPacketSize=',maxpacketsize);
    writeln(t,'UU-VarPacketSize=',jnf(varpacketsize));
    writeln(t,'UU-ForcePacketSize=',jnf(forcepacketsize));
    writeln(t,'UU-SizeNegotiation=',jnf(sizenego));
    writeln(t,'UU-SMTP=',jnf(uusmtp));
    writeln(t,'UU-SMTP-Client=', jnf(ClientSmtp));
    if uuprotos<>'' then writeln(t,'UU-protocols=',uuprotos);
    if maxfsize>0 then writeln(t,'MaxFileSize=',maxfsize);
    writeln(t,'BrettmanagerTyp=',BMtyp);
    writeln(t,'BrettmanagerDomain=',jnf(BMdomain));
    if chsysbetr<>'' then writeln(t,'Sysfile=',chsysbetr);
    writeln(t,'7e1Login=',jnf(uucp7e1));
    if janusplus then writeln(t,'JanusPlus=J');
    writeln(t,'DelQWK=',jnf(DelQWK));
    writeln(t,'Client-Path=', PPPClientPath);
    writeln(t,'Client-Exec=', PPPClient);
    writeln(t,'Client-AddServers=', PPPAddServers);
    writeln(t,'Client-DialUp=', PPPDialUp);
    writeln(t,'Client-Phone=', PPPPhone);
    writeln(t,'Client-Login=', PPPLogin);
    writeln(t,'Client-Password=', PPPPass);
    writeln(t,'Client-AskIfConnect=', jnf(PPPAskIfConnect));
    writeln(t,'Client-AskIfDisconnect=', jnf(PPPAskIfDisconnect));
    writeln(t,'Client-KeepConnectStatus=', jnf(PPPKeepConnectStatus));
    writeln(t,'Client-Spool=', OwnPath + XFerDir + Dateiname + '\');
    MkLongDir(OwnPath + XFerDir + Dateiname, Res);
    if IOResult = 0 then ;
    writeln(t,'Client-MailInServer=', PPPMailInServer);
    writeln(t,'Client-MailInPort=', PPPMailInPort);
    writeln(t,'Client-MailInProtocol=', PPPMailInProtocol);
    writeln(t,'Client-MailInEnvelope=', PPPMailInEnv);
    writeln(t,'Client-MailInUser=', PPPMailInUser);
    writeln(t,'Client-MailInPassword=', PPPMailInPass);
    writeln(t,'Client-MailInUseEnvTo=', jnf(PPPMailInUseEnvTo));
    writeln(t,'Client-MailInKeep=', jnf(PPPMailInKeep));
    writeln(t,'Client-MailInAPOP=', jnf(PPPMailInAPOP));
    writeln(t,'Client-MailOutServer=', PPPMailOutServer);
    writeln(t,'Client-MailOutPort=', PPPMailOutPort);
    writeln(t,'Client-MailFallback=', PPPMailFallback);
    writeln(t,'Client-MailOutEnvelope=', PPPMailOutEnv);
    writeln(t,'Client-MailOutUser=', PPPMailOutUser);
    writeln(t,'Client-MailOutPassword=', PPPMailOutPass);
    writeln(t,'Client-MailOutSMTPafterPOP=', jnf(PPPMailOutSMTPafterPOP));
    writeln(t,'Client-MailOutSMTPLogin=', jnf(PPPMailOutSMTPLogin));
    writeln(t,'Client-NewsServer=', PPPNewsServer);
    writeln(t,'Client-NewsPort=', PPPNewsPort);
    writeln(t,'Client-NewsFallback=', PPPNewsFallback);
    writeln(t,'Client-NewsUser=', PPPNewsUser);
    writeln(t,'Client-NewsPassword=', PPPNewsPass);
    writeln(t,'Client-NewsList=', jnf(PPPNewsList));
    writeln(t,'Client-NewsMaxLen=', PPPNewsMaxLen);
    writeln(t,'Client-NewsMax=', PPPNewsMax);
    writeln(t,'Client-ExternalConfig=', PPPExternCfg);
    { writeln(t,'HdrOnly=Default'); }  { aktiviert HdrOnly in UKAW           }
                                       { und ist derzeit wegen der in FreeXP }
                                       { nicht vorhandenen Untersttzung von }
                                       { HdrOnly deaktiviert                 }
  end;
  close(t);
end;


procedure ReadBoxPar(nt:byte; box:string);
var d     : DB;
    bfile : pathstr;
begin
  dbOpen(d,BoxenFile,1);               { zugehrigen Dateiname holen }
  dbSeek(d,boiName,ustr(box));
  if dbFound then
  begin
    dbRead(d,'dateiname',bfile);
    ReadBox(nt,bfile,BoxPar);             { Pollbox-Parameter einlesen }
  end;
  dbClose(d);
end;


procedure ReadQFG(const dateiname:pathstr; var qrec:QfgRec);
var t  : text;
    s  : String;
    id : string[10];
begin
  fillchar(qrec,sizeof(qrec),0);
  qrec.midtyp:=2;   { Default }
  assign(t,dateiname+QfgExt);
  if existf(t) then with qrec do begin
    reset(t);
    s:='';
    while not eof(t) do begin
      readln(t,s);
      id:=ustr(GetToken(s,':'));
      if id='BBS' then RepFile:=s else
      if id='ZIP' then packer:=s else
      if id='SYS' then door:=s else
      if id='REQ' then requests:=(ustr(s)<>'N') else
      if id='REC' then ebs:=(ustr(s)<>'N') else
      if id='PMA' then privecho:=s else
      if id='NMA' then netecho:=s else
      if id='EMA' then emailecho:=s else
      if id='NMT' then nmt:=minmax(ival(s),0,255) else
      if id='MID' then midtyp:=minmax(ival(s),0,9) else
      if id='HDR' then hdr:=(ustr(s)<>'M') else
      if id='BEB' then bretter:=s;
      end;
    close(t);
    end;
end;


procedure WriteQFG(const dateiname:Pathstr; qrec:QfgRec);
var t1,t2 : text;
    s,ss  : string;
    id    : string[10];
begin
  assign(t1,dateiname+QfgExt);
  if existf(t1) then with qrec do begin
    reset(t1);
    assign(t2,'qwktemp.$$$');
    rewrite(t2);
    while not eof(t1) do begin
      readln(t1,s);
      ss:=s;
      id:=ustr(GetToken(s,':'));
      if id='BBS' then writeln(t2,'BBS: '+RepFile) else
      if id='ZIP' then writeln(t2,'ZIP: '+packer) else
      if id='SYS' then writeln(t2,'SYS: '+door) else
      if id='REQ' then writeln(t2,'REQ: '+iifc(requests,'J','N')) else
      if id='REC' then writeln(t2,'REC: '+iifc(ebs,'J','N')) else
      if id='PMA' then writeln(t2,'PMA: '+privecho) else
      if id='NMA' then writeln(t2,'NMA: '+netecho) else
      if id='EMA' then writeln(t2,'EMA: '+emailecho) else
      if id='NMT' then writeln(t2,'NMT: '+strs(nmt)) else
      if id='MID' then begin
        writeln(t2,'MID: '+strs(midtyp));
        midtyp:=-1;
        end else
      if id='HDR' then begin
        writeln(t2,'HDR: '+iifc(hdr,'J','N'));
        hdr:=false;
        end else
      if id='BEB' then writeln(t2,'BEB: '+bretter)
      else begin
        if lstr(ss)='[brettstart]' then begin
            { MID: und HDR: knnen fehlen, weil ZQWK sie nicht }
            { automatisch erzeugt                              }
          if midtyp>=0 then writeln(t2,'MID: '+strs(midtyp));
          if hdr then writeln(t2,'HDR: J');
          end;
        writeln(t2,ss);
        end;
      end;
    close(t1);
    close(t2);
    erase(t1);
    rename(t2,dateiname+QfgExt);
    end;
end;


function BoxBrettebene(const box:string):string;
begin
  ReadBoxPar(nt_Fido {egal} ,box);
  BoxBrettebene:=boxpar^.MagicBrett;
end;


end.
