{ ------------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.                   }
{ (c) 1991-1999 Peter Mandrella                                       }
{ (c) 2000-2001 OpenXP-Team                                           }
{ (c) 2002-2026 FreeXP, http://www.freexp.de                          }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.         }
{                                                                     }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der     }
{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html }
{ ------------------------------------------------------------------- }


{ CrossPoint - UniSel (Boxen, Gruppen, Systeme, Kurznamen, Mime-Typen) }

{$I XPDEFINE.INC}
{$O+,F+}

unit xp9;

interface

uses
  crt,dos,typeform,fileio,inout,keys,winxp,win2,maske,datadef,database,
  maus2,mouse,resource,xpglobal,xp0,xp1,xp1o,xp1o2,xp1input,xp2c,lfn,
  xpnt;


const umtyp : array[0..5] of string[5] =
              ('IBM','ASCII','ISO','Tab.1','Tab.2','Tab.3');

      enetztypen = 11;  { Netztypen umgeordnet auf DFUe-Welt anno 2001 }
      ntnr   : array[0..enetztypen-1] of byte =
        (nt_Client, nt_UUCP, nt_ZConnect, nt_FIDO, nt_QWK, nt_Maus,
         nt_Netcall, nt_Magic, nt_Pronet, nt_Quick, nt_GS);
      maxboxen = 127;         { max. Gre des Arrays 'boxlist' }

var   UpArcnr       : integer;   { fr EditPointdaten }
      DownArcNr     : integer;
      userfield     : integer;   { Masken-Nr., s. get_first_box }
      gf_fido       : boolean;
      loginfld      : integer;   { UUCP-Loginname }
      uup1,uupl     : integer;
      DomainNt      : shortint;  { Netztyp f. setdomain() und testvertreterbox() }
      bDomainNt     : byte;                                               { u.a. }
      EditPnt       : byte;      { Netztyp f. EditPointdaten }
      EMSIfield     : integer;
      pp_da         : boolean;   { unversandte Nachrichten vorhanden }
      amvfield      : integer;   { EditDiverses }
      downprotnr    : integer;   { Edit/Point - Download-Protokoll }
      MailInServerFld : integer; { Name MailInServer RFC/Client }

const own_Nt    : byte = 255;
        { Netztyp f. "Zustzliche Server" (RFC/Client) bzw. "AKAs/Pakete mitsenden" (Fido) }
      own_Name  : string[BoxNameLen] = '';
        { Boxname f. "Zustzliche Server" (RFC/Client) bzw. "AKAs/Pakete mitsenden" (Fido) }
      showErrors: boolean = true;
        { Flag fr 'addServersTest' in xp9sel.pas }
      BfgToBoxOk: boolean = true;
        { Flag fr 'ChkAddServers' in xp7.inc }
      maxbox    : byte = maxboxen;
        { max. Boxen-Anzahl in Box-Config bzw. NETCALL.DAT }

      delete_on_cDel  : boolean = false; { Steuerung des Verhaltens...   }
      leave_on_cDel   : boolean = false; { ... bei <Ctrl-Del> in Feldern }
      may_insert_clip : boolean = true;  { Clipboard in Felder (nicht) einfgen }

function  Netz_Typ(nt:byte):string;
function  UniSel(typ:byte; edit:boolean; default:string):string;
procedure get_first_box(d:DB);
procedure BoxSelProc(var cr:customrec);
procedure GruppenSelproc(var cr:customrec);

implementation  {---------------------------------------------------}

uses
  xp2b,xp2,xp2x,xp2m,xp3,xp3o,xp4rta,xp9bp,xp9sel,xp10,lister,xpterm,xpovl,xp9mime;


{$IFDEF FPC }
  {$HINTS ON }
{$ENDIF }



{ fr maske.CustomSel }


function Netz_Typ(nt:byte):string;
var i : integer;
begin
  Netz_Typ:=ntName(nt_Netcall);
  for i:=0 to enetztypen-1 do
    if nt=ntnr[i] then Netz_Typ:=ntName(ntnr[i]);
end;


procedure BoxSelProc(var cr:customrec);
begin
  with cr do begin
    s:=UniSel(1,false,s);
    brk:=(s='');
  end;
end;


procedure GruppenSelproc(var cr:customrec);
begin
  with cr do begin
    s:=UniSel(2,false,s);
    brk:=(s='');
    end;
end;


function getdname(nt:byte; boxname:string):string;
var fa : fidoadr;
begin
  if (nt=nt_Fido) or ((nt=nt_QWK) and multipos(_MPMask,boxname)) then begin
    splitfido(boxname,fa,0);
    getdname:=ustr(formi(fa.net mod 10000,4)+formi(fa.node mod 10000,4));
    end
  else
    if validfilename(left(boxname,8)+BfgExt,true) then
      getdname:=ustr(left(boxname,8))
    else
      getdname:='BOX-0001';
end;


function DefaultMaps(nt:byte):string;
begin
  case nt of
    nt_Netcall,
    nt_ZConnect : DefaultMaps:='MAPS';
    nt_Magic    : DefaultMaps:='MAF';
    nt_GS,
    nt_ProNet   : DefaultMaps:='SYSTEM';
    nt_Maus     : DefaultMaps:='MAUS';    { nicht editierbar! }
    nt_Fido     : DefaultMaps:='Areafix';
    nt_UUCP,
    nt_Client   : DefaultMaps:='changesys';
    nt_QWK      : DefaultMaps:='ZQWK';
  else            DefaultMaps:='SYSOP';   { Quick, Turbo }
  end;
end;


{ Typ :  1=Boxen, 2=Gruppen, 3=Systeme, 4=Kurznamen, 5=MIME-Typen }
{ edit:  true=editieren, false=nur auswhlen                      }

function UniSel(typ:byte; edit:boolean; default:string):string;
const maxgl   = 40;
      dsellen = 20;
var t         : taste;    
    x,y       : byte;
    width     : byte;
    buttons   : string[60];
    bp,rb     : shortint;
    okb,edb   : shortint;
    c         : char;
    empty     : boolean;
    s         : string[80];
    setdefault: boolean;
    umlaut    : byte;
    poutside  : boolean;
    startmkey : boolean;   { beim Start war Maustaste gedrckt }
    directsel : string[dsellen];
    nameofs   : byte;

  procedure displine(i:integer);
  var s1,s2      : string[40];
      s3         : string[80];
      scrp       : byte;
      limit,grnr : longint;
      w          : smallword;
      hd,sig,qt  : char;
      qm         : string[8];
      nt,b       : byte;
      dc         : string[2];
      adr        : string[AdrLen];
      fn         : string[12];
  begin
    drec[i]:=dbRecno(d);
    case typ of
      1 : dbRead(d,'Boxname',s1);
      2 : dbRead(d,'Name',s1);
    end;
    if setdefault and (ustr(s1)=ustr(default)) then begin
      p:=i;
      setdefault:=false;
      end;
    case typ of
      1 : begin     { Boxen }
            dbRead(d,'Username',s2);
            dbRead(d,'Kommentar',s3);
            dbRead(d,'Script',scrp);
            dbRead(d,'Netztyp',nt);
            if s1=DefaultBox then
              if s1=DefFidoBox then dc:='F '
              else dc:=' '
            else
              if s1=DefFidoBox then dc:='f '
              else dc:='  ';
            s:=dc+forms(s1,11)+' '+forms(Netz_Typ(nt),12)+forms(s2,17)+' '+
               forms(s3,23);
          end;
      2 : begin     { Gruppen }
            dbRead(d,'msglimit',limit);
            dbRead(d,'int_nr',grnr);
            dbRead(d,'umlaute',umlaut);
            hd:=iifc(ustr(dbReadStr(d,'kopf')+'.XPS')<>ustr(headerfile),'K',' ');
            qm:=dbReadStr(d,'quotemsk');
            qt:=iifc((qm<>'') and (ustr(qm+'.XPS')<>ustr(quotemsk)),'Q',' ');
            sig:=iifc(ustr(dbReadStr(d,'signatur')+'.XPS')<>ustr(signatfile),'S',' ');
            s:=strsn(grnr,5)+' '+hd+qt+sig+' '+forms(s1,28)+' '+
               forms(umtyp[umlaut],6)+
               iifs(limit>0,strsrnp(limit,12,0),sp(11)+' ')+' ';
          end;
      3 : begin     { Systeme }
            dbRead(d,'name',s1);
            dbRead(d,'kommentar',s2);
            dbRead(d,'fs-passwd',s3);
            dbRead(d,'flags',w);
            dbRead(d,'fs-typ',b);
            if b=3 then dc:=' U'
            else if dbReadStr(d,'FS-Name')<>'' then dc:=' F'
            else dc:='  ';
            s:=dc+iifs((s3='') or (b=3),'  ','P ')+forms(s1,20)+' '+forms(s2,26);
          end;
      4 : begin     { Kurznamen }
            dbRead(d,'kurzname',s1);
            dbRead(d,'langname',adr);
            dbRead(d,'pollbox',s2);
            s:=' '+forms(s1,12)+' '+forms(adr,36)+' '+forms(s2,12);
          end;
      5 : begin     { MIME-Typen }
            dbRead(d,'typ',s1);
            dbRead(d,'extension',s2);
            dbRead(d,'programm',s3);
            if s3='' then s3:=getres(934)    { '(intern)' }
            else if length(s3)>31 then s3:=left(s3,31)+'...';
            s1:=extmimetyp(s1);
            if left(s1,12)='application/' then s1:='appl.'+mid(s1,12);
            s:=' '+forms(s1,26)+' '+forms(s2,6)+forms(s3,31);
          end;
    end;
    if not setdefault and (i=p) then attrtxt(col.colsel2bar)
    else attrtxt(col.colsel2box);
    fwrt(x+1,y+i,s);
  end;

  procedure display;
  var i : integer;
      b : boolean;
  begin
    moff;
    if drec[1]=0 then begin
      dbGoTop(d); b:=true; end
    else begin
      dbSkip(d,-1);
      b:=dbBOF(d);
      if b then dbGoTop(d)
      else dbSkip(d,1);
      end;
    fillchar(drec,sizeof(drec),0);
    i:=1;
    while (i<=gl) and not dbEOF(d) do begin
      displine(i);
      dbSkip(d,1);
      inc(i);
      end;
    attrtxt(col.colsel2box);
    if i<=gl then
      clwin(x+1,x+width,y+i,y+gl);
    attrtxt(col.colsel2rahmen);
    fwrt(x,y+1,iifc(b,'',#30));
    fwrt(x,y+gl,iifc(dbEOF(d),'',#31));
    if i=1 then begin
      attrtxt(col.colsel2bar);
      fwrt(x+1,y+1,sp(width));
      end;
    aufbau:=false;
    p0:=p;
    mon;
  end;


  {$I xp9.inc}     { Bearbeitungs-Routinen fr Boxen }


  { --- Bearbeitungs-Routinen fr Gruppen-Liste ---------------------}

  procedure ReadGruppe(edit:boolean; var name:string; var hzeit:integer16;
                       var limit:longint; var umlaut:byte; var hd,qt,sig:string;
                       var flags:byte; var brk:boolean);
  const fname = '1234567890$_-';

    function retypes(nr:byte):string;
    begin
      retypes:=getres2(901,15+nr);
    end;

  var x,y,i : byte;
      ums   : string[5];
      ss    : string;
      retyp : string[10];  { Re^n / Re / Default / nein }
  begin
    dialog(ival(getres2(901,0)),10,getres2(901,iif(edit,1,2)),x,y);    { 'Brettgruppe bearbeiten','neue Brettgruppe anlegen' }
    if even(flags) then begin
      maddstring(3,2,getres2(901,3),name,30,30,''); mhnr(201);   { 'Name    ' }
      msetvfunc(notempty);
      end
    else begin
      maddtext(3,2,getres2(901,4),col.coldialog);      { 'Name' }
      maddtext(12,2,name,col.coldiahigh);
      end;
    maddint   (3,4,getres2(901,5),limit,6,8,0,99999999); mhnr(202);   { 'Limit   ' }
    maddtext  (length(getres2(901,5))+14,4,getres(13),col.coldialog);
    maddint   (3,6,getres2(901,6),hzeit,4,5,0,9999);   { 'Halten: ' }
    maddtext  (length(getres2(901,6))+12,6,getres2(901,7),col.coldialog);   { 'Tg.' }
    ums:=umtyp[umlaut];
    maddstring(3,7,getres2(901,8),ums,5,5,'');         { 'Sonderz.' }
    for i:=0 to 1 do
      mappsel(true,umtyp[i]);
    ss:=range('A','Z')+range('a','z')+fname;
    maddstring(25,5,getres2(901,9),hd,8,8,ss);         { '    Kopf' }
    mappcustomsel(SelSchab,false);
    maddstring(25,6,getres2(901,10),qt,8,8,ss);        { '   Quote' }
    mappcustomsel(SelSchab,false);
    maddstring(25,7,getres2(901,11),sig,8,8,ss);       { 'Signatur' }
    mappcustomsel(SelSchab,false);
    retyp:=retypes((flags and 6) shr 1);
 {  case flags and 6 of
      0 : retyp:='Vorgabe';
      2 : retyp:='Re^n:';
      4 : retyp:='Re:';
      6 : retyp:='nein';
    end; }
    maddstring(3,9,getres2(901,20),retyp,7,7,'');      { 'Replies ' }
    for i:=0 to 3 do
      mappsel(true,retypes(i));
    readmask(brk);
    if not brk then begin
      for i:=0 to 5 do
        if ustr(ums)=ustr(umtyp[i]) then umlaut:=i;
      flags:=flags and (not 6);
      LoString(retyp);
      if retyp=lstr(retypes(1)) then inc(flags,2)        { re^n: }
      else if retyp=lstr(retypes(2)) then inc(flags,4)   { re:   }
      else if retyp=lstr(retypes(3)) then inc(flags,6);  { nein  }
      end;
    enddialog;
    freeres;
  end;

  procedure NeueGruppe;
  var name   : string[30];
      hzeit  : integer16;
      limit  : longint;
      umlaut : byte;
      flags  : byte;
      brk    : boolean;
      hd,sig : string[8];
      qt     : string[8];
  begin
    name:=''; hzeit:=stdhaltezeit; limit:=MaxNetMsgs;
    hd:='header'; sig:='signatur'; qt:='qbrett';
    umlaut:=0;   { IBM-Umlaute, keine Konvertierung }
    flags:=0;    { keine Standard-Gruppe; Re^n: Default }
    readgruppe(false,name,hzeit,limit,umlaut,hd,qt,sig,flags,brk);
    if not brk then begin
      dbSeek(d,giName,ustr(name));
      if dbFound then
        rfehler(910)   { 'Eine Gruppe mit diesem Namen existiert bereits.' }
      else begin
        dbAppend(d);
        dbWrite(d,'Name',name);
        dbWrite(d,'haltezeit',hzeit);
        dbWrite(d,'MsgLimit',limit);
        dbWrite(d,'umlaute',umlaut);
        dbWrite(d,'kopf',hd);
        dbWrite(d,'signatur',sig);
        dbWrite(d,'quotemsk',qt);
        dbWrite(d,'flags',flags);
        dbFlushClose(d);
        dbGo(d,drec[1]);
        dbSkip(d,-1);     {ein Feld zurueck, damit Neueintrag sichtbar ist}
        aufbau:=true;
        end;
      end;
  end;

  procedure EditGruppe;
  var name   : string[30];
      hzeit  : integer16;
      limit  : longint;
      flags  : byte;
      umlaut : byte;
      brk    : boolean;
      hd,sig : string[8];
      qt     : string[8];
  begin
    dbGo(d,drec[p]);
    dbRead(d,'Name',name);
    dbRead(d,'haltezeit',hzeit);
    dbRead(d,'MsgLimit',limit);
    dbRead(d,'flags',flags);
    dbRead(d,'umlaute',umlaut);
    dbRead(d,'kopf',hd);
    dbRead(d,'signatur',sig);
    dbRead(d,'quotemsk',qt);
    readgruppe(true,name,hzeit,limit,umlaut,hd,qt,sig,flags,brk);
    if not brk then begin
      dbWrite(d,'Name',name);
      dbWrite(d,'haltezeit',hzeit);
      dbWrite(d,'MsgLimit',limit);
      dbWrite(d,'Umlaute',umlaut);
      dbWrite(d,'kopf',hd);
      dbWrite(d,'signatur',sig);
      dbWrite(d,'quotemsk',qt);
      dbWrite(d,'flags',flags);
      dbFlushClose(d);
      dbGo(d,drec[1]);
      aufbau:=true;
      end;
  end;

  procedure FidoGruppe;
  var x,y  : byte;
      brk  : boolean;
      orig : string[50];
      addr : string[50];
  begin
    dbGo(d,drec[p]);
    dbRead(d,'origin',orig);
    dbRead(d,'adresse',addr);
    dialog(46,5,getres2(902,1),x,y);    { 'Fido-Einstellungen' }
    maddstring(3,2,getres2(902,2),orig,32,48,range(' ',#126)); mhnr(690);   { 'Origin ' }
    maddstring(3,4,getres2(902,3),addr,15,15,'');   { 'Adresse' }
    mset3proc(setfidoadr);
    readmask(brk);
    enddialog;
    if not brk then begin
      dbWrite(d,'origin',orig);
      dbWrite(d,'adresse',addr);
      dbFlushClose(d);
      end;
  end;

  procedure DelGruppe;
  var grnr  : longint;
      flags : byte;
  begin
    dbGo(d,drec[p]);
    dbRead(d,'flags',flags);
    if odd(flags) then
      rfehler(911)       { 'Gruppe kann nicht gelscht werden!' }
    else begin
      dbRead(d,'INT_NR',grnr);
      dbSetindex(bbase,biGruppe);
      dbSeek(bbase,biGruppe,dbLongStr(grnr));
      if dbFound then
        rfehler(912)     { 'Es sind noch Bretter in dieser Gruppe vorhanden.' }
      else begin
        dbDelete(d);
        dbFlushClose(d);
        if p=1 then dbGoTop(d)
        else dbGo(d,drec[1]);
        aufbau:=true;
        end;
      end;
  end;

  procedure addhzeit(add:integer);
  var hzeit : integer16;
  begin
    dbGo(d,drec[p]);
    dbRead(d,'haltezeit',hzeit);
    hzeit:=max(0,min(hzeit+add,9999));
    dbWrite(d,'haltezeit',hzeit);
    displine(p);
  end;


  { --- Bearbeitungs-Routinen fr System-Liste ---------------------}

  procedure ReadSystem(var name,komm,fs_name,fs_passwd,converter:string;
                       fs_typ:byte; var brk:boolean);
  var x,y : byte;
  begin
    dialog(ival(getres2(903,0)),11,getres2(903,iif(edit,1,2)),x,y);    { 'Systeme bearbeiten','neues System anlegen' }
    maddstring(3,2,getres2(903,3),name,BoxNameLen, BoxNameLen,'>'); mhnr(461);   { 'Systemname ' }
    mappcustomsel(BoxSelProc,false);
    msetvfunc(testsysname);
    maddstring(3,4,getres2(903,4),komm,30,30,'');       { 'Kommentar  ' }
    maddstring(3,6,getres2(903,5),fs_name,20,20,'');    { 'Fileserver ' }
    mappsel(false,'FILESERVER'+uuserver);
    mset3proc(setPasswdField);
    maddstring(3,8,getres2(903,iif(fs_typ=3,7,6)),fs_passwd,20,20,'');  { 'Index-Datei' / 'Pawort    ' }
    maddstring(3,10,getres2(903,8),converter,30,60,'>');  { 'Konvertierer' }
    mappsel(false,'UUCP-FL1.EXE $INFILE $OUTFILECOPY $INFILE $OUTFILE');
    readmask(brk);
    freeres;
    if not brk then
      if ustr(fs_name)<>ustr(uuserver) then
        UpString(fs_name)
      else begin
        if fs_passwd='' then fs_passwd:='index';
        if converter='' then converter:='COPY $INFILE $OUTFILE';
        end;
    enddialog;
  end;

  procedure NeuesSystem;
  var name   : string[20];
      komm   : string[30];
      fsuser : string[20];
      fspass : string[20];
      convert: string[60];
      brk    : boolean;
      w      : word;
      b      : byte;
  begin
    name:=''; komm:='';
    fsuser:=''; fspass:='';
    convert:='';
    readsystem(name,komm,fsuser,fspass,convert,0,brk);
    if not brk then begin
      dbSeek(d,siName,ustr(name));
      if dbFound then
        rfehler(913)     { 'Ein System mit diesem Namen existiert bereits.' }
      else begin
        dbAppend(d);
        dbWrite(d,'Name',name);
        dbWrite(d,'Kommentar',komm);
        dbWrite(d,'fs-name',fsuser);
        dbWrite(d,'fs-passwd',fspass);
        dbWrite(d,'ZBV1',convert);
        w:=iif(fsuser<>'',1,0);
        dbWrite(d,'flags',w);
        b:=iif(ustr(fsuser)=ustr(uuserver),3,0);
        dbWrite(d,'fs-typ',b);
        dbFlushClose(d);
        dbGo(d,drec[1]);
        dbSkip(d,-1);     {ein Feld zurueck, damit Neueintrag sichtbar ist}
        aufbau:=true;
        end;
      end;
  end;

  procedure EditSystem;
  var name   : string[30];
      komm   : string[30];
      fsuser : string[20];
      fspass : string[20];
      convert: string[60];
      brk    : boolean;
      w      : word;
      typ    : byte;
  begin
    dbGo(d,drec[p]);
    dbRead(d,'Name',name);
    dbRead(d,'Kommentar',komm);
    dbRead(d,'fs-name',fsuser);
    dbRead(d,'fs-passwd',fspass);
    dbRead(d,'fs-typ',typ);
    dbRead(d,'ZBV1',convert);
    readsystem(name,komm,fsuser,fspass,convert,typ,brk);
    if not brk then begin
(*      dbOpen(dbox,BoxenFile,1);
      SeekLeftBox(dbox,name);
      if dbFound then nt:=dbReadInt(dbox,'netztyp') else nt:=100;
      dbClose(dbox);
      if nt=nt_Client then begin
        rfehler(0; 'geht nicht im client-modus');
        exit;
      end; *)

      dbWrite(d,'Name',name);
      dbWrite(d,'Kommentar',komm);
      dbWrite(d,'fs-name',fsuser);
      dbWrite(d,'fs-passwd',fspass);
      dbWrite(d,'ZBV1',convert);
      w:=iif(fsuser<>'',1,0);
      dbWrite(d,'flags',w);
      if ustr(fsuser)=ustr(uuserver) then typ:=3
      else if typ=3 then typ:=0;
      dbWrite(d,'fs-typ',typ);
      dbFlushClose(d);
      dbGo(d,drec[1]);
      aufbau:=true;
      end;
  end;

  procedure DelSystem;
  begin
    if dbRecCount(d)<2 then
      rfehler(914)    { 'Es mu mindestens ein System eingetragen sein!' }
    else begin
      dbGo(d,drec[p]);
      if ReadJN(getreps(904,dbReadStr(d,'name')),true) then begin   { '%s lschen' }
        dbDelete(d);
        dbFlushClose(d);
        if p=1 then dbGoTop(d)
        else dbGo(d,drec[1]);
        aufbau:=true;
        end;
      end;
  end;


  { --- Bearbeitungs-Routinen fr Kurznamen-Liste ------------------}

  procedure ReadPseudo(edit:boolean; var kurz,lang,pollbox:string;
                       var brk:boolean);
  var x,y: byte;
  begin
    dialog(ival(getres2(905,0)),7,getres2(905,iif(edit,1,2)),x,y);   { 'Kurzname bearbeiten' / 'Kurzname anlegen' }
    maddstring(3,2,getres2(905,3),kurz,15,15,without(allchar,'@')); mhnr(711);   { 'Kurzname   ' }
    msetvfunc(notempty);
    maddstring(3,4,getres2(905,4),lang,35,79,iifs(ntZonly and not smallnames,'>',''));   { 'Brett/User ' }
    mappcustomsel(Auto_Empfsel,false);
    mset3proc(ps_setempf);
    maddstring(3,6,getres2(905,5),pollbox,BoxRealLen,BoxNameLen,'>');   { 'Server     ' }
    mappcustomsel(BoxSelProc,false);
    freeres;
    readmask(brk);
    enddialog;
  end;

  procedure NeuesPseudo;
  var kurz    : string[15];
      lang    : string[AdrLen];
      pollbox : string[BoxNameLen];
      brk     : boolean;
  begin
    kurz:=''; lang:=''; pollbox:='';
    readpseudo(false,kurz,lang,pollbox,brk);
    if not brk then begin
      dbSeek(d,piKurzname,ustr(kurz));
      if dbFound then
        rfehler(915)     { 'Diesen Kurznamen gibt es bereits.' }
      else begin
        dbAppend(d);
        dbWrite(d,'Kurzname',kurz);
        dbWrite(d,'Langname',lang);
        dbWrite(d,'pollbox',pollbox);
        dbFlushClose(d);
        dbGo(d,drec[1]);
        dbSkip(d,-1);     {ein Feld zurueck, damit Neueintrag sichtbar ist}
        aufbau:=true;
        end;
      end;
  end;

  procedure EditPseudo;
  var kurz    : string[15];
      lang    : string[AdrLen];
      pollbox : string[BoxNameLen];
      brk     : boolean;
  begin
    dbGo(d,drec[p]);
    dbRead(d,'Kurzname',kurz);
    dbRead(d,'Langname',lang);
    dbRead(d,'pollbox',pollbox);
    readpseudo(true,kurz,lang,pollbox,brk);
    if not brk then begin
      dbWrite(d,'Kurzname',kurz);
      dbWrite(d,'Langname',lang);
      dbWrite(d,'pollbox',pollbox);
      dbFlushClose(d);
      dbGo(d,drec[1]);
      aufbau:=true;
      end;
  end;

  procedure DelPseudo;
  begin
    dbGo(d,drec[p]);
    if ReadJN(getreps(906,dbReadStr(d,'kurzname')),true) then begin   { '"%s" lschen' }
      dbDelete(d);
      dbFlushClose(d);
      if p=1 then dbGoTop(d)
      else dbGo(d,drec[1]);
      aufbau:=true;
      end;
  end;

  { sonstige Funktionen }

  procedure readbutt;
  begin
    rbx:=x+1; rby:=y+p;
    rb:=readbutton(x+2,y+gl+2,2,buttons,bp,false,t);
  end;

  procedure maus_bearbeiten;
  var ins1    : boolean;
      inside  : boolean;
      outside : boolean;
      xx,yy   : integer;
  begin
    maus_gettext(xx,yy);
    ins1:=(xx>x) and (xx<=x+width) and (yy>y);
    inside:=ins1 and (yy<=y+gl);
    outside:=not ins1 or (yy>y+gl+iif(edit,2,0));
    if inside then begin
      if (t=mausleft) or (t=mauslmoved) then
        p:=yy-y else
      if (t=mausunright) or (t=mausunleft) then begin
        if not poutside and not edit and (t=mausunleft) then
          if startmkey then startmkey:=false
          else t:=keycr;
        poutside:=false
        end else
      if t=mausldouble then begin
        rb:=edb; t:=keycr; end
      end;
    if outside then begin
      if (t=mausleft) or (t=mausright) or (t=mauslmoved) or (t=mausrmoved) then
        poutside:=true else
      if poutside and ((t=mausunleft) or (t=mausunright)) then begin
        rb:=okb; t:=keyesc; end;
      end;
  end;

  procedure _DirectSel;
  var nfeld : string[10];
      dnew  : string[dsellen];
      i     : integer;
  begin
    if (c<' ') and (c<>#8) then exit;
    if ((c=#8) and (directsel='')) or ((c>=' ') and (length(directsel)=dsellen))
    then begin
      errsound;
      exit;
      end;
    case typ of
      1 : nfeld:='boxname';
      2 : nfeld:='name';
      3 : nfeld:='name';
      4 : nfeld:='kurzname';
    end;
    if c=#8 then dnew:=left(directsel,length(directsel)-1)
    else dnew:=directsel+c;
    dbSeek(d,1,ustr(dnew));
    if dbBOF(d) then dbGoTop(d);
    if dbEOF(d) or (ustr(left(dbReadStr(d,nfeld),length(dnew)))<>ustr(dnew)) then
      errsound
    else begin
      i:=1;
      while (i<=maxgl) and (drec[i]<>dbRecno(d)) do inc(i);
      if i<=maxgl then
        p:=i
      else begin
        aufbau:=true;
        p:=1;
        end;
      DirectSel:=ustr(dnew);
      end;
  end;

begin
  if typ>5 then exit;
  case typ of
    1 : begin     { Boxen }
          dbOpen(d,BoxenFile,1);
          if not edit and (dbRecCount(d)=1) and (lastkey<>keyf2) then begin
            unisel:=dbReadStr(d,'boxname');
            dbClose(d);
            exit;
            end;
          width:=67;
          buttons:=getres(907);   { ' ^Neu , ^Lschen , ^Whlen , ^Edit , Netz^typ , ^OK ' }
          okb:=6; edb:=4;
          pushhp(iif(edit,130,139));
          nameofs:=3;
        end;
    2 : begin     { Gruppen }
          dbOpen(d,GruppenFile,1);
          width:=59;
          buttons:=getres(908);   { ' ^Neu , ^Lschen , ^Edit , ^Fido , ^OK ' }
          okb:=5; edb:=3;
          pushhp(iif(edit,200,209));
          nameofs:=11;
        end;
    3 : begin     { Systeme }
          dbOpen(d,SystemFile,1);
          width:=51;
          buttons:=getres(909);   { ' ^Neu , ^Lschen , ^Edit , ^OK ' }
          okb:=4; edb:=3;
          pushhp(iif(edit,460,469));
          nameofs:=5;
        end;
    4 : begin     { Kurznamen }
          dbOpen(d,PseudoFile,1);
          width:=63;
          buttons:=getres(909);   { ' ^Neu , ^Lschen , ^Edit , ^OK ' }
          okb:=4; edb:=3;
          pushhp(iif(edit,710,719));
          nameofs:=2;
        end;
    5 : begin     { MIME-Typen }
          d:=mimebase;
          width:=65;
          buttons:=getres(909);   { ' ^Neu , ^Lschen , ^Edit , ^OK ' }
          okb:=4; edb:=3;
          pushhp(820);         {JG:1051->820}
          nameofs:=2;
        end;
  end;
  if typ<>5 then miscbase:=d;
  drec[1]:=0;
  gl:=screenlines-11;
  if screenlines>30 then dec(gl,2);
  if screenlines>40 then dec(gl,2);
  selbox(width+2,gl+4,'',x,y,false);

  p:=1; bp:=1; p0:=p;
  if not edit then inc(gl,2);
  if edit then begin
    attrtxt(col.colsel2rahmen);
    mwrt(x,y+gl+1,''+dup(width,'')+'');
    t:='!';    { Buttons nur anzeigen }
    readbutt;
    end;

  aufbau:=true;
  setdefault:=(default<>'');
  maus_pushinside(x+1,x+width,y+1,y+gl);
  poutside:=false;
  startmkey:=(maust<>0);
  directsel:='';
  repeat
    while (p>1) and (drec[p]=0) do dec(p);
    if aufbau then display;
    if setdefault then begin
      setdefault:=false;
      dbSeek(d,1,default);
      if dbFound then display
      else begin
        dbGo(d,drec[1]);
        displine(1);
        end;
      end;
    empty:=(drec[1]=0);
    if not empty then begin
      while drec[p]=0 do dec(p);
      if p<>p0 then begin
        if drec[p0]>0 then begin
          dbGo(d,drec[p0]); displine(p0); end;
        dbGo(d,drec[p]); displine(p);
        p0:=p;
        end;
      end;
    if edit then begin
      t:='*';
      readbutt;
      bp:=abs(rb);
      end
    else begin
      gotoxy(x+length(directsel)+nameofs,y+p);
      get(t,curoff);
      end;
    if (t>=mausfirstkey) and (t<=mauslastkey) then
      maus_bearbeiten;
    c:=UpCase(t[1]);
    if not edit then
      _DirectSel
    else
      if rb>0 then
        case typ of
          1 : case rb of
                1 : NewBox;
                2 : if not empty then DelBox;
                3 : if not empty then SetDefaultBox;
                4 : if not empty then EditBox;
                5 : if not empty then EditNetztyp;
              end;
          2 : case rb of
                1 : NeueGruppe;
                2 : DelGruppe;
                3 : EditGruppe;
                4 : FidoGruppe;
              end;
          3 : case rb of
                1 : NeuesSystem;
                2 : DelSystem;
                3 : EditSystem;
              end;
          4 : case rb of
                1 : NeuesPseudo;
                2 : if not empty then DelPseudo;
                3 : if not empty then EditPseudo;
              end;
          5 : case rb of
                1 : EditMimetyp(true);
                2 : if not empty then DelMimetyp;
                3 : if not empty then EditMimetyp(false);
              end;
        end;
    if not empty and (not edit or (rb<0)) then begin
      if t=keyup then
        if p>1 then dec(p)
        else begin
          dbGo(d,drec[1]);
          dbSkip(d,-1);
          if not dbBOF(d) then aufbau:=true;
          end;
      if t=keydown then
        if p<gl then inc(p)
        else begin
          dbGo(d,drec[gl]);
          dbSkip(d,1);
          if not dbEOF(d) then begin
            dbGo(d,drec[2]); aufbau:=true;
            end;
          end;
      if t=keyhome then begin
        drec[1]:=0; aufbau:=true; p:=1;
        end;
      if t=keyend then
        if drec[gl]=0 then p:=gl
        else begin
          dbGoEnd(d);
          if not dbEOF(d) then begin
            dbSkip(d,-gl+1);
            if dbBOF(d) then dbGoTop(d);
            aufbau:=true; p:=gl;
            end;
          end;
      if t=keychom then p:=1;
      if t=keycend then p:=gl;
      if t=keypgup then begin
        dbGo(d,drec[1]);
        dbSkip(d,-1);
        if dbBOF(d) then p:=1
        else begin
          dbSkip(d,-gl+2);
          if dbBOF(d) then dbGoTop(d);
          aufbau:=true;
          end;
        end;
      if t=keypgdn then
        if drec[gl]=0 then p:=gl
        else begin
          dbGo(d,drec[gl]);
          dbSkip(d,1);
          if dbEOF(d) then p:=gl
          else begin
            dbGo(d,drec[gl]);
            aufbau:=true;
            end;
          end;
      if typ=2 then
        if t='+' then addhzeit(1)
        else if t='-' then addhzeit(-1);
      end;

  until (edit and ((rb=0) or (rb=okb))) or
        (not edit and ((t=keycr) or (t=keyesc)));
  maus_popinside;
  pophp;

  if edit then
    UniSel:=''
  else
    if empty or (t=keyesc) then UniSel:=''
    else begin
      dbGo(d,drec[p]);
      case typ of
        1   : UniSel:=dbReadStr(d,'boxname');
        2,3 : UniSel:=dbReadStr(d,'name');
        4   : UniSel:=dbReadStr(d,'kurzname');   { Dummy }
      end;
    end;


  if typ<>5 then begin
    dbClose(d);
    miscbase:=nil;
    end;
  closebox;
  if (typ = 1) and edit then
    askRTA (false,0);
end;

procedure get_first_box(d:DB);
var x,y  : byte;
    brk  : boolean;
    name : string[20];
    dname: string[8];
    user : string[80];
    maps : string[30];
    dom  : string[60];
    fqdom: string[60];
    email: string[80];
    ntyp : string[20];
    nt,b : byte;
    i    : integer;
label restart;
begin
restart:
  dialog(ival(getres2(911,0)),13,'',x,y);
  maddtext(3,2,getres2(911,1),col.coldiahigh);    { 'Bitte geben Sie Netztyp und Name Ihrer Stamm-' }
  maddtext(3,3,getres2(911,2),col.coldiahigh);    { 'box sowie Username bzw. eMail-Adresse ein.' }
  maddtext(3,5,getres2(911,3),col.coldiahigh);    { 'Bei Einsatz des Netztyps RFC/Client bentigen' }
  maddtext(3,6,getres2(911,4),col.coldiahigh);    { 'Sie einen externen Mail-/News-Client.' }
  name:=''; user:='';
  ntyp:=ntName(nt_Client); nt:=nt_Client;
  maddstring(3,8,getres2(911,5),ntyp,20,20,''); mhnr(681);   { 'Netztyp   ' }
  for i:=0 to enetztypen-1 do
    if (ntnr[i] in ntAllowed) then
      mappsel(true,ntName(ntnr[i]));
  mset3proc(gf_getntyp);
  maddstring(3,10,getres2(912,13),name,20,20,'>-_0123456789:/.'+range('A','Z')+'');
    mhnr(680);                                       { 'Server' bzw. 'Boxname' }
  DomainNt:=-1;
  msetvfunc(xp9_testbox);
  maddstring(3,12,getres2(912,12),user,30,80,'>'); mhnr(682);   { 'eMail-Adr.' bzw. 'Username' }
  userfield:=fieldpos;
  msetvfunc(notempty2);
  masksetstat(true,false,keyf2);    { <- zwingt zur korrekten Eingabe }
  readmask(brk);
  for i:=0 to enetztypen-1 do
    if lstr(ntyp)=lstr(ntName(ntnr[i])) then
      nt:=ntnr[i];
  closemask;
  closebox;
  email:='';

  dom:=ntDefaultDomain(nt);

  if (ustr(name)+'.CFG'=CfgFile) or
     (ustr(name)+'.CFG'=Cfg2File) or
     (ustr(name)+'.CFG'=Cfg3File) then begin
         rfehler(902);         { 'Ungltiger Boxname!' }
         goto restart;
  end;
 
  if nt = nt_Client then begin
    email:=user;
    if not is_mailaddress(email,true) then
    begin
      rfehler(908);
      goto restart;
      end
    else begin
      b := cpos('@', eMail);
      user:=left(email,b-1);
      dom:=mid(email,b);
      if cpos('.',dom)=0 then dom:=''
        else dom:=mid(dom,cpos('.',dom));
      end;
    end;

  user:=left(user,30);

  if not ntNameSpace(nt) then
    for i:=1 to length(user) do    { Leerzeichen aus Username -> "_" }
      if user[i]=' ' then user[i]:='_';
  DefaultBoxPar(nt,boxpar);      { neue Box mit Default-Werten anlegen }
  dbAppend(d);
  dbWrite(d,'netztyp',nt);
  dbWrite(d,'boxname',name);
  dbWrite(d,'username',user);
  dname:=getdname(nt,name);
  dbWrite(d,'dateiname',dname);
  maps:=DefaultMaps(nt);
  dbWrite(d,'NameOMaps',maps);

  dbWrite(d,'Domain',dom);
  fqdom:=''; dbWrite(d,'FQDN',fqdom);
  dbWrite(d,'EMail',email);
   case nt of
    nt_Maus   : boxpar^.pointname:=name;
    nt_Pronet : boxpar^.pointname:='01';
    else      if not nt = nt_Client then boxpar^.pointname:=''
              else
              begin
                b := cpos('@', eMail);
                boxpar^.pointname:=mid(email,b+1);
                truncstr(boxpar^.pointname,min(25,cposx('.',boxpar^.pointname)-1));
              end;
    end;
  dbWrite(d,'Pointname',boxpar^.pointname);
  dbFlushClose(d);
  boxpar^.boxname:=name;
  boxpar^.username:=user;
  boxpar^._Domain:=dom;
  if (nt=nt_UUCP) and exist('UUCP.SCR') then
    boxpar^.script:='UUCP.SCR';
  if (nt=nt_Client) then boxpar^.ReplaceOwn:=true;
  WriteBox(dname,boxpar);
  DefaultBox:=name;
  if nt=nt_Fido then begin
    DefFidobox:=name;
    SetDefZoneNet;
    end;
  SaveConfig2;
  if (nt=nt_UUCP) or (nt=nt_Client) then begin
    UserSlash:=false;
    NewsgroupDisp:=true;
    NewsgroupDispall:=true;
    SaveConfig;
    end;
  pushkey('e');
  if nt=nt_Client then pushkey('c') else pushkey('p');
  if UniSel(1,true,'')='' then;
  end;
end.
