{ ------------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.                   }
{ (c) 1991-1999 Peter Mandrella                                       }
{ (c) 2000-2001 OpenXP-Team                                           }
{ (c) 2002-2026 FreeXP, http://www.freexp.de                          }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.         }
{                                                                     }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der     }
{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html }
{ ------------------------------------------------------------------- }

{ CrossPoint - StartUp }

{$I XPDEFINE.INC}
{$O+,F+}

unit xp2;

interface

uses crt, xpcfg,
     dos,dosx,typeform,fileio,keys,inout,winxp,mouse,datadef,database,
     databaso,maske,video,help,printerx,lister,win2,maus2,crc,clip,
     resource,montage, xpglobal, xp0,xp1,xp10,xp1o2,xp1input,
     xp1help,xp5,xpdatum,lfn;


procedure read_regkey;   { registriert? }
procedure test_pfade;
procedure test_defaultbox;
procedure test_defaultgruppen;
procedure test_systeme;
procedure testdiskspace;
procedure testfilehandles;
procedure TestAutostart;

implementation  {-----------------------------------------------------}

uses
  xp2x,xp2b,xp1o,xpe,xp3,xp9bp,xp9,xpnt,xpfido,xpkeys,xpreg,xpovl,hashfile;

procedure test_pfade;
var   res  : integer;

  procedure TestDir(d:string);
  begin
    if not IsPath(ownpath+d) then begin
      mkdir(ownpath+left(d,length(d)-1));
      if ioresult<>0 then
        interr(reps(getres(203),left(d,length(d)-1))+#7);   { 'Fehler: Kann %s-Verzeichnis nicht anlegen!' }
      end;
  end;

  procedure TestDir2(d:string);
  begin
    if not IsPath(d) and XPFirstStart then
    begin
      mkdir(left(d,length(d)-1));
      if ioresult<>0 then
        interr(reps(getres(203),left(d,length(d)-1))+#7);   { 'Fehler: Kann %s-Verzeichnis nicht anlegen!' }
      end;
  end;

  procedure SetPath(var pathp:pathptr; var oldpath:pathstr);
  begin
    getmem(pathp,length(oldpath)+1);
    pathp^:=oldpath;
    oldpath:=OwnPath;
  end;

begin
  TestDir2(logpath);
  TestDir2(temppath);
  TestDir2(extractpath);
  TestDir2(sendpath);
  if logpath='' then logpath:=ownpath
  else
    if not IsPath(logpath) then
    begin
      logpath:=ownpath;
      trfehler(204,60);  { 'ungltiges Logfileverzeichnis' }
    end;
  if temppath='' then temppath:=ownpath
  else
    if not IsPath(temppath) then
    begin
      temppath:=ownpath;
      trfehler(201,60);   { 'ungltiges Temporr-Verzeichnis eingestellt' }
      end;
  if extractpath='' then extractpath:=OwnPath
  else
    if not IsPath(extractpath) then
    begin
      extractpath:=OwnPath;
      trfehler(202,60);   { 'ungltiges Extrakt-Verzeichnis eingestellt' }
      end;
  if sendpath='' then sendpath:=ownpath
  else
    if not IsPath(sendpath) then
    begin
      sendpath:=ownpath;
      trfehler(203,60);   { 'ungltiges Sendeverzeichnis' }
      end;
  editname:=sendpath+WildCard;
  TestDir(XFerDir);
  TestDir(JanusDir);
  TestDir(FidoDir);
  TestDir(AutoxDir);
  TestDir(BadDir);
  if not IsPath(filepath) then begin
    MkLongdir(filepath,res);
    if res<>0 then begin
      filepath:=OwnPath+InfileDir;
      TestDir(InfileDir);
      end;
    end;
end;


{ Stammbox anlegen, falls noch nicht vorhanden }

procedure test_defaultbox;
var d    : DB;
    dname: string[8];
begin
{$IFDEF Debug }
  dbLog('-- Boxen berprfen');
{$ENDIF }
  dbOpen(d,BoxenFile,1);
  dbSeek(d,boiName,ustr(DefaultBox));
  if not dbFound then begin
    if dbRecCount(d)=0 then begin
      xp9.get_first_box(d);
      dbRead(d,'dateiname',dname);
      end
    else begin
      dbGoTop(d);
      dbRead(d,'boxname',DefaultBox);
      dbRead(d,'dateiname',dname);
      end;
    SaveConfig;
    end
  else
    dbRead(d,'Dateiname',dname);
  if not exist(OwnPath+dname+BfgExt) then begin
    DefaultBoxPar(nt_Netcall,boxpar);
    WriteBox(dname,boxpar);
    end;
  if deffidobox<>'' then begin
    dbSeek(d,boiName,deffidobox);
    if not dbFound then deffidobox:=''
    else HighlightName:=ustr(dbReadStr(d,'username'));
    if deffidobox<>'' then SetDefZoneNet;
    end;
  dbClose(d);  
end;


{ Testen, ob die 3 Default-Brettgruppen vorhanden sind }

procedure test_defaultgruppen;
var d     : DB;

  procedure AppGruppe(name:string; limit:longint; halten:integer16;
                      var grnr:longint);
  const b : byte = 1;
  var   s : string[8];
  begin
    dbAppend(d);
    dbWrite(d,'name',name);
    dbWrite(d,'haltezeit',halten);
    dbWrite(d,'msglimit',limit);
    dbWrite(d,'flags',b);
    s:='header';   dbWrite(d,'kopf',s);
    s:='signatur'; dbWrite(d,'signatur',s);
    dbRead(d,'INT_NR',grnr);
  end;

  procedure getGrNr(name:string; var grnr:longint);
  begin
    dbSeek(d,giName,ustr(name));
    if not dbFound then interr(getres(204));  { 'fehlerhafte Gruppendatei!' }
    dbRead(d,'INT_NR',grnr);
  end;

(*  procedure WriteFido;
  var b : byte;
      s : string[8];
  begin
    b:=4;  dbWrite(d,'flags',b);     { Re^n = N }
    b:=1;  dbWrite(d,'umlaute',b);   { ASCII    }
    s:=''; dbWrite(d,'signatur',s);  { keine Sig. }
  end; *)

begin
{$IFDEF Debug }
  dbLog('-- Gruppen berprfen');
{$ENDIF }
  dbOpen(d,GruppenFile,1);
  if dbEOF(d) then begin
    AppGruppe('Intern',0,0,IntGruppe);
    AppGruppe('Lokal',0,stdhaltezeit,LocGruppe);
    AppGruppe('Netz',maxnetmsgs,stdhaltezeit,NetzGruppe);
    { AppGruppe('Fido',8192,stdhaltezeit,dummy);
      WriteFido; }
    end
  else begin
    getGrNr('Intern',IntGruppe);
    getGrNr('Lokal',LocGruppe);
    getGrNr('Netz',NetzGruppe);
    end;
  dbCLose(d);
end;


procedure test_systeme;
var d : DB;
    s : string[30];
begin
{$IFDEF Debug }
  dbLog('-- Systeme berprfen');
{$ENDIF }
  dbOpen(d,SystemFile,1);
  if dbRecCount(d)=0 then begin
    dbAppend(d);
    s:='SYSTEM';
    dbWrite(d,'name',s);
    end;
  dbClose(d);
end;


procedure testdiskspace;
var free : longint;
    x,y  : byte;
begin
  if ParNomem then exit;
{$IFDEF Debug }
  dbLog('-- Plattenplatz testen');
{$ENDIF }
  free:=disk_free(0);
  if free<200000 then free:=0;
  if free=0 then
  begin
    exitscreen(0);
    writeln(getreps(205,left(OwnPath,2)));   { 'Fehler: zu wenig freier Speicher auf Laufwerk %s !' }
    writeln;
    errsound; delay(60); errsound; delay(60); errsound;
    runerror:=false;
    halt(1);
  end
  {$IFNDEF NO386}
  else if iifb(xp_ntvdm_ok,free<MinMB,free div $100000<MinMB) then
  {$ELSE}
  else if free div $100000<MinMB then
  {$ENDIF}
  begin
    msgbox(51,8,'',x,y);
    moff;
    {$IFNDEF NO386}
    if not xp_ntvdm_ok then free:=free div $100000;
    {$ELSE}
    free:=free div $100000;
    {$ENDIF}
    wrt(x+3,y+1,getres2(206,1));   { 'WARNUNG!' }
    wrt(x+3,y+3,reps(getres2(206,2),trim(strsrn(free,0,1))));  { 'Es sind nur noch %s MB freier Speicherplatz' }
    wrt(x+3,y+4,reps(getres2(206,3),left(ownpath,2)));         { 'auf Laufwerk %s vorhanden! '}
    wrt(x+3,y+6,getres(12));   { 'Taste drcken ...' }
    freeres;
    mon;
    errsound; delay(60); errsound; delay(60); errsound;
    inout.cursor(curon);
    DisableDOS:=true;
    wkey(30,false);
    DisableDOS:=false;
    inout.cursor(curoff);
    closebox;
  end;     
end;

procedure savehandles;
var i,a,b : byte;

begin
   a:=0;
   b:=0;
   for i:=1 to 255 do
   begin
     if handles[i]=$ff then a:=a+1;
     if ((a=needfiles) and (b=0)) then b:=i;
     if ((b>=needfiles) and (handles[i]<>$ff)) then b:=i;
   end;
   MemW[PrefixSeg:$32] := b;
end; 

procedure testfilehandles;
var f,nf,lcol,x,y,i : byte;
    s1,s2,s3,tesf   : string[80];
    w1,w2           : word;
const test='CABDEFGHIJKLMNOPQRSTUVWXYZ';

begin
 {$IFNDEF NO386}
 if NOT DOSBOX then begin
 {$ELSE}
 if 1=1 then begin
 {$ENDIF}
  s1:='';
  s2:='';
  s3:='';
  f:=FreeFILES((needfiles+needreserve));
  if f<(needfiles+needreserve) then begin
    nf:=((ConfigFILES+((needfiles+needreserve)-f)+4)div 5)*5;
    s1:=getres2(10000+100*(223 div 100),223 mod 100);
    truncstr(s1,screenwidth-4);
    {$IFNDEF NO386}
    if WinVersion=4 then
       {Windows NT/2000/XP}
       s2:=getenv('SYSTEMROOT')+'\SYSTEM32\CONFIG.NT'
    else if ((WinVersion=3) and (lo(dosversion)=8)) then
       begin
         {Sonderfall WinME}
         s1:=getres2(10000+100*(225 div 100),225 mod 100);
         truncstr(s1,screenwidth-4);
         s2:=getreps2(10000+100*(226 div 100),226 mod 100,strs(nf));
         truncstr(s2,screenwidth-4);
         s3:=getres2(10000+100*(227 div 100),227 mod 100);
         truncstr(s3,screenwidth-4);
       end
    else {$ENDIF}begin    
      s2:=getenv('ComSpec');
      s2:=Copy(s2,1,3)+'CONFIG.SYS';
      if existrf(s2) then s2:=s2 else begin
        s2:='';
        tesf:=test;
        for i:=1 to 26 do begin
          if s2='' then begin           
            s2:=tesf[i]+':\CONFIG.SYS';
            if not existrf(s2) then s2:='';                    
          end;
        end;
        if s2='' then s2:='CONFIG.SYS';      
      end;
    end;
    truncstr(s2,screenwidth-4);
    if s3='' then begin
      s3:=getreps2(10000+100*(224 div 100),224 mod 100,strs(nf));
      truncstr(s3,screenwidth-4);
    end;
    savecursor; lcol:=textattr;
    w1:=windmin; w2:=windmax;
    window(1,1,80,25);
    pushhp(20223);
    msgbox(max(length(s1),max(length(s2),length(s3)))+6,7,_fehler_,x,y);
    mwrt(x+3,y+2,left(s1,screenwidth-6));
    mwrt(x+3,y+3,left(s2,screenwidth-6));
    mwrt(x+3,y+4,left(s3,screenwidth-6));    
    errsound;
    wait(curoff);
    closebox;
    pophp;
    windmin:=w1; windmax:=w2;
    restcursor;
    attrtxt(lcol);
    runerror:=false;
    exitscreen(0);
    halt(1);
    end;
  savehandles;
 {$IFNDEF NO386}
 end
 else begin
  {Unter DOSBOX geht der Standardtest auf oeffnen von nul schief.}
  {Ein spezieller Test fuer DOSBOX eruebrigt sich, da DOSBOX}
  {immer genuegend FILES bereitstellt (FILES=100)}
 {$ENDIF}
 end;
end;

procedure read_regkey;
var t   : text;
    s   : string[20];
    p   : byte;
    l1,l2,l3 : integer32;
    l   : integer32;
    code: integer32;

  procedure freereg;
  begin
    with registriert do
    begin
      nr:=0;
      tc:='F';        { Freeware-"Key" }
      komreg:=false;
      orgreg:=false;
    end;
  end;

begin
  freereg;
  assign(t,regdat);
  if existf(t) then
  begin
    reset(t);
    readln(t,s);
    s:=trim(s);
    close(t);
    if firstchar(s)='!' then
    begin
      registriert.komreg:=true;
      registriert.orgreg:=true;
      delfirst(s);
    end;
    p:=cpos('-',s);
    if p>0 then
    begin
      if s[1] in ['A','B','C'] then
      begin
        registriert.tc:=s[1]; delete(s,1,1); dec(p);
      end
      else
        registriert.tc:='A';
      l:=ival(left(s,p-1));              { lfd. Nummer }
      if ((l>=4001) and (l<=4009)) or
         (l=800) or                      { Key in Cracker-Box aufgetaucht }
         (l=4088) or                     { Key auf CD-ROM aufgetaucht     }
         (l=4266) or (l=4333) or         { storniert                      }
         (l=8113) or                     { Key in CCC.GER verffentlicht  }
         (l=6323) or                     { Key in Cracker-Kreisen aufgetaucht }
         (l=101) or                      { Key im Usenet aufgetaucht }
         (l=0) or (l=11232) or (l=12345) or (l=23435) or (l=32164) or
         (l=33110) or (l=34521) or (l=54321) or (l=12034) then   { Hacks }
        l:=0;
      registriert.nr:=l;
      l1:=CRC16strXP(reverse(hex(l+11,4))); l1:=l1 xor (l1 shl 4);

      { Registrierungsbug plattformunabhngig emulieren }
      { 10923 * 3 ist grer als maxint (32767) }
      if l<10923 then
        l2:=CRC16strXP(reverse(hex(l*3,5)))
      else
        l2:=CRC16strXP(reverse(hex(l*3-65536,5)));

      l2:=l2 xor (l2*37);
      l3:=l1 xor l2 xor CRC16strXP(reverse(strs(l)));
      delete(s,1,p);
      p:=cpos('-',s); if p=0 then p:=length(s)+1;
      code:=ival(left(s,p-1));                { -Code }
      if registriert.nr=0 then code:=-1;
      delete(s,1,p);
      case registriert.tc of
        'A' : if code<>l1 then freereg;
        'C' : if code<>l3 then freereg;
        'B' : if code<>l2 then freereg;
      end;
      with registriert do
      begin
        komreg:=komreg and IsKomCode(nr);
        orgreg:=orgreg and IsOrgCode(nr);
      end;
    end;
  end;
end;

procedure TestAutostart;
var p   : byte;
    f,t : string[5];
    min : word;
begin
  p:=cpos('-',ParAutost);
  if p=0 then exit;
  min:=ival(left(ParAutost,p-1));
  f:=formi(min div 100,2)+':'+formi(min mod 100,2)+':00';
  min:=ival(mid(ParAutost,p+1));
  t:=formi(min div 100,2)+':'+formi(min mod 100,2)+':59';
  if f<t then
    quit:=quit or (time<f) or (time>t)
  else
    quit:=quit or ((f>time) and (t<time));
end;

end.
