{ ------------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.                   }
{ (c) 1991-1999 Peter Mandrella                                       }
{ (c) 2000-2001 OpenXP-Team                                           }
{ (c) 2002-2024 FreeXP, http://www.freexp.de                          }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.         }
{                                                                     }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der     }
{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html }
{ ------------------------------------------------------------------- }

{ CrossPoint - Deklarationen }

{$I XPDEFINE.INC}

unit xp0;

interface

uses   dos,typeform,keys,xpglobal,lfn;

const  {$IFDEF DPMI}
       IsDPMI      = true;
       {$ELSE}
       IsDPMI      = false;
       {$ENDIF}

       LangVersion = '15';           { Version des Sprachmoduls }
       DLLVersion  = 6;              { Revision der XP_NTVDM.DLL }
                                     { 1 = Urversion }
                                     { 2 = mit Diskfree/Disksize }
                                     { 3 = ConsoleTitle }
                                     { 4 = Korrekturversion }
                                     { 5 = Windows 10/11 }
                                     { 6 = Read Reg for Windows 10/11 }
       needfiles   = 30;             { Ben tigte Filehandles durch XP           }
       needreserve = 10;             { Um den Aufruf von externen Programmen    }
                                     { sicherzustellen, wird auf 10 zus tzliche }
                                     { getestet!!                               }
       menus       = 43;             { Anzahl der Menus (+1 wegen Zusatzmenueerweiterung) }
       ZeilenMenue = 11;
       maxbmark    = 1000;           { maximal markierbare User/Bretter }
       maxmarklist = 5000;           { MK: Maximale Anzahl markierter Msgs }
       QuoteLen    = 5;              { maximale QuoteChar-L nge }
       Ablagen     = 20;             { 0..9 }
       maxpmc      = 3;              { installierbare pmCrypt-Verfahren }
       MaxSigsize  = 300;            { maximale Signaturgr  e (Bytes) }
       maxkeys     = 100;            { s. auch XP10.maxentries }
       excludes    = 4;              { Anzahl Ausschlu zeiten  }
       maxskeys    = 15;             { max. Tasten in Zeile 2  }
       mausdefx    = 620;            { Maus-Startposition      }
       mausdefy    = 28;
       MaxNodelists = 100;
       MaxAKAs     = 10;
       MaxBadConfigLines = 50;       { Maximale Zahl der unbekannten Config-Zeilen }
       maxviewers  = 7;
       defviewers  = 3;
       maxpmlimits = 6;              { Z/Maus/Fido/UUCP/Magic/QMGS     }
       maxheaderlines = 40;
       MaxXposts   = 15;
       MaxCom      = 5;

       BoxNameLen  = 20;             { diese L ngenangaben sollten f r }
       BoxRealLen  = 15;             { alle Bearbeitungs-Variablen f r }
       BrettLen    = 81;             { die entsprechenden Felder ver-  }
       eBrettLen   = 79;             { wendet werden                   }
       AdrLen      = 80;
       eAdrLen     = 79;
       BetreffLen  = 248;
       DateLen     = 11;
       midlen      = 160;
       AKAlen      = 127;
       OrgLen      = 80;             { Organisation }
       PostadrLen  = 80;             { Postadresse }
       TeleLen     = 100;            { Telefon }
       HomepageLen = 90;             { WWW-Homepage }
       CustHeadLen = 60;             { Customizable Header-Lines }
       hdErrLen    = 60;
       ViewprogLen = 70;             { Kommandozeile f r ext. Viewer }
       ResMinmem   = 340000;
       realnlen = 120;               { L nge der Realnames }
{       AutoDatumsBezuege : boolean = false; } {unn tig seit Fix von jg in XP3O2.PAS und XP4.PAS (2001/05/23 und 2001/06/10) }
       MsgFelderMax = 6;             { max. Feldzahl in der Nachrichtenliste }
       UsrFelderMax = 6;             { max. Feldzahl in der Userliste }
          FelderMax = 6;             { groesste der beiden Feldanzahlen }

       QPC_ID      = 'QPC:';
       DES_ID      = 'DES:';
       PMC_ID      = '*crypted*';
       XPMC_ID     = '*Xcrypted*';
       TO_ID       = '/'#0#0#8#8'TO:';
       TO_len      = length(TO_ID);
       vert_char   = #4;             { Verteiler-Kennung }
       MausinfoBrett= '$/ Mausinfo';
       uuserver    = 'UUCP-Fileserver';

       ValidDirCh  = '>ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789\()[]{}!"$%&_-.:,;#~;=';

       PufferFile  = 'PUFFER';        { Z-Netz-Puffer }
       XFerDir_    = 'SPOOL';         { eingehende Mailbatches }
       XFerDir     = XFerDir_+DirSepa;
       JanusDir_   = XFerDir+'JANUS';
       JanusDir    = JanusDir_+DirSepa;
       FidoDir_    = 'FIDO';
       FidoDir     = FidoDir_+DirSepa;{ Nodelists }
       InfileDir   = 'FILES'+DirSepa; { Default: Filerequests }
       AutoxDir    = 'AUTOEXEC'+DirSepa;    { AutoStart-Daten }
       BadDir      = 'BAD'+DirSepa;

       HeaderFile  = 'HEADER.XPS';     { Schablonen-Dateien }
       HeaderPriv  = 'PRIVHEAD.XPS';
       SignatFile  = 'SIGNATUR.XPS';
       PrivSignat  = 'PRIVSIG.XPS';
       QuoteMsk    = 'QBRETT.XPS';
       QuotePriv   = 'QPRIV.XPS';
       QuotePMpriv = 'QPMPRIV.XPS';
       QuoteToMsk  = 'QUOTETO.XPS';
       WeiterMsk   = 'WEITER.XPS';
       ErneutMsk   = 'ERNEUT.XPS';
       EB_Msk      = 'EMPFBEST.XPS';
       CancelMsk   = 'CANCEL.XPS';

       BfgExt      = '.BFG';           { Boxen-Config-File }
       QfgExt      = '.QFG';           { QWK-Config-File   }
       SwapExt     = '.SWP';
       BatchExt    = '.BAT';

       MsgFile     = 'MSGS';           { DB1-Dateinamen }
       BrettFile   = 'BRETTER';
       UserFile    = 'USER';
       BoxenFile   = 'BOXEN';
       GruppenFile = 'GRUPPEN';
       SystemFile  = 'SYSTEME';
       DupeFile    = 'DUPEKILL';       { tempor r in XP4O.DupeKill }
       AutoFile    = 'AUTOMSG';
       PseudoFile  = 'PSEUDOS';
       BezugFile   = 'BEZUEGE';
       MimetFile   = 'MIMETYP';

       CfgFile     = 'XPOINT.CFG';     { verschiedene Dateien }
       Cfg2File    = 'XPOINT2.CFG';
       Cfg3File    = 'OPENXP.CFG';      { NEue cfg mit Sektionen }
       ColCfgfile  = 'XPOINT.COL';
       NewDateFile = 'NEUES.DAT';
       MsgTempFile = 'MSG.TMP';
       AblagenFile = 'MPUFFER.';
       UncryptedFile = 'CRYPT.MSG';
       CryptedFile = 'CRYPT.ENC';
       TimingFile  = 'TIMING.';
       TimingDat   = 'TIMING.DAT';
       KilledDat   = 'REORG.DAT';
       CCfile      = 'VERTEIL.DAT';
       FidoCfg     = 'FIDO.CFG';
       OldNLCfg    = FidoDir+'NODELIST.CFG';
       NodelistCfg = FidoDir+'NODELST.CFG';
       NodeindexF  = FidoDir+'NODELIST.IDX';
       UserindexF  = FidoDir+'NODEUSER.IDX';
       ARCmailDat  = 'ARCMAIL.DAT';
       FileLists   = FidoDir+'FILELIST.CFG';
       ReqDat      = 'REQUEST.DAT';    { Crashs + Requests }
       RegDat      = 'REGDAT.XP';
       UUnumdat    = 'UUNUMMER.DAT';
       FeierDat    = 'FEIERTAG.DAT';
       PGPkeyfile  = 'PGP-KEY.BIN';
       menufile    = 'XPMENU.DAT';
       CrashTemp   = 'CRASH.TMP';

       ErrlogFile  = 'ERRORS.LOG';     { LogFiles }
       Logfile     = 'XPOINT.LOG';
       BiLogFile   = 'LOGFILE';        { f r BiModem- bertragung }
       BrettlogFile= 'BRETTER.LOG';    { automatisch angelegte Bretter }
       UserlogFile = 'USER.LOG';       { automatisch angelegte User }
       DupeLogfile = 'DUPES.LOG';      { s. XP4.DupeKill }
       MausLogfile = 'MAUS.LOG';       { MAGGI: MausTausch-Logfile }
       MausPmLog   = 'MAUSPM.LOG';     { MAGGI: MausTausch-PM-Logfile }
       MausStLog   = 'MAUSSTAT.LOG';   { MAGGI: MausTausch-Nachrichtenstati }
       FidoLog     = 'XPFIDO.LOG';     { XP-FM-Logfile   }
       UUCPlog     = 'XPUUCP.LOG';     { uucico-Logfile  }
       ClientLog   = 'XPCLIENT.LOG';   { Client-Logfile  }
       ScerrLog    = 'SCERRORS.LOG';   { Script-Fehler   }
       NetcallLog  = 'NETCALL.LOG';    { Netcall-Logfile }

       TempBatchFN = 'TMP.BAT';        { Temp. Batchdatei (siehe fileio) }

                                       { Namen der Exe-Dateien }
       MaggiBin         = 'MAGGI.EXE';
       UUCICOBin        = 'UUCICO.EXE';
       UUZBin           = 'UUZ.EXE';
       Yup2PktBin       = 'YUP2PKT.EXE';
       ZFidoBin         = 'ZFIDO.EXE';
       ZQWKBin          = 'ZQWK.EXE';

       miBrett     = 1;                { BRETTNAME/EMPFDATUM/INT_NR         }
       miGelesen   = 2;                { BRETTNAME/GELESEN/EMPFDATUM/INT_NR }
       uiName      = 1;                { User:    +USERNAME                 }
       uiAdrbuch   = 2;                {          ADRBUCH/+USERNAME         }
       uiBoxName   = 3;                {          POLLBOX/+USERNAME         }
       uiBoxAdrbuch= 4;                {          ADRBUCH/POLLBOX/+USERNAME }
       biBrett     = 1;                { Bretter: BRETTNAME                 }
       biGruppe    = 2;                {          GRUPPE                    }
       biIntnr     = 3;                {          INT_NR                    }
       biIndex     = 4;                {          INDEX                     }
       giName      = 1;                { Gruppen: +NAME                     }
       giIntnr     = 2;                {          INT_NR                    }
       boiName     = 1;                { Boxen:   +BOXNAME                  }
       boiDatei    = 2;                {          +DATEINAME                }
       siName      = 1;                { Systeme: +NAME                     }
       aiBetreff   = 1;                { AutoMsg: +BETREFF                  }
       piKurzname  = 1;                { Pseudos: +KURZNAME                 }
       beiMsgID    = 1;                { Bezuege: MsgID                     }
       beiRef      = 2;                {          Ref                       }
       mtiTyp      = 1;                { MimeType: +TYP                     }
       mtiExt      = 2;                {           +EXTENSION               }

       rmUngelesen = 1;                { ReadMode: Lesen/Ungelesen  }
       rmNeues     = 2;                { ReadMode: Lesen/Neues      }
       rmHeute     = 3;                { ReadMode: Lesen/Heute      }

       MaxHdsize   = 2000;             { maximal *erzeugte* Headergr  e }

       AttrQPC     = $0001;            { QPC-codierte Nachricht     }
       AttrCrash   = $0002;            { header.attrib: Crashmail   }
       AttrPmcrypt = $0004;            { pmCrypt-codierte Nachricht }
       AttrIgate   = $0008;            { IGATE.EXE-Nachricht        }
       AttrFile    = $0010;            { File attached              }
       AttrControl = $0020;            { Cancel-Nachricht           }
       AttrMPbin   = $0040;            { Multipart-Binary           }
       AttrPmReply = $0100;            { PM-Reply auf AM (Maus/RFC) }
       AttrQuoteTo = $0400;            { QuoteTo (Maus)             }
       AttrReqEB   = $1000;            { EB anfordern               }
       AttrIsEB    = $2000;            { EB                         }

       fPGP_encoded  = $0001;          { Nachricht ist PGP-codiert  }
       fPGP_avail    = $0002;          { PGP-Key vorhanden          }
       fPGP_signed   = $0004;          { Nachricht ist mit PGP sign.}
       fPGP_clearsig = $0008;          { Clear-Signatur             }
       fPGP_sigok    = $0010;          { Signatur war ok            }
       fPGP_sigerr   = $0020;          { Signatur war fehlerhaft    }
       fPGP_please   = $0040;          { Verifikations-Anforderung  }
       fPGP_request  = $0080;          { Key-Request                }
       fPGP_haskey   = $0100;          { Nachricht enth lt PGP-Key  }
       fPGP_comprom  = $0200;          { Nachricht enth lt compromise }

       fattrHalten   = $0001;          { Nachricht auf "halten"     }
       fattrLoeschen = $0002;          { Nachricht auf "l schen"    }
       fattrGelesen  = $0004;          { Nachricht auf "gelesen"    }
       fattrHilite   = $0008;          { Nachricht hervorheben      }

       kommlmax   = 6;                             { Kommentarbaum }
       kommemax   = kommlmax * 16 + 1;       { maximale Tiefe }
       maxkomm    = 65520 div (6 + kommlmax * 2); { max. Nachr. }
       kflLast    = 1;
       kflBetr    = 2;
       kflPM      = 4;
       kflBrett   = 8;                 { Brettwechsel }

       hdf_Trenn  = 0;                 { Nummern f r Header-Felder }
       hdf_EMP    = 1;
       hdf_ABS    = 2;
       hdf_BET    = 3;        hdf_OAB     = 13;     hdf_TEL      = 23;
       hdf_EDA    = 4;        hdf_OEM     = 14;     hdf_MSTAT    = 24;
       hdf_ROT    = 5;        hdf_WAB     = 15;     hdf_KOP      = 25;
       hdf_MID    = 6;        hdf_ERR     = 16;     hdf_PGPSTAT  = 26;
       hdf_LEN    = 7;        hdf_ANTW    = 17;     hdf_Homepage = 27;
       hdf_BEZ    = 8;        hdf_DISK    = 18;     hdf_Part     = 28;
       hdf_MAILER = 9;        hdf_STW     = 19;     hdf_Priority = 31; {!MH:}
       hdf_FILE   = 10;       hdf_ZUSF    = 20;     hdf_xNoArchive = 32; {!MH:}
       hdf_STAT   = 11;       hdf_DIST    = 21;
       hdf_ORG    = 12;       hdf_POST    = 22;
       hdf_Cust1  = 29;
       hdf_Cust2  = 30;
       hdf_ersetzt = 33;
       hdf_control = 34;

type   textp  = ^text;
       ColArr = array[0..3] of byte;
       ColQArr= array[1..9] of byte;
       ColRec = record
                  ColMenu       : ColArr; { Normaler Men text       }
                  ColMenuHigh   : ColArr; { Direkt-Buchstaben       }
                  ColMenuInv    : ColArr; { Men -Balken             }
                  ColMenuInvHi  : ColArr; { Men -Balken/Buchstabe   }
                  ColMenuDis    : ColArr; { Men  disabled           }
                  ColMenuSelDis : ColArr; { Men  disabled/gew hlt   }
                  ColKeys       : byte;   { Direkttasten            }
                  ColKeysHigh   : byte;   { Direkttasten-Buchstaben }
                  ColKeysAct    : byte;   { aktivierte Taste        }
                  ColKeysActHi  : byte;   { aktivierter Buchstabe   }
                  ColTLine      : byte;   { Trennlinie              }
                  ColBretter    : byte;   { User / Bretter          }
                  ColBretterInv : byte;   { User / Bretter, gew hlt }
                  ColBretterHi  : byte;   { User / Bretter, markiert}
                  ColBretterTr  : byte;   { Trennzeile              }
                  ColMsgs       : byte;   { Msgs                    }
                  ColMsgsHigh   : byte;   { Msgs, markiert          }
                  ColMsgsInv    : byte;   { Msgs, gew hlt           }
                  ColMsgsInfo   : byte;   { Msgs, 1. Zeile          }
                  ColMsgsUser   : byte;   { PM-archivierte Msgs     }
                  ColMsgsInvUser: byte;   { gew hlt+hervorgehoben   }
                  ColMsgsPrio1  : byte;   { Farbe fuer Priority 1   }
                  ColMsgsPrio2  : byte;   { ... 2 }
                  ColMsgsPrio4  : byte;   { ... 4 }
                  ColMsgsPrio5  : byte;   { ... 5 }
                  ColMbox       : byte;   { Meldungs-Box, Text      }
                  ColMboxRahmen : byte;   { Meldungs-Box, Rahmen    }
                  ColMboxHigh   : byte;   { Meldungs-Box, hervorgeh.}
                  ColDialog     : byte;   { Dialoge, Feldnamen u. . }
                  ColDiaRahmen  : byte;   { Dialogbox, Rahmen       }
                  ColDiaHigh    : byte;   { Dialogbox, hervorgeh.T. }
                  ColDiaInp     : byte;   { Dialogbox, Eingabefeld  }
                  ColDiaMarked  : byte;   { Dial., markierter Text  }
                  ColDiaArrows  : byte;   { Pfeile bei Scrollfeldern}
                  ColDiaSel     : byte;   { Masken-Auswahlliste     }
                  ColDiaSelBar  : byte;   {            "            }
                  ColDiaButtons : byte;   { Check/Radio-Buttons     }
                  ColSelbox     : byte;   { Auswahlbox              }
                  ColSelRahmen  : byte;   { Auswahlbox, Rahmen      }
                  ColSelHigh    : byte;   { Auswahlbox, hervorgeh.  }
                  ColSelBar     : byte;   { Auswahlbox, Balken      }
                  ColSelBarHigh : byte;   { Auswahlbox, Balken/hv.  }
                  ColSel2box    : byte;   { Auswahlbox / dunkel     }
                  ColSel2Rahmen : byte;   { Auswahlbox, Rahmen      }
                  ColSel2High   : byte;   { Auswahlbox, hervorgeh.  }
                  ColSel2Bar    : byte;   { Auswahlbox, Balken      }
                  ColButton     : byte;   { Button                  }
                  ColButtonHigh : byte;   { Button - Hotkeys        }
                  ColButtonArr  : byte;   { aktiver Button: Pfeile  }
                  ColUtility    : byte;   { Kalender u. .           }
                  ColUtiHigh    : byte;
                  ColUtiInv     : byte;
                  ColHelp       : byte;   { Hilfe normal            }
                  ColHelpHigh   : byte;   { hervorgehobener Text    }
                  ColHelpQVW    : byte;   { Querverweis             }
                  ColHelpSlQVW  : byte;   { gew hlter Querverweis   }
                  ColListText   : byte;   { Lister, normaler Text   }
                  ColListMarked : byte;   { Lister, markiert        }
                  ColListSelbar : byte;   { Lister, Auswahlbalken   }
                  ColListFound  : byte;   { Lister, nach Suche mark.}
                  ColListStatus : byte;   { Lister, Statuszeile     }
                  ColListQuote  : ColQArr; { Quote-Zeilen + Maps"J" }
                  ColListScroll : byte;   { vertikaler Scroller     }
                  ColListHeader : byte;   { Nachrichtenkopf         }
                  ColListHeaderhigh : byte; { Nachrichtenkopf hervorgehobene Msg}
                  ColListHigh   : byte;   { *hervorgehoben*         }
                  ColListQHigh  : ColQArr; { Quote / *hervorgehoben* }
                  ColEditText   : byte;   { Editor, normaler Text   }
                  ColEditStatus : byte;   { Editor, Statuszeile     }
                  ColEditMarked : byte;   { Editor, markierter Blck.}
                  ColEditMessage: byte;   { Editor-Meldung          }
                  ColEditHead   : byte;   { TED: Info-Kopf          }
                  ColEditQuote  : ColQArr; { TED: farbige Quotes     }
                  ColEditEndmark: byte;   { TED: Endmarkierung      }
                  ColEditMenu   : byte;   { TED: Men                }
                  ColEditMenuHi : byte;   { TED: Hotkey             }
                  ColEditMenuInv: byte;   { TED: Selbar             }
                  ColEditHiInv  : byte;   { TED: gew hlter Hotkey   }
                  ColArcStat    : byte;   { Status-Zeile ArcViewer  }
                  ColMapsBest   : byte;   { bestellte Bretter       }
                  ColMailer     : byte;   { Fido-Mailer/uucico      }
                  ColMailerhigh : byte;   { .. hervorgehoben #1     }
                  ColMailerhi2  : byte;   { .. hervorgehoben #2     }
                  ColBorder     : byte;   { Rahmenfarbe             }
                end;

       { alle nicht genutzen Headerzeilen sollten = 0 sein         }
       { Netztypen: 0=Netcall, 1=Pointcall, 2=ZConnect, 3=MagicNET }
       {            10=QM, 11=GS, 20=Maus, 30=Fido, 40=RFC         }

       OrgStr      = string[OrgLen];
       AdrStr      = string[AdrLen];
       TeleStr     = string[TeleLen];
       HomepageStr = string[HomepageLen];
       CustHeadStr = string[CustHeadLen];
       pviewer     = ^string;

       refnodep= ^refnode;             { Datentyp f r Reference-Liste }
       refnode = record
                   next  : refnodep;
                   ref   : string[midlen];
                 end;
       empfnodep=^empfnode;
       empfnode= record
                   next   : empfnodep;
                   empf   : AdrStr;
                 end;
       RTAEmpfaengerP =^RTAEmpfaengerT;
       RTAEmpfaengerT = record
                          empf          :string[90];
                          RTAEmpf,
                          vertreter,
                          userUnbekannt :boolean;
                          typ           :byte;
                          next          :RTAEmpfaengerP;
                        end;

       header = record
                  netztyp    : byte;          { --- intern ----------------- }
                  archive    : boolean;       { archivierte PM               }
                  attrib     : word;          { Attribut-Bits                }
                  filterattr : word;          { Filter-Attributbits          }
                  empfaenger : string[90];    { --- allgemein --- Brett / User / TO:User }
                  kopien     : empfnodep;     { KOP: - Liste }
                  empfanz    : integer;       { Anzahl EMP-Zeilen }
                  betreff    : string[BetreffLen];
                  absender   : string[AdrLen];
                  datum      : string[11];    { Netcall-Format               }
                  zdatum     : string[22];    { ZConnect-Format; nur auslesen }
                  orgdate    : boolean;       { Ausnahme: zdatum schreiben   }
                  pfad       : String;        { Netcall-Format               }
                  msgid,ref  : string[midlen];{ ohne <>                      }
                  ersetzt    : string[midlen];{ ohne <>                      }
                  refanz     : integer;       { Anzahl BEZ-Zeilen            }
                  typ        : string[1];     { T / B                        }
                  crypttyp   : string[1];     { '' / T / B                   }
                  charset    : string[30];
                  ccharset   : string[30];    { crypt-content-charset }
                  groesse    : longint;
                  realname   : string[realnlen];
                  programm   : string;        { Mailer-Name }
                  organisation : OrgStr;
                  postanschrift: string[PostAdrLen];
                  telefon    : TeleStr;
                  homepage   : HomepageStr;
                  PmReplyTo  : AdrStr;        { Antwort-An    }
                  AmReplyTo  : AdrStr;        { Diskussiom-In }
                  amrepanz   : integer;       { Anzahl Diskussion-in's }
                  komlen     : longint;       { --- ZCONNECT --- Kommentar-L nge }
                  ckomlen    : longint;       { Crypt-Content-KOM }
                  datei      : string[79];    { Dateiname                  }
                  ddatum     : string[14];    { Dateidatum, jjjjmmtthhmmss }
                  prio       : byte;          { 10=direkt, 20=Eilmail      }
                  error      : string[hdErrLen]; { ERR-Header              }
                  oem,oab,wab: AdrStr;
                  oemlist    : empfnodep;     { OEM: - Liste }
                  oar,war    : string[realnlen];    { Realnames }
                  real_box   : string[20];    { --- Maggi --- falls Adresse = User@Point }
                  hd_point   : string[25];    { eigener Pointname }
                  pm_bstat   : string[20];    { --- Maus --- Bearbeitungs-Status }
                  org_msgid  : string[120];
                  org_xref   : string[120];
                  ReplyPath  : string[8];
                  ReplyGroup : string[40];    { Kommentar-zu-Gruppe          }
                  fido_to    : string[36];    { --- Fido ------------------- }
                  x_charset  : string[30];    { --- RFC -------------------- }
                  keywords   : string[60];
                  summary    : string[200];
{!MH:}            priority   : byte;          { Priority: 1, 3, 5 }
                  distribution:string[40];
                  pm_reply   : boolean;       { Followup-To: poster }
                  quotestring: string[20];
                  empfbestto : string[AdrLen];
                  pgpflags   : word;          { PGP-Attribut-Flags           }
                  pgp_uid    : string[80];    { alternative Adresse          }
                  vertreter  : string[80];
                  XPointCtl  : longint;
                  nokop      : boolean;
                  boundary   : string[70];    { MIME-Multipart-Boundary      }
                  mimetyp    : string[30];
                  xnoarchive : boolean;
                  Cust1,Cust2: CustHeadStr;
                  Cust3      : string;        { interner Custom-Headerstring }
                  control    : string[150];
                end;
       headerp = ^header;

       markrec  =  record
                     recno : longint;
                     datum : longint;
                     intnr : longint;
                   end;

       marklist = array[0..maxmarklist] of markrec;
       marklistp= ^marklist;
       bmarklist= array[0..maxbmark-1] of longint;
       bmarkp   = ^bmarklist;

       ComRec = record
                  Fossil : boolean;
                  Cport  : word;        { UART-Adresse   }
                  Cirq   : byte;        { 0..7           }
                  MInit  : ^string;
                  MExit  : ^string;
                  MDial  : ^string;     { W hlbefehl     }
                  Warten : byte;        { Warten auf Modem-Antwort }
                  IgCD   : boolean;     { CD ignorieren  }
                  IgCTS  : boolean;     { CTS ignorieren }
                  UseRTS : boolean;     { RTS-Handshake  }
                  Ring   : boolean;     { RING-Erkennung }
                  u16550 : boolean;     { FIFO verwenden }
                  postsperre : boolean; { 30-Sek.-Minimalw hlpause }
                  tlevel : byte;        { FIFO trigger level }
                end;

       BoxRec = record
                  boxname   : string[20];   { redundant; wird aus .. }
                  pointname : string[25];
                  username  : string[30];
                  _domain   : string[60];   { .. BOXEN.DB1 kopiert   }
                  _fqdn     : string[60];
                  passwort  : string[20];
                  telefon   : string[60];
                  zerbid    : string[4];
                  uploader  : string[127];
                  downloader: string[127];
                  zmoptions : string[60];
                  prototyp  : string[1];    { Protokoll-Typ /Maus }
                  uparcer   : string[100];
                  downarcer : string[100];
                  unfreezer : string[40];
                  ungzipper : string[40];
                  uparcext  : string[3];
                  downarcext: string[3];
                  connwait  : integer;
                  loginwait : integer;
                  redialwait: integer;
                  redialmax : integer;
                  connectmax: integer;
                  packwait  : integer;
                  retrylogin: integer;
                  conn_time : integer;      { Modem-Connect-Zeit }
                  owaehlbef : string[10];   { wird nicht mehr verwendet! }
                  modeminit : string[60];
                  mincps    : integer;
                  bport     : byte;
                  params    : string[3];
                  baud      : longint;
                  gebzone   : string[20];
                  SysopMode : boolean;
                  SysopInp  : string[60];  { Eingabe-Puffer f r SysMode }
                  SysopOut  : string[60];  { Zieldatei f r Sysop-Mode  }
                  SysopStart: string[60];
                  SysopEnd  : string[60];
                  O_passwort: string[25];  { Online-Pa wort }
                  O_logfile : string[60];  { Online-Logfile }
                  O_script  : string[45];  { Online-Script  }
                  MagicNet  : string[8];   { Name des MagicNet's..     }
                  MagicBrett: string[25];  { Bretthierarchie f r Magic }
                  lightlogin: boolean;     { LightNET-Login: \ statt ^F}
                  exclude   : array[1..excludes,1..2] of string[5];
                  FPointNet : smallword;   { Fido: Pointnetz-Nr.       }
                  f4D       : boolean;     { Fido: 4D-Adressen         }
                  fTosScan  : boolean;     { Fido: Box benutzt TosScan }
                  AreaPlus  : boolean;     { Fido: "+" bei AreaFix     }
                  AreaBetreff:boolean;     { Fido: -q / -l             }
                  AreaPW    : string[12];  { Fido/UUCP: Areafix-PW     }
                  FileScanner:string[15];  { Fido: Filescan-Name       }
                  FilescanPW: string[12];  { Fido: Filescan-Pa wort    }
                  EMSIenable: boolean;     { Fido: EMSI m glich        }
                  AKAs      : string[AKAlen]; { Fido: lokale AKA-Liste }
                  SendAKAs  : string[AKAlen]; { Fido: Pakete mitsenden f r.. }
                  GetTime   : boolean;     { Fido: TRX#-Zeit setzen    }
                  SendTrx   : boolean;     { Fido: TRX# senden - undok }
                  NotSEmpty : boolean;     { Fido: kein sendempty - "  }
                  PacketPW  : boolean;     { Fido: Paketpa wort senden }
                  ExtPFiles : boolean;     { Fido: erweiterte Paketdateinamen }
                  LocalIntl : boolean;     { Fido: ~d'Bridge-Areafix   }
                  Brettmails: boolean;     { Turbo-Box/Maus:  Brettnachr. }
                  LoginName : string[60];  { UUCP/QM: login-Username   }
                  UUCPname  : string[8];   { uucico-Systemname         }
                  MaxWinSize: byte;        { UUCP: max. Windowgr  e    }
                  MaxPacketSize:smallword; { UUCP: max. Blockgr  e     }
                  VarPacketSize:boolean;   { UUCP: variable Blockgr  e }
                  ForcePacketSize:boolean; { UUCP: SendWinsize=RecvWinsize }
                  UUprotos  : string[10];  { UUCP: m gl. Protokolle    }
                  SizeNego  : boolean;     { UUCP: size negotiation    }
                  UUsmtp    : boolean;     { UUCP: SMTP/UUCP           }
                  ClientSmtp: boolean;     { UUCP: SMTP/Client         }
                  PPPClientPath: string[MaxLenPathname]; { PPP Client-Pfad   }
                  PPPClient : string[MaxLenPathname];    { PPP Client-Aufruf }
                  PPPAddServers: string[160]; { PPP Pakete mitsenden   }
                  PPPDialUp : string[60];  { PPP Zugang/Dial-Up        }
                  PPPPhone  : string[60];  { PPP Telefon               }
                  PPPLogin  : string[60];  { PPP Login                 }
                  PPPPass   : string[20];  { PPP Passwort              }
                  PPPAskIfConnect     : boolean;    { PPP R ckfrage vor Anwahl     }
                  PPPAskIfDisconnect  : boolean;    { PPP R ckfrage vor Auflegen   }
                  PPPKeepConnectStatus: boolean;    { PPP Verbindungsstatus halten }
                  PPPSpool: string[MaxLenPathname]; { PPP Spool-Verzeichnis      }
                  PPPMailInServer    : string[160]; { PPP Mail-Server   incoming }
                  PPPMailInPort      : string[50];  { PPP Mail-Port     incoming }
                  PPPMailInProtocol  : string[5];   { PPP Mail-Protok.  incoming }
                  PPPMailInEnv       : string[160]; { PPP Mail-Envelope incoming }
                  PPPMailInUser      : string[160]; { PPP Mail-User     incoming }
                  PPPMailInPass      : string[75];  { PPP Mail-Passwort incoming }
                  PPPMailInUseEnvTo  : boolean;     { PPP Mail (X-)Envelope-To auswerten }
                  PPPMailInKeep      : boolean;     { PPP Mail incoming nicht l schen }
                  PPPMailInAPOP      : boolean;     { PPP Mail-Authentifizierung (APOP) incoming }
                  PPPMailOutServer   : string[160]; { PPP Mail-Server   outgoing }
                  PPPMailOutPort     : string[50];  { PPP Mail-Port     outgoing }
                  PPPMailFallback    : string[8];   { PPP Fallback-Server (Mail) }
                  PPPMailOutEnv      : string[160]; { PPP Mail-Envelope outgoing }
                  PPPMailOutUser     : string[160]; { PPP Mail-User     outgoing }
                  PPPMailOutPass     : string[75];  { PPP Mail-Passwort outgoing }
                  PPPMailOutSMTPafterPOP : boolean; { PPP Mail-Authentifizierung (SMTP after POP) outgoing }
                  PPPMailOutSMTPLogin: boolean;     { PPP Mail-Authentifizierung (SMTP AUTH) outgoing }
                  PPPNewsServer      : string[160]; { PPP News-Server            }
                  PPPNewsPort        : string[50];  { PPP News-Port              }
                  PPPNewsFallback    : string[8];   { PPP Fallback-Server (News) }
                  PPPNewsUser        : string[160]; { PPP News-User              }
                  PPPNewsPass        : string[160]; { PPP News-Passwort          }
                  PPPNewsList        : boolean;     { PPP News Liste anfordern/aktualisieren }
                  PPPNewsMaxLen      : longint;     { PPP News max. Artikell nge (KB) }
                  PPPNewsMax         : longint;     { PPP News max. Artikelanzahl pro Newsgroup }
                  PPPExternCfg : string[MaxLenPathname]; { PPP externe Config    }
                  HdrOnly            : string[10];  { HdrOnly-Support }
                  ReplaceOwn: boolean;              { Eigene N. durch R ckl ufer ersetzen }
                  Replace_0: boolean;               {Backupeintraege }
                  Replace_2: boolean;
                  Replace_3: boolean;
                  Replace_4: boolean;
                  Replace_10: boolean;
                  Replace_11: boolean;
                  Replace_20: boolean;
                  Replace_30: boolean;
                  Replace_31: boolean;
                  Replace_40: boolean;
                  Replace_41: boolean;
                  eFilter   : string[60];  { Eingangsfilter            }
                  aFilter   : string[60];  { Ausgangsfilter            }
                  SysopNetcall : boolean;  { Netzanruf-Bericht im S.M. }
                  SysopPack : boolean;     { Sysopnetcall-Paket packen }
                  Script    : string[50];  { Netcall-Script     }
                  chsysbetr : string[50];  { Changesys-Betreff  }
                  uucp7e1   : boolean;     { gerade Parity beim Login }
                  JanusPlus : boolean;     { Janus+             }
                  DelQWK    : boolean;     { ZQWK-Schalter -del }
                  BMtyp     : byte;        { UUCP: Brettmanager-Typ }
                  BMdomain  : boolean;     { UUCP: Brettmanager braucht Domain }
                  maxfsize  : smallword;   { UUCP: max. Empfangsdateigr  e / KB }
                  EB_Daemon : boolean;     { UUCP: "MAILER-DAEMON" }
                  citycarrier : boolean;   { Citycarrier-Zuschlag mitrechnen ? (T-Com ab 01.05.2005)}
                end;
       BoxPtr = ^BoxRec;

       QfgRec = record                     { QWK-QFG-Daten }
                  RepFile   : string[8];   { REP-Dateinahme ohne Ext. }
                  Packer    : string[3];   { Packer-Typ (Extension)   }
                  Door      : string[20];  { Name des Doorprogramms   }
                  requests  : boolean;     { File Requests m glich    }
                  ebs       : boolean;     { Empfangsbest tigungen "  }
                  privecho  : string[50];  { PM-Echo                  }
                  netecho   : string[50];  { Netmail-Echo             }
                  emailecho : string[50];  { EMail-Echo (Oerx)        }
                  nmt       : byte;        { Netmail-Typ              }
                  midtyp    : shortint;    { Message-ID-Typ           }
                  hdr       : boolean;     { Header im Body           }
                  bretter   : string[25];  { Brettebene               }
                end;

       FidoAdr = record
                   username   : string[36];
                   zone,net   : word;
                   node,point : word;
                   ispoint    : boolean;
                 end;

       NL_Rec  = record
                   listfile   : string[12];    { Nodelisten-Datei      }
                   number     : integer;       { akt. Nummer           }
                   updatefile : string[12];    { Diff/Update-Datei     }
                   updatearc  : string[12];    { gepackte Update-Datei }
                   processor  : ^string;       { externer Bearbeiter   }
                   DoDiff     : boolean;
                   DelUpdate  : boolean;       { Diff l schen }
                   format     : byte;     { 1=NL, 2=P24, 3=PVT, 4=4D, 5=FD }
                   zone,net,node : word;
                   sort       : longint;       { Tempor rfeld }
                 end;
       NL_array= array[1..maxNodelists] of NL_Rec;
       NL_ap   = ^NL_array;

       fkeyt  = array[1..10] of record
                                  menue    : string[20];
                                  prog     : string[200];
                                  warten   : boolean;
                                  bname    : boolean;  { $FILE aus Betreff }
                                  ntyp     : byte;   { xp3.extract_msg.typ }
                                  listout  : boolean;  { Ausgabe an Lister }
                                  speicher : word;       { 50 .. 500 KByte }
                                  vollbild : boolean;
                                  autoexec : boolean;
                                end;
       fkeyp  = ^fkeyt;

       KeyRec = record
                  keypos : byte;   { X-Position in 2. Bildzeile }
                  keylen : byte;
                  keyspot: shortint;  { <0 : mehrere Zeichen ab Pos. 0 }
                  key    : taste;  { LowerCase-Taste }
                end;

       proc   = procedure;

       komlines = array[0..kommlmax-1] of word;
       komrec   = record
                    msgpos : longint;
                    lines  : komlines;
                    _ebene : shortint;
                    flags  : byte;
                  end;
       komliste = array[0..maxkomm-1] of komrec;   { Kommentarbaum }
       komlistp = ^komliste;

       ExtHeaderType = array[1..maxheaderlines] of byte;

       viewert  = array[1..maxviewers] of record
                                            ext : string[3];
                                            prog: string[40];
                                          end;
       UnpackRec = record
                     UnARC, UnLZH, UnZOO,
                     UnZIP, UnARJ, UnPAK,
                     UnDWC, UnHYP, UnSQZ,
                     UnRAR                : string[50];
                   end;

       PathPtr   = ^string;

       DomainNodeP = ^domainnode;
       DomainNode = record
                      left,right : DomainNodeP;
                      domain     : ^string;
                    end;

       { Speichert die Zeilen in der Konfiguration, die nicht
         bekannt sind, wichtig f r Kompatibilit t mit anderen
         Programmen }
       TBadConfigLines = array[1..MaxBadConfigLines] of ^String;


const
       menupos : array[0..menus] of byte = (1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                                            1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                                            1,1,1,1,1,1,1,1,1,1);
       menable : array[0..menus] of word = (0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                            0,0,0,0,0,0,0,0,0,0);
       checker : array[0..menus] of byte = (0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,0,0,
                                            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                                            0,0,0,0,0,0,0,0,0,0);

       OStype : (os_dos,os_linux,os_windows,os_2) = os_dos;

       Quit       : boolean = false;
       mbase      : pointer = nil;     { Nachrichten.Datenbank  }
       ubase      : pointer = nil;     { User-Datenbank         }
       bbase      : pointer = nil;     { Brett-Datenbank        }
       auto       : pointer = nil;     { automsg.db1            }
       bezbase    : pointer = nil;     { Bezugs-Datenbank       }
       mimebase   : pointer = nil;     { MIME-Typen-Datenbank   }
       runerror   : boolean = true;    { Runtime Error aufgetreten }
       Timing_Nr  : byte = 1;          { zuletzt eingegebene Nummer}
       ErrLevel   : byte = 0;          { bei Beenden  ber XP.PAS   }
       startup    : boolean = true;    { Datenbank noch nicht initialisier }
       netcalling : boolean = false;   { laufender Netcall }
       autoactive : boolean = false;   { select(20) aktiv  }
       extended   : boolean = false;
       keydisp    : boolean = true;    { Tastenk rzel anzeigen  }
       Clipboard  : boolean = false;   { Windows-Clipboard }
       deutsch    : boolean = true;
       screenlines: byte    = 25;      { Bildschirmzeilen       }
       screenwidth: byte    = 80;      { Bildschirmspalten      }
       OrgVideomode:byte    = 3;
       OldScanlines:byte    = 1;
       uvs_active : boolean = false;   { /N/Z/Unversandt        }
       marksorted : boolean = false;   { marked^[] sortiert     }
       fidolastseek:string[40] = '';   { Fido/Fileliste/Suchen  }       
       cfgmodified: boolean = false;   { Einstellungen ge ndert }
       DisableAltN: boolean = false;   { Alt-N deaktiviert      }
       automessaging: boolean = false; { Nachrichten werden nicht-manuell }
       actscreenlines: integer = 25;
       exzconfig  : boolean = false;   { exist('zconfig.exe') -> /C/A/P }
                                       { verarbeitet (w hren P.-Einlesen  }
       lockopen   : boolean = false;   { LOCKFILE ge ffnet }

    (* XPhilite   : byte    = 20; *)
       XPdisplayed: boolean = false;   { 'CrossPoint' rechts unten angezeigt }

       ParHelp    : boolean = false;   { Hilfsseite             }
       ParDebug   : boolean = false;   { Debugging-Mode         }
       ParDDebug  : boolean = false;   { Database-Debug         }
       ParDebFlags: byte    = 0;       { 1 = Shell-Commands     }
       ParDupeKill: boolean = false;   { autom. DupeKill        }
       ParTrace   : boolean = false;   { Script-Tracefile       }
       ParMono    : boolean = false;   { monochrome Anzeige     }
       ParNojoke  : boolean = false;   { Spruch am Ende abschalten }
       ParXX      : boolean = false;   { s. XP4E                }
       ParNetcall : string[BoxNameLen] = '';  { autom. Netcall }
       ParNCtime  : string[5] = '';    { Uhrzeit f. autom. Netcall }
       ParRelogin : boolean = false;   { Relogin-Netcall        }
       ParNSpecial: boolean = false;   { Netcall/Spezial        }
       ParReorg   : boolean = false;   { autom. Reorganisation  }
       ParSpecial : boolean = false;   { Spezial-Reorg - Puffer-reparieren }
       ParPack    : boolean = false;   { autom. Packen          }
       ParXPack   : boolean = false;   { autom. Packen / nur Dateien mit L cken }
       ParXPfile  : string[8] = '';    { optional zu /xpack: Datenbankname }
       ParQuiet   : boolean = false;   { keine Ger usche        }
       ParTestres : boolean = true;    { Test auf residente Prg. }
       ParMaus    : boolean = false;   { Pseudo-Maus            }
       ParPuffer  : string = '';      { autom. Puffer einlesen }
       ParPufED   : boolean = false;   { -> EmpfDat = ErstDat   }
       ParGelesen : boolean = false;   { ip-eingelesene Nachrichten auf }
       ParTiming  : byte    = 0;       {    'gelesen' setzen    }
       ParExit    : boolean = false;   { Programm beenden       }
       ParSetuser : string[50] = '';   { Username setzen        }
       ParSendbuf : string = '';      { Puffer automatisch versenden }
       ParKey     : char    = ' ';     { autom. Tastendruck     }
       ParEmpfbest: boolean = false;   { Zusatzschalter f r /IPx }
       ParPass    : string[10] = '';   { * -> ausgeben; Hex -> setzen }
       ParPasswd  : string[10] = '';   { Pa wort }
       ParZeilen  : byte = 0;          { Bildzeilen }
       ParWintime : byte    = 0;       { Rechenleistungs-Freigabe:
                                         0=aus, 1=Timeslice, 2=konservativ }
       ParOS2     : byte    = 0;       { Rechenleistungs-Freigabe }
       ParSsaver  : boolean = false;   { Screensaver }
       ParAutost  : string[12] = '';   { /autostart: }
       ParGebdat  : string[12] = 'GEBUEHR.DAT';  { Geb hrenzonenliste }
       ParGebdat2 : string[12] = 'TARIFE.DAT';   { 2. Teil der " }
       ParAV      : string = '';      { Archiv-Viewer }
       ParLanguage: string[4] = '';    { /l: Sprache }
       ParFontfile: string = '';      { /f: Fontdatei laden }
       ParNomem   : boolean = false;   { Speichertest  bergehen }
       ParNoSmart : boolean = false;   { kein Schreibcache-Flush }
       ParLCD     : boolean = false;   { keine Int10/CharGen-Zugriffe }
       ParMenu    : boolean = false;   { /menu: XP mit vollen Men s starten }
       ParG1      : boolean = false;   { Geb hrenzone ermitteln }
       ParG2      : boolean = false;   { Geb hren berechnen }
       ParNolock  : boolean = false;   { keine Lockfile- berpr fung }
{$IFDEF Beta }
       ParNoBeta  : boolean = false;   { keine Beta-Meldung }
{$ELSE }
       ParNoBeta  : boolean = true;    
{$ENDIF }
       ParNoDLL   : boolean = false;   { keine Pr fung der XP_NTVDM.DLL }
       OldXPComp  : boolean = false;   { XP 3.12 Kompatibilit tsmodus }
       ParSavePal : boolean = false;   { Farbpalette sichern }

       MoreMode   : boolean = true;
       Developer  : boolean = false;
       SupportCfg : string[12] = 'SUPPORT.CFG';
       UseNewCfg  : boolean = false;   { neue cfg, wird in initvar (xp2cfg) gesetzt }

       Delviewtmp : boolean = false;   { Win-Viewertempfiles erst beim naechsten Start loeschen }

                         { Externe Viewer: Extension-abhaengige Sicherheitseinstellungen: }

       viewer_danger : string[37] = '.EXE.COM.BAT.BTM.CMD.PIF.LNK.INF.REG.'; { Immer Abfragen }
       viewer_save   : string = '.BMP.GIF.JPG.PCX.IFF.PDF';        { ohne Sicherheitsabfrage }
       viewer_lister : string = '.TXT.ASC';                 { immer internen Lister benutzen }
       viewer_scanner : string[viewproglen] = '';            { Viewer bei Antwort=Nein }

       QuoteCharSet : set of char = [':','|']; { Weitere Quotezeichen }
       OtherQuoteChars : boolean = false; { andere Quotezeichen neben > aktivieren }
       Otherqcback : boolean = false;     { Backup von Otherquotechars zum Umschalten }

       PGP2 = '2.6.x';
       PGP5 = '5.x';
       PGP6 = '6.5.x';
       GPG  = 'GnuPG';
       PGPVersion : string[5] = PGP2;

       mheadercustom : array[1..3] of string[custheadlen] = ('','','');
       cust3len: byte = 255;

       MsgFeldDef = 'FGDAEB'; { Standardreihenfolge: Feldtausch Nachrichtenliste }
       UsrFeldDef = 'FHBGAK'; { Standardreihenfolge: Feldtausch Userliste }

       showungelesen : boolean = true;    { kombinierter Ungelesen-Modus }

       ignoreSupCancel : boolean = false; { Supersedes/Ersetzt und Cancels ignorieren }
       UserAutoCreate  : boolean = false; { Unbekannte User beim Beantworten und }
                                          { Archivieren ohne R ckfrage anlegen   }
       SaveKom         : boolean = false; { XP3EX.extract_msg Kommentar (KOM:) extrahieren }

       Euro_Allowed    : boolean = false; { Euro-Symbol im Editor und Konvertierung  }
                                          { "î" => "EUR" bei ASCII-Brettern erlaubt  }

       EuroKey_pressed : boolean = false; { <AltGr-E> gedrckt? Nur dann bei Nicht-RFC-Netztypen }
                                          { "EUR" im Editor einfgen, nicht aber bei <Alt-238>   }


       ForceNodelistIX : boolean = false; { Nodelistenindizierung beim Start erzwingen (s. xp2cfg.inc) }
       AltGr_N_pressed : boolean = false; { Hotkey <AltGr-N> gedr ckt? (Nodeliste durchsuchen) }

       NodelistBrowserButtonsDisabled : boolean = false; { beim Erstellen von Nachrichten Buttons }
                                                         { im Nodelist-Browser abschalten         }
       IsNodelistBrowserMsg : boolean = false; { Nachricht aus Nodelist-Browser heraus erzeugt }
       IsNodelistBrowserReq : boolean = false; { F'Request aus Nodelist-Browser heraus erzeugt }
                                               { => Fehlermeldung bei <Alt-N> und <AltGr-N>    }
       regstr : string[2]  = ' R';
       ovrstr : string[10] = '';    { wird an Versionsbezeichnung angeh ngt }

var    bb_brettname,bb_kommentar,bb_ldatum,bb_flags,bb_pollbox,bb_haltezeit,
       bb_gruppe,bb_index,bb_adresse,
       ub_username,ub_adresse,ub_kommentar,ub_adrbuch,ub_pollbox,
       ub_haltezeit,ub_userflags,ub_codierer,
       mb_brett,mb_absender,mb_betreff,mb_origdatum,mb_empfdatum,
       mb_groesse,mb_typ,mb_halteflags,mb_gelesen,mb_unversandt,
       mb_ablage,mb_adresse,mb_msgsize,mb_wvdatum,mb_msgid,mb_netztyp,
       mb_name,mb_flags,mb_mimetyp,
       bezb_msgpos,bezb_msgid,bezb_ref,bezb_datum,
       mimeb_typ,mimeb_extension,mimeb_programm : integer;

       IntGruppe,LocGruppe,NetzGruppe : longint;   { INT_NRs der Std.-Gruppen }

       BadConfigLines: TBadConfigLines;
       BadConfigLinesCount: Integer;
       menu         : array[0..menus] of ^string;
       SwapFileName : string[12];
       helpfile     : string[12];     { XP.HLP     }
       keydeffile   : string[12];     { KEYDEF.CFG }
       OwnPath      : string;
       ShellPath    : string;
       TempPath     : string;
       ExtractPath  : string;
       SendPath     : string;
       LogPath      : string;
       FilePath     : string;
       FidoPath     : string;        { OwnPath+FidoDir }
       lockfile     : file;          { gelockte Datei LOCKFILE }

       col          : ColRec;        { CFG-Variablen :  ------ }
       ExtraktTyp   : byte;          { 0=ohne Kopf, 1=mit, 2=Puffer, 3=Quote }
       defExtrakttyp: byte;          { .. in XPOINT.CFG        }
       brettanzeige : byte;          { 0=gross, 1=top, 2=klein }
       ShowMsgDatum : boolean;       { Datum im Nachrichtenf.  }
       viewers      : ^viewert;
       VarEditor,
       VarLister    : string[40];    { externer Editor/Lister  }
       ListerKB     : smallword;
       EditorKB     : smallword;
       stdhaltezeit,
       stduhaltezeit: integer16;
       QuoteChar    : string[QuoteLen];
       QuoteBreak   : byte;          { Zeilenumbruch f r Quoter }
       COMn         : array[1..MaxCom] of ComRec;  { Schnitten-Paras }
       BoxPar       : BoxPtr;
       DefaultBox   : string[20];
       DefFidoBox   : string[20];
   {}  LongNames    : boolean;       {   "       "         : >40 Zeichen }
       ScrSaver     : smallword;
       SoftSaver    : boolean;       { Bild weich ausblenden }
       BlackSaver   : boolean;       { schwarzschalten }
       smallnames   : boolean;       { kleingeschriebene Brett/Usernamen }
       UserAufnahme : byte;          { 0=Alle, 1=Zerberus, 2=keine, 3=PM }
       NeuUserGruppe: integer16;     { Gruppe der neuangelegte User angehoeren }
       MaxBinSave   : longint;
       MaxNetMsgs   : longint;       { Default-Wert f r neue Gruppen }
       ReHochN      : boolean;
       SwapToEMS    : boolean;       { EMS-Swapper f r DOS-Shell }
       SwapToXMS    : boolean;       { XMS-Swapper f r DOS-Shell }
       HayesComm    : boolean;
       ShowLogin    : boolean;
       BreakLogin   : boolean;
       ArchivBretter: string[BrettLen];
       ArchivLoesch : boolean;       { Msgs nach Archivierung l schen }
       ArchivText   : boolean;       { Archivier-Vermerk erstellen}
       shell25      : boolean;       { 25-Zeilen-Mode bei DOS-Shell }
       edit25       : boolean;       { dito bei externem Editor }
       MinMB        : smallword;
       AskQuit      : boolean;
       ListVollbild : boolean;       { Vollbild bei internem Lister }
       ListUhr      : Boolean;       { Uhr bei Vollbildlister }
       ListEndCR    : boolean;       { internen Lister mit <cr> beenden }
       ListWrap     : boolean;
       FKeys        : array[0..4] of fkeyp;
       Unpacker     : ^UnpackRec;
       EditVollbild : boolean;
       ExtEditor    : byte;          { 3=immer, 2=Nachrichten, 1=gro e Files }
       ShowMsgPath  : boolean;
       ShowMsgID    : boolean;
       ShowMsgSize  : boolean;
       DruckLPT     : smallword;          { 1-5: LPT1-3, COM1-2 }
       DruckInit    : string[80];
       DruckExit    : string[80];
       DruckFormlen : byte;          { Seitenl nge; 0 = kein autom. Vorschub }
       DruckFF      : string[80];
       DruckLira    : byte;
       AutoCpgd     : boolean;       { automatisches Ctrl-PgDn im Editor }
       XP_ID_PMs    : boolean;
       XP_ID_AMs    : boolean;
       XP_Tearline  : boolean;
       UserSlash    : boolean;
       BAKext       : string[3];
       keepedname   : boolean;
       pmcrypt      : array[1..maxpmc] of
                        record
                          encode,decode : string[40];
                          name          : string[20];
                          binary        : boolean;
                        end;
       wpz          : longint;       { EUR/Zeile bei Geb hrenstat. *1000  }
       sabsender    : byte;          { 0=normal, 1=klein, 2=mit space,   }
       envspace     : smallword;     { ..3=nur User, 4=Spalten           }
       DefReadmode  : integer;       { Default f r 'readmode' (s.u.) }
       AAmsg        : boolean;       { Auto-Advance }
       AAbrett      : boolean;
       AAuser       : boolean;
       ScrollLock   : boolean;       { umschaltbarer Scroll-Mode }
       GrossWandeln : boolean;       { Adressen in Gro schreibung wandeln }
       HaltOwn      : boolean;
       HaltOwnPM    : boolean;
       DispUsername : boolean;
       SaveUVS      : boolean;       { AutoPark }
       EmpfBest     : boolean;       { autom. Empfangsbest tigungen }
       EmpfBkennung : string[10];    { '##' }
       unescape     : string[100];   { UUCP-Adressen... }
       ReplaceEtime : boolean;       { 00:00 Erstellungszeit }
       trennchar    : string[1];     { Trennzeichen f r Brett-Trennzeilen }
       AutoArchiv   : boolean;       { automatische PM-Archivierung }
       NewBrettEnde : boolean;       { neue Bretter ans Listenende }
       _maus        : boolean;       { Mausbedienung }
       TrennAll     : boolean;       { Trennzeilen im 'Alle'-Mode }
       BaumAdresse  : boolean;       { volle Adresse im Bezugsbaum }
       SwapMausKeys : boolean;       { Maustasten vertauschen }
       MausDblclck  : byte;          { 4/7/11 }
       MausShInit   : boolean;       { Init nach Shell-Aufruf }
       ConvISO      : boolean;       { ISO-Umlaute im Lister lesbar machen }
       KomArrows    : boolean;       { Kommentarpfeile im Lister anzeigen }
       ListScroller : boolean;       { Scrollbalken bei Mausbedienung }
       ListAutoscroll:boolean;       { Scrolling am Bildschirmrand }
       LargestNets  : integer;       { Conf2: die n gr  ten Netze bei Nodestat }
       NS_MinFlags  : integer;       { Conf2: min. Flags bei Nodestatistik }
       CountDown    : boolean;       { Conf2: Down-Nodes mitz hlen }
       UserBoxname  : boolean;       { Boxname in Userbrettern belassen }
       nDelPuffer   : boolean;       { PUFFER nach Einlesen l schen }
       MaxMaus      : boolean;       { Outfile-Gr  e begrenzen }
       Auswahlcursor: boolean;       { Blinden-Option }
       Soundflash   : boolean;       { Geh rlosen-Option }
       MausLeseBest : boolean;       { manuelle Maus-Best tigen }
       MausPSA      : boolean;       { Stati anfordern }
       ShowRealnames: boolean;       { Realnames anzeigen, falls vorhanden }
       ss_passwort  : boolean;       { Startpa wort nach Screensaver }
       NewsMIME     : boolean;       { MIME auch in News verwenden }
       MIMEqp       : boolean;       { quoted-printable }
       RFC1522      : boolean;       { RFC-1522-Header erzeugen }
       NoArchive    : boolean;       { NoArchive-Headerz. erzeugen } {!MMH}
       pmlimits     : array[1..maxpmlimits,1..2] of longint;
       ZC_xposts    : boolean;       { ZConnect-Crosspostings }
       ZC_ISO       : boolean;       { ISO-8859-1 verwenden }
       leaveconfig  : boolean;       { /Config-Men  bei <Esc> ganz verlassen }
       NewsgroupDisp: boolean;       { Anzeige mit "." statt "/" (nur RFC) }
       NewsgroupDispAll: boolean;    { f r alle Gruppen }
       NetcallLogfile:boolean;       { Logfile  ber Netcalls f hren }
       ShrinkUheaders : boolean;     { UUZ-Schalter -r }
       ListHighlight: boolean;       { ** und __ auswerten }
       ListFixedHead: boolean;       { feststehender Nachrichtenkopf }
       MaggiVerkettung: boolean;     { s. xpnt.ntKomkette() }
       ISDN_Int     : byte;          { CAPI-Int, Default=$f1 }
       ISDN_EAZ     : char;          { eigene EAZ, Default='0' }
       ISDN_Controller:byte;         { Nummer des Controllers, Default=0 }
       ISDN_incoming, isdn_outgoing: string[30];
       AutoTimeZone : byte;          { 52=manuell, 53=Datum, 54=TZ, 55=TZ/Datum, 61=Windows }
       SaveType     : byte;          { 0=Sofort, 1=Alt-S, 2=R ckfrage }
       XSA_NetAlle  : boolean;       { Netcall/Alle-Schalter bei /Netcall/L }
       maxcrosspost : byte;          { Filter f r Massen-Crosspostings }
       maildelxpost : boolean;       { 20.01.2000 robo - auch bei Mail? }
       KeepRequests : boolean;       { Requests zur ckstellen }
       waehrung     : string[5];
       gebnoconn    : longint;       { Geb hren f r nicht zustandegek. Verb. }
       citycarriergeb : real;     { Zuschlag f r Citycarrier (T-Com ab 01.05.2005)}
       gebCfos      : boolean;       { Geb hren bernahme von cFos }
       newgeb       : boolean;       { Neues Geb hrenmodell verwenden }
       autofeier    : boolean;       { Feiertage bei Geb hren ber cksichtigen }
       ShellShowpar : boolean;       { Anzeige vor Shell-Aufruf }
       ShellWaitkey : boolean;       { warten nach Shell-Aufruf }
       msgbeep      : boolean;       { Tonsignal in N/B/U- bersicht }
       Netcallunmark: boolean;       { Nachrichten nach Netcall ent-markieren }
       DefaultNokop : boolean;       { Default STAT: NOKOP }
       blind        : boolean;       { Anzeigeunterst tzung f r Blinde }
       quotecolors  : boolean;       { verschiedenfarbige Quoteebenenen }
       trennkomm    : byte;          { 1=links, 2=Mitte, 3=rechts }
       vesa_dpms    : boolean;       { Screen-Saver-Stromsparmodus }
       termbios     : boolean;       { BIOS-Ausgabe im Terminal }
       tonsignal    : boolean;       { zus tzliches Tonsignal nach Reorg u.a. }
       MsgNewFirst  : boolean;       { Nachrichtenanzeige umgekehrt: neue oben }
       MsgFeldTausch   : string[MsgFelderMax]; { f r blinde Benutzer,
                                       die sich Ausgaben vorlesen lassen, k nnen
                                       in der Brettliste Felder vertauscht werden }
       UsrFeldTausch   : string[UsrFelderMax]; { f r blinde Benutzer,
                                       die sich Ausgaben vorlesen lassen, k nnen
                                       in der Userliste Felder vertauscht werden }
       UsrFeldPos1  : Byte;          { Spezialmodus Position der Usernamen (FeldTausch) }
       UsrFeldPos2  : Byte;          { Normalmodus Position der Usernamen (FeldTausch) }
	   EuroOK       : boolean;       { #238 als Euro statt als Epsilon anzeigen }
       Magics       : boolean;       { Auch Magics im F3-Request erkennen j/n }
       brettkomm    : boolean;       { Kommentar aus Brettliste  bernehmen }
       adrpmonly    : boolean;       { Telefon/Adresse nur in PMs }
       newuseribm   : boolean;       { Default-Umlauteinstellung f. neue User }
       Usersortbox  : boolean;       { im Userfenster nach Boxname sortieren }
       _Usersortbox : boolean;       { Hilfszeiger fuer Config }
       multipartbin : boolean;       { RFC-Bin rnachrichten als Multipart }
       RFC_AddOldBetreff : boolean;  { RFC: Bei Betreffaenderung alten Betreff anhaengen }
       mausmpbin    : boolean;       { dto. f r MausTausch }
       askreplyto   : boolean;       { 03.02.2000 robo - fragen bei ANTWORT-AN }

       UsePGP       : boolean;       { PGP verwenden }
       PGPbatchmode : boolean;       { PGP-Schalter +batchmode verwenden }
       PGP_UUCP     : boolean;       { PGP f r RFC/UUCP }
       PGP_Fido     : boolean;       { PGP f r Fido }
       PGP_UserID   : string[80];    { Netzadresse von Key }
       PGP_AutoPM   : boolean;       { Keys aus PMs automatisch einlesen }
       PGP_AutoAM   : boolean;       { Keys aus AMs automatisch einlesen }
       PGP_waitkey  : boolean;       { 'Taste dr cken ...' nach PGP }
       PGP_log      : boolean;       { Logfile f r PGP-Aktivit ten }
       PGP_signall  : boolean;       { alle Nachrichten signieren }
       PGP_GPGEncodingOptions : string; { Standardparameter fuer GPG }

       IntVorwahl   : string[15];    { internationale Vorwahl }
       NatVorwahl   : string[10];    { nationale Vorwahl, normalerweise 0 }
       Vorwahl      : string[15];    { eigene Vorwahl }
       AutoDiff     : boolean;       { Node/Pointdiffs automatisch einbinden }
       ShowFidoEmpf : boolean;       { von/an/Betreff-Anzeige }
       HighlightName: string[25];    { eigenen Fido-Brettempf nger hervorheben }
       AutoTIC      : boolean;       { TIC-Files auswerten }

       AutoUpload   : boolean;       { CrossTerm - PD-Zmodem-Autoupload }
       AutoDownload : boolean;       { Autodownload }
       TermCOM      : byte;          { Schnittstelle }
       TermDevice   : string;        { Device fuer das Terminal }
       TermBaud     : longint;       { Baudrate }
       TermStatus   : boolean;       { Statuszeile }
       TermInit     : string[40];    { Modem-Init }

       mono         : boolean;       { monochrome Anzeige      }
       fnkeylines   : byte;          { wird durch DispFunctionKeys gesetzt }
       lesemodepos  : byte;          { X-Position Lesemode }

       orgcbreak    : boolean;
       oldexit      : pointer;       { alte Exit-Prozedur }

       gl,actgl     : shortint;      { Anzeige-Zeilen im Hauptfenster }
       aufbau       : boolean;       { neuer Bildschirm-Aufbau n tig  }
       xaufbau      : boolean;       { Bezugsbaum neu einlesen        }
       readmode     : integer;       { 0=Alles, 1=Ungelesen, 2=Neues  }
       readdate     : longint;       { 3=Heute, 4=Datum               }
       nachweiter,nw: boolean;       { Auto-Advance im Msg-Fenster    }
       brettweiter  : boolean;
       userweiter   : boolean;
       qchar        : string[20];    { zuletzt verwendeter Quote-String }
       brettall     : boolean;       { false -> nur zutreffende Bretter anz. }
       cfgscrlines  : byte;          { Config-Bildzeilen (wg. /z: }
       domainlist   : DomainNodeP;   { zum Erkennen von Replys auf eigene N. }
       DefaultViewer: pviewer;       { Viewer f r */* }
       DefTextViewer: pviewer;       { Viewer f r text/* }
       PtextViewer  : pviewer;       { Viewer f r text/plain }

       maxmark   : word;             { maximal markierbare Msgs }
       marked    : marklistp;        { Liste der markierten Msgs     }
       markanz   : integer;          { Anzahl markierte Msgs         }
       bmarked   : bmarkp;           { Liste der markierten Bretter/User }
       bmarkanz  : integer;          { Anzahl markierte Bretter/User }

       ablsize     : array[0..ablagen-1] of longint;   { Dateigr  en }
       AktDispmode : shortint;
       AktDisprec  : longint;
       editname    : string;        { Dateiname f r /Edit/Text }
       keymacros   : integer;        { Anzahl geladene Tastenmakros }
       macrokey    : array[1..maxkeys] of taste;
       macroflags  : array[1..maxkeys] of byte;
       macrodef    : array[1..maxkeys] of ^string;
       shortkey    : array[1..maxskeys+1] of KeyRec;
       shortkeys   : shortint;
       registriert : record nr:longint;
                            tc:char;        { A=normal, B=UUCP, C=komplett }
                            komreg,         { 'R-Kom' / 'R-Org' anzeigen }
                            orgreg:boolean;
                     end;
       AutoCrash   : string[30];     { Crash automatisch starten; *.. -> normaler Netcall }
       ntAllowed   : set of byte;    { zul ssige Netztypen }
       extheadersize : integer;      { gr  e des Kopfes bei xp3.extract_msg() }
       extHdLines  : integer;        { Anzahl Kopfzeilen bei Extrakt mit Kopf }
       fidobin     : boolean;        { Bin rnachrichten im FidoNet m glich }
       HeaderLines : integer;        { Def. Anzahl Zeilen bei Extrakt m.Kopf }
       ExtraktHeader : ExtHeaderType;

       PointListn  : string[8];      { alte Pointlisten-Daten }
       PointDiffn  : string[8];
       Pointlist4D : boolean;        { 4D-Liste statt Points24 }

       DefaultZone : word;           { Fido - eigene Zone }
       DefaultNet  : word;           {      - eigenes Net }
       DefaultNode : word;           {      - eigener Node}
       Nodelist    : NL_ap;          { Node-/Pointlisten }
       NL_anz      : byte;           { Anzahl " }
       NodeOpen    : boolean;        { Nodelist(en) vorhanden & ge ffnet }
       ShrinkNodes : string[100];    { Nodeliste einschr nken }
       kludges     : boolean;        { ^A-Zeilen im Lister anzeigen }
       KomShowadr  : boolean;        { <-> BaumAdresse }
       gAKAs       : ^string;        { globale AKA-Adressliste }
       Orga        : ^OrgStr;
       Postadresse : ^string;
       TelefonNr   : ^TeleStr;
       wwwHomepage : ^HomepageStr;
       BrettAlle   : string[20];     { Standardempf nger f r Brettnachrichten }
       fidoto      : string[35];     { XP6: Empf ngername bei Brettnachr.     }
       FidoDelEmpty: boolean;        { 0-Byte-Nachrichten l schen }
       KeepVia     : boolean;        { ZFIDO: Option -via }

       kombaum     : komlistp;       { Kommentarbaum }
       komanz      : word;           { Anzahl Eintr ge }
       maxebene    : shortint;
       komwidth    : shortint;       { Anzeigeabstand zwischen Ebenen }
       kombrett    : string[5];      { Brettcode der Ausgangsnachricht }

       languageopt : boolean;        { /Config/Optionen/Sprachen }
       _fehler_    : string[12];
       _hinweis_   : string[12];
       _days_      : ^string;        { 'Monatag Dienstag ... ' }
       _daylen_    : word;
       StatBrett,                    { / Statistik  }
       UnvBrett,                     { / Unversandt }
       NetBrett    : string[15];     { / Netzanruf  }
       _wotag_     : string[14];     { 'MoDiMiDoFrSaSo' }
       _jn_        : string[2];      { 'JN' }

       { Die Variable RTAMode gibt an, unter welchen Bedingungen sich
         das "Empf nger w hlen"-Fenster  ffnet.

         Bitmaske:  11111111
                    ||  ||||
                    ||  |||\- OAB/WAB-Header vorhanden
                    ||  ||\-- Reply-To-Empf nger vorhanden
                    ||  |\--- KOP/OEM/EMP vorhanden
                    ||  \---- RTA
                    ||
                    |\------- immer
                    \-------- erster Start nach neuer Version }

       RTAMode     : byte;

       { Mit RTAStandard kann man festlegen, ob der Standard im
         'Empf nger w hlen"-Dialog auf 'alle' oder auf der ersten
         Adresse liegt. 'true' -> 'alle'; 'false' -> erste Adresse }

       RTAStandard : boolean;

       { Die ausgelesenen Mailadressen werden bei RTA zu den eigenen Adressen
         hinzugef gt, bzw. wieder entfernt. RTANoOwnAdresses hat Vorrang! }

       RTAOwnAddresses, RTANoOwnAddresses :^string;

      {Lightweight-Readpar}

      noovrbuf  : boolean;
      xmsovrbuf : boolean;
      emsovrbuf : boolean;

      {Filehandles}
      handles   : array[1..255] of byte;

      {NTFont}
      nttimer   : integer;
      modus    : boolean;

      {UKAWP}
      ukawp: boolean;

      {Cancel-Lock}
      sitekey: string;

{ Globale Variable enthalten eine Listerzeile mit text in charbuf und word-Attribuen }
{ in attrbuf. beschrieben werden sie in xp1.MakeListDisplay, gelesen in Winxp.consolewrite }

{$IFDEF Ver32}
{$IFDEF NCRT}
       charbuf     : string[254];                 { Nicht zu klein :-) }
       attrbuf     : array [1..254] of smallword;
{$ELSE }
       charbuf     : string[82];                  {82 Zeichen   Reihenfolge nicht vertauschen!}
       attrbuf     : array [1..82] of smallword;  {82 Attribute}
{$ENDIF}
{$ENDIF}

implementation

end.
