{ ------------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.                   }
{ (c) 1991-1999 Peter Mandrella                                       }
{ (c) 2000-2001 OpenXP-Team                                           }
{ (c) 2002-2026 FreeXP, http://www.freexp.de                          }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.         }
{                                                                     }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der     }
{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html }
{ ------------------------------------------------------------------- }

{ UUCP/RFC <-> ZConnect }
{ PM 10/92              }

{$I XPDEFINE.INC }
(* {$R+,Q+}  {nur zum Testen aktivieren!} *)

{$M 16384,$14000,655360}

program uuz;

uses  xpglobal,crt,clip,dos,dosx,typeform,xpovl,fileio,xpdatum,mimedec,
      montage,lfn,uuz0,uuz1;

{ --- ZConnect-Header verarbeiten ----------------------------------- }

const ReadKoplist = false;
const ReadOEMList = false;

{$define uuzrefs}
{$define ulines}
{$define pgp}

{ 03.02.2000 robo }
{$define uuzmime }
{ /robo }

{$I xpmakeh.inc}

{ my: procedure WriteZcHeader nach uuz0.pas verlagert!! }






(*  my: Debug-Routine
function ComparePath:boolean;
var pfadstr : string;
          l : byte;
begin
  l:=min(LongHdr[LPath].len,248);
  fastmove(LongHdr[LPath].hdr^[1],pfadstr[1],l);
  pfadstr[0]:=chr(l);
  if (length(hd.pfad)>=248) and (right(hd.pfad,length(truncater))=truncater) then
  begin
    hd.pfad:=left(hd.pfad,length(hd.pfad)-length(truncater));
    if length(pfadstr)>length(hd.pfad) then
      pfadstr:=left(pfadstr,length(hd.pfad));
  end;
  ComparePath:=pfadstr=hd.pfad;
end;
*)




{ SMTP-Mail -> ZConnect }

procedure ConvertSmtpFile(fn:pathstr; compressed:boolean);
var       f : file;
    fp,bp,n : longint;
         rr : word;
      p1,p2 : byte;
      mempf : string[AdrLen];
      ende,
     nofrom : boolean;

  function GetAdr:string;
  var p : byte;
  begin
    p:=cpos('<',s);
    if p=0 then GetAdr:=''
    else begin
      if lastchar(s)='>' then dellast(s);
      GetAdr:=copy(s,p+1,length(s)-p);
    end;
  end;

begin
  n:=0;
  write('mail: ',fn);
  if compressed then
  begin
    assign(f,fn);
    reset(f,1);
    setlength(s, 4);
    blockread(f,s[1],4,rr);
    close(f);
    if (left(s,2)=#$1f#$9d) or (left(s,2)=#$1f#$9f) or
       (left(s,2)=#$1f#$8b) then
    begin
      rename(f,fn+'.Z');
      case s[2] of
        #$9d : begin
                 write(' - uncompressing SMTP mail...');
                 shell(uncompress+fn,500);
               end;
        #$9f : begin
                 write(' - unfreezing SMTP mail...');
                 shell(unfreeze+fn,500);
               end;
        #$8b : begin
                 write(' - unzipping SMTP mail...');
                 shell(ungzip+fn,500);
               end;
      end;
    end;
  end;
  write(sp(8));
  OpenFile(fn);
  repeat
    fillchar(hd,sizeof(hd),0);
    if client or (mbox>0) then
      hd.netztyp:=nt_Client
    else
      hd.netztyp:=nt_RFC;
    ende:=false;
    repeat                    { SMTP-Header bzw. 'From_'-Zeile (mbox) lesen }
      ReadString(false);
      if mbox=0 then
      begin
        if ustr(left(s,9))='MAIL FROM' then          { Envelope-From (SMTP) }
          hd.wab:=GetAdr else
        if ustr(left(s,7))='RCPT TO'   then
          hd.empfaenger:=GetAdr;                       { Envelope-To (SMTP) }
      end else
      if (left(s,length(mboxline))=mboxline) then    { Envelope-From (mbox) }
      begin
        mailstring(mid(s,length(mboxline)),hd.wab,false);
        RFC2822_Remove(hd.wab,0);
      end;
      ende:=(bufpos>=bufanz) {or (s='QUIT')};
    until ende or ((mbox=0) and ((s='DATA') or (s='QUIT'))) or
                  ((mbox>0) and (left(s,length(mboxline))=mboxline));
    if ((mbox=0) and (s='DATA')) or
       ((mbox>0) and (left(s,length(mboxline))=mboxline)) then
    begin
      with hd do
        if wab<>'' then
        begin
          p1:=cpos('@',wab);
          if p1=0 then p1:=length(wab)+1;
          p2:=cpos('!',wab);
          if ((p2>0) and (p2<p1)) then
          begin
            p2:=p1-1;
            wab:=left(wab,p1-1);
            while wab[p2]<>'!' do dec(p2);   { rechtes "!" suchen }
            p1:=p2-1;
            while (p1>0) and (wab[p1]<>'!') do dec(p1);
            wab:=mid(wab,p2+1)+'@'+copy(wab,p1+1,p2-p1-1);
          end;
        end;
      inc(n); inc(mails);
      start_of_UTF:=true;
      end_of_UTF:=false;
      write(dup(6,#8),n:6);
      repeat                       { UUCP-Envelope berlesen }
        if not ((mbox>0) and is_nextstring(mboxline)) then
          ReadString(true);
        nofrom:=(mbox>0) or
                (lstr(left(s,5))<>'from ') and (lstr(left(s,5))<>'>from');
        if (eol=0) and not nofrom then
          ReadString(false);
      until nofrom;
      mempf:=SetMailUser(hd.empfaenger);
      ReadRFCheader(3+mbox,s);
(*
      if not ComparePath then
        AppendLog('different data in LongHdr[LPath] and hd.pfad',
                  n,ustr(fn),hd.msgid,true);
*)
      if UseEnvTo and (hd.envemp<>'') then
        mempf:=hd.envemp
      else if getrecenvemp and (ReceivedEnv<>'') then
        mempf:=ReceivedEnv;

      if mempf<>'' then CheckEnvEmp(mempf);

      fp:=fpos; bp:=bufpos;
      hd.groesse:=0;
      ReadRfcBody(3+mbox,false,0);     { Mailgre berechnen }
      seek(f1,fp); ReadBuf; bufpos:=bp;
      WriteZcHeader(true);             { ZC-Header erzeugen }
      CheckMem(n,fn,true);
      ReadRfcBody(3+mbox,true,0);      { Body anhngen }
    end;
  until ende;
  close(f1);
  setfattr(f1,0);   { Archivbit abschalten }
  writeln(' - ok');
  start_of_UTF:=false;  { Default setzen! }
  end_of_UTF:=false;    { Default setzen! }
end;


function unbatch(s:string):boolean;
begin
  unbatch:=(left(s,11)='#! cunbatch') or (left(s,11)='#! funbatch') or
           (left(s,11)='#! gunbatch') or (left(s,11)='#! zunbatch');
end;


{ Newsbatch -> ZConnect }

procedure ConvertNewsfile(fn:pathstr);
var       f : file;
       size : longint;
    fp,bp,n : longint;
     freeze : boolean;
       gzip : boolean;
          p : byte;
      newfn : pathstr;
        dir : dirstr;
       name : namestr;
        ext : extstr;
label ende;
begin
  write('news: ',fn);
  OpenFile(fn);
  ReadString(false);
  while unbatch(s) do
  begin
    freeze:=(pos('funbatch',lstr(s))>0);
    gzip:=(pos('gunbatch',lstr(s))>0) or (pos('zunbatch',lstr(s))>0);
    seek(f1,length(s)+1);
    fsplit(fn,dir,name,ext);
{$IFDEF Linux}
    if (ext<>'.Z') or (ext<>'.gz') or (ext<>'.xz') then begin
      if (freeze) then
        newfn:=fn+'.xz'
      else if (gzip) then
        newfn:=fn+'.gz'
      else
        newfn:=fn+'.Z';
    end;
{$ELSE}
    if ext='' then newfn:=fn+'.Z'
    else
      if freeze then newfn:=dir+name+left(ext,2)+'XZ'
      else newfn:=dir+name+left(ext,3)+'Z';
{$ENDIF}
    assign(f,newfn);
    rewrite(f,1);
    fMove(f1,f);
    close(f);
    close(f1);
    close(f2);
    if freeze then
    begin
      write(' - unfreezing news...');
      shell(unfreeze+newfn,500);
    end
    else if gzip then
    begin
      write(' - unzipping news...');
      shell(ungzip+newfn,500);
    end
    else begin
      write(' - uncompressing news...');
      shell(uncompress+newfn,500);
    end;
    reset(f2,1); seek(f2,filesize(f2));
    if exist(newfn) then begin
      writeln(' - Fehler beim Entpacken');
      writeln(uncompress+newfn);halt;
      assign(f,newfn); erase(f);
      exit;
      end;
    OpenFile(fn);
    ReadString(false);
  end;
  n:=0;
  if left(s,2)='#!' then
    if left(s,8)<>'#! rnews' then
    begin
      writeln(' - unbekanntes Batchformat');
      goto ende;
    end
    else begin
      write(sp(8));
      repeat
        while ((pos('#! rnews',s)=0) or (length(s)<10)) and
              (bufpos<bufanz) do
          ReadString(false);
        if bufpos<bufanz then
        begin
          p:=pos('#! rnews',s);
          if p>1 then delete(s,1,p-1);
          inc(n);
          write(dup(6,#8),n:6);
          inc(news);
          start_of_UTF:=true;
          end_of_UTF:=false;
          size:=minmax(ival(mid(s,10)),0,maxlongint);
          fp:=fpos; bp:=bufpos;
          fillchar(hd,sizeof(hd),0);
          if client then
            hd.netztyp:=nt_Client
          else
            hd.netztyp:=nt_RFC;
          ReadString(true);
          ReadRFCheader(1,s);
          seek(f1,fp); ReadBuf; bufpos:=bp;
          { ------------------------------------------------------- }
    {*}   { my: Die so gekennzeichneten Zeilen sind ein Bugfix      }
          {     gem (son-of-)RFC1036, wonach EOLs nur als 1 Byte  }
          {     gezhlt werden drfen, auch wenn es sich um CRLF,   }
          {     CRCRLF o.. handelt.                                }
          {     Mit diesem Fix werden auch News-Batches, die CRLFs  }
          {     als Zeilenabschlu und eine RFC-konforme Lngenan-  }
          {     gabe in der rnews-Zeile haben, korrekt und verlust- }
          {     frei konvertiert (was bisher nicht der Fall war).   }
          {     Da jedoch einige Clients (z.B. XPNews, UKAW v1.37g) }
          {     sich diesbzgl. nicht RFC-konform verhalten und die  }
          {     tatschliche EOL-Lnge in die rnews-Zeile schreiben,}
          {     wird dieser Bugfix dort Datenverlust verursachen.   }
          {     MK (XPNews) ist ber die Problematik informiert (er }
          {     hat diesen Bugfix in 05/2002 selbst in den UUZ von  }
          {     OpenXP/32 eingebaut), bei lteren UKAW-Versionen    }
          {     wie v1.37g kann der Datenverlust vermieden werden,  }
          {     indem man in der Datei <Server>.RC nicht den        }
          {     Default-Eintrag "$newline: crlf" beibehlt, sondern }
          {     ihn in "$newline: lf" abndert.                     }
          {                                                 05/2003 }
          { ------------------------------------------------------- }
          {     Nachtrag: Seit dem 06.06.2003 ist eine gefixte      }
          {     XPNews-Version (v1.2.3) verfgbar, mit der kein     }
          {     Datenverlust mehr entsteht (es werden bei News      }
          {     reine LF-Zeilenenden geschrieben).                  }
          { ------------------------------------------------------- }
          {     Nachtrag: Siehe auch 'ReadRfcBody' in uuz0.pas      }
          {     (Routine fr alle Nachrichtentypen zusammengefat   }
          {     und verlagert)                              04/2004 }
          { ------------------------------------------------------- }
          repeat                           { Header berlesen }
            ReadString(true);
         (* dec(size,length(s)+eol); *)
    {*}     dec(size,length(s)+minmax(eol,0,1));
          until (s='') and (lasteol or (bufpos>=bufanz));
          fp:=fpos; bp:=bufpos;
          ReadRfcBody(1,false,size);  { Gre berechnen }
          WriteZcHeader(false);       { ZC-Header erzeugen }
          CheckMem(n,fn,false);
          seek(f1,fp); ReadBuf; bufpos:=bp;
          ReadRfcBody(1,true,size);   { Body anhngen }
          if bufpos<bufanz then
            ReadString(false);
        end;
      until (bufpos>=bufanz{-8}) or (s='');
      writeln(' - ok');
    end;
ende:
  close(f1);
  setfattr(f1,0);   { Archivbit abschalten }
  if n=0 then writeln;
  start_of_UTF:=false;  { Default setzen! }
  end_of_UTF:=false;    { Default setzen! }
end;


procedure UtoZ;
var sr    : searchrec;
    spath : pathstr;
    s     : string;
    typ   : string[10];   { 'mail' / 'news'   }
    dfile : string[12];   { Name des D.-files }
    p     : byte;
    n     : longint;
    mailuser: string;
    dir,name,ext,bak: string;

  procedure GetStr;   { eine Textzeile aus X.-File einlesen }
  var c : char;
  begin
    s:='';
    repeat
      blockread(f1,c,1);
      if (c=#9) or (c>=' ') then s:=s+c;
    until (c=#10) or eof(f1);
  end;

  function U2DOSfile(s:string):string;
  var i : integer;
      b : byte;
  begin
    s:=s[1]+'-'+right(s,5);
    b:=0;
    for i:=0 to 3 do            { Schreibweise in einem Byte codieren }
      if (s[i+4]>='A') and (s[i+4]<='Z') then
        inc(b,1 shl i);
    U2DOSfile:=s+hex(b,1);
  end;

  procedure ReadXfile;
  begin
    assign(f1,spath+sr.name);
    reset(f1,1);
    typ:=''; dfile:='';
    mailuser:='';
    while not eof(f1) do begin
      GetStr;
      if s<>'' then
        case UpCase(s[1]) of
          'C' : if typ='' then begin    { Befehl: 'rmail' / 'rnews' / 'rsmtp' }
                  s:=trim(mid(s,2));
                  p:=blankpos(s);
                  if p>0 then begin
                    typ:=left(s,p-1); mailuser:=trim(mid(s,p+1));
                    p:=blankpos(mailuser);
                    if p>0 then truncstr(mailuser,p-1);
                    end
                  else typ:=s;
                end;
          'F' : if dfile='' then begin  { zugehriges Datenfile }
                  s:=trim(mid(s,2));
                  dfile:=U2DOSfile(s);
                end;
        end;
      end;
    close(f1);
  end;

  function FileType:shortint;
  var f  : file;
      s  : string[12];
      rr : word;
  begin
    assign(f,spath+sr.name);
    reset(f,1);
    blockread(f,s[1],12,rr);
    close(f);
    s[0]:=chr(rr);
    if left(s,8)='#! rnews' then
      FileType:=1
    else if unbatch(s) then       { '#! cunbatch' / '#! funbatch' }
      FileType:=2
    else if (left(ustr(s),5)='HELO ') or
            ((mbox>0) and (left(s,length(mboxline))=mboxline)) then
      FileType:=3
    else if left(lstr(s),5)='from ' then
      FileType:=4
    else if left(lstr(s),6)='>from ' then
      FileType:=4
    else if rawmail(spath+sr.name) then
      FileType:=5
    else
      FileType:=0;
  end;

begin
  membefore:=memavail;                       { Bezugspunkt fr memory check }
  maxbefore:=maxavail;
  allocMem;                            { Vor evtl. Umbenennung Speicher fr }
  assign(f2,dest);                     { dynamische ZC-Header reservieren   }
  if exist(dest) then
  begin
    if not xp2 then              { FreeXP: existierenden Puffer umbenennen! }
    begin
      FSplit(dest, dir, name, ext);
      if ext = '.BAK' then
        bak := dir + name + '.BA1'
      else
        bak := dir + name + '.BAK';
      era(bak); if ioresult = 0 then ;
      _rename(dest, bak);
      rewrite(f2,1);
    end
    else begin                     { XP2: an existierenden Puffer appenden! }
      reset(f2,1);
      seek(f2,filesize(f2));
    end;
  end
  else rewrite(f2,1);
  outbufpos:=0;
  spath:=GetFileDir(source);
  n:=0;
  findfirst(source,ffAnyFile,sr);
  while doserror=0 do
  begin
    if (mbox=0) and (left(sr.name,2)='X-') then
    begin
      incr(TotalSize,sizeKB(spath+sr.name));
      ReadXFile;                          { X.-file interpretieren }
      LoString(typ);
      if exist(spath+dfile) then
      begin
        incr(TotalSize,sizeKB(spath+dfile));
        inc(n);
        if (typ='rnews') or (typ='crnews') or
           (typ='frnews') or (typ='grnews') then
          ConvertNewsfile(spath+dfile)
        else if typ='rmail' then ConvertMailfile(spath+dfile,SetMailuser(mailuser),false)
        else if (typ='rsmtp') or (typ='crsmtp') or (typ='rcsmtp') or
                (typ='frsmtp') or (typ='rfsmtp') or
                (typ='rzsmtp') or (typ='zrsmtp') or
                (typ='rgsmtp') or (typ='grsmtp') then
          ConvertSmtpFile(spath+dfile,typ<>'rsmtp');
      end;
    end
    else begin
      incr(TotalSize,sizeKB(spath+sr.name));
      inc(n);
      case FileType of
        1,2 : ConvertNewsfile(spath+sr.name);
        3   : begin
                if (n=1) and (mbox>0) then
                  writeln('Conversion of "mbox'+iifs(mbox=1,'o','rd')+
                          '" mailbox format');
                ConvertSmtpFile(spath+sr.name,false);
              end;
        4   : ConvertMailfile(spath+sr.name,'',false);
        5   : ConvertMailfile(spath+sr.name,'',true);  { raw }
      else
        dec(n);
      end;
    end;
    findnext(sr);
  end;
  findclose(sr);
  if n>0 then writeln;
  p:=max(length(strs(mails)),length(strs(news)));
  writeln('Mails: ',mails:p);
  writeln('News : ',news:p);
  flushoutbuf;
  close(f2);
  TotalMsgs:=mails+news;
end;


{ --- ZConnect -> UUCP/RFC ------------------------------------------ }

{$I xpfiles.inc}    { Unix2DOSfile }


function NextUunumber:word;
begin
  NextUunumber:=uunumber;
  if uunumber=65535 then uunumber:=0
  else inc(uunumber);
end;


procedure wrs(var f:file; s:string);
begin
  if length(s)>254 then SetLength(s,254);
  s:=s+#10;
  blockwrite(f,s[1],length(s));
end;

procedure wrs_nolf(var f:file; s:string);
begin
  blockwrite(f,s[1],length(s));
end;


{ my: weitgehender Rewrite 11/2002-04/2003 }

procedure WriteRFCheader(var f:file; mail:boolean);
const smtpfirst : boolean = true;
var s,rfor   : string;
    first,ua : boolean;     { ua: "User-Agent:" erzeugen }
    i,j,p    : integer;
    ep       : empfnodep;
    msgdate,                { Datum der Nachricht (bezogen auf Lokalzeit) }
    msgtime,                { Lokalzeit der Nachricht }
    nowdate,                { aktuelles Datum }
    nowtime,                { aktuelle Lokalzeit }
    msg_TZ,                 { Zeitzone der Nachricht }
    now_TZ   : datetimest;  { aktuelle Zeitzone (Basis: Zeitzone Nachricht) }
    msg_DST,                { Nachrichtendatum => Sommerzeit? }
    now_DST,                { aktuelles Datum => Sommerzeit? }
    use_TZ   : boolean;     { Inhalt der TZ-Variable fr akt. Zone verwenden }

const mlm =  78; { max. Lnge nicht codierter Zeilen bei Folding (Mail) }
      mel =  76; { max. Lnge codierter Zeilen                          }
      mln = 998; { max. Zeilenlnge (News)                              }

  { --------------------------------------------------------------------- }
  { my: 'EncodeFoldQuote' - Neue Routine 11-12/2002                       }
  {                                                                       }
  {     Headerzeile ggf. MIME-decodieren, quoten und/oder folden und in   }
  {     RFC-Header schreiben.                                             }
  { --------------------------------------------------------------------- }
  {                                                                       }
  { - Der Parameter 'LF' definiert, ob bei gefoldeten Headern die letzte  }
  {   Zeile mit einem LF abgeschlossen wird. Dies ist relevant fr den    }
  {   mehrfachen Aufruf dieser Routine hintereinander, wenn mehrere Teile }
  {   eines Headers (z.B. Adresse und Realname oder mehrere Keywords)     }
  {   unabhngig voneinander behandelt, aber unmittelbar nacheinander     }
  {   geschrieben werden sollen.                                          }
  { - In Verbindung damit kann der Routine ber den Parameter 'len' die   }
  {   Zeichenanzahl bergeben werden, die in der (aktuell letzten)        }
  {   Headerzeile bereits geschrieben wurde. Dadurch ist die Routine in   }
  {   der Lage, selbst bei mittels Mehrfach-Aufrufen zusammengesetzten    }
  {   Headerzeilen an der richtigen Stelle zu folden. Wird an 'len' ein   }
  {   negativer Wert bergeben, bedeutet dies, da in der Zeile bereits   }
  {   ein EW vorhanden ist (was Einflu auf die max. zulssige Zeilen-    }
  {   lnge hat).                                                         }
  { - Der Parameter 'id' ist fr den Bezeichner (z.B. "Keywords: ")       }
  {   bestimmt (er darf daher bei Mehrfach-Aufrufen nur beim ersten       }
  {   Aufruf bergeben werden). Der Parameter 'txt' definiert einen       }
  {   String (i.d.R. ein Trennzeichen wie Komma), der nach der Verarbei-  }
  {   tung des bergebenen Strings an diesen angehngt werden soll, z.B.  }
  {   um einen strukturierten Header danach fortzusetzen (siehe z.B. in   }
  {   'WriteKeywords').                                                   }
  { - Rckgabewert der Funktion ist die Anzahl der Zeichen, die in die    }
  {   (letzte) Headerzeile geschrieben wurden und kann dann als Parameter }
  {   'len' z.B. in einem Schleifenaufruf wiederum an die Routine         }
  {   bergeben werden.                                                   }
  { - Auch wenn die Headerzeile MIME-codiert oder gequotet wird und sich  }
  {   dadurch die Gesamtanzahl der Zeichen auf ber 254 erhht, ist unab- }
  {   hngig von der Lnge des bergebenen Strings jetzt sichergestellt,  }
  {   da keine Zeichen mehr verlorengehen oder defekte MIME-Header       }
  {   erzeugt werden (wir arbeiten nicht mit 'insert' und addieren keine  }
  {   Strings).                                                           }
  { - Der Parameter 'quote' bestimmt, ob strukturierte Header gequotet    }
  {   werden sollen (alle 'uline's z.B., die hinsichtlich der bei der     }
  {   Codierung angewandten Regeln als strukturierte Header behandelt     }
  {   werden, drfen nicht gequotet, wohl aber MIME-codiert werden!).     }
  { - Die Routine bercksichtigt hinsichtlich der zu codierenden Zeichen  }
  {   den jeweiligen Kontext (strukturierter/unstrukturierter Header),    }
  {   die in diesem Kontext geltende max. Zeilenlnge bei Mail von 76     }
  {   Zeichen (fr codierte Zeilen) bzw. 78 Zeichen (fr nicht codierte   }
  {   Zeilen) sowie die brigen in RFC2822 niedergelegten Regeln.         }
  { - Bei News werden nur noch Header gefaltet, die lnger als 998        }
  {   Zeichen sind. Folding ist bei News nach wie vor weder blich noch   }
  {   erwnscht und kann zu Problemen bei bestimmten Funktionen ("NOV")   }
  {   mit manchen Newsservern und -Clients fhren, andererseits ist bei   }
  {   Zeilen, die lnger als 998 Zeichen sind, u.U. der sichere Transport }
  {   nicht immer gewhrleistet.                                          }
  { - Es wird jetzt prinzipiell "minimal invasiv" MIME-codiert, d.h. es   }
  {   werden nur noch die Worte codiert, die im jeweiligen Kontext auch   }
  {   zu codierende Zeichen enthalten. Dabei wird fr jedes zu codierende }
  {   Wort der zu verwendende Zeichensatz separat ermittelt. Mehrere zu   }
  {   codierende Words hintereinander, auf die derselbe Zeichensatz ange- }
  {   wandt werden kann, werden zusammengefat und gemeinsam codiert.     }
  { - Die Header "Newsgroups:" und "References:" werden generell nicht    }
  {   gefolded.                                                           }
  { - Nicht codierte Headerzeilen oder Teile davon, die mangels eines     }
  {   Trenners nicht gefolded werden knnen, werden in der vollen Lnge   }
  {   in den RFC-Header geschrieben, auch wenn sie die empfohlene Lnge   }
  {   von max. 76 bzw. 78 Zeichen (Mail) Zeichen berschreiten sollten.   }
  { - Im Subject werden "falsche" Prefixe wie "RE: ", "re:", "AW: " und   }
  {   "Sv: " sowie alle Inkarnationen davon durch das korrekte "Re: "     }
  {   ersetzt.                                                            }
  { - In strukturierten Headern werden Mehrfach-Leerzeichen entfernt.     }
  {                                                                       }
  { --------------------------------------------------------------------- }

  function EncodeFoldQuote(id,txt,hdr:string; len:integer;
                           const MIMEencode,quote,structured,LF:boolean):longint;
  var  cs,firstcs : string[11];
            s1,s2 : string;
      isoCs,hasEW,
           lastEW : boolean;
         c,p,p0,r,
          t,w1,w2,
             fold : integer;

  const blanks : integer = 0;
        mew        = 75;  { max. Lnge von 'encoded words' }
        minEWchars =  5;  { Wenn soviele Zeichen bei gesplitteten EWs }
                          { nicht mehr in das nchste EW in derselben }
                          { Zeile passen, wird der Header gefolded    }

  { Laut RFC2047 5.(3) drfen die folgenden Zeichen in einem   }
  { 'encoded word' in einer "Phrase" eines strukturierten      }
  { Headers (z.B. Realname vor angle-address) nicht vorkommen  }
  { und mssen daher codiert werden. Die ABNF gibt zwar nichts }
  (*dafr her, da das auch fr die Zeichen "#$%&'^`{|}~"     *)
  { gilt, aber getreu dem Motto "be conservative in what you   }
  { send" halten wir uns vorsichtshalber daran und wenden dies }
  { auf strukturierte Header generell (also nicht nur auf      }
  { "Phrasen") an. Dies dient auch der Vereinfachung, weil wir }
  { dann nicht mehr zwischen Kommentar, Phrase usw. unter-     }
  { scheiden mssen und sicher sind, eher zuviel als zuwenig   }
  { zu codieren und somit immer in jedem Kontext gltige       }
  { 'encoded words' zu erzeugen.                               }

  const encodeChars = '"#$%&''(),.:;<>@[\]^`{|}~';

  { Wenn eines der folgenden Zeichen in einem strukturierten  }
  { Header vorkommt, mu der String "gequotet" werden (falls  }
  { er nicht wegen anderer Zeichen ohnehin MIME-codiert wird, }
  { dann mssen diese Zeichen ebenfalls codiert werden). In   }
  { einem 'quoted-string' mssen die Zeichen '"' und '\' dann }
  { als 'quoted-pair' erscheinen.                             }

  const specials2822 = '()<>@,;:\".[]';

    { Prfen, ob Word/String MIME-codiert werden }
    { mu, korrekten Charset setzen und Anzahl   }
    { der zu codierenden Zeichen zurckgeben.    }

    function encodeAnz(s0:string; var w:integer; const HeaderIsEncoded:boolean):integer;
    var       anz,ii : integer;
        hasDelimiter : boolean;
    begin
      anz:=0;
      cs:='';
      iso15:=not noEuro and (cpos(chr(euro),s0)>0);
      { Sonderfall: Word enthlt sowohl Euro als auch '' oder '' }
      { => Word mu gesplittet werden, weil diese Zeichen in ISO15 }
      {    nicht existieren (wohl aber in CP437 und ISO1)!         }
      if iso15 and HeaderIsEncoded and
         ((cpos('',s0)>0) or (cpos('',s0)>0)) then
      begin
        ii:=1;
        while not (s0[ii] in [chr(euro),'','']) do inc(ii);
        if s0[ii]=chr(euro) then
          while not (s0[ii+1] in ['','']) do inc(ii)
        else begin
          iso15:=false;
          while not (s0[ii+1]=chr(euro)) do inc(ii);
        end;
        dec(w,length(s0)-ii);
        s0:=left(s0,ii);
        s2:=s0;
      end;
      setIBM2ISO;
      IBM2ISO(s0,255,false);

      { RFC2047 bestimmt im Abschnitt 7, da jeder String, }
      { der mit '=?' beginnt und mit '?=' endet und keine  }
      { WSPs enthlt, ein gltiges 'encoded word' zu sein  }
      { hat. Wenn von Hand ein entsprechender String in    }
      { den Header geschrieben wurde (' =?abc?= '), mu er }
      { daher codiert werden.                              }
      { Da aber viele Mail-/Newsreader beim Decodieren     }
      { nach dem "robustness principle" verfahren und auch }
      { ungltige EWs (z.B. mit WSPs) decodieren, codieren }
      { wir sicherheitshalber jeden String, der ein '=?'   }
      { oder ein '?=' enthlt.                             }

      hasDelimiter:=(pos('=?',s0)+pos('?=',s0))>0;
      isoCs:=containsumlaut(s0);
      if isoCs or
         (cpos(#0,s0)>0) or
         (cpos(#10,s0)>0) or
         (cpos(#13,s0)>0) or
         (HeaderIsEncoded and structured and multipos(specials2822,s0)) or
         hasDelimiter then
        for ii:=1 to length(s0) do
          if ((s0[ii] in [#0..#31,#127..#255,'_','?','=']) or
              (structured and (cpos(s0[ii],encodeChars)>0))) then
          begin
            inc(anz);
            if not HeaderIsEncoded then break; { beim ersten zu codierenden }
          end;                                 { Zeichen abbrechen          }
      if anz>0 then
      begin
        if not isoCs then
          cs:=RFC_CharsetName(cs_us_ascii)
        else
          cs:=RFC_CharsetName(iif(iso15,cs_iso8859_15,cs_iso8859_1));
      end
      else if not HeaderIsEncoded then
        hdr:=s0;       { IBM => ISOnn, wenn keine zu codierenden Zeichen !! }
      encodeAnz:=anz;
    end;

    { Beginn des nchsten Words ermitteln, }
    { dabei fhrende WSPs ignorieren       }

    function NextWord(const LastWord:integer):integer;
    var p0,p1,p2:integer;
    begin
      p0:=LastWord+1;
      while (p0<length(hdr)) and (hdr[p0] in [' ',#9]) do inc(p0);
      if p0<length(hdr) then
      begin
        p1:=posn(' ',hdr,p0);
        p2:=posn(#9,hdr,p0);
        if p1=0 then
          p0:=p2
        else if p2=0 then
          p0:=p1
        else p0:=min(p1,p2);
      end;
      if p0=0 then p0:=length(hdr);
      if p0<length(hdr) then dec(p0);
      NextWord:=p0;
    end;

    { encoded word bei Erreichen der max. EW-Lnge }
    { abschlieen und in nchstem EW fortsetzen }

    procedure splitEW;
    begin
      s1:=s1+'?=';
      if mail or (not mail and                           { Folding bei Mail }
         (t+length(cs)+8+minEWchars>fold)) then          { Folding bei News }
      begin
        wrs(f,s1);
        t:=0;
        blanks:=0;
      end
      else wrs_nolf(f,s1);                          { kein Folding bei News }
      id:='';
      dec(p);
      s1:=' =?'+cs+'?Q?';
      r:=mew+1;
      c:=length(s1)+2;
      inc(t,c);
    end;

  begin
    hasEW:=len<0;
    len:=abs(len);
    c:=0;
    w1:=0;
    w2:=0;
    t:=len;                   { Anzahl bereits geschriebener Zeichen => 't' }
    firstcs:='';
    s1:='';
    s2:='';
    lastEW:=false;
    if structured then                               { Multi-WSPs entfernen }
    begin
      repeat
        p:=pos('  ',hdr);
        if p>0 then delete(hdr,p,1);
      until p=0;
      repeat
        p:=pos(#9' ',hdr);
        if p>0 then delete(hdr,p,1);
      until p=0;
      repeat
        p:=pos(' '#9,hdr);
        if p>0 then delete(hdr,p+1,1);
      until p=0;
      repeat
        p:=pos(#9#9,hdr);
        if p>0 then delete(hdr,p,1);
      until p=0;
    end;
    if (lstr(left(id,8))='subject:') then         { Bestimmte Prefixe durch }
    begin                                         { 'Re: ' ersetzen         }
      p:=cpos(':',hdr);
      if p>0 then
      begin
        s2:=trim(lstr(left(hdr,p-1)));
        if pos(';'+s2+';',';re;aw;sv;')>0 then
        begin
          id:=id+'Re: ';
          hdr:=ltrim(mid(hdr,p+1));
        end;
      end;
    end;
    p:=0;
    if id<>'' then                                   { Bezeichner schreiben }
    begin
      wrs_nolf(f,id);
      inc(t,length(id));
    end;
    { --------------------------------------------------------------------- }
                                                     { Header MIME-codieren }
    if MIMEencode and (encodeAnz(hdr,w1,false)>0) then while p<length(hdr) do
    begin                                            

      {    r = max. verfgbare Lnge in aktueller     }
      {        Zeile fr aktuelles/nchstes EW (inkl. }
      {        fhrender WSPs!)                       }
      {    c = aktuelle Anzahl der Zeichen im EW      }
      {        (inkl. fhrender WSPs!)                }
      {    t = aktuelle Gesamt-Zeichenanzahl in       }
      {        Headerzeile                            }
      {    p = aktuell bearbeitetes Zeichen in 'hdr'  }
      {   w1 = letztes Zeichen des aktuell in 'hdr'   }
      {        bearbeiteten Teilstrings               }
      { fold = Position, an der gefolded werden *mu* }

      if mail then
        fold:=mel
      else
        fold:=mln;                                { Nchstes Word ermitteln }
      p:=w1;                                      { ('w1' ist das letzte    }
      w1:=NextWord(w1);                           {  Zeichen des Words vor  }
      s2:=copy(hdr,p+1,w1-p);                     {  dem ersten WSP danach) }

      c:=encodeAnz(s2,w1,true);       { 'c' und 'r' temporr fr Anzahl der }
      w2:=w1;  { 'w1' sichern }       { zu codierenden Zeichen mibrauchen  }

      if c>0 then                     { (1): zu codierendes Word bearbeiten }
      begin
        r:=c;
        firstcs:=cs;
        while (r>0) and                             { Mehrere mit demselben }
              (w1<length(hdr)) and                  { Charset zu codierende }
              (cs=firstcs) do                       { Words hintereinander  }
        begin                                       { sammeln               }
          p0:=w2;
          w2:=NextWord(w2);
          s2:=copy(hdr,p0+1,w2-p0);
          r:=encodeAnz(s2,w2,true);
          if (r>0) and (cs=firstcs) then
          begin
            inc(c,r);
            w1:=w2;
          end;
        end;
        cs:=firstcs;                                    { Charset resetten! }

        s2:='=?'+cs+'?Q?';                            { Delimiter EW-Anfang }

        if id='' then
        begin
          s2:=' '+s2;                           { nchstes Leerzeichen nach }
          if not lastEW and (hdr[p+1]=' ') then { Nicht-EW skippen, weil    }
            inc(p);                             { jetzt vor Delimiter       }
        end;

        c:=(w1-p)+(2*c)+length(s2)+2+             { Lnge nchstes EW inkl. }
           iif(w1=length(hdr),                    { evtl. WSPs und 'txt'    } 
               length(txt),0);
        r:=min(mew+(cpos('=',s2)-1),fold-t);       { max. Lnge nchstes EW }
        if (((c>fold-t) and (c<=fold)) or        { Folding vor nchstem EW? }
            (t+length(s2)+minEWchars>fold)) and
            (id='') then
        begin
          wrs(f,s1);                           { vorheriges Word schreiben, }
          t:=0;                                { dann Header folden         }
          blanks:=0;
          r:=mew+(cpos('=',s2)-1);
        end
        else if s1<>'' then                     { vorheriges Word schreiben }
          wrs_nolf(f,s1);

        { --------- bis hier enthielt 's1' das *vorherige* Word! ---------- }

        s1:=s2;                                       { Delimiter EW-Anfang }
        c:=length(s1)+2;                      { '+2' fr Abschlu-Delimiter }
        inc(t,c);

        s2:=hdr;                                        { ISO-Konvertierung }
        iso15:=not noEuro and
               (cpos(chr(euro),copy(hdr,p+1,w1-p))>0); { Teilstring auf     }
        setIBM2ISO;                                    { Charset prfen und }
        IBM2ISO(s2,255,false);                         { ISO-Tabelle setzen }

        while p<w1 do                                    { Word(s) codieren }
        begin
          inc(p); inc(c); inc(t);
          if (s2[p]<=#31) or                 { (1a): zu codierendes Zeichen }
             (s2[p]>=#127) or
             (s2[p] in ['_','?','=']) or
             (structured and (cpos(s2[p],encodeChars)>0)) then
          begin                                    { zu codierendes Zeichen }
            if (c+2+iif(w1=length(hdr),length(txt),0)<=r) and
               (t<=fold) then
            begin                                            { qp-Codierung }
              s1:=s1+'='+hex(ord(s2[p]),2);
              inc(c,2);
              inc(t,2);
            end
            else begin                       { pat nicht mehr, EW splitten }
              splitEW;
              continue;      { Teil des EW geschrieben, Schleife fortsetzen }
            end;
          end
          else begin                   { (1b): nicht zu codierendes Zeichen }
            if (c+iif(w1=length(hdr),length(txt),0)<=r) and
               (t<=fold) then
            begin
              s1:=s1+s2[p];                           { uncodiertes Zeichen }
              if s2[p]=' ' then                       { in EW => s1         }
                s1[length(s1)]:='_';
            end
            else begin                       { pat nicht mehr, EW splitten }
              splitEW;
              continue;      { Teil des EW geschrieben, Schleife fortsetzen }
            end;
          end;
        end;
        s1:=s1+'?=';                   { Ende EW, Abschlu-Delimiter setzen }
        hasEW:=true;
        lastEW:=true;
        id:='';
      end

      else begin                { (2): nicht zu codierendes Word bearbeiten }
        c:=(w1-p)+                           { Lnge neues Word inkl. 'txt' }
           iif(w1=length(hdr),length(txt),0);
        r:=iif(mail,iif(hasEW,mel,mlm),mln)-t;    { max. Lnge neues Word   }

        if (c>r) and (id='') then                 { Folding vor neuem Word? }
        begin
          wrs(f,s1);                           { vorheriges Word schreiben, }
          t:=0;                                { dann Header folden         }
          blanks:=0;
          s1:='';
          hasEW:=false;
        end;

        if s1<>'' then                          { vorheriges Word schreiben }
          wrs_nolf(f,s1);

        s1:=copy(hdr,p+1,w1-p);                      { aktuelles Word => s1 }
        inc(t,length(s1));
        iso15:=false;
        setIBM2ISO;
        IBM2ISO(s1,255,false);                          { ISO-Konvertierung }
        lastEW:=false;
        id:='';
      end;

      if p>=length(hdr) then                       { letztes Word schreiben }
        if LF then
        begin
          wrs_nolf(f,s1);
          wrs(f,txt);
          t:=0;
          blanks:=0;
        end
        else begin
          wrs_nolf(f,s1);
          wrs_nolf(f,txt);
          inc(t,length(txt));
        end;

    end
    { --------------------------------------------------------------------- }
    else if quote and structured and                        { Header quoten }
            multipos(specials2822,hdr) then
    begin
      {  r = max. Restanzahl der pro Zeile zur }
      {      Verfgung stehenden Zeichen       }
      {  p = aktuelle Position in 'hdr'        }
      {  c = aktuelle Position in 's1'         }
      {  t = aktuelle Gesamt-Zeichenanzahl in  }
      {      Headerzeile                       }
      { w1 = Position des letzten WSP in 'hdr' }
      { w2 = Position des letzten WSP in 's1'  }
      if len=0 then              { fortgesetzter Header (z.B. 'Keywords:')? }
      begin
        w1:=-1; w2:=-1;          { wenn nicht, erst ab zweitem Word folden, }
      end;                       { um keine leeren Headerzeilen zu erzeugen }
      r:=1;
      while hdr[r] in [' ',#9] do inc(r);
      if r>1 then                    { DQUOTE *hinter* fhrende WSPs setzen }
      begin
        s1:=left(hdr,r-1);
        inc(p,r-1);
        inc(c,r-1);
        inc(t,r-1);
        if w2>=0 then
        begin
          w1:=r-1; w2:=r-1;
        end;
      end;
      s1:=s1+'"'; inc(c); inc(t);
      r:=iif(mail,iif(hasEW,mel,mlm),mln);          { max. Zeichen in Zeile }
      while p<length(hdr) do
      begin
        inc(p); inc(c); inc(t);
        if (hdr[p] in [' ',#9]) then
        begin
          if w2>=0 then
          begin
            w1:=p;                            { letztes WSP in 'hdr' merken }
            w2:=c;                            { letztes WSP in 's1'  merken }
          end;
        end
        else begin                            { Zeichen <> WSP => ab jetzt  }
          if w2<0 then                        { WSPs merken und ggf. folden }
          begin
            w1:=0; w2:=0;
          end;
          if hdr[p] in ['"','\'] then
          begin
            s1:=s1+'\';
            inc(c); inc(t);
          end;
        end;
        s1:=s1+hdr[p];
        if (((p<length(hdr)) and (t>r)) or      { Folding ntig und mglich }
            ((p=length(hdr)) and               { Damit Zeile nicht wegen    }
             (t+1+length(txt)>r))) and         { abschlieendem DQUOTE bzw. }
           (w2>0) then                         { 'txt' lnger als 'r' wird  }
        begin
          s2:=mid(s1,w2);
          s1:=left(s1,w2-1);                       { zurck zum letzten WSP }
          wrs(f,s1);
          s1:=s2;
          c:=length(s1); t:=c;
          w1:=-1; w2:=-1;          { erst wieder ab zweitem Word folden, um }
          hasEW:=false;            { keine leeren Headerzeilen zu erzeugen  }
          if mail then
            r:=mlm
          else
            r:=mln;
          if p=length(hdr) then            { wenn am Headerende angekommen, }
            wrs_nolf(f,s1);                { letztes Word schreiben         }
        end
        else if (c>=sizeof(s1)-3) or                         { berlauf von }
                (p=length(hdr)) then                         { s1 vermeiden }
        begin
          wrs_nolf(f,s1);
          s1:='';
          c:=0; w1:=0; w2:=0;
        end;
      end;
      if LF then
      begin
        wrs_nolf(f,'"');
        wrs(f,txt);
        t:=0;
        blanks:=0;
      end
      else begin
        wrs_nolf(f,'"');
        wrs_nolf(f,txt);
        inc(t,1+length(txt));                { fr letztes DQUOTE und 'txt' }
      end;
    end
    { --------------------------------------------------------------------- }
    else while hdr<>'' do          { Header weder MIME-codieren noch quoten }
    begin
      { r = max. Anzahl der pro Zeile zur }
      {     Verfgung stehenden Zeichen   }
      { p = aktuelle Position in 'hdr'    }
      r:=max(0,iif(mail,iif(hasEW,mel,mlm),mln)-t-blanks);   { max. Zeichen }
      p:=length(hdr)+length(txt);
      if (p>r) and              { Headerlnge > max. Zeilenlnge => Folding }
         (t+length(trim(hdr))+
          length(trim(txt))>0) then    { aber keine leeren Zeilen erzeugen! }
      begin
        p:=min(r+1,length(hdr));
        while (p>0) and                        { letztes WSP vor 'r' suchen }
              not (hdr[p] in [' ',#9]) do
          dec(p);
        if (p<1) or                          { kein WSP vorhanden oder      }
           ((trim(left(hdr,p))='') and       { String nur aus WSPs gefunden }
            (((len>0) and (t=0)) or
             ((len=0) and (t<=length(id))))) then
          p:=NextWord(r);                      { erstes WSP nach 'r' suchen }
        if trim(left(hdr,p))='' then       { Nur-Leerzeichen nicht anhngen }
          p:=0
        else if (hdr[p] in [' ',#9]) then
          dec(p);
        id:='';
        hasEW:=false;
      end;
      s1:=left(hdr,p);
      if p<byte(hdr[0]) then
        hdr:=mid(hdr,p+1)
      else
        hdr:='';
      if LF or (hdr<>'') then   { Jede nicht-letzte bzw. einzige (wenn 'LF' }
      begin                     { true) Headerzeile mit LF abschlieen      }
        wrs_nolf(f,s1);
        wrs(f,iifs(hdr='',txt,''));     { Bei letzter Zeile 'txt' schreiben }
        t:=0;
        blanks:=0;
      end
      else begin                         { Einzige bzw. letzte Zeile eines  }
        wrs_nolf(f,s1);                  { langen Headers ohne LF schreiben }
        wrs_nolf(f,txt);
        if t+length(trim(s1))+
           length(trim(txt))>0 then
        begin
          inc(t,length(s1)+length(txt));
          blanks:=0;
        end
        else inc(blanks,length(s1)+length(txt));
      end;
    end;
    EncodeFoldQuote:=iif(hasEW,t*-1,t);
  end;  { of Encode FoldQuote }


  { my: Neue Routine                            05/2004 }
  {     (Schreiben langer RFC-Header bis 65500 Zeichen) }
  function WriteLongRfcHdr(const n:byte; Id:string;
                           const structured:boolean):boolean;
  var rlen      : word;
      hpos,opos : byte;
      hdr       : string;

    procedure GotoPreviousNonBlankIfAny;
    begin
      while (hpos>0) and (LongHdr[n].hdr^[hpos] in [' ',#9]) do dec(hpos);
      if (hpos=0) then hpos:=opos;
    end;

    procedure GotoEndOfPreviousWordIfAny;
    begin
      while (hpos>0) and not (LongHdr[n].hdr^[hpos] in [' ',#9]) do dec(hpos);
      if hpos=0 then
        hpos:=opos
      else
        GotoPreviousNonBlankIfAny;
    end;

  begin
    if (LongHdr[n].hdr<>nil) then
    begin
      WriteLongRfcHdr:=true;
      p:=0;
      rlen:=LongHdr[n].len;   { noch zu schreibende Restlnge }
      while rlen>0 do
      begin
        hpos:=min(255,rlen);  { Position im (Rest-)Header }
        opos:=hpos;           { Ausgangsposition merken   }
        if hpos<rlen then
        begin
          if LongHdr[n].hdr^[hpos] in [' ',#9] then
            GotoPreviousNonBlankIfAny
          else if not (LongHdr[n].hdr^[hpos+1] in [' ',#9]) then
            GotoEndOfPreviousWordIfAny;
        { else: Pos. 255 befindet sich bereits am Ende eines Worts! }
        end;
        byte(hdr[0]):=hpos;
        fastmove(LongHdr[n].hdr^[1],hdr[1],hpos);
        if hpos<rlen then
          move(LongHdr[n].hdr^[hpos+1],LongHdr[n].hdr^[1],rlen-hpos);
        dec(rlen,hpos);
        p:=EncodeFoldQuote(id,iifs((rlen=0) and LongHdr[n].trunc,
                                   LongHdr[n].rest+truncater,''),
                           hdr,p,true,false,structured,rlen=0);
        id:='';
      end;
    end
    else WriteLongRfcHdr:=false;
  end;


  function month(m:string):string;
  begin
    month:=copy('Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec ',
                ival(m)*4-3,4);
  end;

  { --------------------------------------------------------- }
  { asc=false: Datums-/Zeitstring in RFC-Format umwandeln     }
  {            (fr "Date:"-Header, Quelle: EDA:-Header)      }
  {            (fr "Received:"-Header, akt. Zeit)            }
  {            "Fri, 31 Dec 1999 23:01:00 +0100"              }
  {                                                           }
  { asc=true : Datums-/Zeitstring in asctime-Format umwandeln }
  {            (fr "From_"-Zeile in UUCP-Mails, akt. Zeit)   }
  {            "Fri Dec 31 23:01:00 1999"                     }
  {                                                           }
  { dateS    = Datum im Format "31.12.1999"                   }
  { timeS    = Zeit  im Format "23:01:00"                     }
  { --------------------------------------------------------- }

  function RFCdate(const dateS,timeS,TZ:datetimest; const asc:boolean):string;
  begin
    if dateS<>'' then
    begin
      RFCdate:=copy('MonTueWedThuFriSatSun',dow(dateS)*3-2,3)+
        iifs(asc,'',', ')+
        iifs(asc,'',left(dateS,2))+' '+month(copy(dateS,4,2))+
        iifs(asc,iifs(dateS[1]='0',' '+copy(dateS,2,1),left(dateS,2)),
                 right(dateS,4))+
        iifs(timeS='','',' '+timeS)+
        iifs(asc,' '+right(dateS,4),iifs(TZ='','',' '+TZ));
    end
    else RFCdate:='';
  end;


  function formnews(s:string):string;
  var p : byte;
  begin
    if s[1]='/' then delfirst(s);
    repeat
      p:=cpos('/',s);
      if p>0 then s[p]:='.';
    until p=0;

{ 03.09.1999 robo - bei Netztyp RFC Gruppennamen nicht nach }
{ lowercase wandeln wegen Macrosuff-Schrottnewsservern }

    if hd.netztyp in [nt_RFC, nt_Client]
      then formnews:=s
      else

{ /robo }

    formnews:=lstr(s);
  end;


  { my: einzelne eMail-Adresse (auch mit Realname) }
  {     codieren/quoten/folden/schreiben   12/2002 }

  procedure WriteAddress(const id:string; var adr,rn:string);
  begin
    if rn<>'' then
    begin
      p:=EncodeFoldQuote(id,'',rn,0,true,true,true,false);
      if abs(p)+length(adr)+3 >                     { '3' = ' ' + '<' + '>' }
         iif(mail,iif(p<0,mel,mlm),mln) then         { 'p<0' = EW vorhanden }
        wrs(f,'');
      wrs(f,' <'+adr+'>');                                  { Header folden }
    end
    else wrs(f,id+'<'+adr+'>');
  end;


  { my: From:-Header (auch mit mehreren Adressen und Realnames) }
  {     codieren/quoten/folden/schreiben                05/2004 }

  procedure WriteFrom;
  var   id : string;
         i : byte;
  begin
    id:='From: ';
    i:=0;
    p:=0;
    with hd do while (i<absanz) and (xabs<>nil) do
    begin
      inc(i);
      if xabs^[i].name^<>'' then
      begin
        p:=EncodeFoldQuote(id,'',iifs(id<>'','',' ')+xabs^[i].name^,p,
                           true,true,true,false);
        id:='';
      end;
      p:=EncodeFoldQuote(id,iifs(i<absanz,',',''),
                         iifs(id<>'','',' ')+'<'+xabs^[i].adr^+'>',p,
                         false,false,true,absanz<=i);
      id:='';
    end;
  end;


  { my: Cc:-Header folden/schreiben   01/2003 }

  procedure WriteCCs;
  var   id : string;
         t : integer;
      more : boolean;

    function moreCCs:boolean;            { weitere Cc-Empfnger vorhanden? }
    var p : empfnodep;
    begin
      p:=empflist^.next;
      while (p<>nil) and
            (cpos('@',p^.empf)=0) do
        p:=p^.next;
      moreCCs:=p<>nil;
    end;

  begin
    id:='Cc: ';
    t:=0;
    first:=true;
    while empflist<>nil do
    begin
      if not hd.nokop then
      begin
        if cpos('@',empflist^.empf)>0 then               { Mail-Empfnger? }
        begin
          more:=moreCCs;
          t:=EncodeFoldQuote(id,iifs(more,',',''),
                             iifs(first,'',' ')+'<'+empflist^.empf+'>',t,
                             false,false,true,not more);
          id:='';
          first:=false;
        end;
      end;
      ep:=empflist^.next;
      dispose(empflist);
      empflist:=ep;
    end;
  end;

  procedure WriteNewsgroups;   { Newsgroups nicht folden! }
  var s : string;
      p : empfnodep;
  begin
    s:='Newsgroups: '+formnews(hd.empfaenger);
    wrs_nolf(f,s);
    while empflist<>nil do
    begin
      s:=','+formnews(empflist^.empf);
      wrs_nolf(f,s);
      p:=empflist^.next;
      dispose(empflist);
      empflist:=p;
    end;
    wrs(f,'');
  end;

  { my: Keywords codieren/quoten/folden/schreiben   12/2002 }

  procedure WriteKeywords;
  var  t : integer;
      id : string;
  begin
    t:=0;
    id:='Keywords: ';
    if keystart<>nil then
    begin
      first:=true;
      keylauf:=keystart;
      while keylauf<>nil do
      begin
        t:=EncodeFoldQuote(id,iifs(keylauf^.next=nil,'',','),
                           iifs(first,'',' ')+keylauf^.s^,t,
                           true,true,true,keylauf^.next=nil);
        keylauf:=keylauf^.next;
        id:='';
        first:=false;
      end;
      DisposeKeywordList;
    end;
  end;

  function maintype(const ctype:byte):string;
  begin
    case ctype of
      tText        : maintype:='text';
      tApplication : maintype:='application';
      tImage       : maintype:='image';
      tMessage     : maintype:='message';
      tMultipart   : maintype:='multipart';
      tAudio       : maintype:='audio';
      tVideo       : maintype:='video';
      tModel       : maintype:='model';
      else           maintype:='application';
    end;
  end;

  { my: "Content-Type:"-Parameter bei multipart/* folden/schreiben/anhngen }

  procedure WriteCT_MultiPar(const par,val:string);
  begin
    if length(s)+length(par)+length(val)+4>mlm then  { 4 = '; '+'""' }
    begin
      s:=s+';';
      wrs(f,s);
      s:=#9+par+'="'+val+'"';
    end else
      s:=s+'; '+par+'="'+val+'"';
  end;

  procedure WriteContentDisposition;
  var fpar  : string;
      fdata : boolean;
  begin
    with hd do
    begin
      if datei<>'' then
      begin
        datei:=trim(datei);
        QuoteStr(datei,true);
      end;
      fdata:=(ddatum<>'') or (hd.groesse>0);
      wrs(f,'Content-Disposition: attachment'+
            iifs(datei<>'','; filename="'+datei+'"','')+
            iifs(fdata,';',''));
      if fdata then
      begin
        fpar:=#9;
        if ddatum<>'' then
        begin
          fpar:=fpar+'modification-date="'+
                RFCdate(copy(ddatum,7,2)+'.'+copy(ddatum,5,2)+'.'+
                        left(ddatum,4),copy(ddatum,9,2)+':'+
                        copy(ddatum,11,2)+':'+copy(ddatum,13,2),
                        '-0000',false)+'"';
          if hd.groesse>0 then fpar:=fpar+'; size='+strs(hd.groesse);
        end
        else if hd.groesse>0 then
          fpar:=fpar+'size='+strs(hd.groesse);
        wrs(f,fpar);
      end;
    end;
  end;

  { -------------------------------------------------- }
  { my: Zustzliche Header aus MAIL/NEWS.RFC anhngen  }
  {                                                    }
  {     Die Dateien werden in 'initvar' geprft,       }
  {     bleiben (sofern OK) zur Laufzeit geffnet, und }
  {     werden erst in 'donevar' wieder geschlossen.   }
  {                                            12/2005 }
  { -------------------------------------------------- }

  procedure AddHeaders(var hf:file);
  var crlf,
      hdfsize,
      newsize  : word;
      hdrbuf   : LongHdrP;
  begin
    reset(hf,1);
    hdfsize:=FileSize(hf);
    if maxavail>=hdfsize then
    begin
      getmem(hdrbuf,hdfsize);
      blockread(hf,hdrbuf^,hdfsize);
      newsize:=hdfsize;
      repeat
        if posLong('U-',hdrbuf,1,newsize,false)=1 then     { "U-" entfernen }
        begin
          dec(newsize,2);
          move(hdrbuf^[3],hdrbuf^[1],newsize);
        end;
        crlf:=min(posLong(#13#10,hdrbuf,1,newsize,true),
                  posLong(#10,hdrbuf,1,newsize,true));
        if crlf=0 then crlf:=newsize+1;                          { kein EOL }
        blockwrite(f,hdrbuf^,crlf-1);
        wrs(f,'');
        while (crlf<hdfsize) and (hdrbuf^[crlf+1] in [#13,#10]) do inc(crlf);
        if crlf<newsize then
        begin
          dec(newsize,crlf);
          move(hdrbuf^[crlf+1],hdrbuf^[1],newsize);
          crlf:=0;
        end;
      until crlf>=newsize;
      freemem(hdrbuf,hdfsize);
    end;
  end;

begin  { of WriteRFCheader }
  with hd do
  begin
    msgtime:='';
    msgdate:='';
    msg_TZ:='';
    nowdate:=date;
    nowtime:=time;
    ua:=(LongHdr[LProg].hdr=nil) and    { "User-Agent:" erzeugen? }
        UserAgent(programm);
    if getTZ(now_TZ) then        { Zeitzone aus TZ-Variable holen }
    begin
      use_TZ:=true;
      p:=cpos(':',now_TZ);
      if p=0 then p:=byte(now_TZ[0])+1;
      now_TZ:=now_TZ[2]+formi(ival(copy(now_TZ,3,p-3)),2)+
              formi(ival(mid(now_TZ,p+1)),2);
    end
    else begin        { Default: MEZ/MESZ (nur falls "EDA:" leer) }
      use_TZ:=false;
      now_DST:=sommer(nowdate,nowtime);
      now_TZ:=iifs(now_DST,'+0200','+0100');
    end;
    if (length(zdatum)>7) and (length(datum)>5) then
    begin
      { my: Ggf. Jahr bei Jahrhundertwechsel korrigieren,   }
      {     damit bei Nachrichten, die als lokales Datum in }
      {     'hd.datum' bereits den 01.01.00 (zweistellige   }
      {     Jahreszahl!), als UTC-Datum in 'hd.zdatum' aber }
      {     noch den 31.12.1999 ausweisen, nicht wie bisher }
      {     durch das blinde Kopieren der ersten beiden     }
      {     Ziffern der Jahreszahl aus 'zdatum' das lokale  }
      {     RFC-Datum "01 Jan 1900" erzeugt wird.           }
      msgdate:=copy(datum,5,2)+'.'+copy(datum,3,2)+'.'+
               iifs(((copy(zdatum,3,2)='99') and (left(datum,2)='00')),
                      strs(ival(left(zdatum,2))+1)+left(datum,2),
                      left(zdatum,2)+left(datum,2));
      if (length(zdatum)>13) and (length(datum)>9) then
        msgtime:=copy(datum,7,2)+':'+copy(datum,9,2)+':'+copy(zdatum,13,2);
      if (length(zdatum)>16) and (upcase(zdatum[15]) in ['W','S']) and
         (zdatum[16] in ['+','-']) and (zdatum[17] in ['0'..'9']) then
      begin
        p:=cpos(':',zdatum);
        if p=0 then p:=byte(zdatum[0])+1;
        msg_TZ:=zdatum[16]+formi(ival(copy(zdatum,17,p-17)),2)+
                formi(ival(mid(zdatum,p+1)),2);
        if right(msg_TZ,4)='0000' then            { bei TZ '0000' immer '+' }
          msg_TZ[1]:='+';
        if not use_TZ then                      { TZ-Variable nicht gesetzt }
        begin
          msg_DST:=sommer(msgdate,msgtime);
          p:=ival(left(msg_TZ,3))+      { 'p' fr akt. Zeitzone mibrauchen }
             iif(not msg_DST and now_DST,1,
                 iif(msg_DST and not now_DST,-1,0));
          now_TZ:=iifs(p<0,'-','+')+formi(abs(p),2)+right(msg_TZ,2);
        end;
      end;
    end;
    if mail then
    begin
      if wab='' then s:=absender          { Envelope erzeugen }
      else s:=wab;
      p:=cpos('@',s);
      if SMTP then
      begin
        if smtpfirst or client then
        begin
          wrs(f,'HELO '+mid(s,p+1));
          smtpfirst:=false;
        end;
        wrs(f,'MAIL FROM:<'+s+'>');
        if cpos('@',hd.empfaenger)>0 then
          wrs(f,'RCPT TO:<'+hd.empfaenger+'>');
        ep:=empflist;
        while ep<>nil do
        begin
          if cpos('@',ep^.empf)>0 then
            wrs(f,'RCPT TO:<'+ep^.empf+'>');
          ep:=ep^.next;
        end;
        wrs(f,'DATA');
      end
      else wrs(f,'From '+left(s,p-1)+' '+
                 RFCdate(nowdate,nowtime,now_TZ,true)+ { akt. Datum/Uhrzeit }
                 ' remote from '+mid(s,p+1));
      if (wab<>'') and (cpos('@',oem)>0) and not smtp   { (*1) - s.u. }
        then rfor:=empfaenger
      else rfor:='';
      if (add_gate<>'') or nomailer then
        xp_received:=''
      else if not ua then
        xp_received:=programm;

      { 'Received:' aus Einzelteilen zusammenbauen, um keine Zeichen }
      { zu verlieren und Header nicht hart folden, sondern via       }
      { 'EncodeFoldQuote' in Abhngigkeit von der Lnge              }

      p:=EncodeFoldQuote('Received: ','','by '+mid(s,cpos('@',s)+1),0,
                         false,false,true,false);
      if xp_received<>'' then
      begin
        p:=EncodeFoldQuote('','',' (',p,
                           false,false,true,false);
        p:=EncodeFoldQuote('',')'+iifs(rfor<>'','',';'),xp_received,p,
                           false,false,true,false);
      end;
      if rfor<>'' then
        p:=EncodeFoldQuote('','',' for '+rfor+';',p,
                           false,false,true,false);
      EncodeFoldQuote('','',' '+RFCdate(nowdate,nowtime,now_TZ,false),p,
                      false,false,true,true);
    end
    else if not client or (add_gate<>'') then
      if not WriteLongRfcHdr(LPath,'Path: ',false) and   { Langen Path-     }
         (pfad<>'') then                                 { Header schreiben }
        wrs(f,'Path: '+pfad);                               { Backdoor Path }
    WriteFrom;
    if wab<>'' then
      WriteAddress('Sender: ',wab,war);
    if mail then
    begin
      if (wab<>'') and (cpos('@',oem)>0)   { s. (*1) }
        then wrs(f,'To: <'+oem+'>')
        else wrs(f,'To: <'+empfaenger+'>');
      first:=true;
      uuz0.s:='';
      WriteCCs;
    end else
      WriteNewsgroups;
    wrs(f,'Message-ID: <'+msgid+'>');
    if ref<>'' then
    begin

      { 03.09.1999 robo - References einigermassen RFC-konform krzen }
      { 30.11.2002   my - von 980 auf 998 Zeichen erweitert (RFC2822) }

      repeat
        j:=12+length(ref)+2;
        for i:=1 to addrefs do j:=j+length(addref[i])+3;
        if j>mln then begin
          FastMove(addref[2],addref[1],(maxrefs-1)*sizeof(addref[1]));
          dec(addrefs);
        end;
      until j<=mln;

      { /robo }

      if mail then
        wrs(f,'In-Reply-To: <'+iifs(addrefs>0,addref[addrefs],ref)+'>');

      { my: References bei News nicht mehr folden, manche }
      {     News-Server/Clients kommen mit gefoldeten     }
      {     References:-Headern nicht zurecht.    11/2002 }

      wrs_nolf(f,'References: <'+ref+'>'+iifs(mail or (addrefs=0),#10,''));
      for i:=1 to addrefs do
        wrs_nolf(f,' <'+addref[i]+'>'+iifs(mail or (i=addrefs),#10,''));

      { /my }

    end;

    if xp2 then control:=betreff;               { XP2-Cancel-Kompatibilitt }
    if (attrib and attrControl<>0) and (pos('cancel ',control)>0) then
      if not xp2 then
      begin
        insert ('<',control,8);
        wrs(f,'Control: '+control+'>');
      end
      else wrs(f,'Control: '+control);
    if mail and (lstr(betreff)='<none>') then
      betreff:='';
    if not WriteLongRfcHdr(LSub,'Subject: ',false) then  { Langen Subject-  }
    begin                                                { Header schreiben }
      if (betreff<>'') then
        EncodeFoldQuote('Subject: ','',betreff,0,        { Backdoor Subject }
                        true,false,false,true)
      else if not mail then                     { 'Subject: ' bei News auch }
        wrs(f,'Subject: ');                     { erzeugen, wenn leer!      }
    end;
    wrs(f,'Date: '+iifs(msgdate<>'',RFCdate(msgdate,msgtime,msg_TZ,false),
                                    RFCdate(nowdate,nowtime,now_TZ,false)));
    if keystart<>nil then
      WriteKeywords;
    if not WriteLongRfcHdr(LSum,'Summary: ',false) and   { Langen Summary-  }
       (summary<>'') then                                { Header schreiben }
      EncodeFoldQuote('Summary: ','',summary,0,
                      true,false,false,true);            { Backdoor Summary }
    if not nomailer then
    begin
      if ua then                                       { "User-Agent:" fr  }
        EncodeFoldQuote('User-Agent: ','',programm,0,  { XP-Header kreieren }
                        true,false,false,true)
      else if mail then
      begin
        if not WriteLongRfcHdr(LProg,'X-Mailer: ',false) { Langen Mailer-   }
           and (programm<>'') then                       { Header schreiben }
          EncodeFoldQuote('X-Mailer: ','',programm,0,
                          true,false,false,true);         { Backdoor Mailer }
      end
      else begin
        if not WriteLongRfcHdr(LProg,'X-Newsreader: ', { Langen Newsreader- }
                               false) and              { Header schreiben   }
           (programm<>'') then                        
          EncodeFoldQuote('X-Newsreader: ','',programm,0,
                          true,false,false,true);     { Backdoor Newsreader }
      end;
    end;

    { X-No-Archive Konvertierung }
    if xnoarchive then wrs(f,'X-No-Archive: yes');

    { X-Priority Konvertierung }
    if priority<>0 then wrs(f,'X-Priority: '+strs(priority));

    { my: Content-Type auch bei US-ASCII schreiben! }
    {     (wegen news.t-online.de)                  }

    if mpart or binaer or (mime.charset<>'') or (mime.subtype<>'plain') then
    with mime do
    begin
      wrs(f,'MIME-Version: '+mversion);
      s:='Content-Type: '+maintype(ctype)+'/'+subtype;
      case ctype of
        tText        : if charset<>'' then s:=s+'; charset='+charset;
        tMultipart   : begin
                         WriteCT_MultiPar('boundary',xpboundary);
                         if mimereltyp<>'' then         { multipart/related }
                         begin
                           WriteCT_MultiPar('type',mimereltyp);
                           if mimerelstart<>'' then              { "start=" }
                             WriteCT_MultiPar('start',mimerelstart);
                           if mimerelsinfo<>'' then         { "start-info=" }
                             WriteCT_MultiPar('start-info',mimerelsinfo);
                         end;
                       end;
      end;
      wrs(f,s);        { Content-Type (letzte oder einzige Zeile) schreiben }

      { my: CTE-Header immer schreiben! }

      case encoding of
        enc7bit   : s:='7bit';
        enc8bit   : s:='8bit';
        encQP     : s:='quoted-printable';
        encBase64 : s:='base64';
        encBinary : s:='binary';
      end;
      wrs(f,'Content-Transfer-Encoding: '+s);

      { RFC 2183 }
      if binaer and (attrib and AttrMPbin=0) then   { Singlepart-Attachment }
        WriteContentDisposition;

    end;

    if not mail and (distribution<>'') then
      wrs(f,'Distribution: '+distribution);
    if PmReplyTo<>'' then
      wrs(f,'Reply-To: '+pmreplyto);
    if pm_reply then
      wrs(f,'Followup-To: poster')
    else
      if not mail and (AmReplyTo<>'') then
        wrs(f,'Followup-To: '+formnews(AmReplyTo));
    if mail and (attrib and attrReqEB<>0) then
      wrs(f,'Return-Receipt-To: '+iifs(empfbestto<>'',empfbestto,
            iifs(wab<>'',wab,iifs(pmReplyTo='',absender,pmReplyTo))));
    if mail and (pgpflags and fPGP_encoded<>0) then
      wrs(f,'Encrypted: PGP');
    if not WriteLongRfcHdr(LOrg,'Organization: ',false) and { Langen Org.-  }
       (organisation<>'') then                           { Header schreiben }
      EncodeFoldQuote('Organization: ','',organisation,0,
                      true,false,false,true);       { Backdoor Organisation }
    if not WriteLongRfcHdr(LPost,'X-ZC-Post: ',false) and { Langen Post-    }
       (postanschrift<>'') then                          { Header schreiben }
      EncodeFoldQuote('X-ZC-Post: ','',postanschrift,0,
                      true,false,false,true);      { Backdoor Postanschrift }
    if not WriteLongRfcHdr(LTele,'X-ZC-Telefon: ',false) and { Langen Tel.- }
       (telefon<>'') then                                { Header schreiben }
      EncodeFoldQuote('X-ZC-Telefon: ','',telefon,0,
                      true,false,false,true);            { Backdoor Telefon }
    if not WriteLongRfcHdr(LHome,'X-Homepage: ',false) and { Langen Homep.- }
       (homepage<>'') then                               { Header schreiben }
      wrs(f,'X-Homepage: '+homepage);                   { Backdoor Homepage }
    if XPointCtl<>0 then
      wrs(f,'X-XP-Ctl: '+strs(XPointCtl));
    if ersetzt<>'' then
      wrs(f,'Supersedes: <'+ersetzt+'>');
    if fido_to<>'' then
      wrs(f,'X-Comment-To: '+fido_to);
    { ----------- zustzliche Header in MAIL/NEWS.RFC schreiben ----------- }
    if (mail and MailHdrFileOK) then
      AddHeaders(MailHdrFile)
    else if (not mail and NewsHdrFileOK) then
      AddHeaders(NewsHdrFile);
    { ----------- /zustzliche Header in MAIL/NEWS.RFC schreiben ---------- }
    if (add_gate='') and not noxpver and (pos(lstr(xp_name),lstr(programm))>0) then
      EncodeFoldQuote('X-XP-Version: ','',programm,0,true,false,false,true);
    if add_gate='' then
      wrs(f,'X-RFC-Converter: '+SProgname+' ['+xp_display+' '+
          verstr+uuzsubver+betastr+'] @ '+uuztime(false,0))
    else if not WriteLongRfcHdr(LGate,'X-Gateway: ',     { Langen Gateway-  }
                                false) then              { Header schreiben }
    begin
      if gateway<>'' then                                { Backdoor Gateway }
        EncodeFoldQuote('X-Gateway: ','',gateway,0,true,false,false,true)
      else                                         { eigener Gateway-Header }
        EncodeFoldQuote('X-Gateway: ','',add_gate,0,true,false,false,true);
    end;
    for i:=1 to ulines do
    begin
      p:=cpos(':',uline^[i]);
      if p>1 then
      begin
        s:=mid(uline^[i],p+1);
        if s[1] in [' ',#9] then delfirst(s);
        EncodeFoldQuote(left(uline^[i],p)+' ','',s,0,true,false,true,true);
      end;
    end;
    if not mail then
      wrs(f,'Lines: '+strs(lines+iif(attrib and AttrMPbin<>0,16,0)));
    wrs(f,'');
    if binaer and (attrib and AttrMPbin<>0) then     { Multipart-Attachment }
    begin
      { Anzahl der Zeilen incl. Trailer oben bei Lines einsetzen! }
      wrs(f,'--'+xpboundary);
      wrs(f,'Content-Type: text/plain');
      wrs(f,'');
      wrs(f,'Diese Nachricht enthaelt eine MIME-codierte Binaerdatei. Falls Ihr');
      wrs(f,'Mailer die Datei nicht decodieren kann, verwenden Sie dafuer bitte');
      wrs(f,'ein Tool wie ''munpack'' oder ''udec''.');
      wrs(f,'');
      wrs(f,'This message contains a MIME encoded binary file. If your mailer');
      wrs(f,'cannot decode the file, please use a decoding tool like ''munpack''.');
      wrs(f,'');
      wrs(f,'--'+xpboundary);
      GetBinType(datei);                     { MIMETYP.CFG fr CT auswerten }
      wrs(f,'Content-Type: '+maintype(mime.ctype)+'/'+mime.subtype);
      wrs(f,'Content-Transfer-Encoding: base64');
      { RFC 2183 }
      WriteContentDisposition;

      wrs(f,'');
    end;
  end;
end;  { of WriteRFCheader }


procedure WriteRfcTrailer(var f:file);
begin
  if binaer and (hd.attrib and AttrMPbin<>0) then
    wrs(f,'--'+xpboundary+'--');
end;


procedure ZtoU;
const maxqplines = 11;   { max. 25 qp-codierte Zeichen pro Zeile mit 253 Z. }
      maxqplen   = 76;
      maxlinelen = 998;
var hds,adr : longint;
    fs,n,gs : longint;
    mail,ok : boolean;
    f       : file;
    fn      : string[12];
    fc      : text;
    server  : string;       { Adresse UUCP-Fileserver }
    files   : longint;
    copycount : integer;    { fr Mail-'CrossPostings' }
    ldstr   : string[2];
    ovrwrt  : boolean;
    qplines : array[1..maxqplines] of string[maxqplen+2];   { +2 = '.' + LF }
    bodyline,
    nextline: array[1..maxlinelen+1] of char;               { +1 = '.' }
    linelen,
    nextlen : word;
    DotAdded: boolean;

  procedure resetVars;
  var i : byte;
  begin
    for i:=1 to maxqplines do qplines[i]:='';
    linelen:=0; nextlen:=0;
    DotAdded:=false;
    fillchar(bodyline,sizeof(bodyline),#0);
    fillchar(nextline,sizeof(bodyline),#0);
  end;

  procedure FlushOutbuf(var f:file);
  begin
    if outbufpos>0 then
      blockwrite(f,outbuf^,outbufpos);
    outbufpos:=0;
  end;

  procedure wrbuf(var f:file; var ss:string; const LF:boolean);
  begin
    if LF then
    begin
      if length(ss)<255 then inc(byte(ss[0]));
      ss[length(ss)]:=#10;
    end;
    if outbufpos+length(ss)>=outbufsize then
      FlushOutbuf(f);
    FastMove(ss[1],outbuf^[outbufpos],length(ss));
    inc(outbufpos,length(ss));
  end;

  procedure MakeXfile(sender:string);
  var name,name2 : string[14];
      mail,smtp  : boolean;
      nr         : string[4];
      fs         : longint;
  begin
    mail:=(sender='mail');
    smtp:=(sender='smtp');
    nr:=hex(NextUunumber,4);
    assign(f2,dest+'X-'+nr+'.OUT');
    rewrite(f2,1);
    if mail or smtp then wrs(f2,'U '+MailUser+' '+_from)
    else wrs(f2,'U '+NewsUser+' '+_from);
    name:=fn[1]+'.'+left(_from,7)+iifc(mail or smtp,'C','d')+right(fn,4);
    wrs(f2,'F '+name);
    wrs(f2,'I '+name);
    if smtp and csmtp then
      wrs(f2,'C rcsmtp')
    else if smtp and fsmtp then
      wrs(f2,'C rfsmtp')
    else if smtp and zsmtp then
      wrs(f2,'C rgsmtp')
    else
      wrs(f2,'C r'+sender+iifs(mail,' '+hd.empfaenger,''));
    fs:=filesize(f2);
    close(f2);
    name2:=fn[1]+'.'+left(_to,7)+'D'+right(fn,4);
    write(fc,'S ',name2,' ',name,' ',iifs(mail or smtp,MailUser,NewsUser),
             ' - ',name2,' 0666');
    if ParSize then writeln(fc,' "" ',_filesize(dest+fn+'.OUT'))
    else writeln(fc);
    name2:='D.'+left(_to,7)+'X'+nr;
    write(fc,'S ',name2,' X.',left(_from,7),iifc(mail or smtp,'C','d'),nr,' ',
             iifs(mail or smtp,MailUser,NewsUser),' - ',name2,' 0666');
    if ParSize then writeln(fc,' "" ',fs)
    else writeln(fc);
  end;

  procedure WrFileserver;
  var p        : byte;
      fromfile : string;
      tofile   : string[40];
      request  : boolean;
      transfer : boolean;
      tfiles   : integer;

    function slashs(fn:pathstr):pathstr;
    var i : byte;
    begin
      for i:=1 to length(fn) do
        if fn[i]='\' then fn[i]:='/';
      slashs:=fn;
    end;

    procedure WriteTransfer(s:string);
    begin
      writeln(fc,'S ',slashs(fromfile),' ',s,' ',FileUser,' - ',
              getfilename(fromfile),' 0666' +
              iifs(ParSize,' "" '+strs(_filesize(fromfile)),''));
    end;

  begin
    request:=(ustr(hd.betreff)='REQUEST');
    transfer:=(hd.attrib and attrFile)<>0;
    if transfer then begin
      fromfile:=hd.betreff;
      if not exist(fromfile) then begin
        writeln(' warning: ',fromfile,' not found!');
        exit;
        end;
      tfiles:=0;
      end;
    seek(f1,adr+hds);
    ReadBuf;
    while fpos+bufpos<adr+hds+hd.groesse do
    begin
      ReadString(false);
      s:=trim(s);
      if (s<>'') and (s[1]<>'#') then
      begin
        if request then
        begin
          p:=blankpos(s);
          if p=0 then
          begin
            fromfile:=s;
            if Uselfn then tofile:=Unix2LFNfile(s,'');
            if not Uselfn then tofile:=Unix2DOSfile(s,'');
          end
          else begin
            fromfile:=left(s,p-1);
            tofile:=trim(mid(s,p+1));
          end;
          writeln(fc,'R ',fromfile,' ',tofile,' ',FileUser,' -');
        end
        else begin
          WriteTransfer(s);
          inc(tfiles);
        end;
        inc(files);
      end;
    end;
    if transfer and (tfiles=0) then
      WriteTransfer(lstr(getfilename(fromfile)));
  end;

  { String abkrzen, falls Zeile nicht mit CR/LF beendet }
  { und nachfolgendes EMP: angehngt wurde               }

  procedure ShortS;
  begin
    s:=left(s,max(0,integer(length(s))-(fpos+bufpos-gs)+2));
  end;

  { --------------------------------------------------------------- }
  { my: Body-Zeile ISO-konvertieren, ggf. qp-codieren und schreiben }
  {                                               03/2003 + 04/2004 }
  { --------------------------------------------------------------- }
  {     Bugfixes/nderungen:                                        }
  {     - Lange nicht qp-codierte Zeilen werden nicht mehr nach 253 }
  {       Zeichen umbrochen (sondern gem RFC1036/2882 nach 998    }
  {       Zeichen bzw. dem letzten WSP davor).                      }
  {     - Beim berschreiten der max. Zeilenlnge von 998 Zeichen   }
  {       und anschlieendem Umbruch bzw. bei fortgesetzten qp-     }
  {       Zeilen wird in SMTP-Mails jetzt auch in diesen Fllen der }
  {       evtl. notwendige zustzliche "." hinzugefgt (wenn die    }
  {       neue Zeile ebenfalls mit einem "." beginnt). Bei der      }
  {       Berechnung der max. Zeilenlnge wird dieser Punkt nicht   }
  {       bercksichtigt.                                           }
  {     - Bei der qp-Codierung kann kein Zeichenverlust bei langen  }
  {       Strings durch 'insert' mehr entstehen.                    }
 (*     - Lo-ASCIIs und die EBCDIC-kritischen Zeichen !"#$@[\]`{|}~ *)
  {       werden bei -qp jetzt codiert.                             }
  {     - Das letzte WSPs am Ende einer Zeile wird bei -qp jetzt    }
  {       codiert (und damit auch automatisch bei Sigtrennern).     }
  {     - Die zwei XP-typischen WSPs am Zeilenende (und nur die)    }
  {       werden jetzt entfernt.                                    }
  {                                                                 }
  { Diese Routine setzt auf der momentanen Logik von 'ReadString'   }
  { auf! Sollte diese Logik gendert werden, sind mglicherweise    }
  { auch hier Anpassungen erforderlich.                             }
  { --------------------------------------------------------------- }

  procedure WriteS(var f0:file; const write:boolean);
  var qp,sMoved : boolean;
              i : word;

    { my: Die vom XP-Editor bei "fortlaufend umbrochenen Abstzen"   }
    {     erzeugten zwei Leerzeichen - und *nur* die - am Zeilenende }
    {     entfernen (ein oder mehr als zwei Leerzeichen bleiben      }
    {     erhalten!). Dabei Sonderflle bei Pos. 253-255 abfangen,   }
    {     gleichzeitig 'eol' setzen (auch, um nicht entfernte Blanks }
    {     am Zeilenende korrekt qp-codieren zu knnen) und Buffer-   }
    {     position korrigieren.                                      }

    procedure remove_xp_blanks;
    var c1,c2,c3,c4 : char;

      { Nchstes Zeichen im Buffer prfen, falls vorhanden }
      function nextchar(const p:byte):char;
      begin
        if fpos+bufpos+p<gs then       { 'bufpos' steht hier bereits }
          nextchar:=buffer[bufpos+p]   { auf dem *nchsten* Zeichen! }
        else
          nextchar:=#0;        { Ende des Buffers bzw. der Nachricht }
      end;

    begin
      { --- Fall #1: eol und '  ' am Zeilenende --- }
      {     (fr Zeilenlngen bis 252 Zeichen)      }
      if (eol>0) and (byte(s[0])>2) and (right(s,2)='  ') and
         (s[byte(s[0])-2]<>' ') then
        s:=rtrim(s)
      else if (eol=0) and (byte(s[0])=MaxReadLen) then
      begin
        c1:=nextchar(0);  { letztes Zeichen im String +1 lesen }
        c2:=nextchar(1);  { letztes Zeichen im String +2 lesen }
        c3:=nextchar(2);  { letztes Zeichen im String +3 lesen }
        c4:=nextchar(3);  { letztes Zeichen im String +4 lesen }
        { --- Fall #2: kein eol und '  ' an Pos. 253/254 --- }
        if (lastchar(s)=' ') and (s[byte(s[0])-1]<>' ') and
           (c1=' ') and (c2 in [#0,#13,#10]) then
        begin
          inc(eol);
          if (c2=#13) and (c3=#10) then inc(eol);
          inc(bufpos);
          if c2<>#0 then inc(bufpos,eol);
          s:=rtrim(s);
        end
        { --- Fall #3: kein eol und '  ' an Pos. 254/255 --- }
        else if (lastchar(s)<>' ') and (c1=' ') and
                (c2=' ') and (c3 in [#0,#13,#10]) then
        begin
          inc(eol);
          if (c3=#13) and (c4=#10) then inc(eol);
          inc(bufpos,2);
          if c3<>#0 then inc(bufpos,eol);
        end;
      end;
    end;

    { Hier wird geprft, ob es machbar und sinnvoll ist, den Anfang   }
    { von 'nextline' an das Ende von 'bodyline' zu verschieben. Das   }
    { ist dann der Fall, wenn im entsprechenden Teil von 'nextline'   }
    { WSPs vorkommen oder wenn in 'nextline' bzw. 's' gar keine WSPs  }
    { vorkommen und das Wort daher ohnehin auseinandergerissen wrde. }
    { Sinn und Zweck ist, einerseits die max. Zeilenlnge mglichst   }
    { vollstndig auszunutzen, andererseits aber Worte nicht durch    }
    { Zeilenumbrche mitten im Wort auseinanderzureien (vorausge-    }
    { setzt, das Wort wrde vollstndig in die nchste Zeile passen). }

    function rewrap:boolean;
    var       p0 : word;
        DotFirst : boolean;
    begin
      rewrap:=false;
      if nextlen=0 then exit;
      DotFirst:=mail and SMTP and (linelen>=2) and   { '.' nicht mitzhlen! }
                (bodyline[1]='.') and (bodyline[2]='.');
      DotAdded:=mail and SMTP and (nextlen>=2) and   { '.' nicht mitzhlen! }
                (nextline[1]='.') and (nextline[2]='.');
      p0:=(maxlinelen-linelen)+byte(DotAdded)+byte(DotFirst);
      if p0>byte(DotAdded) then
      begin
        if not (nextline[p0+1] in [' ',#9]) then  { genau Ende eines Worts? }
        begin
          while (p0>0+byte(DotAdded)) and not (nextline[p0] in [' ',#9]) do dec(p0);
          while (p0>0+byte(DotAdded)) and (nextline[p0] in [' ',#9]) do dec(p0);
        end;
        if p0<=byte(DotAdded) then                     { kein vollstndiges }
        begin                                          { Wort links von p0  }
          p0:=(maxlinelen-linelen)+byte(DotAdded)+byte(DotFirst)+1;
          while (p0<=nextlen) and not (nextline[p0] in [' ',#9]) do inc(p0);
          if (p0>nextlen) and
             (sMoved or                                      
              (not sMoved and                     { null WSPs in Folgezeile }
               (blankpos(left(s,maxlinelen+byte(DotFirst)-nextlen))=0))) then
            p0:=(maxlinelen-linelen)+byte(DotAdded)+byte(DotFirst)
          else
            p0:=byte(DotAdded);                { WSPs rechts von p0 in      }
        end;                                   { Folgezeile => kein rewrap! }
      end;
      if p0>byte(DotAdded) then      { Anfang 'nextline' => Ende 'bodyline' }
      begin
        rewrap:=true;
        dec(p0,byte(DotAdded));
        fastmove(nextline[1+byte(DotAdded)],bodyline[linelen+1],p0);
        inc(linelen,p0);
        inc(p0,byte(DotAdded));
        dec(nextlen,p0);
        DotAdded:=mail and SMTP and (nextline[p0+1]='.');     { neu setzen! }
        if DotAdded then nextline[1]:='.';
        move(nextline[p0+1],nextline[1+byte(DotAdded)],nextlen);
        inc(nextlen,byte(DotAdded));
      end;
    end;

    { lange Zeile bis 998 Zeichen schreiben }

    procedure WrBodyline(const next2body:boolean);
    var bs    : string;
        ll,ls : word;
    begin
      ll:=0;                         { Anzahl bereits geschriebener Zeichen }
      while ll<linelen do
      begin
        ls:=min(254,linelen-ll);
        fastmove(bodyline[ll+1],bs[1],ls);
        bs[0]:=chr(ls);
        inc(ll,ls);
        if write then wrbuf(f0,bs,ll>=linelen)       { Teilstring schreiben }
        else if ll>=linelen then inc(hd.lines);
      end;
      linelen:=0;
      fillchar(bodyline,sizeof(bodyline),#0);
      if next2body then
      begin
        bodyline:=nextline;                      { 'nextline' => 'bodyline' }
        linelen:=nextlen;
        nextlen:=0;
        fillchar(nextline,sizeof(nextline),#0);
      end;
      DotAdded:=false;
    end;

    procedure sMoveToNextline;
    begin
      if mail and SMTP and (nextlen=0) and (firstchar(s)='.') then
      begin
        nextline[1]:='.';
        inc(nextlen);
      end;
      fastmove(s[1],nextline[nextlen+1],byte(s[0]));
      inc(nextlen,byte(s[0]));
    end;

    procedure MakeQuotedPrintable;
    var      ii,p : byte;                    {EBCDIC}     { ------- EBCDIC ------ }

      function WSP_at_eol:boolean;
      begin
        WSP_at_eol:=(eol>0) and (p=byte(s[0])) and (s[p] in [#9,' ']);
      end;

    const qprchar = [#0..#8,#11,#12,#14..#31,'!'..'$','=','@','['..'^','`','{'..'~',#127..#255];
    begin
      ii:=1;
      p:=1;
      DotAdded:=mail and SMTP and       { zustzlicher '.' bei neuem String }
                ((LastEol and (left(s,2)='..')) or
                 (not LastEol and (left(qplines[ii],2)='..')));
      while (p<=length(s)) and (ii<=maxqplines) do
      begin
        if length(qplines[ii])-byte(DotAdded) >      { '.' nicht mitzhlen! }
           ((maxqplen-iif((eol=0) or (p<length(s)),4,3)) +
            iif((s[p] in qprchar) or WSP_at_eol,0,2)) then
        begin
          qplines[ii]:=qplines[ii]+'='#10;             { soft line break    }
          inc(ii);                                     { (Zeile fortsetzen) }
        end;
        if (ii>1) and (length(qplines[ii])=0) then
        begin
          if mail and SMTP and (s[p]='.') then    { '.' bei fortgesetzten   }
          begin                                   { Zeilen in SMTP-Mails    }
            qplines[ii]:='.';                     { hinzufgen, falls ntig }
            DotAdded:=true;
          end
          else DotAdded:=false;
        end;
        if (s[p] in qprchar) or WSP_at_eol then
          qplines[ii]:=qplines[ii]+'='+hex(ord(s[p]),2)      { qp-Codierung }
        else
          qplines[ii]:=qplines[ii]+s[p];
        inc(p);
      end;
      if eol>0 then qplines[ii]:=qplines[ii]+#10;
    end;

  begin  { of WriteS }
    qp:=MakeQP and (hd.mime.encoding=encQP);
    remove_xp_blanks;                      { 2 WSPs am Zeilenende entfernen }
    if write and convcharset then
      IBM2ISO(s,254,false);
    { ===================================== qp-codierte Zeile schreiben === }
    if qp then
    begin
      MakeQuotedPrintable;
      i:=1;
      while (qplines[i]<>'') and (i<=maxqplines) do
      begin
        if (eol=0) and                         { wenn Body-Zeile noch nicht }
           ((i=maxqplines) or                  { beendet ist, letzte qpline }
            (qplines[i+1]='')) then            { nicht schreiben, sondern   }
        begin                                  { nach qplines[1] sichern!   }
          if i>1 then
          begin
            qplines[1]:=qplines[i];
            qplines[i]:='';
          end;
          break;
        end;
        if write then
          wrbuf(f0,qplines[i],false)                      { Zeile schreiben }
        else
          inc(hd.lines);
        qplines[i]:='';
        inc(i);
      end;
    end
    { =============================== nicht qp-codierte Zeile schreiben === }
    else begin
      { -------------------------------- Zeile <= 253 Zeichen schreiben --- }
      if lasteol and (eol>0) then 
      begin
        if write then
          wrbuf(f0,s,true)
        else
          inc(hd.lines);
      end
      else begin
        DotAdded:=mail and SMTP and (linelen>=2) and
                  (bodyline[1]='.') and (bodyline[2]='.');
        { ---------------------------- Zeile 254..998 Zeichen schreiben --- }
        if (nextlen=0) and (linelen+byte(s[0])<=maxlinelen+byte(DotAdded)) then
        begin
          fastmove(s[1],bodyline[linelen+1],byte(s[0]));
          inc(linelen,byte(s[0]));
          if eol>0 then WrBodyline(false);       { aktuelle Zeile schreiben }
        end
        { ------------------------------- Zeile > 998 Zeichen schreiben --- }
        else begin
          DotAdded:=mail and SMTP and (nextlen>=2) and
                    (nextline[1]='.') and (nextline[2]='.');
          if nextlen+byte(s[0])<=maxlinelen+Byte(DotAdded) then
          begin
            sMoveToNextline;
            if eol>0 then
            begin
              rewrap;
              WrBodyline(true);                 { vorherige Zeile schreiben }
              WrBodyline(false);                { aktuelle  Zeile schreiben }
            end;
          end
          else begin                    { 's' pat nicht mehr in 'nextline' }
            sMoved:=false;
            if rewrap and                                  { pat 's' jetzt }
               (nextlen+byte(s[0])<=maxlinelen) then       { in 'nextline'? }
            begin
              sMoveToNextline;
              sMoved:=true;
            end;
            WrBodyline(true{!});                { vorherige Zeile schreiben }
            if not sMoved then    { *mu* passen, 'nextline' ist jetzt leer }
              sMoveToNextline;
            if eol>0 then
            begin
              { 'sMoved' kann (und mu!) hier nur dann false  }
              { sein, wenn 's' in der unmittelbar vorherigen  }
              { Anweisung nach 'nextline' gemoved wurde. Es   }
              { wird hier temporr auf true gesetzt, damit    }
              { 'rewrap' nicht unntig auf WSPs in 's' prft  }
              { und daraus evtl. falsche Schlsse zieht ('s'  }
              { befindet sich in Wirklichkeit ja bereits in   }
              { 'nextline', aber 'sMoved' mu fr den Aufruf  }
              { von 'WrBodyline' weiterhin auf false stehen). }
              if not sMoved then
              begin
                sMoved:=true;
                rewrap;
                sMoved:=false;
              end;
              WrBodyline(not sMoved);           { aktuelle Zeile schreiben }
              if not sMoved then
                WrBodyline(false);      { evtl. berhang aus 's' schreiben }
            end;
          end;
        end;
      end;
    end;
  end;  { of WriteS }

  procedure CreateNewfile;
  begin
    repeat
      fn:=ldstr+hex(NextUunumber,4);
    until not exist(dest+fn+'.OUT') or ovrwrt;
    assign(f2,dest+fn+'.OUT');
    rewrite(f2,1);
  end;

  { my: Extern-Modus - Bei ZConnect-Nachrichten (= nicht mit }
  {     einer RFC-Box von FreeXP erzeugt) Body auf Hi-ASCIIs }
  {     prfen und Charset/Encoding entsprechend setzen      }

  procedure checkBody4CharsetEncoding;
  var is8bit : boolean;
          cs : word;
  begin
    with hd.mime do
    begin
      if mpart or (ctype=tMessage) then exit;
      { Sonderfall: UTF-7-Nachrichten nicht auf 8bit-Zeichen untersuchen! }
      if not convcharset and (hd.charset=RFC_CharsetName(cs_utf_7)) then
      begin
        charset:=hd.charset;
        encoding:=enc7bit;
        exit;
      end;
      is8bit:=false;
      iso15:=false;
      charset:=RFC_CharsetName(cs_us_ascii);
      if encoding<>encQP then
        encoding:=enc7bit;
      seek(f1,adr+hds);
      ReadBuf;
      gs:=min(adr+hds+hd.groesse,filesize(f1));
      while (fpos+bufpos<gs) and not
            (is8bit and ((convcharset and (noEuro or iso15)) or not convcharset)) do
      begin
        ReadString(true);
        if fpos+bufpos>gs then ShortS;
        if convcharset then
        begin
          iso15:=not noEuro and (cpos(chr(euro),s)>0);
          setIBM2ISO;
          IBM2ISO(s,254,false);
        end;
        if containsumlaut(s) then
        begin
          if convcharset then
            charset:=RFC_CharsetName(iif(iso15,cs_iso8859_15,cs_iso8859_1))
          else
            charset:=hd.charset;   { 'CHARSET: <charset>' }
          if MakeQP then
            encoding:=encQP
          else
            encoding:=enc8bit;
          is8bit:=true;
        end;
      end;
    end;
  end;

  procedure WriteNews(const write:boolean);
  begin
    if bufpos=0 then eol:=1;            { damit lasteol am Anfang true wird }
    ReadString(true);
    if fpos+bufpos>gs then ShortS;
    WriteS(f,write);                          { konvertiert auch IBM => ISO }
  end;

begin
  new(uline);
  keystart:=nil;
  incr(TotalSize,sizeKB(source));
  assign(f1,source);
  reset(f1,1);
  adr:=0; n:=0;
  if not client then begin
    assign(fc,dest+'C-'+hex(NextUunumber,4)+'.OUT');   { "C."-File }
    rewrite(fc);
  end;
  if filesize(f1)<10 then
  begin
    close(f1);
    if not client then close(fc);
    exit;
  end;
  assign(f,OwnPath+TempFileName);
  rewrite(f,1);
  server:=ustr(UUserver+'@'+_to);
  files:=0;

  ldstr:=iifs(client,'N','D-');
  ovrwrt:=not client;
  mail:=false;

  if not client then CreateNewfile;         { 1. Durchgang: News }
  fs:=filesize(f1);
  repeat
    resetVars;
    seek(f1,adr);
    empflist:=nil;
    makeheader(true,f1,1,0,hds,hd,ok,false);
    if not ok then
    begin
      close(f1);
      close(f); erase(f);
      error('fehlerhafter Eingabepuffer!');
    end;
    gs:=min(adr+hds+hd.groesse,filesize(f1));
    if (hd.empfaenger<>'') and (cpos('@',hd.empfaenger)=0) then     { AM }
    begin
      SetMimeData;
      inc(n);
      if n=1 then write(#13'News:'+sp(9));
      write(dup(6,#8),n:6);
      if client then CreateNewFile;
      seek(f1,adr+hds);
      if binaer then
        hd.lines:=(hd.groesse+53) div 54    { Anzahl Base64-Zeilen }
      else begin
        ReadBuf;
        while fpos+bufpos<gs do             { Zeilen zhlen }
          WriteNews(false);
        resetVars;
        if checkbody then
          checkBody4CharsetEncoding;
      end;
      seek(f,0);
      WriteRFCheader(f,false);
      seek(f1,adr+hds);   { Text kopieren }
      ReadBuf;
      outbufpos:=0;
      iso15:=not noEuro and
             (hd.mime.charset=RFC_CharsetName(cs_iso8859_15));
      setIBM2ISO;
      if binaer then
        while fpos+bufpos<gs do
        begin
          ReadBinString(gs-fpos-bufpos);
          wrbuf(f,s,true);
        end
      else while fpos+bufpos<gs do
        WriteNews(true);
      flushoutbuf(f);
      WriteRfcTrailer(f);
      truncate(f);
      if not client then wrs(f2,'#! rnews '+strs(filesize(f)));
      seek(f,0);
      fmove(f,f2);
      if client then close(f2);
    end;
    disposeempflist(empflist);
    DisposeAbsList;
    DisposeAllLongHdr;
    inc(adr,hds+hd.groesse);
  until adr>fs-10;
  empflist:=nil;
  if not client then close(f2);
  if n=0 then
  begin
    if not client then erase(f2);
  end
  else begin
    if not client then MakeXfile('news');
    writeln;
  end;
  close(f); erase(f);
  inc(TotalMsgs,n);

  adr:=0; n:=0;                             { 2. Durchgang: Mail }

  ldstr:=iifs(client,'M','D-');
  mail:=true;

  if SMTP and not client then CreateNewfile;
  repeat
    resetVars;
    copycount:=1;
    repeat
      seek(f1,adr);
      makeheader(true,f1,copycount,0,hds,hd,ok,false);
      if cpos('@',hd.empfaenger)>0 then
      begin
        SetMimeData;
        if ustr(left(hd.empfaenger,length(server)))=server then
        begin
          if not client then WrFileserver;
        end
        else begin
          inc(n);
          if n=1 then write(#13'Mails:'+sp(8));
          write(dup(6,#8),n:6);
          if not SMTP or client then
            CreateNewfile;
          if binaer then
            seek(f1,adr+hds)
          else if checkbody then
            checkBody4CharsetEncoding;
          WriteRFCheader(f2,true);
          seek(f1,adr+hds);                 { Text kopieren }
          ReadBuf;
          gs:=min(adr+hds+hd.groesse,filesize(f1));
          outbufpos:=0;
          iso15:=not noEuro and
                 (hd.mime.charset=RFC_CharsetName(cs_iso8859_15));
          setIBM2ISO;
          if binaer then while fpos+bufpos<gs do
          begin
            ReadBinString(gs-fpos-bufpos);
            wrbuf(f2,s,true);
          end
          else while fpos+bufpos<gs do
          begin
            if bufpos=0 then eol:=1;    { damit lasteol am Anfang true wird }
            ReadString(true);
            if fpos+bufpos>gs then ShortS;
            if SMTP and lasteol and (firstchar(s)='.') then s:='.'+s;
            WriteS(f2,true);                  { konvertiert auch IBM => ISO }
          end;
          flushoutbuf(f2);
          WriteRfcTrailer(f2);
          if SMTP then
          begin
            wrs(f2,'.');                { Ende der Mail }
            if client then
            begin
              wrs(f2,'QUIT');
              close(f2);
            end;
          end
          else begin
            close(f2);
            if not client then MakeXfile('mail');
          end;
        end;
      end;
      disposeempflist(empflist);
      DisposeAbsList;
      DisposeAllLongHdr;
      if SMTP then copycount:=hd.empfanz;
      inc(copycount);
    until copycount>hd.empfanz;
    inc(adr,hds+hd.groesse);
  until adr>fs-10;
  if n>0 then writeln;
  if files>0 then
    writeln('Files: ',files);
  if SMTP and not client then
  begin
    wrs(f2,'QUIT');
    close(f2);
    if n=0 then erase(f2)
    else if not client then MakeXfile('smtp');
  end;
  close(f1);
  if not client then close(fc);
  dispose(uline);
  inc(TotalMsgs,n);
end;


procedure SetWindow;
var y : byte;
begin
  y:=wherey;
  close(output); assigncrt(output); rewrite(output);
  window(1,4,80,xpwindow-2);
  gotoxy(1,y-3);
end;



begin
  Randomize;
  ShellPath:=dospath(0);             { aktuelles Verzeichnis ohne "\"       }
  if lastchar(ShellPath)<>DirSepa then
    ShellPath:=ShellPath+DirSepa;    { aktuelles Verzeichnis mit "\"        }
  GetOwnPath;                        { UUZ-Verzeichnis mit "\"              }
  if ShellPath<>OwnPath then
    GoDir(OwnPath);                  { um die XP_NTVDM.DLL finden zu knnen }
  {$IFNDEF NO386}
  InitWinVersion;
  {$ENDIF}
  GetRunOS;               { OS-Plattform fr Logo-Ausgabe und "User-Agent:" }
  if ShellPath<>OwnPath then
    GoDir(ShellPath);                { zurck zum aktuellen Verzeichnis     }
  logo;
  initvar;
  {$IFNDEF NO386}
  DestructWinVersion;                { brauchen wir ab hier nicht mehr      }
  {$ENDIF}
  getpar;
  testfiles;
  if XpWindow>0 then SetWindow;
  uuzstartdate:=get_date;
  uuzstarttime:=get_time;
  if u2z then UtoZ
  else ZtoU;
  run_time:=time_diff(uuzstarttime,get_time);
  if (TotalSize>0) and (TotalMsgs>0) then
  begin
    writeln;
    if run_time>0 then 
      writeln(strsr(TotalSize,2) + ' KB processed in ' + strSecs(run_time) +
              ' at ' + strsr(TotalSize/run_time,2) + ' KB/sec and ' +
              strsr(TotalMsgs/run_time,2) + ' messages/sec')
    else
      writeln(strsr(TotalSize,2) + ' KB processed in less than 1/100 sec');
  end;
  donevar;
end.
