{ ------------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.                   }
{ (c) 1991-1999 Peter Mandrella                                       }
{ (c) 2000-2001 OpenXP-Team                                           }
{ (c) 2002-2025 FreeXP, http://www.freexp.de                          }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.         }
{                                                                     }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der     }
{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html }
{ ------------------------------------------------------------------- }

(***********************************************************)
(*                                                         *)
(*                      UNIT typeform                      *)
(*                                                         *)
(*             Strings und Typkonvertierungen              *)
(*                                                         *)
(***********************************************************)

{$I XPDEFINE.INC }

unit typeform;


{  ==================  Interface-Teil  ===================  }

interface

uses
  xpglobal, dos, lfn;

{$IFNDEF DPMI}
  const  Seg0040 = $40;
         SegA000 = $a000;
         SegB000 = $b000;
         SegB800 = $b800;
{$ENDIF}

type DateTimeSt = string[11];
     s20        = string[20];
     s40        = string[40];
     s60        = string[60];
     s80        = string[80];
     atext      = s80;

Function Bin(l:longint; n:byte):string;      { Bin-Zahl mit n Stellen       }
Function Blankpos(const s:string):byte;        { Position von ' ' oder #9     }
Function CountChar(const c: char; const s: string): integer; { zaehlt c in s }
Function CPos(c:char; const s:string):byte;    { schnelles POS fr CHARs      }
Function CPosX(c:char; const s:string):byte;   { pos=0 -> pos:=length(s)+1    }
Function Date:DateTimeSt;                    { dt. Datumsstring             }
Function Dup(const n:integer; const c:Char):string;      { c n-mal duplizieren          }
Function Even(const l:longint):boolean;            { not odd()                    }
Function FileName(var f):string;                { Dateiname Assign             }
Function FirstChar(const s:string):char;           { s[1]                         }
Function fitpath(path:string; n:byte):pathstr;   {+ Pfad evtl. abkrzen    }
Function FormI(const i:longint; const n:Byte):string;    { i-->str.; bis n mit 0 auff.  }
Function HBar(const len:byte):string;              { ...Ĵ      }
Function Hex(const l:longint; const n:byte):string;      { Hex-Zahl mit n Stellen       }
Function HexVal(const s:string):longint;           { Hex-Val                      }
Function iif(b:boolean; l1,l2:longint):longint; { IIF Integer               }
Function iifb(b,b1,b2:boolean):boolean;         { IIF Boolean               }
Function iifc(b:boolean; c1,c2:char):char;      { IIF Char                  }
Function iifr(b:boolean; r1,r2:real):real;      { IIF Real                  }
Function iifs(b:boolean; const s1,s2:string):string;  { IIF String                }
Function IntQSum(const l:longint):longint;         { Quersumme                    }
Function IVal(s:string):longint;             { Value Integer                }
Function Lastchar(const s:string):char;            { letztes Zeichen eines Str.   }
Function LoCase(const c:char):char;                { LowerCase                    }
Function LStr(const s:string):string;              { LowerString                  }
Function Ltrim(const s:string):string;             { linke Leerzeichen entfernen  }
Function Max(const a,b:longint):longint;          { Maximum Integer              }
Function Mid(const s:string; const n:byte):string;       { Rest des Strings ab Pos. n   }
Function Min(const a,b:longint):longint;           { Minimum Integer              }
Function MinMax(const x,min,max:longint):longint;  { x -> [min,max]               }
Function MultiPos(const s1,s2:string):boolean;     { pos(s1[i],s2)>0              }
Function PosN(s1,s2:string; n:byte):byte;    { POS ab Stelle n              }
Function PosX(const s1,s2:string):byte;            { length(s)+1, falls pos=0     }
Function ProgName:string;                   { Name des Programms           }
Function ProgPath:PathStr;                   { Pfad des Programms           }
Function QSum(const s:string):longint;             { Quersumme                    }
Function Range(const c1,c2:char):string;           { z.B. ('1','5') = '12345'     }
Function Rtrim(s:string):string;             { rechte Leerzeichen entfernen }
Function RVal(const s:string):real;                { Value Real                   }
Function Sgn(const x:longint):longint;       { Signum Integer               }
Function Sp(const n:integer):string;               { space$                       }
Function Stricmp(s1,s2:string):boolean;      { UStr-Vergleich               }
Function StrS(const l:longint):string;             { "echtes" Str$, Integer       }
Function Time:DateTimeSt;                    { dt. Zeitstring               }
Function UpCase(const c:char):char;                { int. UpCase                  }
Function UStr(const s:String):String;              { UpperString                  }
Function Without(s1,s2:string):string;       { Strings "subtrahieren"       }

{$IFDEF NOASM }
Function Right(s:string; n:byte):string;     { RightString                  }
Function Left(s:string; n:byte):string;      { LeftString                   }
Function Trim(s:string):string;              { Linke u. rechte ' ' abschn.  }
Function FormS(s:string; n:byte):string;     { String auf n Stellen mit ' ' }
{$ELSE}
function Right(const s:string; n:byte):string;          { RightString                  }
Function Left(const s:string; n:byte):string;           { LeftString                   }
Function trim(const s:string):string;                   { Linke u. rechte ' ' abschn.  }
Function FormS(const s:string; const n:byte):string;    { String auf n Stellen mit ' ' }
{$ENDIF }

Procedure bind(var l:longint; const min,max:longint);  { l:=minmax(l,min,max);    }
Procedure bindr(var r:real; const min,max:real);   { r:=minmaxr(r,min,max);       }
Procedure delfirst(var s:string);            { ersten Buchstaben lschen    }
Procedure delfirstHuge(var s:Hugestring);            { ersten Buchstaben lschen    }
Procedure dellast(var s:string);             { letzten Buchstaben lschen   }
Procedure incr(var r1:real; r2:real);        { r1:=r1+r2                    }
Procedure iswap(var l1,l2:longint);           { l1 und l2 vertauschen        }
Procedure LoString(var s:string);            { LowerString                  }
Procedure release;                           { system.release abfangen      }
Procedure SetParity(var b:byte; even:boolean);  { Bit 7 auf Paritt setzen  }
Procedure TruncStr(var s:string; n:byte);    { String krzen                }
Procedure UpString(var s:string);            { UpperString                  }
Procedure FastMove(var Source, Dest; const Count : WORD);
{ Holt so viel Speicher wie mglich, mindestens aber MinMem und
  gibt im Fehlerfalle eine Fehlermeldung aus. Rckgabewert ist
  der tatschlich allocierte Speicher }
Function GetMaxMem(var p: Pointer; MinMem, MaxMem: Word): Word;
Function Log2int(const l:longint):byte;      { Integer-Logarithmus          }


(*     {Unbenutzt}

Procedure SetSysDate(const d:DateTimeSt);          { Datum nach dt. String setzen }
Procedure SetSysTime(const t:DateTimeSt);          { Zeit nach dt. String setzen  }
Function SwapLong(l:longint):longint;        { Byteorder umdrehen           }
Function ShortPath(path:pathstr; n:byte):pathstr;  { Pfadname krzen        }
Function SiMatch(const s1,s2:string):byte;         { dto., ignore case            }
Function CreditCardOk(s:string):boolean;           { Kreditkartennummer berprfen }
Function StrChar(const s:string; const n:byte):char;     { n-tes Zeichen aus s          }
Function Log2(const r:real):real;            { Logarithmus zur Basis 2      }
Function Log10(const r:real):real;           { Logarithmus zur Basis 10     }
function Potenz(const basis,exponent:real):real;   { allgemeine Potenz            }
Function Lead(s:string):string;              { Anf.-u. End-0en abschneiden  }
Function FormR(const r:real; const vk,nk:byte):string;   { r-->str.; vk+nk mit 0 auff.  }
Function SgnR(const x:real):real;            { Signum Real                  }
Function MinS(const a,b:string):string;            { Minimum String               }
Function Log(const b,r:real):real;           { allg. Logarithmus            }
Function PSeg(p:pointer):word;               { Segment-Anteil des Pointers  }
Function POfs(p:pointer):word;               { Offset-Anteil des Pointers   }
Function Long(const l:longint):longint;            { Type-Cast nach Longint       }
*)
Function Oct(l:longint):String;              { Longint -> Oktalstring       }
Function OctVal(const s:string):Longint;           { Oct-Val                   }
Function StrSn(Const l:Longint;n:Byte):String;  { "echtes" Str$, Integer    }



{ ================= Implementation-Teil ==================  }

implementation

uses
  Strings;

type psplit = record              { Fr Pointer-Type-Cast }
                o,s : smallword;
              end;


function CountChar(const c: char; const s: string): integer;
var i,j: integer;
begin
  j:=0;
  for i:= 1 to length(s) do
    if s[i]=c then inc(j);
  CountChar:= j;
end;


{$IFDEF Ver32 }

{ 10.01.2000 robo - in 32-Bit-ASM umgeschrieben }
function CPos(c: char; const s: string): byte; {&uses edi} assembler;
asm
         cld
         mov    edi,s
         movzx  ecx,byte ptr [edi]
         jecxz  @notf            { s='' -> nicht gefunden }
         inc    ecx
         mov    edx,ecx          { lnge merken }
         inc    edi
         mov    al,c
         repnz  scasb
         jecxz  @notf
         mov    eax,edx
         sub    eax,ecx
         jmp    @end
@notf:   xor    eax,eax
@end:
{$ifdef FPC }
end ['EAX', 'ECX', 'EDX', 'EDI'];
{$else}
end;
{$endif}

{$ELSE}

{ MK 08.01.2000 in Inline-ASM umgeschrieben und verbessert }
function CPos(c: char; const s: string): byte; assembler;
asm
         cld
         les    di,s
         mov    ch, 0
         mov    cl,es:[di]
         jcxz   @notf            { s='' -> nicht gefunden }
         inc    cx
         mov    dx,cx            { lnge merken }
         inc    di
         mov    al,c
         repnz  scasb
         jcxz   @notf
         mov    ax,dx
         sub    ax,cx
         jmp    @end
@notf:   xor    ax,ax
@end:
end;

{$ENDIF}


{$IFDEF Ver32 }

{ 10.01.2000 robo - in 32-Bit-ASM umgeschrieben }
procedure SetParity(var b:byte; even:boolean); {&uses edi} assembler;
asm
          mov    edi,b
          mov    al,[edi]
          cmp    even,0
          jz     @setodd
          and    al,07fh               { Test auf gerade Paritt }
          jpe    @spok
          or     al,80h
          jmp    @spok
@setodd:  and    al,07fh               { Test auf ungerade Paritt }
          jpo    @spok
          or     al,80h
@spok:    mov    [edi],al
{$ifdef FPC }
end ['EAX', 'EDI'];
{$else}
end;
{$endif}

{$ELSE}

{ MK 08.01.2000 in Inline-ASM umgeschrieben }
procedure SetParity(var b:byte; even:boolean); assembler;
asm
          les    di,b
          mov    al,es:[di]
          cmp    even,0
          jz     @setodd
          and    al,07fh               { Test auf gerade Paritt }
          jpe    @spok
          or     al,80h
          jmp    @spok
@setodd:  and    al,07fh               { Test auf ungerade Paritt }
          jpo    @spok
          or     al,80h
@spok:    mov    es:[di],al
end;

{$ENDIF}



{$IFDEF NOASM}

Function Max(const a,b:longint):longint;
begin
  if a>b then max:=a else max:=b;
end;

Function Min(const a,b:longint):longint;
begin
  if a<b then min:=a else min:=b;
end;

Function MinMax(const x,min,max:longint):longint;
begin
  if x<min then MinMax:=min
  else if x>max then MinMax:=max
  else MinMax:=x;
end;

{$ELSE}
{$IFDEF NO386}

Function Max(const a,b:longint):longint;
begin
  if a>b then max:=a else max:=b;
end;

Function Min(const a,b:longint):longint;
begin
  if a<b then min:=a else min:=b;
end;

Function MinMax(const x,min,max:longint):longint;
begin
  if x<min then MinMax:=min
  else if x>max then MinMax:=max
  else MinMax:=x;
end;

{$ELSE}
Function Max(const a,b:longint):longint; assembler;
asm
        db 66h
        mov dx,word ptr a
        db 66h
        mov si,word ptr b
        db 66h 
        cmp dx,si
        jg @nomax
        db 66h
        mov dx,si
@nomax: mov ax,dx
        db 66h
        shr dx,16
end; 


Function Min(const a,b:longint):longint; assembler;
asm
        db 66h
        mov dx,word ptr a
        db 66h
        mov si,word ptr b
        db 66h 
        cmp dx,si
        jl @nomin
        db 66h
        mov dx,si
@nomin: mov ax,dx
        db 66h
        shr dx,16
end; 

Function MinMax(const x,min,max:longint):longint; assembler;
asm
        db 66h
        mov dx,word ptr x
        db 66h
        mov si,word ptr min
        db 66h
        mov di,word ptr max
        db 66h 
        cmp dx,si
        jl @min
        db 66h
        cmp dx,di
        jng @nomax
        db 66h
        mov dx,di
        jmp @nomax
@min:   db 66h
        mov dx,si
@nomax: mov ax,dx
        db 66h
        shr dx,16
end; 
{$ENDIF}
{$ENDIF}


(*
Function Log(const b,r:real):real;
begin
  log:=ln(r)/ln(b);
end;
*)

(*
Function Log2(const r:real):real;
begin
  log2:=Log(2,r);
end;
*)

Function Log2int(const l:longint):byte;
var i : byte;
begin
  log2int := 0;
  for i:=0 to 31 do
    if l and (1 shl i) <> 0 then
      Log2int:=i;
end;

(*
Function Log10(const r:real):real;
begin
  log10:=Log(10,r);
end;
*)

(*
function potenz(const basis,exponent:real):real;
begin
  if basis=0 then
    potenz:=0
  else
    potenz:=exp(exponent*ln(basis));
end;
*)

(*
Function MinS(const a,b:string):string;
begin
  if a<b then mins:=a else mins:=b;
end;
*)

procedure bind(var l:longint; const min,max:longint);
begin
  if l<min then l:=min
  else if l>max then l:=max;
end;


procedure bindr(var r:real; const min,max:real);
begin
  if r<min then r:=min
  else if r>max then r:=max;
end;


{$IFDEF NOASM}
Function Sgn(const x:longint):longint;
begin
  if x>0 then
    Sgn:=1
  else
    if x=0 then
      Sgn:=0
    else
      Sgn:=-1;
end;

{$ELSE}

Function Sgn(const x:longint):longint; assembler;
asm
        db 66h
        mov ax,word ptr [x]
        db 66h
        or ax,ax
        mov dx,0
        je @end
        mov ax,1
        jns @end
        dec dx
        dec ax
        dec ax
@end:
end;
{$ENDIF}

(*
Function SgnR(const x:real):real;
begin
  if x>0 then
    SgnR:=1.0
  else
    if x=0 then
      SgnR:=0
    else
      SgnR:=-1.0;
end;
*)

Function FormI(const i:longint; const n:Byte):string;
var
  st:string;
begin
  Str(i,st);
  while length(st)<n do
    st:='0'+st;
  formi:=st;
end;

(*
Function FormR(const r:real; const vk,nk:byte):string;
var i  : byte;
    st : string;
begin
  i:=vk+nk; if nk>0 then i:=succ(i);
  str(r:i:nk,st);
  i:=1;
  while st[i]=' ' do begin
    st[i]:='0';
    i:=succ(i);
    end;
  formr:=st;
end;
*)

(*
Function Lead(s:string):string;
begin
  if cpos('.',s)>0 then
    while s[length(s)]='0' do      { terminiert, da s[0]<>'0' fr s='' }
      dellast(s);
  if s[length(s)]='.' then dellast(s);
  while (s<>'') and (s[1]='0') do
    delfirst(s);
  Lead:=s;
end;
*)

Function Time:DateTimeSt;
VAR stu,min,sec,du :rtlword;
begin
  gettime(stu,min,sec,du);
  time:=formi(stu,2)+':'+formi(min,2)+':'+formi(sec,2);
end;


Function Date:DateTimeSt;
VAR  ta,mo,ja,wt: rtlword;
begin
  getdate(ja,mo,ta,wt);
  date:=formi(ta,2)+'.'+formi(mo,2)+'.'+strs(ja);
end;

(*
Procedure SetSysTime(const t:DateTimeSt);
VAR st,mi,se,res : Integer;
begin
  Val(Copy(t,1,2),st,res);
  Val(Copy(t,4,2),mi,res);
  Val(Copy(t,7,2),se,res);
  settime(st,mi,se,0);
end;
*)

(*
Procedure SetSysDate(const d:DateTimeSt);
VAR t,m,j,res : Integer;
begin
  Val(Copy(d,1,2),t,res);
  Val(Copy(d,4,2),m,res);
  Val(Copy(d,7,4),j,res);
  setdate(j,m,t);
end;
*)

{$IFDEF NOASM}
Function Dup(const n:integer; const c:Char):string;
VAR h : String;
begin
  if n<=0 then Dup:=''
  else begin
    h[0]:=chr(n);
    fillchar(h[1],n,c);
    dup:=h;
    end;
end;

{$ELSE}

Function Dup(const n:integer; const c:Char):string; assembler;
asm
    les di,@result
    mov cx,word ptr n
    cmp ch,0
    mov al,cl
    je @1
    mov al,0
    stosb
    jmp @end
@1: stosb
    mov al,byte ptr c
    rep stosb
@end:
end;      
{$ENDIF}

Function Sp(const n:integer):string;
begin
  sp:=dup(n,' ');
end;


{$IFDEF NOASM}
Function FormS(s:string; n:byte):string;
var b : integer;  { kann bei length(s)=255 = 256 werden!! }
begin
  for b:=length(s)+1 to n do
    s[b]:=' ';
  s[0]:=char(n);
  FormS:=s;
end;

{$ELSE}

Function FormS(const s:string; const n:byte):string; assembler;
asm
        push ds
        mov ch,0
        lds si,s
        les di,@result
        mov al,n
        mov dl,al
        stosb
        lodsb
        mov cl,al
        rep movsb
        mov cl,dl
        sub cl,al
        jbe @end
        mov al,' '
        rep stosb
@end:   pop ds
end;
{$ENDIF}


Function StrS(const l:longint):string;
var s : string[10];
begin
  str(l:0,s);
  strs:=s;
end;

Function StrSn(const l:Longint;n:Byte):String;
Var s : String[10];

Begin
  str(l:0,s);
  While Length(s) < n Do s:=' '+s;
  strsn:=Copy(s,1,n);
  End;


{$IFDEF NOASM }
{$IFNDEF Windows }

Function UpCase(const c:char):char;
begin
  case c of
    'a'..'z' : UpCase:=chr(ord(c) and $df);
    ''      : UpCase:='';
    ''      : UpCase:='';
    ''      : UpCase:='';
    ''      : UpCase:='';
    ''      : UpCase:='';
    ''      : UpCase:='';
    ''      : UpCase:='';
    ''      : UpCase:='';
  else
    UpCase:=c;
  end;
end;

Function LoCase(const c:char):char;
begin
  case c of
    'A'..'Z' : LoCase:=chr(ord(c) or $20);
    ''      : LoCase:='';
    ''      : LoCase:='';
    ''      : LoCase:='';
    ''      : LoCase:='';
    ''      : LoCase:='';
    ''      : LoCase:='';
    ''      : LoCase:='';
    ''      : LoCase:='';
  else
    LoCase:=c;
  end;
end;

{$ELSE}

Function UpCase(const c:char):char;
begin
  case c of
    'a'..'z'  : UpCase:=chr(ord(c) and $df);
    #224..#253: UpCase:=chr(ord(c) and $df);
  else
    UpCase:=c;
  end;
end;

Function LoCase(const c:char):char;
begin
  case c of
    'A'..'Z'  : LoCase:=chr(ord(c) or $20);
    #192..#221: LoCase:=chr(ord(c) or $20);
  else
    LoCase:=c;
  end;
end;

{$ENDIF}

{$ELSE} { NOASM }

{$ifdef ver32}

function Upcase(const c:char): char; {&uses ebx} assembler;
const
  LookUp: array[0..158] of Char = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~' +
{$IFDEF Windows}
   '' +
   '';
{$ELSE}
   '' +
   '';
{$ENDIF}
asm
    xor ebx,ebx
    mov   bl, c
    cmp   bl, 'a'                         { erst ab 'a'... }
    jb @noupcase
    mov al,byte ptr [offset lookup+ebx-61h]          { Lookup-Table begint bei 'a'... }
    jmp @Upcase_end
@noupcase:
    mov al,bl
@Upcase_end:
{$ifdef FPC }
end ['EAX', 'EBX'];
{$else}
end;
{$endif}

function Locase(const c:char):char; {&uses ebx} assembler;
const
  Look: array[0..7] of char = '';
  Get: array[0..7] of char = '';
asm
    mov al,c                { Weniger Benutzt - weniger schnell aber kuerzer }
    cmp al,"A"
    jb @Locase_end
    cmp al,"Z"
    ja @3
@1: or al,20h
    jmp @Locase_end


{$IFDEF Windows}

 @3: cmp al,192
     jb @Locase_end
     cmp al,221
     jna @1
     jmp @Locase_end

{$ELSE}

 @3: mov ebx,7
 @4: cmp byte ptr [look+eBX],al
     je @5
     dec ebx
     jns @4
     jmp @Locase_end
 @5: mov al,byte ptr [get+ebx]
     jmp @Locase_end

{$ENDIF}

@Locase_end:
{$ifdef FPC }
end ['EAX', 'EBX'];
{$else}
end;
{$endif}

{$else}

function Upcase(const c:char): char; assembler;
asm
    mov   bl, c
    cmp   bl, 'a'                         { erst ab 'a'... }
    mov   bh, 0
    jb @noupcase
    mov al,cs:[offset @lookup+bx-61h]          { Lookup-Table begint bei 'a'... }
    jmp @Upcase_end

{Win/DOS Tabellenteile nur mit dem jeweils passenden  }
{Editor bzw. Zeichensatz aendern...                   }

@Lookup: db 'ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~'

{$IFDEF Windows}
         db ''
         db ''
{$ELSE}
         db ''
         db ''
{$ENDIF}

@noupcase:
    mov al,bl

@Upcase_end:
end;

function Locase(const c:char):char; assembler;
asm
    mov al,c                { Weniger Benutzt - weniger schnell aber kuerzer }
    cmp al,"A"
    jb @Locase_end
    cmp al,"Z"
    ja @3
@1: or al,20h
    jmp @Locase_end


{$IFDEF Windows}

 @3: cmp al,192
     jb @Locase_end
     cmp al,221
     jna @1
     jmp @Locase_end

{$ELSE}

 @3: mov bx,7
 @4: cmp byte ptr cs:[@look+BX],al
     je @5
     dec bx
     jns @4
     jmp @Locase_end
 @5: mov al,byte ptr cs:[@get+bx]
     jmp @Locase_end

 @Look: db ''
 @Get:  db ''

{$ENDIF}

@Locase_end:
end;

{$endif}

{$ENDIF}


{$ifdef noasm}

Procedure LoString(var s:string);
var i : integer;
begin
  for i:=1 to length(s) do
    s[i]:=LoCase(s[i]);
end;


Procedure UpString(var s:string);
var i : integer;
begin
  for i:=1 to length(s) do
    s[i]:=UpCase(s[i]);
end;


Function UStr(const s: AnsiString): AnsiString;
var i : integer;
begin
  Ustr[0]:=s[0];
  for i:=1 to length(s) do
    UStr[i]:=UpCase(s[i]);
end;


Function LStr(const s:string):string;
var i : integer;
begin
  LStr[0]:=s[0];
  for i:=1 to length(s) do
    LStr[i]:=LoCase(s[i]);
end;

{$else}

{$ifdef ver32}

procedure LoString (var s: string); {&uses ebx,edi} assembler;
  asm
    mov ebx,s
    movzx ecx,byte ptr [ebx]
    jecxz @lostr_ende
    mov edi,ecx
  @lostr_next:
    mov al,byte ptr [ebx+edi]
    cmp al,'A'
    jnae @lostr_weiter
    cmp al,'Z'
    jnbe @lostr_auml
    add byte ptr [ebx+edi],32
    jmp @lostr_weiter
  @lostr_auml:

{$ifndef windows}

    cmp al,''
    jne @lostr_ouml
    mov byte ptr [ebx+edi],''
    jmp @lostr_weiter
  @lostr_ouml:
    cmp al,''
    jne @lostr_uuml
    mov byte ptr [ebx+edi],''
    jmp @lostr_weiter
  @lostr_uuml:
    cmp al,''
    jne @lostr_eacute
    mov byte ptr [ebx+edi],''
    jmp @lostr_weiter
  @lostr_eacute:
    cmp al,''
    jne @lostr_aring
    mov byte ptr [ebx+edi],''
    jmp @lostr_weiter
  @lostr_aring:
    cmp al,''
    jne @lostr_aelig
    mov byte ptr [ebx+edi],''
    jmp @lostr_weiter
  @lostr_aelig:
    cmp al,''
    jne @lostr_ntilde
    mov byte ptr [ebx+edi],''
    jmp @lostr_weiter
  @lostr_ntilde:
    cmp al,''
    jne @lostr_ccedil
    mov byte ptr [ebx+edi],''
    jmp @lostr_weiter
  @lostr_ccedil:
    cmp al,''
    jne @lostr_weiter
    mov byte ptr [ebx+edi],''

{$else}

    cmp al,192
    jnae @lostr_weiter
    cmp al,221
    jnbe @lostr_weiter
    add byte ptr [ebx+edi],32

{$endif}

  @lostr_weiter:
    dec edi
    jnz @lostr_next
  @lostr_ende:
{$ifdef FPC }
  end ['EAX', 'EBX', 'ECX', 'EDI'];
{$else}
  end;
{$endif}

procedure UpString (var s: string); {&uses ebx,edi} assembler;
  asm
    mov ebx,s
    movzx ecx,byte ptr [ebx]
    jecxz @upstr_ende
    mov edi,ecx
  @upstr_next:
    mov al,byte ptr [ebx+edi]
    cmp al,'a'
    jnae @upstr_weiter
    cmp al,'z'
    jnbe @upstr_auml
    sub byte ptr [ebx+edi],32
    jmp @upstr_weiter
  @upstr_auml:

{$ifndef windows}

    cmp al,''
    jne @upstr_ouml
    mov byte ptr [ebx+edi],''
    jmp @upstr_weiter
  @upstr_ouml:
    cmp al,''
    jne @upstr_uuml
    mov byte ptr [ebx+edi],''
    jmp @upstr_weiter
  @upstr_uuml:
    cmp al,''
    jne @upstr_eacute
    mov byte ptr [ebx+edi],''
    jmp @upstr_weiter
  @upstr_eacute:
    cmp al,''
    jne @upstr_aring
    mov byte ptr [ebx+edi],''
    jmp @upstr_weiter
  @upstr_aring:
    cmp al,''
    jne @upstr_aelig
    mov byte ptr [ebx+edi],''
    jmp @upstr_weiter
  @upstr_aelig:
    cmp al,''
    jne @upstr_ntilde
    mov byte ptr [ebx+edi],''
    jmp @upstr_weiter
  @upstr_ntilde:
    cmp al,''
    jne @upstr_ccedil
    mov byte ptr [ebx+edi],''
    jmp @upstr_weiter
  @upstr_ccedil:
    cmp al,''
    jne @upstr_weiter
    mov byte ptr [ebx+edi],''

{$else}

    cmp al,224
    jnae @upstr_weiter
    cmp al,253
    jnbe @upstr_weiter
    sub byte ptr [ebx+edi],32

{$endif}

  @upstr_weiter:
    dec edi
    jnz @upstr_next
  @upstr_ende:
{$ifdef FPC }
  end ['EAX', 'EBX', 'ECX', 'EDI'];
{$else}
  end;
{$endif}

{$else}

procedure LoString (var s: string); assembler;
  asm
    les bx,[s[0]]
    mov cl,es:[bx]
    xor ch,ch
    jcxz @lostr_ende
    mov di,cx
  @lostr_next:
    mov al,byte ptr es:[bx+di]
    cmp al,'A'
    jnae @lostr_weiter
    cmp al,'Z'
    jnbe @lostr_auml
    add byte ptr es:[bx+di],32
    jmp @lostr_weiter
  @lostr_auml:

{$ifndef windows}

    cmp al,''
    jne @lostr_ouml
    mov byte ptr es:[bx+di],''
    jmp @lostr_weiter
  @lostr_ouml:
    cmp al,''
    jne @lostr_uuml
    mov byte ptr es:[bx+di],''
    jmp @lostr_weiter
  @lostr_uuml:
    cmp al,''
    jne @lostr_eacute
    mov byte ptr es:[bx+di],''
    jmp @lostr_weiter
  @lostr_eacute:
    cmp al,''
    jne @lostr_aring
    mov byte ptr es:[bx+di],''
    jmp @lostr_weiter
  @lostr_aring:
    cmp al,''
    jne @lostr_aelig
    mov byte ptr es:[bx+di],''
    jmp @lostr_weiter
  @lostr_aelig:
    cmp al,''
    jne @lostr_ntilde
    mov byte ptr es:[bx+di],''
    jmp @lostr_weiter
  @lostr_ntilde:
    cmp al,''
    jne @lostr_ccedil
    mov byte ptr es:[bx+di],''
    jmp @lostr_weiter
  @lostr_ccedil:
    cmp al,''
    jne @lostr_weiter
    mov byte ptr es:[bx+di],''

{$else}

    cmp al,192
    jnae @lostr_weiter
    cmp al,221
    jnbe @lostr_weiter
    add byte ptr es:[bx+di],32

{$endif}

  @lostr_weiter:
    dec di
    jnz @lostr_next
  @lostr_ende:
  end;

procedure UpString (var s: string); assembler;
  asm
    les bx,[s[0]]
    mov cl,es:[bx]
    xor ch,ch
    jcxz @upstr_ende
    mov di,cx
  @upstr_next:
    mov al,byte ptr es:[bx+di]
    cmp al,'a'
    jnae @upstr_weiter
    cmp al,'z'
    jnbe @upstr_auml
    sub byte ptr es:[bx+di],32
    jmp @upstr_weiter
  @upstr_auml:

{$ifndef windows}

    cmp al,''
    jne @upstr_ouml
    mov byte ptr es:[bx+di],''
    jmp @upstr_weiter
  @upstr_ouml:
    cmp al,''
    jne @upstr_uuml
    mov byte ptr es:[bx+di],''
    jmp @upstr_weiter
  @upstr_uuml:
    cmp al,''
    jne @upstr_eacute
    mov byte ptr es:[bx+di],''
    jmp @upstr_weiter
  @upstr_eacute:
    cmp al,''
    jne @upstr_aring
    mov byte ptr es:[bx+di],''
    jmp @upstr_weiter
  @upstr_aring:
    cmp al,''
    jne @upstr_aelig
    mov byte ptr es:[bx+di],''
    jmp @upstr_weiter
  @upstr_aelig:
    cmp al,''
    jne @upstr_ntilde
    mov byte ptr es:[bx+di],''
    jmp @upstr_weiter
  @upstr_ntilde:
    cmp al,''
    jne @upstr_ccedil
    mov byte ptr es:[bx+di],''
    jmp @upstr_weiter
  @upstr_ccedil:
    cmp al,''
    jne @upstr_weiter
    mov byte ptr es:[bx+di],''

{$else}

    cmp al,224
    jnae @upstr_weiter
    cmp al,253
    jnbe @upstr_weiter
    sub byte ptr es:[bx+di],32

{$endif}

  @upstr_weiter:
    dec di
    jnz @upstr_next
  @upstr_ende:
  end;

{$endif}

Function UStr(const s:string):string;
  var _s:string;
  begin
    _s:=s;
    UpSTring(_s);
    UStr:=_s;
  end;

Function LStr(const s:string):string;
  var _s:string;
  begin
    _s:=s;
    LoString(_s);
    LStr:=_s;
  end;

{$endif}

function UStrHuge(const s: HugeString): HugeString;
var
  i : integer;
begin
  UStrHuge := s;
  for i:=1 to Length(s) do
    UStrHuge[i]:=UpCase(s[i]);
end;

{$IFDEF NOASM }
function Left(s:string; n:byte):string;
begin
  if n<length(s) then s[0]:=chr(n);
  left:=s;
end;
{$ELSE }

{$ifdef ver32}
{ 01.02.2000 robo - 32 Bit}
function Left(const s: String; n: byte): string; {&uses esi,edi} assembler;
asm
        cld
        mov     edi, @result
        mov     esi, s
        xor     eax, eax
        lodsb
        cmp     al, n
        jb      @1
        mov     al, n
@1:     mov     ecx, eax
        stosb
        rep     movsb
{$ifdef FPC }
end ['EAX', 'ECX', 'ESI', 'EDI'];
{$else}
end;
{$endif}
{ /robo }
{$else}
function Left(const s: String; n: byte): string; assembler;
asm
        push ds
        cld
        les di,@result
        lds si,s
        mov ah,0
        mov bl,n
        lodsb
        cmp al,bl
        jb @1
        mov al,bl
@1:     mov cx,ax
        stosb
        rep movsb
        pop ds
end;
{$endif}
{$ENDIF }

{ MK 08.01.2000 Routine in Inline-Assembler neu geschrieben }
{$IFDEF NOASM }
Function Right(s:string; n:byte):string;
begin
  if n>=length(s) then
    Right:=s
  else
    Right:=copy(s,length(s)-n+1,255);
end;
{$ELSE }
{$ifdef ver32}
{ 01.02.2000 robo - 32 Bit}
function Right(const s: string; n: byte):string; {&uses esi,edi} assembler;
asm
        cld
        mov     esi, s
        mov     edi, @result
        xor     eax, eax
        xor     ecx, ecx
        mov     cl, n
        lodsb
        cmp     al, n                   { n > als Lnge von s }
        jnb @3
        mov     cl, al
@3:     mov     dl, al                  { Stringlnge merken }
        sub     al, cl
        jnc @1
        mov     cl, dl
        xor     eax, eax
@1:     mov     [edi], cl
        inc     edi
        add     esi, eax
        rep     movsb
{$ifdef FPC }
end ['EAX', 'ECX', 'EDX', 'ESI', 'EDI'];
{$else}
end;
{$endif}
{ /robo }
{$else}
function Right(const s: string; n: byte):string; assembler;
asm
        push ds
        cld
        lds si,s
        les di,@result
        xor ax,ax
        xor cx,cx
        mov cl,n
        mov bl,cl
        lodsb
        cmp al,bl                   { n > als Lnge von s }
        jnb @3
        mov cl,al
@3:     mov dl,al                   { Stringlnge merken }
        sub al,cl
        jnc @1
        mov cl,dl
        xor ax,ax
@1:     mov es:[di],cl
        inc di
        add si,ax
        rep movsb
        pop ds
end;
{$endif}
{$ENDIF }

{ MK 08.01.2000 Routine in Inline-Assembler neu geschrieben }
{$IFDEF NOASM }
Function Mid(const s:string; const n:byte):string;
begin
  mid:=copy(s,n,255);
end;
{$ELSE }
function Mid(const s:string; const n:byte): string; assembler;
asm
        mov     bx, ds
        cld
        les     di, @result
        lds     si, s
        xor     dx, dx
        xor     cx, cx
        lodsb
        cmp     al, n
        jnb @3
        mov     al, cl              { n > als Lnge von s }
        stosb
        jmp @2
@3:     mov     dl, al
        sub     al, n
        inc     al
        jnbe   @4
        dec  al                     { Stringlnge 255, n = 0 }
@4:     cmp     al, dl
        jc      @1
        mov     al, dl
@1:     mov     cl, al
        stosb
        sub     dx, cx
        add     si, dx
        rep movsb
@2:     mov     ds, bx
end;
{$ENDIF}

{$IFDEF NOASM}
Function trim(s:string):string;
begin
  while (s[length(s)]=' ') or (s[length(s)]=#9) do     { terminiert, da s[0]<>' ' fr s='' }
    dec(byte(s[0]));
  while (s<>'') and ((s[1]=' ') or (s[1]=#9)) do
    delete(s,1,1);
  trim:=s;
end;

{$ELSE}

Function trim(const s:string):string; assembler;
asm
    push ds
    lds si,s
    les di,@result
    mov bx,si
    lodsb
    mov ah,0
    mov cx,ax
    cmp cl,0
    jne @2
@n: mov al,0
    stosb
    jmp @end

@2: add si,ax
    dec si
    mov dx,0920h
    std 
@1: lodsb
    or cx,cx { so Notwendig, falls String >127...}
    je @n
    dec cx
    cmp al,dl
    je @1
    cmp al,dh
    je @1
    inc cx

    mov si,bx
    inc si
    cld
@3: lodsb
    or cx,cx
    je @n
    dec cx 
    cmp al,dl
    je @3
    cmp al,dh
    je @3 
    inc cx

    dec si 
    mov al,cl
    stosb
    rep movsb
@end:
    pop ds
end;    
{$ENDIF}


{$IFDEF NOASM}
Function Range(const c1,c2:char):string;
var s : string;
    c : char;
begin
  s:='';
  for c:=c1 to c2 do
    s:=s+c;
  range:=s;
end;

{$ELSE}

Function Range(const c1,c2:char):string; assembler;
asm
    les di,@result
    mov cl,byte ptr c1
    mov bl,byte ptr c2
    mov al,bl
    mov ah,0
    sub al,cl
    ja @2
    jne @1 
    mov al,1
    mov ah,cl
    stosw
@1: mov al,0
    stosb
    jmp @end

@2: inc ax 
    jne @4
    dec ax
@4: stosb
    mov al,cl
@3: stosb
    inc al
    je @end
    cmp al,bl
    jna @3
@end:
end;   
{$ENDIF}


Function IVal(s:string):longint;
var l   : longint;
    res : integer;
begin
  if s[1]='+' then delete(s,1,1);
  val(trim(s),l,res);
  IVal:=l;
end;


Function RVal(const s:string):real;
var r   : real;
    res : integer;
begin
  val(trim(s),r,res);
  RVal:=r;
end;


function progname:string;
var ps : pathstr;
    ds : string;
    ns : string;
    es : string;
begin
  ps:=paramstr(0);
  if ps='' then progname:=''
  else begin
    fsplit(ps,ds,ns,es);
    progname:=ns;
    end;
end;

function progpath:pathstr;
var ps : pathstr;
    ds : string;
    ns : string;
    es : string;
begin
  ps:=paramstr(0);
  if ps='' then progpath:=''
  else begin
    fsplit(ps,ds,ns,es);
    if cpos(':',ds)=0 then  { relativer Pfad?! }
    begin
      GetDir(0,ns);         { 'ns' fr aktuelles Verzeichnis mibrauchen   }
      ChDir(ds);            { aktuelles Verzeichnis => Programmverzeichnis }
      GetDir(0,ds);         { voll qualifizierten Pfad holen               }
      ChDir(ns);            { aktuelles Verzeichnis zurcksetzen           }
    end;
    progpath:=ds;
  end;
end;


{$IFDEF NOASM}
function Hex(const l:longint; const n:byte):string;
const hexch : array[0..15] of char = '0123456789ABCDEF';
var   s    : string[8];
      f    : shortint;
      trim : boolean;
begin
  trim:=(n=0);
  f:=iif(trim,28,(n-1)*4);
  s:='';
  while f>=0 do begin
    s:=s+hexch[(l shr f)and $f];
    dec(f,4);
    end;
  if trim then
    while (length(s)>1) and (s[1]='0') do
      delete(s,1,1);
  Hex:=s;
end;
{$ELSE}
{$IFDEF NO386}
function Hex(const l:longint; const n:byte):string;
const hexch : array[0..15] of char = '0123456789ABCDEF';
var   s    : string[8];
      f    : shortint;
      trim : boolean;
begin
  trim:=(n=0);
  f:=iif(trim,28,(n-1)*4);
  s:='';
  while f>=0 do begin
    s:=s+hexch[(l shr f)and $f];
    dec(f,4);
    end;
  if trim then
    while (length(s)>1) and (s[1]='0') do
      delete(s,1,1);
  Hex:=s;
end;
{$ELSE}
function Hex(const l:longint; const n:byte):string; assembler;
asm
        les di,@result        
        push di
        inc di
        mov al,n
        mov ah,0
        mov cx,ax
        mov dx,ax
        cmp dl,8
        ja @tr
        cmp dl,0
        jne @ntr
@tr:    mov cl,8
@ntr:   dec cx
        shl cx,2
        db 66h

        mov bx,word ptr l
@1:     db 66h
        mov ax,bx
        db 66h
        shr ax,cl
        and al,0fh
        or al,30h
        cmp al,'9'
        jna @12
        add al,7
@12:    cmp dl,0
        jne @11
        cmp al,'0'
        jne @11
        cmp cl,0
        jne @2 
@11:    stosb
        inc dh                
@2:     sub cx,4
        jns @1

        mov al,dh
        pop di
        stosb
end;
{$ENDIF}
{$ENDIF}

Function HexVal(const s:string):longint;
var l   : longint;
    res : integer;
begin
  val('$'+trim(s),l,res);
  if res=0 then HexVal:=l
  else HexVal:={0}-1;  { my: Wert kann auch #0 ergeben (binaries)! }
end;


Function OctVal(const s:string):Longint;
var l   : Longint;
    res : Integer;
    n   : Integer;
    s1  : String;
    neg : Boolean;

Begin
  l:=0;
  s1:=Trim(s);
  neg:=False;
  res:=0;
  While Length(s1) > 0 Do Begin
    If s1[1] = '-' Then neg:= True Else
    If s1[1] = '+' Then neg:= False Else
    If (s1[1] >= '0') And (s1[1] <= '7') Then Begin
      l:=(l Shl 3) + (Ord(s1[1]) And $0007);
      End Else Begin
      res:=1;
      Break;
      End;
    If Length(s1) > 1 Then s1:=Copy(s1,2,Length(s1)-1) Else s1:='';
    End;
  If neg Then l:=(-l);
  If res=0 Then OctVal:=l Else OctVal:=0;
  End;

Function Bin(l:longint; n:byte):string;
var s : string[32];
    i : byte;
begin
  s:='';
  for i:=1 to n do begin
    if odd(l) then s:='1'+s
    else s:='0'+s;
    l:=l shr 1;
    end;
  bin:=s;
end;


Function FileName(var f):string;
var s : pathstr;
    i : byte;
begin
  FastMove(filerec(f).name,s[1],79);
  i:=1;
  while (i<79) and (s[i]<>#0) do inc(i);
  s[0]:=chr(i-1);
  FileName:=s;
end;

Function iif(b:boolean; l1,l2:longint):longint;
begin
  if b then iif:=l1
  else iif:=l2;
end;


Function iifb(b,b1,b2:boolean):boolean;
begin
  if b then iifb:=b1
  else iifb:=b2;
end;


Function iifc(b:boolean; c1,c2:char):char;
begin
  if b then iifc:=c1
  else iifc:=c2;
end;


Function iifr(b:boolean; r1,r2:real):real;
begin
  if b then iifr:=r1
  else iifr:=r2;
end;


Function iifs(b:boolean; const s1,s2:string):string;
begin
  if b then iifs:=s1
  else iifs:=s2;
end;


procedure delfirst(var s:string);
begin
  delete(s,1,1);
end;

Procedure delfirstHuge(var s:Hugestring);            { ersten Buchstaben lschen    }
begin
  delete(s,1,1);
end;


procedure dellast(var s:string);
begin
  if s<>'' then dec(byte(s[0]));
end;

(*
function posn(s1,s2:string; n:byte):byte;
begin
  if pos(s1,mid(s2,n))=0 then PosN:=0
  else PosN:=pos(s1,mid(s2,n))+n-1;
end;
*)

function posn(s1,s2:string; n:byte):byte;
var n1:byte;
begin
  if n=0 then n:=1;
  n1:=pos(s1,mid(s2,n));
  if n1<>0 then inc(n1,n-1);
  PosN:=n1;
end;

(*
function long(const l:longint):longint;
begin
  long:=l;
end;
*)

(*
function shortpath(path:pathstr; n:byte):pathstr;
var ds : string;
    ns : string;
    es : string;
begin
  fsplit(path,ds,ns,es);
  ds:=left(ds,n-length(ns+es));
  dellast(ds);
  shortpath:=ds+DirSepa+ns+es;
end;
*)

(*
function pofs(p:pointer):word;
begin
  pofs:=psplit(p).o;
end;
*)

(*
function pseg(p:pointer):word;
begin
  pseg:=psplit(p).s;
end;
*)

Procedure iswap(var l1,l2:longint);
var h : longint;
begin
  h:=l1; l1:=l2; l2:=h;
end;


function fitpath(path:string; n:byte):string;
var dir      : string;
    name     : string;
    ext      : string;
    p,p1     : byte;
    wasLFN   : boolean;


  { Verzeichnisnamen durch "\x..\" ersetzen }

  function ReplaceDirs:boolean;
  begin
    ReplaceDirs:=false;
    p:=0;
    while length(dir)+length(name)+length(ext) > n do
    begin
      p:=posn(DirSepa,dir,p+1);                { ersten/nchsten '\' suchen }
      if p>0 then
      begin
        p1:=posn(DirSepa,dir,p+1);             { nchsten '\' danach suchen }
        if (p1>0) then
        begin
          if (p1-p>4) then               { sonst "lohnt" das Ersetzen nicht }
            dir:=left(dir,p)+dir[p+1]+'..'+mid(dir,p1);
        end
        else exit;
      end
      else exit;
    end;
    ReplaceDirs:=true;
  end;


  { Verzeichnisebenen mit "\...\" zusammenfassen }

  function ReduceDirLevels:boolean;
  begin
    ReduceDirLevels:=false;
    while length(dir)+length(name)+length(ext) > n do
    begin
      p:=cpos(DirSepa,dir);                             { ersten '\' suchen }
      if p>0 then
      begin
        p1:=posn(DirSepa,dir,p+1);                    { nchsten '\' suchen }
        if (p1>0) then
        begin
          p1:=posn(DirSepa,dir,p1+1);             { bernchsten '\' suchen }
          if p1>0 then
            dir:=left(dir,p)+'...'+mid(dir,p1)
          else exit;
        end
        else exit;
      end
      else exit;
    end;
    ReduceDirLevels:=true;
  end;

begin
  if length(path)<=n then fitpath:=path
  else begin
    wasLFN:=LFNEnabled;
    if not LFNEnabled then EnableLFN;
    fsplit(path,dir,name,ext);
    if length(ext) > 7 then ext:=left(ext,4)+'...';  { 3 Stellen immer behalten }
    if not ReplaceDirs then
      if not ReduceDirLevels then
        name:=left(name,n-(length(dir)+length(ext)+5))+'[...]';
    fitpath:=dir+name+ext;
    if not wasLFN then DisableLFN;
  end;
end;


Function MultiPos(const s1,s2:string):boolean;
var i  : byte;
    mp : boolean;
begin
  mp:=false; i:=1;
  while not mp and (i<=length(s1)) do begin
    mp:=(cpos(s1[i],s2)>0);
    inc(i);
    end;
  MultiPos:=mp;
end;


Procedure release;
begin
  writeln(#7#7#7'Release???');
end;


Function QSum(const s:string):longint;             { Quersumme }
var l : longint;
    i : byte;
begin
  l:=0;
  for i:=1 to length(s) do
    inc(l,ord(s[i]));
  qsum:=l;
end;

Function IntQSum(const l:longint):longint;         { Longint-Quersumme }
begin
  if l=0 then IntQSum:=0
  else IntQSum:=l mod 10 + IntQSum(l div 10);
end;


Function Even(const l:longint):boolean;
begin
  even:=not odd(l);
end;


Function Ltrim(const s:string):string;
var i : byte;
begin
  i:=1;
  while (i<=length(s)) and ((s[i]=' ') or (s[i]=#9)) do inc(i);
  ltrim:=copy(s,i,255);
end;

Function Rtrim(s:string):string;
begin
  while (s[length(s)]=' ') or (s[length(s)]=#9) do
    dec(byte(s[0]));
  Rtrim:=s;
end;


Function Without(s1,s2:string):string;       { Strings "subtrahieren"  }
var p,i : byte;
begin
  for i:=1 to length(s2) do
    repeat
      p:=cpos(s2[i],s1);
      if p>0 then delete(s1,p,1);
    until p=0;
  Without:=s1;
end;


{$IFDEF NOASM}

Function Lastchar(const s:string):char;           { letztes Zeichen eines Str.   }
begin
  lastchar:=s[length(s)];
end;

Function FirstChar(const s:string):char;           { UpCase(s[1]) }
begin
  if s='' then firstchar:=#0
  else firstchar:=s[1];
end;

Function Blankpos(const s:string):byte;        { Position von ' ' oder #9     }
var p1,p2 : byte;
begin
  p1:=cpos(' ',s);
  p2:=cpos(#9,s);
  if p1=0 then blankpos:=p2
  else if p2=0 then blankpos:=p1
  else blankpos:=min(cpos(' ',s),cpos(#9,s));
end;

{$ELSE}

Function Lastchar(const s:string):char; assembler;   { letztes Zeichen eines Str.   }
asm
        push ds
        lds si,s
        lodsb
        mov ah,0
        add si,ax
        dec si
        lodsb
        pop ds
end;

Function FirstChar(const s:string):char; assembler;  { UpCase(s[1]) }
asm
        push ds
        lds si,s
        lodsw
        cmp al,0
        je @end
        mov al,ah
@end:   pop ds
end;

Function Blankpos(const s:string):byte; assembler;
asm
        push ds 
        lds si,s
        lodsb
        mov ah,0
        mov cx,ax
        mov dl,ch 
        inc cx
@1:     lodsb
        dec cx
        je @found
        inc dx
        cmp al,' '
        je @fnd
        cmp al,9
        jne @1
@fnd:   mov cl,dl 
@found: mov al,cl
        pop ds
end;
{$ENDIF}


Procedure TruncStr(var s:string; n:byte);    { String krzen                }
begin
  if length(s)>n then
    s[0]:=chr(n);
end;


Procedure incr(var r1:real; r2:real);
begin
  r1:=r1+r2;
end;


function hbar(const len:byte):string;
begin
  hbar:=''+dup(len-2,'')+'';
end;

(*
Function StrChar(const s:string; const n:byte):char;     { n-tes Zeichen aus s }
begin
  StrChar:=s[n];
end;
*)

Function Stricmp(s1,s2:string):boolean;      { UStr-Vergleich }
begin
  UpString(s1);
  UpString(s2);
  Stricmp:=(s1=s2);
end;

function Oct(l:longint):string;        { Longint -> Oktalstring }
var s   : string;
    sgn : string[1];
begin
  s:='';
  if l<0 then begin
    sgn:='-';
    l:=-l;
    end
  else sgn:='';
  while l<>0 do begin
    s := chr((l and 7) + $30) + s;
    l := (l shr 3);
    end;
  if s='' then Oct:='0'
  else Oct:=sgn+s;
end;

Function CPosX(c:char; const s:string):byte;   { pos=0 -> pos:=length(s)+1 }
var p : byte;
begin
  p:=cpos(c,s);
  if p=0 then CPosX:=length(s)+1
  else CPosX:=p;
end;


Function PosX(const s1,s2:string):byte;            { length(s)+1, falls pos=0 }
var p : byte;
begin
  p:=pos(s1,s2);
  if p=0 then PosX:=length(s2)+1
  else PosX:=p;
end;

(*
Function SiMatch(const s1,s2:string):byte;         { dto., ignore case }
var p,ml : byte;
begin
  p:=0;
  ml := min(length(s1),length(s2));
  while (p<ml) and (UpCase(s1[p+1])=UpCase(s2[p+1])) do
    inc(p);
  SiMatch:=p;
end;
*)

(*
function SwapLong(l:longint):longint;        { Byteorder umdrehen }
type sr = record
            w1,w2 : smallword;
          end;
var  m  : longint;
begin
  sr(m).w1:=swap(sr(l).w2);
  sr(m).w2:=swap(sr(l).w1);
  SwapLong:=m;
end;
*)

(*
Function CreditCardOk(s:string):boolean;   { Kreditkartennummer berprfen }
const cntab : array['0'..'9'] of byte = (0,2,4,6,8,1,3,5,7,9);
var i,sum : integer;
begin
  i:=1;
  while i<=length(s) do
    if (s[i]<'0') or (s[i]>'9') then
      delete(s,i,1)
    else
      inc(i);
  sum:=0;
  for i:=1 to length(s) do
    if odd(length(s)+1-i) then inc(sum,ord(s[i])-48)
    else inc(sum,cntab[s[i]]);
  CreditCardOk:=(sum mod 10=0);
end;
*)

{$IFDEF NO386 }
{ JG+MK+de.comp.lang.assembler.x86: Superschnelle MOVE-Routine }
procedure FastMove(var Source, Dest; const Count: WORD); assembler;
asm
        mov  cx, count
        or   cx, cx        { Nichts zu kopieren? }
        jz   @ende

        mov  bx, ds
        les  di, dest
        lds  si, source

        cld
        shr  cx, 1
        rep  movsw          { Zuerst die geraden Wrter, wegen Alignment }
        jnc  @even
        movsb
@even:  mov ds, bx
@ende:
end;
{$ELSE }
procedure FastMove(var Source, Dest; const Count: WORD); assembler;
asm
        mov  cx, count
(*      or   cx, cx        { Nichts zu kopieren? }
        jz   @ende *)      { MY: Auskommentiert - laut JG berflssig }

        mov  bx, ds
        les  di, dest
        lds  si, source
        cld

@fast:  shr  cx, 1
        db $0F,$92,$C2     { setc dl }
        shr  cx, 1
        db $66
        rep  movsw         { rep movsd }
        jnc  @even2
        movsw
@even2: shr  dl, 1
        jnc @even
        movsb
@even:  mov ds, bx
@ende:
end;
{$ENDIF }

function GetMaxMem(var p: Pointer; MinMem, MaxMem: Word): Word;
var
  Size: Word;
begin
  if MinMem > (MaxAvail + MaxAvail div 10) then
  begin
    Writeln('Nicht gengend Speicher');
    Halt(1);
  end;
  Size := Word(Min(MaxAvail - MaxAvail div 10, MaxMem));
  GetMem(p, Size);
  GetMaxMem := Size;
end;


  end.
