{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 2004-2023      Martin Wodrich, http://www.martinwodrich.de  }
{ (c) 2008-2024      FreeXP, http://www.freexp.de                 }
{                                                                 }
{ Dieser Quelltext ist Freeware.                                  }
{                                                                 }
{ Die allgemeinen Nutzungsbedingungen fuer diesen Quelltext       }
{ finden Sie in der Datei TOUCH.TXT oder auf                      }
{ http://www.martinwodrich.de/Software/Touch/nutzung.htm          }
{ --------------------------------------------------------------- }

{ Betriebsystemabhдngige Routinen }
unit touch1;

interface
{$I TOUCH.INC }

uses touch0{$IFDEF Win16},windos{$ELSE}{$IFDEF unix1},dos,oldlinux{$ELSE}{$IFNDEF PASCALABC},dos{$ENDIF}{$ENDIF}{$ENDIF};

{$IFDEF unix1}
function ftime2epoch(ftime:longint):longint;
function unixsetftime(path:pathstr; etime:longint):boolean;
{$ENDIF}

implementation

{$IFDEF unix1}
function ftime2epoch(ftime:longint):longint;
var dt: DateTime;
begin
  UnPackTime(ftime,dt);
  ftime2epoch:=LocalToEpoch(dt.Year,dt.Month,dt.Day,dt.Hour,dt.Min,dt.Sec);
end;

function unixsetftime(path:pathstr; etime:longint):boolean;
var utim:utimbuf;
begin
  utim.actime:=etime;
  utim.modtime:=etime;
  unixsetftime:=Utime(path,utim);
end;
{$ENDIF}

end.
