{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 2004-2024 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT                                               }
{ --------------------------------------------------------------- }

{ Extraktions-Tool fr Einzeilenkommentare in .DQs }
program snapx;

uses
  crt, dos;
var infile, outfile : text;
    s, Eingabe, Ausgabe : string;
    aa : integer;

procedure usage;
const crlf = #13#10;
begin
  writeln('  Usage:  SnapX  ? | -? | /? | -h | [infile [outfile]]');
  writeln('  Default-Infile:  SNAPSHOT.DQ');
  writeln('  Default-Outfile: EXTRAKT.TXT');
  halt(0)
end;


function exist(n:string):boolean;
var sr : searchrec;
    ex : boolean;
begin
  findfirst(n,anyfile-volumeid-directory,sr);
  ex:=(doserror=0);
  while not ex and (doserror=0) do begin
    findnext(sr);
    ex:=(doserror=0);
  end;
{   findclose(sr); }    { keine LFN-Behandlung }
  exist:=ex;
end;


begin
  if (Paramstr(1) = '/?') or (Paramstr(1) = '-?') or (Paramstr(1) = '?')
    or (Paramstr(1) = '-h') then usage;
  if Paramstr(1) <> '' then Eingabe := Paramstr(1)
    else Eingabe := 'SNAPSHOT.DQ';
  assign(infile, Eingabe);
  if not exist(Eingabe) then begin
    writeln(' Das File ',Eingabe,' wurde im Verzeichnis nicht gefunden');
    usage;  { => halt(0) }
  end;
  if Paramstr(2) <> '' then Ausgabe := Paramstr(2)
    else Ausgabe := 'EXTRAKT.TXT';
  assign(outfile, Ausgabe);
  rewrite(outfile);
  if IOResult <> 0 then begin
    close(infile);
    writeln;
    writeln(' Das Ausgangsfile ',Ausgabe,' konnte nicht geffnet werden');
    halt(1);
  end;
  reset(infile);
  aa:=0;
  while not eof(infile) do begin
    readln(infile, s);
    if copy(s,1,1)='%' then begin
      delete(s,1,1);
      writeln(outfile, s);
      inc(aa);
    end;
  end;
  close(infile);
  close(outfile);
  writeln(' ',aa,' Einzeilenkommentare von: ',Eingabe,' nach: ',Ausgabe,' kopiert');
end.
