{ -------------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.                    }
{ (c) 2004-2024 FreeXP, http://www.freexp.de                           }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.          }
{                                                                      }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der      }
{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html. }
{ -------------------------------------------------------------------- }

program gendate;

uses dos,crt,typeform;

var t        : datetime;
    outpath  : dirstr;
    hund,dow : Word;
    f        : text;
    tp       : longint;

begin
  {BEGIN TOUCH.CTL}
  filemode:=0;
  Assign(f,'BUILD\ALL\TOUCH.CTL');
  {$I-}
  Reset(f);
  {$I+}
  if Ioresult<>0 then begin
    {keine TOUCH.CTL also Systemzeit nehmen}
    Gettime(t.Hour,t.Min,t.Sec,hund);
    Getdate(t.Year,t.Month,t.Day,dow);
  end else begin
    {TOUCH.CTL, also deren Zeitstempel nehmen}
    Getftime(f,tp);
    UnpackTime(tp,t);
    Close(f); 
  end;
  filemode:=2;
  {END TOUCH.CTL}
  outpath:='';
  if (paramcount=1) then begin
    outpath:=paramstr(1);
    if outpath<>'' then
      if outpath[length(outpath)]<>'\' then
        outpath:=outpath+'\';
  end;
  Assign(f,outpath+'compdate.pas');
  Rewrite(f);
  writeln(f,'{ -------------------------------------------------------------------- }');
  writeln(f,'{ Dieser Quelltext ist urheberrechtlich geschuetzt.                    }');
  writeln(f,'{ (c) 2004-2024 FreeXP, http://www.freexp.de                           }');
  writeln(f,'{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.          }');
  writeln(f,'{                                                                      }');
  writeln(f,'{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der      }');
  writeln(f,'{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html. }');
  writeln(f,'{ -------------------------------------------------------------------- }');
  writeln(f,'{ '+#36+'Id: '+#36+' }');
  writeln(f,'unit compdate;');
  writeln(f,'');
  writeln(f,'interface');
  writeln(f,'');
  writeln(f,'const');
  writeln(f,'  comp_YY : string[4] = '''+strs(t.Year)+''';');
  writeln(f,'  comp_MO : string[2] = '''+formi(t.Month,2)+''';');
  writeln(f,'  comp_DD : string[2] = '''+formi(t.Day,2)+''';');
  writeln(f,'  comp_HH : string[2] = '''+formi(t.Hour,2)+''';');
  writeln(f,'  comp_MI : string[2] = '''+formi(t.Min,2)+''';');
  writeln(f,'  comp_SS : string[2] = '''+formi(t.Sec,2)+''';');
  writeln(f,'');
  writeln(f,'implementation');
  writeln(f,'');
  writeln(f,'end.');
  Packtime(t,tp);  {Zur Sicherheit nochmal ein Touch}
  SetFTime(f,tp);  {auf compdate.pas}
  close(f);
end.
