{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 2006-2024 FreeXP, http://www.freexp.de                      }
{                                                                 }
{ Dieser Quelltext dient ausschlielich dazu, in FreeXP           }
{ verwendete Quelltexte Dritter, die von FreeXP modifiziert       }
{ wurden, auch in anderen Programmen als FreeXP verwenden zu      }
{ knnen.                                                         }
{ --------------------------------------------------------------- }

{ Unit freexp }
unit freexp;
{$I-}

{$IFDEF VER70 }
  {$DEFINE BP}
  {$IFDEF WINDOWS}
    {$DEFINE Win16}
  {$ENDIF }
{$ELSE}
  {$IFDEF VER80 }
    {$DEFINE BP}
    {$IFDEF WINDOWS}
      {$DEFINE Win16}
    {$ENDIF }
  {$ENDIF }
{$ENDIF }

interface

const FMRead       = $00;     { Konstanten fr Filemode }
      FMWrite      = $01;
      FMRW         = $02;
      FMDenyNone   = $40;
      FMDenyRead   = $30;
      FMDenyWrite  = $20;
      FMDenyBoth   = $10;
      FMCompatible = $00;

procedure fm_ro;                                { Filemode ReadOnly       }
procedure fm_rw;                                { Filemode Read/Write     }
Function Hex(const l:longint; const n:byte):string;      { Hex-Zahl mit n Stellen       }
Function  existf(var f):boolean;                { Datei vorhanden ?       }
Function  exist(const n:string):boolean;         { Datei vorhanden ?       }

implementation

{$IFNDEF Win16 }
uses dos;
{$ELSE }
uses windos,strings;
{$ENDIF }

procedure fm_ro;      { Filemode ReadOnly }
begin
  filemode:=fmRead;
end;

procedure fm_rw;      { Filemode Read/Write }
begin
  filemode:=fmRW;
end;

function Hex(const l:longint; const n:byte):string;
const hexch : array[0..15] of char = '0123456789ABCDEF';
var   s    : string[8];
      f    : shortint;
      trim : boolean;
begin
  trim:=(n=0);
  if trim then f:=28 else f:=((n-1)*4);
  s:='';
  while f>=0 do begin
    s:=s+hexch[(l shr f)and $f];
    dec(f,4);
    end;
  if trim then
    while (length(s)>1) and (s[1]='0') do
      delete(s,1,1);
  Hex:=s;
end;

Function existf(var f):Boolean;
var
  fm : byte;
begin
  existf:=false;
  fm:=filemode;
  filemode:=FMDenyNone;
  reset(file(f));
  if IOResult=0 then
  begin
    close(file(f));
    existf:=true;
  end;
  filemode:=fm;
  if ioresult = 0 then ;
end;

function exist(const n:string):boolean;
var
  {$IFNDEF Win16 }
  sr : searchrec;
  {$ELSE }
  sr : Tsearchrec;
  sp : Array[0..255] of Char;
  {$ENDIF }
  ex : boolean;
begin
  {$IFNDEF Win16 }
  FindFirst(n,$27,sr);
  {$ELSE }
  StrPCopy(sp,n);
  FindFirst(sp,$27,sr);
  {$ENDIF }
  ex:=(doserror=0);
  while not ex and (doserror=0) do
  begin
    FindNext(sr);
    ex:=(doserror=0);
  end;
  {$IFNDEF BP }
  FindClose(sr);
  {$ENDIF }
  exist:=ex;
end;

end.
