{ ------------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.                   }
{ (c) 1991-1999 Peter Mandrella                                       }
{ (c) 2000-2001 OpenXP-Team                                           }
{ (c) 2002-2025 FreeXP, http://www.freexp.de                          }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.         }
{                                                                     }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der     }
{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html }
{ ------------------------------------------------------------------- }

{ File-I/O, Locking und Dateinamenbearbeitung }

{$I XPDEFINE.INC }

unit fileio;

interface

uses
  xpglobal, dos, typeform, lfn;

const FMRead       = $00;     { Konstanten fr Filemode }
      FMWrite      = $01;
      FMRW         = $02;
      FMDenyNone   = $40;
      FMDenyRead   = $30;
      FMDenyWrite  = $20;
      FMDenyBoth   = $10;
      FMCompatible = $00;

const
  { Neue AnyFile-Konstante, da $3F oft nicht luft }
  ffAnyFile = $21; { Normal, R/O und Archiv }

type  TExeType = (ET_Unknown, ET_DOS, ET_Win16, ET_Win32,
                  ET_OS2_16, ET_OS2_32, ET_ELF);


function  AddDirSepa(const p: pathstr): pathstr; { Verz.-Trenner anhaengen }
procedure EmergMove2Bad(var f:file);                 { Nach Assign noch ins Bad }
Function  exist(const n:string):boolean;         { Datei vorhanden ?       }
Function  existf(var f):boolean;                { Datei vorhanden ?       }
Function  existrf(var f):boolean;               { D.v. (auch hidden etc.) }
function  existBin(const fn: pathstr): boolean;	{ Datei vorhanden (PATH)  }
Function  ValidFileName(const name:PathStr;savemode:boolean):boolean;  { gltiger Dateiname ?    }
Function  IsPath(name:PathStr):boolean;         { Pfad vorhanden ?        }
function  TempFile(const path:pathstr):pathstr;       { TMP-Namen erzeugen      }
function  TempExtFile(const path,ld,ext:pathstr):pathstr; { Ext-Namen erzeugen }
function  Size_OVR:integer;                     { Groesse des Overlays in KB }
function  _filesize(const fn:pathstr):longint;        { Dateigre in Bytes     }
function  filetime(const fn:pathstr):longint;         { Datei-Timestamp         }
procedure setfiletime(const fn:pathstr; newtime:longint);  { Dateidatum setzen  }
function  copyfile(const srcfn, destfn:pathstr):boolean; { Datei kopieren }
Procedure era(const s:string);                        { Datei lschen           }
procedure erase_mask(const s:string);                 { Datei(en) lschen       }
(* Procedure erase_all(path:pathstr);              { Lschen mit Subdirs     } *)
function  _rename(const n1,n2:pathstr):boolean;       { Lschen mit $I-         }
Procedure MakeBak(const n,newext:string);             { sik anlegen             }
procedure MakeFile(const fn:pathstr);                 { Leerdatei erzeugen      }
procedure mklongdir(path:pathstr; var res:integer);  { mehrere Verz. anl. }
function  diskfree(drive:byte):longint;         { 2-GB-Problem umgehen    }
function  disksize(drive:byte):longint;         { dito                    }
function  disk_free(drive:byte):longint;        { diskfree/NTDiskFree     }
function  exetype(const fn:pathstr):TExeType;

procedure fm_ro;                                { Filemode ReadOnly       }
procedure fm_rw;                                { Filemode Read/Write     }
procedure resetfm(var f:file; fm:byte);         { mit spez. Filemode ffn.}
function  FileLock(var datei:file; from,size:longint):boolean;
procedure FileUnLock(var datei:file; from,size:longint);
function  XPLock:boolean;
procedure XPUnlock;

procedure addext(var fn:pathstr; const ext:extstr);
procedure adddir(var fn:pathstr; dir:dirstr);
function  GetFileDir(const p:pathstr):dirstr;
function  GetFileName(const p:pathstr):string;
function  GetBareFileName(const p:pathstr):string;    { Filename ohne .ext und ohne Pfad}
function  GetFileExt(const p:pathstr):string;         { Extension *ohne* "." }
procedure WildForm(var s: pathstr);              { * zu ??? erweitern }
function ChangeFileExt(const Filename, Ext: string): string;

function  ioerror(i:integer; const otxt:atext):atext; { Fehler-Texte            }
procedure WriteBatch(const s:string);                 { Batchfile erstellen     }
function RenameDir(Const OldName, NewName : String) : Boolean;

implementation  { ------------------------------------------------------- }

uses
  xp0,clip,overlay;

const
  PathSepaChar          = ';';

var
  ShareDa : boolean;

{ Haengt einen fehlenden Verzeichnisseparator an.
  Loest dabei C: auf (nur Nicht-Unix }
function  AddDirSepa(const p: pathstr): pathstr;
var
  cwd: pathstr;
begin
  if p='' then
    AddDirSepa:= ''
  else begin
    if LastChar(p)<>DirSepa then
    begin
      if (length(p)=2) and (p[2]=':') then
      begin	{ Nur C: ? }
        getdir(Ord(UpCase(p[1]))-64,cwd);		{ -> Akt. Verz. ermitteln }
	AddDirSepa:= AddDirSepa(cwd);
      end else
        AddDirSepa:= p+DirSepa;
    end
    else
      AddDirSepa:= p;
  end;
end;

procedure EmergMove2Bad(var f:file);
const name='2BMP-FXP';
var ext  : extstr;

begin
  ext:='.001';
  while exist(BadDir+name+ext) and (ext<>'.999') do
      ext:='.'+formi(ival(mid(ext,2))+1,3);
  if exist(BadDir+name+ext) then
    era(BadDir+name+ext);
  if not exist(BadDir+name+ext) then begin
    rename(f,BadDir+name+ext);
    if ioresult<>0 then;
    end;
end;

{ Sucht die Datei 'fn' in folgender Reihenfolge:
  - Aktuelle Verzeichnis
  - Startverzeichnis der aktuellen Programmdatei
  - Environment-Var PATH
}
function  existBin(const fn: pathstr): boolean;
var
  envpath: string;			{ Opps, bug in brain. PATH kann > 256 sein }
  filename, path: PathStr;
  i, j, k: integer;
begin
  filename:= GetFileName(fn);		{ Evtl. Pfad ignorieren }
  if exist(fn) then begin		{ -> Aktuelles Verzeichnis }
    existBin:= true;
    exit;
  end;
  path:= ProgPath;			{ -> Startverzeichnis }
  if path<>'' then begin
    if exist(AddDirSepa(path)+filename) then begin
      existBin:= true;
      exit;
    end;
  end;
  envpath:= dos.getenv('PATH');
  j:= CountChar(PathSepaChar,envpath);
  for i:= 1 to j do begin
    k:= CPos(PathSepaChar, envpath);
    path:= copy(envpath,1,k-1);
    delete(envpath,1,k);
    if path<>'' then
      if exist(AddDirSepa(path)+filename) then begin
        existBin:= true;
	exit;
      end;
  end;
  if envpath<>'' then begin		{ Noch was ueber ? }
    if exist(AddDirSepa(envpath)+filename) then
      existBin:= true
    else
      existBin:= false;
  end else
    existBin:= false;
end;

function exist(const n:string):boolean;
var
  sr : searchrec;
  ex : boolean;
begin
  FindFirst(n,anyfile-volumeid-directory,sr);
  ex:=(doserror=0);
  while not ex and (doserror=0) do
  begin
    FindNext(sr);
    ex:=(doserror=0);
  end;
  FindClose(sr);
  exist:=ex;
end;

Function existf(var f):Boolean;
var
  fm : byte;
begin
  existf:=false;
  fm:=filemode;
  filemode:=FMDenyNone;
  reset(file(f));
  if IOResult=0 then
  begin
    close(file(f));
    existf:=true;
  end;
  filemode:=fm;
  if ioresult = 0 then ;
end;

Function existrf(var f):Boolean;
var a : rtlword;
    e : boolean;
begin
  getfattr(f,a);
  setfattr(f,archive);
  e:=existf(f);
  setfattr(f,a);
  a:=ioresult;
  existrf:=e;
end;

Function ValidFileName(const name:PathStr;savemode:boolean):boolean;
var f : file;
begin
  if (name='') or multipos('*?/',name) then  { Fehler in DR-DOS 5.0 umgehen }
    ValidFileName:=false
  else begin
    if savemode then assign(f,ustr(name))
    else assign(f,name);
    if existf(f) then ValidFileName:=true
    else begin
      rewrite(f);
      close(f);
      erase(f);
      ValidFileName:=(ioresult=0);
    end;
  end;
end;


Function IsPath(name:PathStr):boolean;         { Pfad vorhanden ? }
var sr : searchrec;
begin
  name:=trim(name);
  if multipos('?*',name) or (name='') then
    IsPath:=false
  else begin
    if (name='\') or (name[length(name)]=':') or (right(name,2)=':\')
    then begin
      findfirst(name+'*.*',ffAnyFile,sr);
      if doserror=0 then
        IsPath:=true
      else
        IsPath:=validfilename(name+'1$2$3.xx',false);
      findclose(sr);
    end
    else
    begin
      if name[length(name)]='\' then
        dellast(name);
      findfirst(name,Directory,sr);
      IsPath:=(doserror=0) and (sr.attr and directory<>0);
      findclose(sr);
    end;
  end;
end;

function copyfile(const srcfn, destfn:pathstr):boolean;  { Datei kopieren }
{ keine berprfung, ob srcfn existiert oder destfn bereits existiert }
var bufs,rr:word;
    buf:pointer;
    f1,f2:file;
begin
  bufs := GetMaxMem(buf, 1024, 32768);
  assign(f1,srcfn);
  assign(f2,destfn);
  reset(f1,1);
  rewrite(f2,1);
  while not eof(f1) and (inoutres=0) do begin
    blockread(f1,buf^,bufs,rr);
    blockwrite(f2,buf^,rr);
  end;
  close(f2);
  close(f1);
  copyfile:=(inoutres=0);
  if ioresult<>0 then ;
  freemem(buf,bufs);
end;

Procedure era(const s:string);
var f : file;
begin
  assign(f,s);
  erase(f);
end;


procedure erase_mask(const s:string);                 { Datei(en) lschen }
var sr : searchrec;
begin
  findfirst(s,ffAnyfile,sr);
  while doserror=0 do begin
    era(getfiledir(s)+sr.name);
    findnext(sr);
  end;
  FindClose(sr);
end;

{ path: Pfad mit '\' bzw. '/' am Ende! }

procedure erase_all(path:pathstr);
var sr : searchrec;
    f  : file;
    er : integer;
begin
  { Auf keinen Fall das XP-Verzeichnis lschen! }
  Findfirst(path+Progname+'.exe',anyfile-VolumeID,sr);
  er:=doserror;
  FindClose(sr);
  { xp.exe gefunden, dann wahrscheinlich im XP-Verzeichnis! }
  if (er=0) then exit;
  { Oops, XPVerzeichnis erwischt! }
  if (ownpath=path) then exit;
  { Oops, Rootverzeichnis erwischt! }
  if ((path='\') or (path='/')) then exit;

  findfirst(path+WildCard,anyfile-VolumeID,sr);
  while (doserror=0) do begin
    with sr do
      if (name[1]<>'.') then
        if attr and Directory<>0 then
          erase_all(path+name+DirSepa)
        else begin
          assign(f,path+name);
          if attr and (ReadOnly+Hidden+Sysfile)<>0 then setfattr(f,0);
          erase(f);
        end;
    findnext(sr);
  end;
  FindClose(sr);
  if cpos(DirSepa,path)<length(path) then begin
    dellast(path);
    rmdir(path);
  end;
end;

Procedure MakeBak(const n,newext:string);
var bakname : string;
    f       : file;
    dir     : dirstr;
    name    : string;
    ext     : extstr;
begin
  assign(f,n);
  if not existrf(f) then exit;
  fsplit(n,dir,name,ext);
  bakname:=dir+name+'.'+newext;
  assign(f,bakname);
  if existrf(f) then begin
    setfattr(f,archive);
    erase(f);
  end;
  assign(f,n);
  setfattr(f,archive);
  rename(f,bakname);
  if ioresult<>0 then;
end;

function ioerror(i:integer; const otxt:atext):atext;
begin
  case i of
      2 : ioerror:='Datei nicht gefunden';
      3 : ioerror:='ungltiges Verzeichnis';
      4 : ioerror:='zu viele Dateien geffnet (bitte FILES erhhen!)';
      5 : ioerror:='Zugriff verweigert';
      7 : ioerror:='Speicherverwaltung zerstrt';
      8 : ioerror:='ungengend Speicher';
     10 : ioerror:='ungltiges Environment';
     11 : ioerror:='ungltiges Aufruf-Format';
     15 : ioerror:='ungltige Laufwerksbezeichnung';
     16 : ioerror:='Verzeichnis kann nicht gelscht werden';
     18 : ioerror:='Fehler bei Dateisuche';
    101 : ioerror:='Diskette/Platte voll';
    150 : ioerror:='Diskette ist schreibgeschtzt';
    152 : ioerror:='keine Diskette eingelegt';
154,156 : ioerror:='Lesefehler (Diskette/Platte defekt)';
157,158 : ioerror:='Diskette ist nicht korrekt formatiert';
    159 : ioerror:='Drucker ist nicht betriebsbereit';
    162 : ioerror:='Hardware-Fehler';
    209 : ioerror:='Fehler in .OVR-Datei';
  else
    ioerror:=otxt;
  end;
end;


procedure WriteBatch(const s:string);
var
  f:text;
  io:integer;
begin
  assign(f, TempBatchFN);
  rewrite(f);
  io:=ioresult;
  if (io=0) then begin
    writeln(f,'@echo off');
    writeln(f,s);
    close(f);
  end;
  io:=ioresult; { Muss das doppelt sein? (hd) }
  io:=ioresult;
end;

{ res:  0 = Pfad bereits vorhanden }
{       1 = Pfad angelegt          }
{     < 0 = IO-Fehler              }

procedure mklongdir(path:pathstr; var res:integer);
const testfile = 'test0000.$$$';
var p : byte;
begin
  path:=trim(path);
  if path='' then begin
    res:=0;
    exit;
  end;
  if right(path,1)<>DirSepa then path:=path+DirSepa;
  if validfilename(path+testfile,false) then
    res:=0
  else
    if pos(DirSepa,path)<=1 then begin
      mkdir(path);
      res:=-ioresult;
    end
    else begin
      p:=iif(path[1]=DirSepa,2,1);
      res:=0;
      while (p<=length(path)) do begin
        while (p<=length(path)) and (path[p]<>DirSepa) do inc(p);
        if not IsPath(left(path,p)) then begin
          mkdir(left(path,p-1));
          if inoutres<>0 then begin
            res:=-ioresult;
            exit;
          end;
        end
        else
          res:=1;
        inc(p);
      end;
    end;
end;

function TempFile(const path:pathstr):pathstr;       { TMP-Namen erzeugen }
var n : string[12];
begin
  repeat
    n:=formi(random(10000),4)+'.TMP'
  until not exist(path+n);
  TempFile:=path+n;
end;

function TempExtFile(const path,ld,ext:pathstr):pathstr;  { Ext-Namen erzeugen }
{ ld max. 4 Zeichen, ext mit Punkt '.bat' }
var n : string[MaxLenFilename];
begin
  repeat
    n:=ld+formi(random(10000),4)+ext
  until not exist(path+n);
  TempExtFile:=path+n;
end;

function Size_OVR:integer;
begin
  Size_OVR:=((_filesize(ownpath+'XP.OVR')) DIV 1024);
end;

function _filesize(const fn:pathstr):longint;
var sr : searchrec;
begin
  findfirst(fn,ffAnyFile,sr);
  if doserror<>0 then
    _filesize:=0
  else
    _filesize:=sr.size;
  FindClose(sr);
end;

procedure MakeFile(const fn:pathstr);
var t : text;
begin
  assign(t,fn);
  rewrite(t);
  if ioresult=5 then
    setfattr(t,0)
  else
    close(t);
end;

function filetime(const fn:pathstr):longint;
var sr : searchrec;
begin
  findfirst(fn,ffAnyFile,sr);
  if doserror=0 then
    filetime:=sr.time
  else
    filetime:=0;
  FindClose(sr);
end;

procedure setfiletime(const fn:pathstr; newtime:longint);  { Dateidatum setzen }
var f : file;
begin
  assign(f,fn);
  reset(f,1);
  setftime(f,newtime);
  close(f);
  if ioresult<>0 then;
end;

function GetFileDir(const p:pathstr):dirstr;
var d : dirstr;
    n : string;
    e : extstr;
begin
  fsplit(p,d,n,e);
  GetFileDir:=d;
end;

function GetFileName(const p:pathstr):string;
var d : dirstr;
    n : string;
    e : extstr;
begin
  fsplit(p,d,n,e);
  GetFileName:=n+e;
end;

function GetBareFileName(const p:pathstr):string;
var d : dirstr;
    n : string;
    e : extstr;
begin
  fsplit(p,d,n,e);
  GetBareFileName:=n;
end;

function GetFileExt(const p:pathstr):string;
var d : dirstr;
    n : string;
    e : extstr;
begin
  fsplit(p,d,n,e);
  GetFileExt:=mid(e,2);
end;

function _rename(const n1,n2:pathstr):boolean;
var f : file;
begin
  assign(f,n1);
  rename(f,n2);
  _rename:=(ioresult=0);
end;

{ Extension anhngen, falls noch nicht vorhanden }

procedure addext(var fn:pathstr; const ext:extstr);
var dir  : dirstr;
    name : string;
    _ext : extstr;
begin
  fsplit(fn,dir,name,_ext);
  if _ext='' then fn:=dir+name+'.'+ext;
end;

{ Verzeichnis einfgen, falls noch nicht vorhanden }

procedure adddir(var fn: pathstr; dir:dirstr);
var _dir : dirstr;
    name : string;
    ext  : extstr;
begin
  fsplit(fn,_dir,name,ext);
  if _dir='' then begin
    if dir[length(dir)]<>DirSepa then dir:=dir+DirSepa;
    insert(dir,fn,1);
  end;
end;

procedure fm_ro;      { Filemode ReadOnly }
begin
  filemode:=fmRead;
end;

procedure fm_rw;      { Filemode Read/Write }
begin
  filemode:=fmRW;
end;

function FileLock(var datei:file; from,size:longint):boolean;
var
  regs : registers;
begin
  if Shareda then
    with regs do
    begin
      ax:=$5c00;
      bx:=filerec(datei).handle;
      cx:=from shr 16; dx:=from and $ffff;
      si:=size shr 16; di:=size and $ffff;
      msdos(regs);
      FileLock:=flags and fcarry = 0;
    end else
      FileLock:=true;
end;

procedure FileUnLock(var datei:file; from,size:longint);
var
  regs : registers;
begin
  if shareda then
  with regs do
  begin
    ax:=$5c01;
    bx:=filerec(datei).handle;
    cx:=from shr 16; dx:=from and $ffff;
    si:=size shr 16; di:=size and $ffff;
    msdos(regs);
  end;
end;

function XPLock:boolean;
var
  regs : registers;
  from,size: longint;

begin
  from:=0;
  size:=_filesize(Progname+'.exe');
  if shareda then
  with regs do
  begin
    ax:=$5c00;
    bx:=OvrDosHandle;
    cx:=from shr 16; dx:=from and $ffff;
    si:=size shr 16; di:=size and $ffff;
    msdos(regs);
    XPLock:=flags and fcarry = 0;
  end else
    XPLock:=true;
end;

procedure XPUnlock;
var
  regs : registers;
  from,size: longint;

begin
  from:=0;
  size:=_filesize(Progname+'.exe');
  if shareda then
  with regs do
  begin
    ax:=$5c01;
    bx:=OvrDosHandle;
    cx:=from shr 16; dx:=from and $ffff;
    si:=size shr 16; di:=size and $ffff;
    msdos(regs);
  end;
end;

(*
procedure TestShare;
var
  regs : registers;
begin
  { Installcheck fr Share }
  with regs do
  begin
    fillchar(regs, sizeof(regs), 0);
    ah:=$10;
    intr($2f, regs);
    ShareDa := al = $ff;
  end;
end;
*)

{$IFDEF NO386}
procedure TestShare;
var
  regs : registers;
begin
  { Installcheck fr Share }
  with regs do
  begin
    fillchar(regs, sizeof(regs), 0);
    ah:=$10;
    intr($2f, regs);
    ShareDa := al = $ff;
  end;
end;
{$ELSE}
procedure Testshare; Assembler;
asm
      mov ax,1000h
      int 2fh
      shr al,7
      mov [shareda],al
end;         
{$ENDIF}

procedure resetfm(var f:file; fm:byte);
var fm0 : byte;
begin
  fm0:=filemode;
  filemode:=fm;
  reset(f,1);
  filemode:=fm0;
end;

procedure WildForm(var s: pathstr);
var dir : dirstr;
    name: string;
    ext : extstr;
    p   : byte;
begin
  fsplit(s,dir,name,ext);
  p:=cpos('*',name);
   if p>0 then name:=left(name,p-1)+typeform.dup(9-p,'?');
  p:=cpos('*',ext);
   if p>0 then ext:=left(ext,p-1)+typeform.dup(5-p,'?');
  s:=dir+name+ext;
end;


{ -------------------------------------------------------- }
{ Hinweis zu diskfree/disksize und Windows NT/2000/XP:     }
{ -------------------------------------------------------- }
{ 'diskfree' und 'disksize' aus fileio.pas sollten unter   }
{ WinNT nicht zum Einsatz kommen, sondern stattdessen      }
{ 'NTDiskFree' bzw. 'NTDiskSize' aus clip.pas. Dabei ist   }
{ zu beachten, da die Funktionen in fileio.pas max. 2GB   }
{ in Bytes zurckgeben, die NT-Funktionen in clip.pas      }
{ jedoch max. 2PB in Megabytes liefern und bei Vergleichen }
{ mit Dateigren unter WinNT die jeweiligen Werte daher   }
{ mit $100000 zu multiplizieren bzw. durch $100000 zu      }
{ dividieren sind.                                         }
{                                                          }
{ Mit der Funktion 'xp_ntvdm_ok' in clip.pas kann festge-  }
{ stellt werden, ob man sich unter Windows NT/2000/XP oder }
{ einem anderen Betriebssystem befindet (xp_ntvdm_ok ist   }
{ immer true unter WinNT).                                 }
{                                                          }
{ Die Funktion 'disk_free' fat die Funktionen 'diskfree'  }
{ und 'NTDiskFree' zusammen und gibt ebenfalls max. 2GB    }
{ in Bytes zurck.                                         }
{ -------------------------------------------------------- } 


{ Zwei diskfree/disksize-Probleme umgehen:                   }
{                                                            }
{ - bei 2..4 GB liefern diskfree und disksize negative Werte }
{ - bei bestimmten Cluster/Sektorgren-Kombinationen        }
{   liefern diskfree und disksize falsche Werte              }

function diskspace(drive:byte; size:boolean):longint;
var l,ll : longint;
    regs : registers;
begin
  regs.ah := $36;
  regs.dl := drive;
  msdos(regs);
  if regs.ax=$ffff then
    l:=0
  else begin
    if size then
      l:=longint(regs.ax)*regs.dx    { Secs/Cluster * Clusters/Disk }
    else
      l:=longint(regs.ax)*regs.bx;   { Secs/Cluster * Free Clusters }
    if regs.cx>=512 then
      ll:=(l div 2)*(regs.cx div 512)
    else
      ll:=(l div 1024)*regs.cx;
    if ll>=2097152 then
      l:=maxlongint
    else
      l:=l*regs.cx;
  end;
  diskspace:=l;
end;

function diskfree(drive:byte):longint;
begin
  diskfree:=diskspace(drive,false);
end;

function disksize(drive:byte):longint;
begin
  disksize:=diskspace(drive,true);
end;

{ Diese Funktion ermittelt den freien Festplattenplatz   }
{ in Abhngigkeit vom verwendeten OS (unter WinNT/2K/XP  }
{ mit 'NTDiskFree' (siehe clip.pas), bei allen anderen   }
{ mit 'diskfree'(siehe oben)). Max. Rckgabewert ist 2GB }
{ in Bytes (maxlongint), daher kann die Funktion direkt  }
{ bei Tests auf ausreichenden Plattenplatz verwendet     }
{ werden, ohne in den Routinen selbst auf das OS prfen  }
{ zu mssen.                                             }
{                                                        }
{                                         MW+MY  08/2003 }

function disk_free(drive:byte):longint;
var free : longint;
begin
{$IFNDEF NO386}
  if xp_ntvdm_ok then
  begin
    free:=NTDiskFree(drive);
    if free>2047 then
      free:=maxlongint
    else
      free:=free*$100000;
  end
  else free:=fileio.diskfree(drive);
{$ELSE}
  free:=fileio.diskfree(drive);
{$ENDIF}        
  disk_free:=free;
end;


function exetype(const fn:pathstr):TExeType;
var f       : file;
    magic   : array[0..1] of char;
    magic2  : array[0..2] of char;
    hdadr   : longint;
    version : byte;
begin
  assign(f,fn);
  resetfm(f,FMDenyWrite);
  blockread(f,magic,2);
  seek(f,60);
  blockread(f,hdadr,4);
  if (ioresult<>0) then
    exetype:=ET_Unknown
  else if (magic<>'MZ') then
    begin
      seek(f, 1);                    { ELF }
      blockread(f,magic2,3);         { IOResult braucht nicht abgefragt }
      if (magic2='ELF') then         { zu werden, da bereits ein hoehrer }
        exetype:=ET_ELF              { Offset verwandt wurde }
      { Fuer andere Suchen }
      else
        exetype:=ET_Unknown;
    end
  else if odd(hdadr) then
    exetype:=ET_DOS
  else
  begin { MK 01/00 Fix fr LZEXE gepackte Dateien }
    if (hdadr > 0) and (hdadr < FileSize(f)-54) then
    begin
      seek(f,hdadr);
      blockread(f,magic,2);
      if ioresult<>0 then
        exetype:=ET_DOS
      else if magic='PE' then
        exetype:=ET_Win32
      else if magic='LX' then
        exetype:=ET_OS2_32
      else if magic<>'NE' then
        exetype:=ET_DOS
      else begin
        seek(f,hdadr+54);
        blockread(f,version,1);
        if version=2 then exetype:=ET_Win16
        else exetype:=ET_OS2_16;
      end;
    end else
      exetype := ET_DOS;
  end;
  close(f);
  if ioresult<>0 then;
end;

function RenameDir(Const OldName, NewName : String) : Boolean;
var
  f: File;
begin
  Assign(f, Oldname);
  rename(f, newname);
  RenameDir := IOResult = 0;
end;

function ChangeFileExt(const Filename, Ext: string): string;
var d, n, e: String;
begin
  fsplit(Filename,d,n,e);
  ChangeFileExt := d + n + Ext;
end;

begin
  TestShare;
end.
