{ ------------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.                   }
{ (c) 1991-1999 Peter Mandrella                                       }
{ (c) 2000-2001 OpenXP-Team                                           }
{ (c) 2002-2024 FreeXP, http://www.freexp.de                          }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.         }
{                                                                     }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der     }
{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html }
{ ------------------------------------------------------------------- }

{ DATABASE.PAS - globale Deklarationen }

{$I XPDEFINE.INC }

unit datadef;

interface

uses xpglobal;

const   dbEMShandle   : word = 0;
        dbInterrProc  : pointer = nil;

{$IFDEF UnixFS }
        dbExt         = '.db1';
        dbIxExt       = '.ix1';
        dbExtExt      = '.eb1';
{$ELSE }
        dbExt         = '.DB1';
        dbIxExt       = '.IX1';
        dbExtExt      = '.EB1';
{$ENDIF }

        dbFeldNameLen = 10;

        dbTypeString  = 1;    { String mit Lngenbyte, Freiraum 0-gefllt }
        dbTypeInt     = 2;    { numerisch mitVorzeichen, 1/2/4 Bytes      }
        dbTypeReal    = 3;    { Real 6 Bytes                              }
        dbTypeDatum   = 4;    { Datum 4 Bytes t/m/jj  ==  LongInt         }
        dbUntyped     = 5;    { untypisiert, feste Lnge                  }
        dbUntypedExt  = 6;    { bis 32K Lnge, 4Byte-Zeiger auf DBD-File  }

        dbFlagIndexed = 1;    { Flag fr dbOpen }

        icIndexNum    = 1;    { <- Anzahl Indizes   (indexnr)     }
        icIndex       = 2;    { <- indexstr [ / indexproc]        }
        icOpenWindow  = 3;    { -> Message-Fenster                }
        icShowIx      = 4;    { -> Anzeige (df/indexnr/percent)   }
        icCloseWindow = 6;    { -> Message-Fenster schliessen     }
        icOpenCWindow = 7;    { -> Message-Fenster f. Konvert.    }
        icShowConvert = 8;    { -> Anzeige (df/percemt)           }
        icOpenPWindow = 9;    { -> Pack-Fenster                   }
        icShowPack    = 10;   { -> Anzeige (df/percent)           }
        icOpenKwindow = 11;   { -> Kill-EB1-Fenster               }
        icShowKillX   = 12;   { -> Anzeige (df/percent/count)     }


type    DB          = pointer;   { allgemeiner Datenbank-Typ }
        dbFeldStr   = string[dbFeldNameLen];
        dbFileName  = string[80];

        dbFeldTyp   = packed record             { Felder s.u. (dbfeld)      }
                        fname     : dbFeldStr;  { Name aus A..Z,_           }
                        ftyp      : byte;       { 1..6                      }
                        fsize     : smallword;  { phys. Feldgre bei 1,2,5 }
                        fnlen,fnk : byte;       { nur bei Typ 2,3           }
                        fofs      : smallword;  { intern: Offset im record  }
                        indexed   : boolean;    { intern: indiziertes Feld  }
                      end;

        dbFeldListe = packed record
                        felder : smallword;
                        feld   : array[0..1000] of dbFeldTyp;  { 0=INT_NR }
                      end;
        dbFLP       = ^dbFeldListe;

        dbIndexFunc = function(dpb:DB):string;
        dbIndexCRec = packed record
                        command  : byte;        { ->  }
                        indexnr  : byte;        { <-> }
                        df       : dbFileName;  { ->  }
                        indexstr : string[80];  { <-  }
                        indexfunc: dbIndexFunc; { <-  }
                        indexsize: byte;        { <-  }
                        percent  : byte;        { ->  }
                        count    : longint;     { ->  }
                      end;
        dbIndexCProc= procedure(var ICR:dbIndexCrec);  { s. Dateiende! }


implementation

end.

