{ ------------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.                   }
{ (c) 1991-1999 Peter Mandrella                                       }
{ (c) 2000-2001 OpenXP-Team                                           }
{ (c) 2002-2026 FreeXP, http://www.freexp.de                          }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.         }
{                                                                     }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der     }
{ Datei SLIZENZ.TXT oder auf http://www.crosspoint.de/oldlicense.html }
{ ------------------------------------------------------------------- }

{$I XPDEFINE.INC }
{$O+,F+}

unit clip;

interface

uses xpglobal,resource, dos;

function ClipAvailable:boolean;                     { Clipboard verfgbar?        }

function  Clip2String(maxlen,oneline:byte):string;  { Clipboardinhalt als String }
procedure String2Clip(var str: String);             { String ins Clipboard       }
{$IFNDEF NO386}
procedure FileToClip(fn:pathstr);                   { Dateiinhalt ins Clipboard  }
procedure ClipToFile(fn:pathstr);                   { Clipboardinhalt als Datei  }

function  TrueWinVersion:smallword;
function  WinVersion:smallword;                     { Windows >= 3.0             }
function  WinNTVersion:dword;
function  InitWinVersion:SmallWord;
procedure DestructWinVersion;
function  DOSEmuVersion: String;
function  DOSBOX: boolean;

function NTDiskFree(drive:byte):longint;
function NTDiskSize(drive:byte):longint;
function NTDiskType(drive:byte):byte;
function xp_ntvdm_ver:byte;
function Is64BitWindows:byte;
function xp_ntvdm_ok:boolean;

function GetTimezone(var tzone:string):boolean;

procedure GetConsoleTitle(maxlen:byte;var contitle:String);
procedure SetConsoleTitle(contitle:string);
{$ELSE}
procedure ClipToFile(fn:pathstr);
procedure FileToClip(fn:pathstr); 
{$ENDIF}
function  SmartInstalled:boolean;
function  SmartCache(drive:byte):byte;          { 0=nope, 1=read, 2=write }
function  SmartSetCache(drive,b:byte):boolean;  { 0=nope, 1=read, 2=write }
procedure SmartResetCache;
procedure SmartFlushCache;

var mode,minutes: longint;

const
  ClipFileName = 'CLIP.TXT';

implementation  { ---------------------------------------------------- }

uses
  xp0, fileio, typeform, crt;

const
  Multiplex = $2f;
  cf_Oemtext   = 7;
  maxfile   = 65520;

type
  ca  = array[0..65530] of char;
  cap = ^ca;

{$IFNDEF NO386}
var
  windows_version:  smallword;
  windows_nt_ver:   Dword;
  ntvdm_handle:	    smallword;
  ntvdm_error:	    smallword;

function TrueWinVersion:smallword;assembler;      { echte Windows-Version abfragen }
asm
              mov    ax,1600h
              int    Multiplex
              cmp    al,0
              jz     @NoWin
              cmp    al,20
              ja     @NoWin
              cmp    al,1
              jz     @Win386
              cmp    al,0ffh
              jz     @Win386
              xchg   al,ah
              jmp    @WinOk
@Win386:      mov    ax,200h
              jmp    @WinOk
@NoWin:       xor    ax,ax
@WinOk:
end;

{ Rckgabe: 2 = Win 3.xx, 3 = Win95/98/ME/..., 4 = WinNT/2k/XP/... }
function WinVersion:smallword;             { Windows-Version abfragen }
begin
  WinVersion := windows_version;
end;

function WinNTVersion:DWord;
begin
  WinNTVersion := windows_nt_ver;
end;  

function InitWinVersion:SmallWord; assembler;
const
  winnt_version_dll_name:pchar = 'XP_NTVDM.DLL';
  winnt_version_dll_init:pchar = 'FREEXP_INIT';
  winnt_version_dll_call:pchar = 'FREEXP_CALL';
asm
              mov    ax,160Ah
              int    Multiplex
              or     ax, ax
              jne    @NoWin95    { Call not supported }
              cmp    bx, 0395h   { lter als Win95x }
              jae    @Win3
	      mov    ax, 2
	      jmp    @Done	 { Win 3.1 }
@Win3:        cmp    bh, 3       { Win 95 oder 98 }
              jz     @Win95
              cmp    bh, 4       { Win 95 oder 98 }
              jnz    @NoWin95
@Win95:       mov    ax, 3
	      jmp    @Done       { Win 95/98/ME }
@NoWin95:     mov    ax, $3306   { Get True Version Number }
              int    $21
              cmp    bx, $3205   { Win NT/2000 DOS Box }
              jne    @NoWin

	      push ds

              mov ax, word ptr winnt_version_dll_name+2;
	      push ax
	      pop ds
              mov ax, word ptr winnt_version_dll_init+2;
	      push ax
	      pop es
              mov si, word ptr winnt_version_dll_name;
              mov di, word ptr winnt_version_dll_init;
              mov bx, word ptr winnt_version_dll_call;
              dw     $c4c4    { illegal instruction (for ntvdm calls) }
              db     $58,$00  { RegisterModule }
	      jc     @ErrorNT

	      mov    ntvdm_handle,ax

	      xor    dx, dx
	      dw     $c4c4
	      db     $58,$02  

	      db     $66			{ 32 bit prefix }
	      mov    WORD PTR windows_nt_ver,ax { mov DWORD PTR ..., eax }

              jmp    @DoneNT
	      
@ErrorNT:     {xor    ax, ax }
	      mov    WORD PTR windows_nt_ver+2, ax
	      xor    ax, ax
	      mov    WORD PTR windows_nt_ver, ax
	      mov    ntvdm_handle,ax

@DoneNT:      pop    ds
	      mov    ax, 4 	 { Win NT }
              jmp    @Done

@NoWin:       xor    ax, ax
@Done:        mov    windows_version, ax
end;

{ Gibt die Versionnummer vom DOSEmu zurck, wenn XP nicht unter
  dem Linux DOSEmu luft, wird ein Leerstring zurckgegeben }
function DOSEmuVersion: String;
const
  DOSEMU_MAGIC_STRING       = '$DOSEMU$';
var
  DOSEMU_MAGIC: array[1..8] of char absolute $F000:$FFE0;
  DOSEMU_VersionPos: array[1..4] of byte absolute $F000:$FFE8;
  Dosemu_Dummy: String[8];
begin
  DOSEmuVersion:= '';
  Move(DOSEMU_MAGIC, DOSEMU_DUMMY[1], sizeof(DOSEMU_DUMMY) - 1);
  Dosemu_Dummy[0] := chr(sizeof(Dosemu_Dummy) - 1);
  if Dosemu_Dummy = DOSEMU_MAGIC_STRING then
    DOSEmuVersion:= StrS(DOSEMU_VersionPos[4]) + '.' +
      StrS(DOSEMU_VersionPos[3]) + '.' + StrS(DOSEMU_VersionPos[2]);
end;

function DOSBOX: boolean;
var
  DOSBOX_X_MAGIC: array[1..8] of char absolute $F000:$E061;
  DOSBOX_Dummy: String[8];
begin
  Move(DOSBOX_X_MAGIC, DOSBOX_Dummy[1], sizeof(DOSBOX_Dummy) - 1);
  DOSBOX_Dummy[0] := chr(sizeof(DOSBOX_Dummy) - 1);
  if DOSBOX_Dummy = 'DOSBox-X' then
    DOSBOX:=True
  else  
    DOSBOX:=(Test8086>1) and not (MEM[$F000 : $FFFE] = $FC);
end;

function GetTimezone(var tzone:string):boolean;
var hour:longint;
var mode:smallint;
var minutes:smallint;

   function Loadtimezone1:longint;assembler;
   asm
     mov dx,$0002
     mov ax,ntvdm_handle
     db  $c4,$c4,$58,2
   end;

   function Loadtimezone2:longint;assembler;
   asm
     mov dx,$0003
     mov ax,ntvdm_handle
     db  $c4,$c4,$58,2
   end;

   function makeTZ(sw:char;tzdiff:longint):string;
   var s:string;
   begin
     s:=strs(tzdiff);
     if s[1]<>'-' then s:=sw+'+'+s else s:=sw+s;
     makeTZ:=s;
   end;

begin
  {Nur bei Windows NT 5.x moeglich}
  if ((WinVersion=4) and (Lo(WinNTVersion)>=5)) then
  begin
    mode:=Loadtimezone1;        {NTVDM aufrufen}
    minutes:=Loadtimezone2;     {NTVDM aufrufen}
    hour:=-(minutes div 60);
    {hour:=hour mod 24;}
    if (mode=0) then
       tzone:=makeTZ('W',hour)
    else
      tzone:=makeTZ('S',hour);    
    GetTimezone:=true;
  end
   else
     GetTimezone:=false;
end;

{ -------------------------------------------------------- }
{ Hinweis zu diskfree/disksize und Windows NT/2000/XP:     }
{ -------------------------------------------------------- }
{ 'diskfree' und 'disksize' aus fileio.pas sollten unter   }
{ WinNT nicht zum Einsatz kommen, sondern stattdessen      }
{ 'NTDiskFree' bzw. 'NTDiskSize' aus clip.pas. Dabei ist   }
{ zu beachten, da die Funktionen in fileio.pas max. 2GB   }
{ in Bytes zurckgeben, die NT-Funktionen in clip.pas      }
{ jedoch max. 2PB in Megabytes liefern und bei Vergleichen }
{ mit Dateigren unter WinNT die jeweiligen Werte daher   }
{ mit $100000 zu multiplizieren bzw. durch $100000 zu      }
{ dividieren sind.                                         }
{                                                          }
{ Mit der Funktion 'xp_ntvdm_ok' in clip.pas kann festge-  }
{ stellt werden, ob man sich unter Windows NT/2000/XP oder }
{ einem anderen Betriebssystem befindet (xp_ntvdm_ok ist   }
{ immer true unter WinNT).                                 }
{                                                          }
{ Die Funktion 'disk_free' fat die Funktionen 'diskfree'  }
{ und 'NTDiskFree' zusammen und gibt ebenfalls max. 2GB    }
{ in Bytes zurck.                                         }
{ -------------------------------------------------------- } 


function NTDiskFree(drive:byte):longint;assembler;
asm
  mov cl,drive
  mov dx,$0200
  mov ax,ntvdm_handle
  db  $c4,$c4,$58,2
  db  $66
  mov dx,ax
  db  $66
  sar dx,16
end;

function NTDiskSize(drive:byte):longint;assembler;
asm
  mov cl,drive
  mov dx,$0201
  mov ax,ntvdm_handle
  db  $c4,$c4,$58,2
  db  $66
  mov dx,ax
  db  $66
  sar dx,16
end;

{ Hinweis zu NTDiskType (Disktype per Win32-API }
{ Aufgerufen wird diese Funktion mit 1=A usw.   }
{ Als Rckgabewert erhlt man                   }
{ 0 = unbestimmter Disktyp                      }
{ 1 = kein ROOT-DIR                             } 
{ 2 = Wechseldatentraeger                       }
{ 3 = Festplatte                                }
{ 4 = Netzwerklaufwerk                          }
{ 5 = CD/DVD-Laufwerk                           }
{ 6 = RAM-Disk                                  }

function NTDiskType(drive:byte):byte;assembler;
asm
  mov cl,drive
  mov dx,$0203
  mov ax,ntvdm_handle
  db  $c4,$c4,$58,2
end;

function xp_ntvdm_ver:byte;assembler;
asm
  mov dx,$0001
  mov ax,ntvdm_handle
  db  $c4,$c4,$58,2
end;

function _Is64BitWindows:byte;assembler;
asm
  mov dx,$0004
  mov ax,ntvdm_handle
  db  $c4,$c4,$58,2
end;

function Is64BitWindows:byte;
begin
  {Nur bei Windows NT 5.x moeglich}
  if ((WinVersion=4) and (Lo(WinNTVersion)>=5)) then
  begin
     Is64BitWindows:=_Is64BitWindows;
  end
  else
  begin
     Is64BitWindows:=0;
  end; 
end;

function xp_ntvdm_ok:boolean;
begin
  xp_ntvdm_ok:=(WinVersion=4) and (Lo(WinNTVersion)<>0);
end;

procedure GetConsoleTitle(maxlen:byte;var contitle:String);
var p: pointer;
begin
 p:=@contitle;
 if ((xp_ntvdm_ok) and (xp_ntvdm_ver>=3)) then
 asm
   mov cl,maxlen
   db  $66		    { 32 bit prefix }
   mov di,WORD PTR p	    { mov edi, DWORD PTR p }
   mov dx,$0300
   mov ax,ntvdm_handle
   db  $c4,$c4,$58,2
 end;  
end;

procedure SetConsoleTitle(contitle:string);
var p:pointer;
    maxlen:byte;
begin
 p:=@contitle;
 maxlen:=length(contitle);
 if ((xp_ntvdm_ok) and (xp_ntvdm_ver>=3)) then
 asm
   mov cl,maxlen
   db  $66		    { 32 bit prefix }
   mov di,WORD PTR p	    { mov edi, DWORD PTR p }   
   mov dx,$0302
   mov ax,ntvdm_handle
   db  $c4,$c4,$58,2
 end;  
end;

procedure DestructWinVersion;
begin
  if windows_version <> 4 then exit;
  if ntvdm_handle = 0 then exit;
  asm
    mov ax, ntvdm_handle;
    dw $c4c4
    db $58,1
  end;
end;

function WinClipAvailable:boolean; assembler;   { wird Clipboard untersttzt? }
asm
              mov    ax,1700h
              int    multiplex
              sub    ax,1700h
              jz     @ca1
              mov    al,1
@ca1:
end;

function WinNTClipAvailable:boolean;            { NTVDM-Clipboard vorhanden? }
begin
  WinNTClipAvailable := ((WinVersion=4) 
    and (ntvdm_handle<>0));
end;

function ClipAvailable:boolean;
begin
  ClipAvailable := WinClipAvailable or WinNTClipAvailable;
end;
{$ELSE}
function ClipAvailable:boolean;				  { Stub fuer 8088/8088 Version }
begin
  ClipAvailable := False;
end;
{$ENDIF}

function ClipOpen:boolean; assembler;         { Clipboard ffnen }
asm
              mov    ax,1701h
              int    multiplex
              or     ax,ax
              jz     @c1
              mov    ax,1
@c1:
end;



function ClipClose:boolean; assembler;        { Clipboard schlieen }
asm
              mov    ax,1708h
              int    multiplex
              or     ax,ax
              jz     @c1
              mov    ax,1
@c1:
end;

function ClipEmpty:boolean; assembler;       { Clipboard lschen }
asm
              mov    ax,1702h
              int    multiplex
              or     ax,ax
              jz     @c1
              mov    ax,1
@c1:         
end;

function ClipCompact(desired:longint):longint; assembler;     { Platz ermitteln }
asm
              mov    ax,1709h
              mov    cx,word ptr desired
              mov    si,word ptr desired+2
              int    multiplex               { Ergebnis in DX:AX }
end;


function ClipWrite2(format:word; lsize:longint; var ldata):boolean; near; assembler;
asm
              mov ax,1703h
              mov dx,format
              mov si,word ptr lsize+2             { lsize ist zwar longint }
              mov cx,word ptr lsize               { aber es werden maximal 64K genutzt }
              les bx,ldata

              cmp cx,0ffffh
              jne @1                              {Text MUSS mit #0 enden !!!!}
              dec cx                              { Wenn 65536 Zeichen wird das letze auf #0 gesetzt }
@1:
              mov di,cx
              mov byte ptr es:[bx+di],0
              inc cx

              int multiplex
              or ax,ax
              jz @cw1
              mov ax,1
@cw1:
end;

function ClipGetDatasize(format:word):longint; assembler;
asm
              mov    ax,1704h
              mov    dx,format
              int    multiplex         { liefert Ergebnis in DX:AX }
end;


function ClipRead(format:word; var ldata):boolean; assembler;   { Daten lesen }
asm
              mov    ax,1705h
              mov    dx,format
              mov    es,word ptr ldata+2
              mov    bx,word ptr ldata
              int    multiplex
              or     ax,ax
              jz     @cr1
              mov    ax,1
@cr1:
end;

{$IFNDEF NO386}
function _Clip2String(maxlen,oneline:byte):string;
var
  s: String;
  p: pointer;
begin

  if WinNTClipAvailable then
  begin
    p:=@s;
    asm
      db  $66		    { 32 bit prefix }
      mov di,WORD PTR p	    { mov edi, DWORD PTR p }
      mov cl,maxlen
      mov ch,oneline
      
      mov dx,$0101
      mov ax,ntvdm_handle
      db  $c4,$c4,$58,2
      cld
    end;    
    _Clip2String := s;
  end else
  { Text aus Clipboard direkt als Pascal-String uebergeben             }
  { Maximallaenge, Einzeilig ( <> 0: CR/LF wird in Space umgewandelt)  }
  asm           les bx,@result
                mov word ptr es:[bx],0         { Leerstring bei Fehler }

                mov ax,1701h                   { Clipboard ffnen }
                int multiplex
                push ax                        { Aktuellen Clipboardstatus merken }

                mov ax,1704h                   { Datengrsse ermitteln }
                mov dx,cf_Oemtext
                int multiplex                  { DX:AX }
                pop di                         { Clipboardstatus }

                cmp ax,$0100                   { Abbruch bei }
                ja @nope                       { leerem Testclipboard }
                jne @lower
                dec ax
  @lower:       cmp al,0
                or dl,ah
                cmp dx,0                       { oder mehr als 256 Zeichen }
                jne @nope

                les bx,@result
                inc bx
                push ax                        { Textlnge, Start und    }
                push bx                        { Clipboardstatus sichern }
                push di

                push word ptr es:[bx+256]      { Bytes nach String retten }
                mov ax,1705h                   { Text aus Clipboard anhngen }
                mov dx,cf_Oemtext
                int multiplex
                pop word ptr es:[bx+256]

                pop di
                pop si                         { SI=Textstart }
                pop cx
                mov ch,0                       { CX=Textlnge laut Windows }
                inc cx                         { ( gerundet auf 32Byte )   }

                mov bx,-1
  @@1:          inc bx
                dec cx
                je @@1c
                cmp byte ptr es:[si+bx],0      { vom Textanfang aus }
                jne @@1                        { erste Null suchen }

  @@1c:         cmp oneline,0
                je @@1b
  @@1a:         cmp byte ptr es:[si+bx-1],' '
                jnbe @@1b
                dec bx
                jz @nope
                jmp @@1a

  @@1b:         cmp bl,maxlen                  { Stringlnge auf Maximallnge krzen }
                jna @1
                mov bl,maxlen
  @1:           mov es:[si-1],bl
                mov cl,bl
       
                dec bx     
       
                cmp oneline,0                  { Wenn alles in eine Zeile soll... }
                je @bye
  @@2:          cmp byte ptr es:[si+bx],' '    { Steuerzeichen in Spaces umwandeln }
                jnb @@3

                mov ah,bl
  @@2a:         mov al, es:[si+bx+1]
                mov es:[si+bx],al
                inc bl
                cmp bl,cl
                jbe @@2a
                dec byte ptr[es:si-1]
                mov bl,ah 
                                      
  @@3:          dec bx
                jns @@2
                jmp @bye

  @nope:        push 1000                      { Fehler: }
                call far ptr sound             { BEEP    }
                push 25
                call far ptr delay
                push 780
                call far ptr sound
                push 25
                call far ptr delay
                call far ptr nosound

  @bye:         mov ax,1708h                   { Clipboard immer schliessen }
                int multiplex
  @jup:
  end; 
end;
{$ENDIF} 

function Clip2String(maxlen,oneline:byte):String;
var t: text;
    s: String;
begin
{$IFNDEF NO386}
  if Clipboard then Clip2String:=_Clip2String(maxlen,oneline)
  else begin
  {$ENDIF} 
    s:='';
    assign(t,ClipFileName);
    reset(t);
    if IOResult = 0 then
    begin
      readln(t,s);
      close(t);
    end;
    Clip2String:=s;
	{$IFNDEF NO386}
  end;
  {$ENDIF} 
end;  

{ String ins Clipboard kopieren }
{$IFNDEF NO386}
procedure _String2Clip(var str:string);
var
  str_p: Pointer;
  str_l: DWORD;
begin
  if WinNTClipAvailable then
  begin
    str_p:=@(Str[1]);
    str_l:=Length(Str);
    asm
      db  $66		 { 32 bit prefix }
      mov si,WORD PTR str_p { mov esi, DWORD PTR sp }
      db  $66
      mov cx,WORD PTR str_l { mov ecx, DWORD PTR sl }
    
      mov dx,$0102
      mov ax,ntvdm_handle
      db  $c4,$c4,$58,2
    end;    
  end else
  asm
              mov ax,1701h                     { Clipboard ffnen }
              int multiplex
              push ax                          { Aktuellen Clipboardstatus merken }

              mov ax,1702h
              int multiplex                    { Clipboard leeren}

              les bx,str
              mov si,0
              mov cx,si
              mov cl,es:[bx]                   { Stringlnge -> si:cx   }
              inc bx                           { Textstart   -> es:bx   }
              jcxz @quit                       { Abbruch bei Nullstring } 

              mov di,cx
              add di,bx 
              inc cx
              push word ptr es:[di]            { Alte Daten am Stringende sichern } 
              mov al,0
              stosb                            { String muss mit #0 enden... }

              mov ax,1703h                     { String ins Clipboard schreiben... }
              mov dx,cf_Oemtext                { Als OEMTEXT }
              int multiplex
              pop ax                           { Alte Stringende-Daten zurckschreiben } 
              stosw

  @quit:      pop ax
              or ax,ax                         { Wenn Clipboard nicht auf war }
              je @end
              mov ax,1708h                     { wieder schliessen }
              int multiplex
  @end:
  end;
end;
{$ENDIF} 
  
procedure String2Clip(var str:string);
var t: text;
begin
{$IFNDEF NO386}
  if Clipboard then _String2Clip(str)
  else begin
  {$ENDIF} 
    assign(t,ClipFileName);
    rewrite(t);
    if IOResult = 0 then
    begin
      writeln(t,str);
      close(t);
    end;
{$IFNDEF NO386}
  end;
  {$ENDIF} 
end;  


{ Schreiben }
function ClipWrite(format:word; size:longint; var data):boolean;
begin
  if ClipCompact(size)>=size then
    ClipWrite:=ClipWrite2(format,size,data)
  else
    ClipWrite:=false;
end;


procedure replace_asc0(var puffer;len:word); assembler;
asm
    les di,puffer
    mov cx,len
    mov al,0
@1: repne scasb
    jne @end
    mov byte ptr [es:di-1],' '
    jmp @1
@end:
end;

{$IFNDEF NO386}
procedure FileToClip(fn:pathstr);       { Dateiinhalt ins Clipboard schicken }
var f  : file;
    p  : pointer;
    bs : word;
    rr : word;
begin
  if WinNTClipAvailable then
  begin
    fn:=fn+#0;
    p := @(fn[1]);
    asm
      db  $66		{ 32 bit prefix }
      mov si,WORD PTR p { mov esi, DWORD PTR p }
      mov dx,$0104
      mov ax,ntvdm_handle
      db  $c4,$c4,$58,2
      cld
    end;    
  end else
  if WinClipAvailable and ClipOpen then
  begin
    assign(f,fn);
    reset(f,1);
    if ioresult=0 then
    begin
      if maxavail>maxfile then
        bs:=maxfile
      else
        bs:=maxavail;
      getmem(p,bs);
      blockread(f,p^,bs,rr);
      ClipEmpty;
      replace_asc0(p^,rr);
      ClipWrite(cf_Oemtext,rr,p^);
      freemem(p,bs);
      close(f);
    end;
    ClipClose;                          { Clipboard immer schliessen }
  end;
end;

procedure ClipToFile(fn:pathstr);       { Clipboardinhalt als File speichern }
var f  : file;
    p  : cap;
    bs : longint;
    s  : string[40];
    bp : longint;
begin
  if WinNTClipAvailable then
  begin
    fn:=fn+#0;
    p := @(fn[1]);
    asm
      db  $66		{ 32 bit prefix }
      mov si,WORD PTR p { mov esi, DWORD PTR p }
      mov dx,$0103
      mov ax,ntvdm_handle
      db  $c4,$c4,$58,2
      cld
    end;    
  end
  else begin
    assign(f,fn);
    rewrite(f,1);
    if IOResult = 0 then
    begin
      if WinClipAvailable and ClipOpen then
      begin
        bs:=ClipGetDatasize(cf_OemText);
        if (bs>=maxfile) or (bs>=maxavail) then begin  { Passen wenn Clipboardinhalt }
          s:=getres2(10100,12)+#13#10;                 { grsser als Clipfile oder   }
          blockwrite(f,s[1],length(s));                { freier Speicher ist         }
        end
        else if bs>0 then begin
          getmem(p,bs);
          if ClipRead(cf_Oemtext,p^) then
          begin
            bp:=0;
            while (bp<bs) and (p^[bp]<>#0) do inc(bp);
            blockwrite(f,p^,bp);
          end;
          freemem(p,bs);
        end;
        ClipClose;                      { Clipboard immer schliessen }
      end;
      close(f);
    end;
  end;
end;

{$ELSE} 

procedure FileToClip(fn:pathstr);       { Dateiinhalt ins Windows-Clipboard schicken }
var f  : file;
    p  : pointer;
    bs : word;
    rr : word;
begin
  assign(f,fn);
  reset(f,1);
  if ioresult=0 then
    if ClipAvailable and ClipOpen then begin
      if maxavail>maxfile then bs:=maxfile
      else bs:=maxavail;
      getmem(p,bs);
      blockread(f,p^,bs,rr);
      close(f);
      if ClipEmpty then;
      if ClipWrite(cf_Oemtext,rr,p^) then;
      if ClipClose then;
      freemem(p,bs);
      end;
end;

procedure ClipToFile(fn:pathstr);       { Win-Clipboardinhalt als File speichern }
var f  : file;
    p  : cap;
    bs : longint;
    s  : string[40];
    bp : longint;
begin
  assign(f,fn);
  rewrite(f,1);
  if ioresult=0 then begin
    if ClipAvailable and ClipOpen then begin
      bs:=ClipGetDatasize(cf_OemText);
      if (bs>=maxfile) or (bs>=maxavail) then begin       { Passen wenn CLipboardinhalt }
        s:='Clipboard-Inhalt ist zu umfangreich'#13#10;   { groesser als Clipfile oder  }
        blockwrite(f,s[1],length(s));                     { freier Speicher ist         }
      end
      else if bs>0 then begin
        getmem(p,bs);
        if ClipRead(cf_Oemtext,p^) then begin
          bp:=0;
          while (bp<bs) and (p^[bp]<>#0) do inc(bp);
          if (bp=bs) and (p^[bp]<>#0) then bp:=0;

          blockwrite(f,p^,bp);
        end;
        freemem(p,bs);
      end;
      if ClipClose then;
    end;
    close(f);
  end;
end;
{$ENDIF} 

{ Smartdrive vorhanden? }

function SmartInstalled:boolean;
var regs : registers;
begin
  with regs do begin
    ax:=$4a10;
    bx:=0;                { installation check }
    intr($2f,regs);
    SmartInstalled:=(ax=$BABE);
    end;
end;


{ Cache-Status abfragen }

function SmartCache(drive:byte):byte;          { 0=nope, 1=read, 2=write }
var regs : registers;
begin
  with regs do begin
    ax:=$4a10;
    bx:=3;
    bp:=drive;
    dl:=0;                { get status }
    intr($2f,regs);
    if (ax<>$BABE) or (dl=$ff) then
      SmartCache:=0
    else if dl and $40=0 then SmartCache:=2
    else if dl and $80=0 then SmartCache:=1
    else SmartCache:=0;
    end;
end;


{ Cache-Status setzen }

function SmartSetCache(drive,b:byte):boolean;  { 0=nope, 1=read, 2=write }
var regs : registers;
  procedure sfunc(nr:byte);
  begin
    with regs do begin
      ax:=$4a10;
      bx:=3;
      bp:=drive;
      dl:=nr;
      intr($2f,regs);
      SmartSetcache:=(ax=$BABE) and (dl<>$ff);
      end;
  end;
begin
  case b of
    0 : sfunc(2);          { turn off read cache }
    1 : begin
          sfunc(1);        { turn on read cache }
          sfunc(4);        { turn off write cache }
        end;
    2 : begin
          sfunc(1);        { turn on read cache }
          sfunc(3);        { turn on write cache }
        end;
  end;
end;


{ Schreib-Cache leeren }

procedure SmartResetCache; assembler;
asm
  mov ax, $4a10
  mov bx, 2
  int $2f
end;


{ Read-Cache-Inhalt verwerfen, Schreibcache leeren }

procedure SmartFlushCache; assembler;
asm
  mov ax, $4a10
  mov bx, 2
  int $2f
end;

end.

