@ECHO OFF
:REM
:REM  BUILD.BAT ͻ
:REM                                                                       
:REM  FreeXP "make" Batchdatei: Compiliert alle fr FreeXP relevanten      
:REM                            Programme und Ressourcen und erstellt      
:REM                            Distributions- und Source-Archivdateien    
:REM                                                                       
:REM  (c) FreeXP 2003-2026, http://www.freexp.de                           
:REM                                                                       
:REM Ķ
:REM                                                                       
:REM  Diese Batch ist nur zum Betrieb innerhalb der vom CVS-Repository     
:REM  vorgegebenen Verzeichnisstruktur bestimmt. Sie *mu* vom Verzeichnis 
:REM  .\build\DOS16 unterhalb des Source-Verzeichnisses aus gestartet und  
:REM  darf nicht umbenannt werden.                                         
:REM                                                                       
:REM  Das vorausgesetzt, sind Anpassungen nur bei den Variablen %BP_PATH%  
:REM  (Pfad zum Programmverzeichnis von Borland Pascal 7.01, nie einen     
:REM  anderen Compiler verwenden!), %ZIP_PATH% (Pfad zum ZIP-Verzeichnis)  
:REM  und ggf. %ZIP_PROG% (falls man einen alternativen Packer zu PKZIP    
:REM  verwenden mchte) notwendig und sinnvoll.                            
:REM                                                                       
:REM  Wenn ein alternativer Packer verwendet wird, sind die verwendeten    
:REM  Kommandozeilenparameter auf Kompatibilitt zu prfen und ggf.        
:REM  entsprechend anzupassen.                                             
:REM                                                                       
:REM  Compiler und Packer nicht ber Batchdateien aufrufen, ansonsten      
:REM  erfolgt keine Rckkehr in diese Batch und der Vorgang kann nicht     
:REM  vollstndig abgeschlossen werden.                                    
:REM                                                                       
:REM Ķ
:REM                                                                       
:REM  Getestet unter: MS-DOS 6.22, Windows 95/98, Windows 2000/XP          
:REM                                                                       
:REM ͼ

:REM Ŀ
:REM  Auf korrekte Verzeichnisstruktur testen
:REM 
ECHO.>$DIRTEST.$$$
CD ..
IF NOT EXIST DOS16\$DIRTEST.$$$ GOTO WRONGDIR
IF NOT EXIST DOS16\BUILD.BAT GOTO WRONGDIR
IF NOT EXIST ..\XPGLOBAL.PAS GOTO WRONGDIR
IF NOT EXIST ..\XPDEFINE.INC GOTO WRONGDIR
IF NOT EXIST ..\COMPDATE.PAS GOTO WRONGDIR
CD DOS16
IF EXIST $DIRTEST.$$$ DEL $DIRTEST.$$$ 
GOTO SET_ENV

:WRONGDIR
ECHO.
ECHO BUILD.BAT wurde offenbar nicht in der erforderlichen Umgebung gestartet -
ECHO Buildvorgang wird abgebrochen.
GOTO ENDE

:SET_ENV
:REM Ŀ
:REM  Umgebungsvariablen setzen
:REM  (%BP_PATH%, %ZIP_PATH% und %ZIP_PROG% ggf. anpassen!)
:REM 
:REM Pfad zu Borland Pascal (ohne abschlieenden Backslash!)
REM SET BP_PATH=U:\BP\BIN
SET BP_PATH=C:\BP\BIN
:REM Optionen fr BP (ohne fhrendes Leerzeichen, nicht ndern!)
:REM ("-CD": DOS real mode target, "-B": Build all units)
SET BP_OPT=-CD -B
:REM Pfad zu ZIP-Programm (ohne abschlieenden Backslash!)
:REM SET ZIP_PATH=c:\git-Work\freexp\BIN\7ZIP
SET ZIP_PATH=c:\svn-Work\freexp\trunk\BIN\INFOZIP
:REM Name des ZIP-Programms
:REM (wenn nicht PKZIP, verwendete Optionen auf Kompatibilitt prfen!)
:FREM SET ZIP_PROG=7Z.EXE
SET ZIP_PROG=ZIP.EXE

:REM Ŀ
:REM  Testen, ob jetzt noch genug Environment fr das Label in %RETURN%
:REM  vorhanden ist, um den korrekten Ablauf der Batch sicherzustellen
:REM  (wenn es schon vorher Probleme mit dem Umgebungsspeicher gab, dann
:REM  kann auch diese Variable jetzt nicht korrekt gesetzt werden)
:REM 
SET RETURN=MOVE_RES
IF "%RETURN%"=="MOVE_RES" GOTO CHECK_BP
ECHO.
ECHO Nicht gengend Umgebungsspeicher vorhanden - Buildvorgang wird abgebrochen.
GOTO CLEAN_3

:CHECK_BP
:REM Ŀ
:REM  Auf Existenz von BPC.EXE prfen
:REM 
IF EXIST %BP_PATH%\BPC.EXE GOTO MAKEDIRS
ECHO.
ECHO %BP_PATH%\BPC.EXE nicht gefunden - Buildvorgang wird abgebrochen.
ECHO (Variable %%BP_PATH%% evtl. nicht oder falsch gesetzt?)
GOTO CLEAN_3

:MAKEDIRS
:REM Ŀ
:REM  Unterverzeichnisse anlegen (falls noch nicht vorhanden) und zurck
:REM  ins Source-Verzeichnis
:REM 
ECHO.
ECHO Ŀ
ECHO  Schritt 1: Verzeichnisse erstellen ...                                 
ECHO 
IF EXIST DISTRI\NUL GOTO CHK_XP
IF EXIST DISTRI\*.* GOTO CHK_XP
MD DISTRI
:CHK_XP
IF EXIST XPDIR\NUL GOTO CHK_XPXT
IF EXIST XPDIR\*.* GOTO CHK_XPXT
MD XPDIR
:CHK_XPXT
IF EXIST XPDIRXT\NUL GOTO CHK_DOC
IF EXIST XPDIRXT\*.* GOTO CHK_DOC
MD XPDIRXT
:CHK_DOC
CD XPDIR
IF EXIST DOC\NUL GOTO CHK_BSP
IF EXIST DOC\*.* GOTO CHK_BSP
MD DOC
:CHK_BSP
IF EXIST BEISPIEL\NUL GOTO CHK_SMP
IF EXIST BEISPIEL\*.* GOTO CHK_SMP
MD BEISPIEL
:CHK_SMP
IF EXIST SAMPLES\NUL GOTO CHK_WIN7
IF EXIST SAMPLES\*.* GOTO CHK_WIN7
MD SAMPLES
:CHK_WIN7
IF EXIST VISTAKIT\NUL GOTO CHK_DOCXT
IF EXIST VISTAKIT\NUL GOTO CHK_DOCXT
MD VISTAKIT
:CHK_DOCXT
CD ..
CD XPDIRXT
IF EXIST DOC\NUL GOTO CHK_BSPXT
IF EXIST DOC\*.* GOTO CHK_BSPXT
MD DOC
:CHK_BSPXT
IF EXIST BEISPIEL\NUL GOTO CHK_SMPXT
IF EXIST BEISPIEL\*.* GOTO CHK_SMPXT
MD BEISPIEL
:CHK_SMPXT
IF EXIST SAMPLES\NUL GOTO CD_SRC
IF EXIST SAMPLES\*.* GOTO CD_SRC
MD SAMPLES
:CD_SRC
CD ..
CD ..
CD ..

ECHO.
ECHO Ŀ
ECHO  Schritt 2: Hilfsprogramme compilieren ...                              
ECHO 

%BP_PATH%\BPC.EXE %BP_OPT% -E.\ GENDATE
IF ERRORLEVEL 1 GOTO FEHLER_1
IF EXIST *.TPU DEL *.TPU
%BP_PATH%\BPC.EXE %BP_OPT% -E.\ RC
IF ERRORLEVEL 1 GOTO FEHLER_1
IF EXIST *.TPU DEL *.TPU

%BP_PATH%\BPC.EXE %BP_OPT% -E.\DOC IHS
IF ERRORLEVEL 1 GOTO FEHLER_1
IF EXIST .\DOC\*.TPU DEL .\DOC\*.TPU
%BP_PATH%\BPC.EXE %BP_OPT% -E.\DOC DOCFORM
IF ERRORLEVEL 1 GOTO FEHLER_1
IF EXIST .\DOC\*.TPU DEL .\DOC\*.TPU

%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR TOUCH
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT TOUCH
IF ERRORLEVEL 1 GOTO FEHLER_1

:REM Standard-COMPDATE sichern
IF EXIST compdate.pas IF NOT EXIST compdate.pa$ REN compdate.pas compdate.pa$

:REM Neue COMPDATE erzeugen
GENDATE.EXE
DEL GENDATE.EXE

:REM Build-Helper erstellen
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR FXPBHELP
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT FXPBHELP
IF ERRORLEVEL 1 GOTO FEHLER_1

ECHO.
ECHO Ŀ
ECHO  Schritt 3: FreeXP compilieren ...                                      
ECHO 

:REM i386 Build
COPY XPDEFINE.386 XPDEFINE.INC
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR AVSCAN
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR MAGGI
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR NDIFF
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR PMCONV
IF ERRORLEVEL 1 GOTO FEHLER_1
:REM %BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR SCRIPTS
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR UUCICO
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR UUCP-FL1
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR UUZ
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR XP
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR XP-FM
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR XPME
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR YUP2PKT
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR ZFIDO
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIR ZPR
IF ERRORLEVEL 1 GOTO FEHLER_1

:REM 8086/8088 Build
COPY XPDEFINE.XT XPDEFINE.INC
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT AVSCAN
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT MAGGI
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT NDIFF
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT PMCONV
IF ERRORLEVEL 1 GOTO FEHLER_1
:REM %BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT SCRIPTS
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT UUCICO
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT UUCP-FL1
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT UUZ
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT XP
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT XP-FM
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT XPME
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT YUP2PKT
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT ZFIDO
IF ERRORLEVEL 1 GOTO FEHLER_1
%BP_PATH%\BPC.EXE %BP_OPT% -EBUILD\DOS16\XPDIRXT ZPR
IF ERRORLEVEL 1 GOTO FEHLER_1

RC.EXE XP-D BUILD\DOS16\XPDIR
IF ERRORLEVEL 1 GOTO FEHLER_1
RC.EXE XP-D BUILD\DOS16\XPDIRXT
IF ERRORLEVEL 1 GOTO FEHLER_1
RC.EXE XP-E BUILD\DOS16\XPDIR
IF ERRORLEVEL 1 GOTO FEHLER_1
RC.EXE XP-E BUILD\DOS16\XPDIRXT
IF ERRORLEVEL 1 GOTO FEHLER_1
RC.EXE XPFM-D BUILD\DOS16\XPDIR
IF ERRORLEVEL 1 GOTO FEHLER_1
RC.EXE XPFM-D BUILD\DOS16\XPDIRXT
IF ERRORLEVEL 1 GOTO FEHLER_1
RC.EXE XPFM-E BUILD\DOS16\XPDIR
IF ERRORLEVEL 1 GOTO FEHLER_1
RC.EXE XPFM-E BUILD\DOS16\XPDIRXT
IF ERRORLEVEL 1 GOTO FEHLER_1
RC.EXE XPUU-D BUILD\DOS16\XPDIR
IF ERRORLEVEL 1 GOTO FEHLER_1
RC.EXE XPUU-D BUILD\DOS16\XPDIRXT
IF ERRORLEVEL 1 GOTO FEHLER_1
RC.EXE XPUU-E BUILD\DOS16\XPDIR
IF ERRORLEVEL 1 GOTO FEHLER_1
RC.EXE XPUU-E BUILD\DOS16\XPDIRXT
IF ERRORLEVEL 1 GOTO FEHLER_1

CD DOC
IHS.EXE XP ..\BUILD\DOS16\XPDIR
IF ERRORLEVEL 1 GOTO FEHLER_2
IHS.EXE XP ..\BUILD\DOS16\XPDIRXT
IF ERRORLEVEL 1 GOTO FEHLER_2
IHS.EXE XP-E ..\BUILD\DOS16\XPDIR
IF ERRORLEVEL 1 GOTO FEHLER_2
IHS.EXE XP-E ..\BUILD\DOS16\XPDIRXT
IF ERRORLEVEL 1 GOTO FEHLER_2
DOCFORM.EXE xpoint.dq ..\BUILD\DOS16\XPDIR\DOC\xpoint.txt 71 3 -p -x
IF ERRORLEVEL 1 GOTO FEHLER_2
DOCFORM.EXE xpoint.dq ..\BUILD\DOS16\XPDIRXT\DOC\xpoint.txt 71 3 -p -x
IF ERRORLEVEL 1 GOTO FEHLER_2
DOCFORM.EXE fido.dq ..\BUILD\DOS16\XPDIR\DOC\fido.txt 71 3 -p -tI\Grundlagen -kFido
IF ERRORLEVEL 1 GOTO FEHLER_2
DOCFORM.EXE fido.dq ..\BUILD\DOS16\XPDIRXT\DOC\fido.txt 71 3 -p -tI\Grundlagen -kFido
IF ERRORLEVEL 1 GOTO FEHLER_2
DOCFORM.EXE uucp.dq ..\BUILD\DOS16\XPDIR\DOC\uucp.txt 71 3 -p -tI\Grundlagen -kUUCP
IF ERRORLEVEL 1 GOTO FEHLER_2
DOCFORM.EXE uucp.dq ..\BUILD\DOS16\XPDIRXT\DOC\uucp.txt 71 3 -p -tI\Grundlagen -kUUCP
IF ERRORLEVEL 1 GOTO FEHLER_2
DOCFORM.EXE xpme.dq ..\BUILD\DOS16\XPDIR\DOC\xpme.txt 71 3 -p -t### -kXPME
IF ERRORLEVEL 1 GOTO FEHLER_2
DOCFORM.EXE xpme.dq ..\BUILD\DOS16\XPDIRXT\DOC\xpme.txt 71 3 -p -t### -kXPME
IF ERRORLEVEL 1 GOTO FEHLER_2
DOCFORM.EXE zpr.dq ..\BUILD\DOS16\XPDIR\DOC\zpr.txt 71 3 -p -t### -kZPR
IF ERRORLEVEL 1 GOTO FEHLER_2
DOCFORM.EXE zpr.dq ..\BUILD\DOS16\XPDIRXT\DOC\zpr.txt 71 3 -p -t### -kZPR
IF ERRORLEVEL 1 GOTO FEHLER_2
REM DOCFORM.EXE snapshot.dq ..\BUILD\DOS16\XPDIR\DOC\FXP342.txt 71 3 -p -t### -kSnapshot
REM IF ERRORLEVEL 1 GOTO FEHLER_2
REM DOCFORM.EXE snapshot.dq ..\BUILD\DOS16\XPDIRXT\DOC\FXP342.txt 71 3 -p -t### -kSnapshot
REM IF ERRORLEVEL 1 GOTO FEHLER_2

:REM Nach CLEAN_1 kommen wir zu MOVE_RES wieder zurck!
GOTO CLEAN_1

:MOVE_RES
ECHO.
ECHO Ŀ
ECHO  Schritt 4: Hilfe-/Beispieldateien kopieren ...                         
ECHO 

:REM Dokumentation kopieren (i386)
IF EXIST DOC\COPYING COPY DOC\COPYING BUILD\DOS16\XPDIR\DOC

IF EXIST DOC\FXP_EN.TXT COPY DOC\FXP_EN.TXT BUILD\DOS16\XPDIR\DOC
IF EXIST DOC\FXP_EN.HTM COPY DOC\FXP_EN.HTM BUILD\DOS16\XPDIR\DOC
IF EXIST DOC\README.TXT COPY DOC\README.TXT BUILD\DOS16\XPDIR\DOC
IF EXIST DOC\SLIZENZ.TXT COPY DOC\SLIZENZ.TXT BUILD\DOS16\XPDIR\DOC
IF EXIST DOC\UUZ_ENH.TXT COPY DOC\UUZ_ENH.TXT BUILD\DOS16\XPDIR\DOC
IF EXIST DOC\UKAWP.TXT COPY DOC\UKAWP.TXT BUILD\DOS16\XPDIR\DOC
IF EXIST DOC\UPDATE.TXT COPY DOC\UPDATE.TXT BUILD\DOS16\XPDIR\DOC
IF EXIST DOC\ZM.TXT COPY DOC\ZM.TXT BUILD\DOS16\XPDIR\DOC
IF EXIST DOC\ZM-ENG.TXT COPY DOC\ZM-ENG.TXT BUILD\DOS16\XPDIR\DOC
IF EXIST DOC\VERSION.TXT COPY DOC\VERSION.TXT BUILD\DOS16\XPDIR\DOC
IF EXIST DOC\VERSIONS.FAQ COPY DOC\VERSIONS.FAQ BUILD\DOS16\XPDIR\DOC
IF EXIST DOC\XP_NTVDM.TXT COPY DOC\XP_NTVDM.TXT BUILD\DOS16\XPDIR\DOC

:REM Dokumentation kopieren (8086/8088)
IF EXIST DOC\COPYING COPY DOC\COPYING BUILD\DOS16\XPDIRXT\DOC

IF EXIST DOC\FXP_EN.TXT COPY DOC\FXP_EN.TXT BUILD\DOS16\XPDIRXT\DOC
IF EXIST DOC\FXP_EN.HTM COPY DOC\FXP_EN.HTM BUILD\DOS16\XPDIRXT\DOC
IF EXIST DOC\README.TXT COPY DOC\README.TXT BUILD\DOS16\XPDIRXT\DOC
IF EXIST DOC\SLIZENZ.TXT COPY DOC\SLIZENZ.TXT BUILD\DOS16\XPDIRXT\DOC
IF EXIST DOC\UUZ_ENH.TXT COPY DOC\UUZ_ENH.TXT BUILD\DOS16\XPDIRXT\DOC
IF EXIST DOC\UKAWP.TXT COPY DOC\UKAWP.TXT BUILD\DOS16\XPDIRXT\DOC
IF EXIST DOC\UPDATE.TXT COPY DOC\UPDATE.TXT BUILD\DOS16\XPDIRXT\DOC
IF EXIST DOC\ZM.TXT COPY DOC\ZM.TXT BUILD\DOS16\XPDIRXT\DOC
IF EXIST DOC\ZM-ENG.TXT COPY DOC\ZM-ENG.TXT BUILD\DOS16\XPDIRXT\DOC
IF EXIST DOC\VERSION.TXT COPY DOC\VERSION.TXT BUILD\DOS16\XPDIRXT\DOC
IF EXIST DOC\VERSIONS.FAQ COPY DOC\VERSIONS.FAQ BUILD\DOS16\XPDIRXT\DOC
IF EXIST DOC\XP_NTVDM.TXT COPY DOC\XP_NTVDM.TXT BUILD\DOS16\XPDIRXT\DOC

:REM Beispieldateien kopieren (i386)
IF EXIST BEISPIEL\*.* COPY BEISPIEL\*.* BUILD\DOS16\XPDIR\BEISPIEL
IF EXIST SAMPLES\*.* COPY SAMPLES\*.* BUILD\DOS16\XPDIR\SAMPLES
IF EXIST BEISPIEL\*.SCR COPY BEISPIEL\*.SCR BUILD\DOS16\XPDIR\SAMPLES
IF EXIST BEISPIEL\*.DAT COPY BEISPIEL\*.DAT BUILD\DOS16\XPDIR\SAMPLES
IF EXIST BEISPIEL\*.CFG COPY BEISPIEL\*.CFG BUILD\DOS16\XPDIR\SAMPLES
IF EXIST BEISPIEL\*.REG COPY BEISPIEL\*.REG BUILD\DOS16\XPDIR\SAMPLES

:REM Beispieldateien kopieren (8086/8088)
IF EXIST BEISPIEL\*.* COPY BEISPIEL\*.* BUILD\DOS16\XPDIRXT\BEISPIEL
IF EXIST SAMPLES\*.* COPY SAMPLES\*.* BUILD\DOS16\XPDIRXT\SAMPLES
IF EXIST BEISPIEL\*.SCR COPY BEISPIEL\*.SCR BUILD\DOS16\XPDIRXT\SAMPLES
IF EXIST BEISPIEL\*.DAT COPY BEISPIEL\*.DAT BUILD\DOS16\XPDIRXT\SAMPLES
IF EXIST BEISPIEL\*.CFG COPY BEISPIEL\*.CFG BUILD\DOS16\XPDIRXT\SAMPLES
IF EXIST BEISPIEL\*.REG COPY BEISPIEL\*.REG BUILD\DOS16\XPDIRXT\SAMPLES

:REM FreeXP-Startkit fr Windows Vista kopieren (nur i386)
IF EXIST VISTAKIT\*.* COPY VISTAKIT\*.* BUILD\DOS16\XPDIR\VISTAKIT

:REM 7ZIP und STUNNEL bereitstellen (nur i386)
IF EXIST BIN\*.* XCOPY BIN\*.* BUILD\DOS16\XPDIR\BIN\ /S

:REM Sonstiges (i386)
IF EXIST FILE_ID.DIZ COPY FILE_ID.DIZ BUILD\DOS16\XPDIR
IF EXIST MIME.TYP COPY MIME.TYP BUILD\DOS16\XPDIR
IF EXIST binaries\*.* COPY binaries\*.* BUILD\DOS16\XPDIR
IF EXIST FIDO.PC COPY FIDO.PC BUILD\DOS16\XPDIR

:REM Sonstiges (8086/8088)
IF EXIST FILE_ID.DIZ COPY FILE_ID.DIZ BUILD\DOS16\XPDIRXT
IF EXIST MIME.TYP COPY MIME.TYP BUILD\DOS16\XPDIRXT
IF EXIST binaries\*.* COPY binaries\*.* BUILD\DOS16\XPDIRXT
IF EXIST FIDO.PC COPY FIDO.PC BUILD\DOS16\XPDIRXT

:REM TODO

:REM Ab ins XPDIR 
CD BUILD
CD DOS16
CD XPDIR

:REM Overlay einbauen?
FXPBHELP.EXE OVR
IF ERRORLEVEL 10 GOTO USEOVR

:REM Overlay in die EXE einbauen
COPY /B XP.EXE+XP.OVR XP.IMG
DEL XP.EXE
DEL XP.OVR
REN XP.IMG XP.EXE

CD ..
CD XPDIRXT
COPY /B XP.EXE+XP.OVR XP.IMG
DEL XP.EXE
DEL XP.OVR
REN XP.IMG XP.EXE

:USEOVR
DEL FXPBHELP.EXE

CD ..
CD XPDIR

:REM Bei Bedarf UPX aktivieren!!
:REM UPX -9 *.EXE

CD ..
CD XPDIRXT

:REM Bei Bedarf UPX aktivieren!!
:REM UPX -9 *.EXE

CD ..
CD XPDIR

:REM Alles einmal touchen (mit MW-Touch)
ECHO.
ECHO Ŀ
ECHO  Schritt 5: Einheitlichen Timestamp fr compilierte Dateien setzen ...  
ECHO 
TOUCH.EXE .\#\*.* /R=..\..\..\COMPDATE.PAS /G /MD5 /SHA1

CD ..
CD XPDIRXT
TOUCH.EXE .\#\*.* /R=..\..\..\COMPDATE.PAS /G /MD5 /SHA1

:REM compdate.pas restaurieren
CD ..
CD ..
CD ..
SET RETURN=CHK_ZIP
GOTO CLEAN_2

:CHK_ZIP
IF EXIST %ZIP_PATH%\%ZIP_PROG% GOTO MAKE_ZIP
ECHO.
ECHO %ZIP_PATH%\%ZIP_PROG% nicht gefunden - Buildvorgang wird abgebrochen.
ECHO (Variable %%ZIP_PATH%% und/oder %%ZIP_PROG%% evtl. nicht oder falsch gesetzt?)
GOTO CLEAN_3

:MAKE_ZIP
CD XPDIR
ECHO.
ECHO Ŀ
ECHO  Schritt 6: Archivdateien erstellen ...                                 
ECHO 

MOVE TOUCH.EXE ..\DISTRI

:REM Komplett-Archiv
%ZIP_PATH%\%ZIP_PROG% -r -x@..\..\ALL\NTVDM.LST ..\DISTRI\FXP342.ZIP *

:REM Enhanced UUZ-Archiv
%ZIP_PATH%\%ZIP_PROG% -r -x@..\..\ALL\NTVDM.LST ..\DISTRI\UUZ_ENH.ZIP @..\..\ALL\UUZ.LST

:REM NTVDM Archiv
%ZIP_PATH%\%ZIP_PROG% -r ..\DISTRI\NTVDM.ZIP @..\..\ALL\NTVDM.LST

:REM 2-Disketten-Distribution
%ZIP_PATH%\%ZIP_PROG% -r -x@..\..\ALL\NTVDM.LST ..\DISTRI\FXP342-1.ZIP @..\..\ALL\DISK01.LST
%ZIP_PATH%\%ZIP_PROG% -r -x@..\..\ALL\NTVDM.LST ..\DISTRI\FXP342-2.ZIP @..\..\ALL\DISK02.LST
REM %ZIP_PATH%\%ZIP_PROG% -r -x@..\..\ALL\NTVDM.LST ..\DISTRI\FXP342-3.ZIP @..\..\ALL\DISK03.LST
REM STUNNEL nicht in der Diskettendistribution
REM %ZIP_PATH%\%ZIP_PROG% -r -x@..\..\ALL\NTVDM.LST ..\DISTRI\FXP342-4.ZIP @..\..\ALL\DISK04.LST

CD ..
CD XPDIRXT

:REM Komplett-Archiv
%ZIP_PATH%\%ZIP_PROG% -r -x@..\..\ALL\NTVDM.LST ..\DISTRI\FXP342XT.ZIP *

:REM Enhanced UUZ-Archiv
%ZIP_PATH%\%ZIP_PROG% -r -x@..\..\ALL\NTVDM.LST ..\DISTRI\UUZ_ENHXT.ZIP @..\..\ALL\UUZ.LST

:REM 2-Disketten-Distribution
%ZIP_PATH%\%ZIP_PROG% -r -x@..\..\ALL\NTVDM.LST ..\DISTRI\FXP342XT1.ZIP @..\..\ALL\DISK01.LST
%ZIP_PATH%\%ZIP_PROG% -r -x@..\..\ALL\NTVDM.LST ..\DISTRI\FXP342XT2.ZIP @..\..\ALL\DISK02.LST

:REM Zurck ins Source-Verzeichnis
CD ..
CD ..
CD ..

:REM Source-Komplettarchiv
%ZIP_PATH%\%ZIP_PROG% -r -x@BUILD\ALL\EXCLUDE.LST BUILD\DOS16\DISTRI\FXP342S.ZIP *

:REM 2-Disketten-Source
REM %ZIP_PATH%\%ZIP_PROG% -r -x@BUILD\ALL\EXCLUDE.LST -x@BUILD\ALL\SDISK.LST BUILD\DOS16\DISTRI\FXP342S1.ZIP *.*
REM %ZIP_PATH%\%ZIP_PROG% -r -x@BUILD\ALL\EXCLUDE.LST BUILD\DOS16\DISTRI\FXP342S2.ZIP @BUILD\ALL\SDISK.LST

:REM Ein letzter Touch auf die Archive
ECHO.
ECHO Ŀ
ECHO  Schritt 7: Einheitlichen Timestamp fr Archive setzen ...              
ECHO 
CD BUILD
CD DOS16
CD DISTRI
TOUCH.EXE *.* /R=../XPDIR/XP.EXE /G
DEL TOUCH.EXE

:REM Zurck ins Source-Verzeichnis
CD ..
CD ..
CD ..
ECHO.
ECHO Der Buildvorgang wurde fehlerfrei abgeschlossen. :-)

:REM Ŀ
:REM  Wenn kein Fehler aufgetreten ist, nur Variablen zurcksetzen
:REM  (berflssige Dateien wurden bereits vorher entfernt).
:REM 

GOTO CLEAN_3

:FEHLER_1
:REM Vom Source- ins DOC-Verzeichnis wechseln
CD DOC

:FEHLER_2
SET RETURN=
ECHO.
ECHO Es ist ein Fehler whrend des Compilierens aufgetreten! :-(

:REM Ŀ
:REM  Hier laufen wir entweder unmittelbar nach der Compilierung durch
:REM  (wenn kein Fehler aufgetreten ist) und mssen wieder nach MOVE_RES
:REM  zurck, oder es ist ein Fehler aufgetreten und wir rumen nur auf
:REM  und beenden die Batch. Was davon passiert, entscheidet der aktuelle
:REM  Inhalt der Variable %RETURN%.
:REM 

:CLEAN_1
ECHO.
ECHO Ŀ
ECHO  Hilfsprogramme entfernen ...                                           
ECHO 
:REM (Wir mssen bereits im DOC-Verzeichnis sein!)
IF EXIST IHS.EXE DEL IHS.EXE
IF EXIST DOCFORM.EXE DEL DOCFORM.EXE

:REM Ressourcen-Compiler entfernen
CD ..
IF EXIST RC.EXE DEL RC.EXE

:REM BP-Unitdateien von FreeXP entfernen
CD BUILD
CD DOS16
CD XPDIR
IF EXIST *.TPU DEL *.TPU
CD ..
CD XPDIRXT
IF EXIST *.TPU DEL *.TPU
CD ..
CD ..
CD ..

IF NOT "%RETURN%"=="" GOTO %RETURN%

:REM Ŀ
:REM  Hier laufen wir entweder nach der Compilierung durch (wenn kein
:REM  Fehler aufgetreten ist) und mssen wieder nach MAKE_ZIP zurck, oder
:REM  es ist ein Fehler aufgetreten und wir schreiben nur COMPDATE.PAS
:REM  zurck und beenden die Batch. Was davon passiert, entscheidet der
:REM  aktuelle Inhalt der Variable %RETURN%.
:REM 

:CLEAN_2
ECHO.
ECHO Ŀ
ECHO  COMPDATE.PAS (Dummy) restaurieren ...                                  
ECHO 
:REM (Wir mssen bereits im Source-Verzeichnis sein!)
IF EXIST compdate.pas IF EXIST compdate.pa$ DEL compdate.pas
IF NOT EXIST compdate.pas IF EXIST compdate.pa$ REN compdate.pa$ compdate.pas
CD BUILD
CD DOS16

IF NOT "%RETURN%"=="" GOTO %RETURN%

:CLEAN_3
:REM Benutzte Variablen zurcksetzen
SET BP_PATH=
SET BP_OPT=
SET ZIP_PATH=
SET ZIP_PROG=
SET RETURN=

goto ENDE

{

}

:ENDE
